/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.bukkit.Location;
import org.bukkit.Raid;
import org.bukkit.entity.Raider;

public final class CraftRaid
implements Raid {
    private final net.minecraft.world.raid.Raid handle;

    public CraftRaid(net.minecraft.world.raid.Raid handle) {
        this.handle = handle;
    }

    @Override
    public boolean isStarted() {
        return this.handle.func_221301_k();
    }

    @Override
    public long getActiveTicks() {
        return this.handle.field_221346_j;
    }

    @Override
    public int getBadOmenLevel() {
        return this.handle.field_221352_p;
    }

    @Override
    public void setBadOmenLevel(int badOmenLevel) {
        int max = this.handle.func_221327_m();
        Preconditions.checkArgument((0 <= badOmenLevel && badOmenLevel <= max ? 1 : 0) != 0, (String)"Bad Omen level must be between 0 and %s", (int)max);
        this.handle.field_221352_p = badOmenLevel;
    }

    @Override
    public Location getLocation() {
        BlockPos pos = this.handle.func_221304_t();
        World world = this.handle.func_221316_i();
        return new Location(world.getWorld(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public Raid.RaidStatus getStatus() {
        if (this.handle.func_221310_d()) {
            return Raid.RaidStatus.STOPPED;
        }
        if (this.handle.func_221321_e()) {
            return Raid.RaidStatus.VICTORY;
        }
        if (this.handle.func_221336_f()) {
            return Raid.RaidStatus.LOSS;
        }
        return Raid.RaidStatus.ONGOING;
    }

    @Override
    public int getSpawnedGroups() {
        return this.handle.func_221315_l();
    }

    @Override
    public int getTotalGroups() {
        return this.handle.field_221359_w + (this.handle.field_221352_p > 1 ? 1 : 0);
    }

    @Override
    public int getTotalWaves() {
        return this.handle.field_221359_w;
    }

    @Override
    public float getTotalHealth() {
        return this.handle.func_221290_r();
    }

    @Override
    public Set<UUID> getHeroes() {
        return Collections.unmodifiableSet(this.handle.field_221345_i);
    }

    @Override
    public List<Raider> getRaiders() {
        return (List)this.handle.getRaiders().stream().map(new Function<AbstractRaiderEntity, Raider>(){

            @Override
            public Raider apply(AbstractRaiderEntity entityRaider) {
                return (Raider)((Object)entityRaider.getBukkitEntity());
            }
        }).collect(ImmutableList.toImmutableList());
    }
}

