/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChorusFlowerBlock;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.entity.item.minecart.HopperMinecartEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.item.minecart.SpawnerMinecartEntity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.EvokerFangsEntity;
import net.minecraft.entity.projectile.EyeOfEnderEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlaySoundPacket;
import net.minecraft.network.play.server.SUpdateTimePacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.Unit;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.raid.RaidManager;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.Ticket;
import net.minecraft.world.server.TicketType;
import org.apache.commons.lang.Validate;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameRule;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Raid;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_16_R3.CraftChunk;
import org.bukkit.craftbukkit.v1_16_R3.CraftEffect;
import org.bukkit.craftbukkit.v1_16_R3.CraftFluidCollisionMode;
import org.bukkit.craftbukkit.v1_16_R3.CraftHeightMap;
import org.bukkit.craftbukkit.v1_16_R3.CraftParticle;
import org.bukkit.craftbukkit.v1_16_R3.CraftRaid;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftSound;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_16_R3.boss.CraftDragonBattle;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.metadata.BlockMetadataStore;
import org.bukkit.craftbukkit.v1_16_R3.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftRayTraceResult;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Cat;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cod;
import org.bukkit.entity.ComplexLivingEntity;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Egg;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Husk;
import org.bukkit.entity.Illager;
import org.bukkit.entity.Illusioner;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Mule;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinBrute;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.Player;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Slime;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Strider;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.TraderLlama;
import org.bukkit.entity.Trident;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Turtle;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zoglin;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.SpawnerMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Consumer;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class CraftWorld
implements World {
    public static final int CUSTOM_DIMENSION_OFFSET = 10;
    private final ServerWorld world;
    private WorldBorder worldBorder;
    private World.Environment environment;
    private final CraftServer server = (CraftServer)Bukkit.getServer();
    private final ChunkGenerator generator;
    private final List<BlockPopulator> populators = new ArrayList<BlockPopulator>();
    private final BlockMetadataStore blockMetadata = new BlockMetadataStore(this);
    private int monsterSpawn = -1;
    private int animalSpawn = -1;
    private int waterAnimalSpawn = -1;
    private int waterAmbientSpawn = -1;
    private int ambientSpawn = -1;
    private static final Random rand = new Random();
    private static Map<String, GameRules.RuleKey<?>> gamerules;
    private static Map<String, GameRules.RuleType<?>> gameruleDefinitions;
    private final World.Spigot spigot = new World.Spigot(){

        @Override
        public LightningStrike strikeLightning(Location loc, boolean isSilent) {
            LightningBoltEntity lightning = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a((net.minecraft.world.World)CraftWorld.this.world);
            lightning.func_225653_b_(loc.getX(), loc.getY(), loc.getZ());
            lightning.isSilent = isSilent;
            CraftWorld.this.world.strikeLightning((net.minecraft.entity.Entity)lightning);
            return (LightningStrike)((Object)lightning.getBukkitEntity());
        }

        @Override
        public LightningStrike strikeLightningEffect(Location loc, boolean isSilent) {
            LightningBoltEntity lightning = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a((net.minecraft.world.World)CraftWorld.this.world);
            lightning.func_225653_b_(loc.getX(), loc.getY(), loc.getZ());
            lightning.field_184529_d = true;
            lightning.isSilent = isSilent;
            return (LightningStrike)((Object)lightning.getBukkitEntity());
        }
    };

    public CraftWorld(ServerWorld world, ChunkGenerator gen, World.Environment env) {
        this.world = world;
        this.generator = gen;
        this.environment = env;
    }

    @Override
    public Block getBlockAt(int x, int y, int z) {
        return CraftBlock.at((IWorld)this.world, new BlockPos(x, y, z));
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        return this.getHighestBlockYAt(x, z, HeightMap.MOTION_BLOCKING);
    }

    @Override
    public Location getSpawnLocation() {
        BlockPos spawn = this.world.func_241135_u_();
        return new Location(this, spawn.func_177958_n(), spawn.func_177956_o(), spawn.func_177952_p());
    }

    @Override
    public boolean setSpawnLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        return this.equals(location.getWorld()) ? this.setSpawnLocation(location.getBlockX(), location.getBlockY(), location.getBlockZ(), location.getYaw()) : false;
    }

    @Override
    public boolean setSpawnLocation(int x, int y, int z, float angle) {
        try {
            Location previousLocation = this.getSpawnLocation();
            this.world.field_72986_A.func_176143_a(new BlockPos(x, y, z), angle);
            SpawnChangeEvent event = new SpawnChangeEvent(this, previousLocation);
            this.server.getPluginManager().callEvent(event);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean setSpawnLocation(int x, int y, int z) {
        return this.setSpawnLocation(x, y, z, 0.0f);
    }

    @Override
    public Chunk getChunkAt(int x, int z) {
        return this.world.func_72863_F().func_217205_a((int)x, (int)z, (boolean)true).bukkitChunk;
    }

    @Override
    public Chunk getChunkAt(Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"null block");
        return this.getChunkAt(block.getX() >> 4, block.getZ() >> 4);
    }

    @Override
    public boolean isChunkLoaded(int x, int z) {
        net.minecraft.world.chunk.Chunk chunk = this.world.func_72863_F().func_217205_a(x, z, false);
        return chunk != null;
    }

    @Override
    public boolean isChunkGenerated(int x, int z) {
        try {
            return this.isChunkLoaded(x, z) || this.world.func_72863_F().field_217237_a.func_227078_e_(new ChunkPos(x, z)) != null;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Chunk[] getLoadedChunks() {
        Long2ObjectLinkedOpenHashMap chunks = this.world.func_72863_F().field_217237_a.field_219252_f;
        return (Chunk[])chunks.values().stream().map(ChunkHolder::getFullChunk).filter(Objects::nonNull).map(net.minecraft.world.chunk.Chunk::getBukkitChunk).toArray(Chunk[]::new);
    }

    @Override
    public void loadChunk(int x, int z) {
        this.loadChunk(x, z, true);
    }

    @Override
    public boolean unloadChunk(Chunk chunk) {
        return this.unloadChunk(chunk.getX(), chunk.getZ());
    }

    @Override
    public boolean unloadChunk(int x, int z) {
        return this.unloadChunk(x, z, true);
    }

    @Override
    public boolean unloadChunk(int x, int z, boolean save) {
        return this.unloadChunk0(x, z, save);
    }

    @Override
    public boolean unloadChunkRequest(int x, int z) {
        if (this.isChunkLoaded(x, z)) {
            this.world.func_72863_F().func_217222_b(TicketType.PLUGIN, new ChunkPos(x, z), 1, (Object)Unit.INSTANCE);
        }
        return true;
    }

    private boolean unloadChunk0(int x, int z, boolean save) {
        if (!this.isChunkLoaded(x, z)) {
            return true;
        }
        net.minecraft.world.chunk.Chunk chunk = this.world.func_212866_a_(x, z);
        chunk.mustNotSave = !save;
        this.unloadChunkRequest(x, z);
        this.world.func_72863_F().purgeUnload();
        return !this.isChunkLoaded(x, z);
    }

    @Override
    public boolean regenerateChunk(int x, int z) {
        throw new UnsupportedOperationException("Not supported in this Minecraft version! Unless you can fix it, this is not a bug :)");
    }

    @Override
    public boolean refreshChunk(int x, int z) {
        if (!this.isChunkLoaded(x, z)) {
            return false;
        }
        int px = x << 4;
        int pz = z << 4;
        int height = this.getMaxHeight() / 16;
        for (int idx = 0; idx < 64; ++idx) {
            this.world.func_184138_a(new BlockPos(px + idx / height, idx % height * 16, pz), Blocks.field_150350_a.func_176223_P(), Blocks.field_150348_b.func_176223_P(), 3);
        }
        this.world.func_184138_a(new BlockPos(px + 15, height * 16 - 1, pz + 15), Blocks.field_150350_a.func_176223_P(), Blocks.field_150348_b.func_176223_P(), 3);
        return true;
    }

    @Override
    public boolean isChunkInUse(int x, int z) {
        return this.isChunkLoaded(x, z);
    }

    @Override
    public boolean loadChunk(int x, int z, boolean generate) {
        IChunk chunk = this.world.func_72863_F().func_212849_a_(x, z, generate ? ChunkStatus.field_222617_m : ChunkStatus.field_223226_a_, true);
        if (chunk instanceof ChunkPrimerWrapper) {
            chunk = this.world.func_72863_F().func_212849_a_(x, z, ChunkStatus.field_222617_m, true);
        }
        if (chunk instanceof net.minecraft.world.chunk.Chunk) {
            this.world.func_72863_F().func_217228_a(TicketType.PLUGIN, new ChunkPos(x, z), 1, (Object)Unit.INSTANCE);
            return true;
        }
        return false;
    }

    @Override
    public boolean isChunkLoaded(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"null chunk");
        return this.isChunkLoaded(chunk.getX(), chunk.getZ());
    }

    @Override
    public void loadChunk(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"null chunk");
        this.loadChunk(chunk.getX(), chunk.getZ());
        ((CraftChunk)this.getChunkAt((int)chunk.getX(), (int)chunk.getZ())).getHandle().bukkitChunk = chunk;
    }

    @Override
    public boolean addPluginChunkTicket(int x, int z, Plugin plugin) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"null plugin");
        Preconditions.checkArgument((boolean)plugin.isEnabled(), (Object)"plugin is not enabled");
        ChunkManager.ProxyTicketManager chunkDistanceManager = this.world.func_72863_F().field_217237_a.field_219267_u;
        if (chunkDistanceManager.addTicketAtLevel(TicketType.PLUGIN_TICKET, new ChunkPos(x, z), 31, (Object)plugin)) {
            this.getChunkAt(x, z);
            return true;
        }
        return false;
    }

    @Override
    public boolean removePluginChunkTicket(int x, int z, Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"null plugin");
        ChunkManager.ProxyTicketManager chunkDistanceManager = this.world.func_72863_F().field_217237_a.field_219267_u;
        return chunkDistanceManager.removeTicketAtLevel(TicketType.PLUGIN_TICKET, new ChunkPos(x, z), 31, (Object)plugin);
    }

    @Override
    public void removePluginChunkTickets(Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"null plugin");
        ChunkManager.ProxyTicketManager chunkDistanceManager = this.world.func_72863_F().field_217237_a.field_219267_u;
        chunkDistanceManager.removeAllTicketsFor(TicketType.PLUGIN_TICKET, 31, (Object)plugin);
    }

    @Override
    public Collection<Plugin> getPluginChunkTickets(int x, int z) {
        ChunkManager.ProxyTicketManager chunkDistanceManager = this.world.func_72863_F().field_217237_a.field_219267_u;
        SortedArraySet tickets = (SortedArraySet)chunkDistanceManager.field_219377_e.get(ChunkPos.func_77272_a((int)x, (int)z));
        if (tickets == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder ret = ImmutableList.builder();
        for (Ticket ticket : tickets) {
            if (ticket.func_219479_a() != TicketType.PLUGIN_TICKET) continue;
            ret.add((Object)((Plugin)ticket.field_219482_c));
        }
        return ret.build();
    }

    @Override
    public Map<Plugin, Collection<Chunk>> getPluginChunkTickets() {
        HashMap<Plugin, ImmutableList.Builder> ret = new HashMap<Plugin, ImmutableList.Builder>();
        ChunkManager.ProxyTicketManager chunkDistanceManager = this.world.func_72863_F().field_217237_a.field_219267_u;
        for (Long2ObjectMap.Entry chunkTickets : chunkDistanceManager.field_219377_e.long2ObjectEntrySet()) {
            long chunkKey = chunkTickets.getLongKey();
            SortedArraySet tickets = (SortedArraySet)chunkTickets.getValue();
            Chunk chunk = null;
            for (Ticket ticket : tickets) {
                if (ticket.func_219479_a() != TicketType.PLUGIN_TICKET) continue;
                if (chunk == null) {
                    chunk = this.getChunkAt(ChunkPos.func_212578_a((long)chunkKey), ChunkPos.func_212579_b((long)chunkKey));
                }
                ret.computeIfAbsent((Plugin)ticket.field_219482_c, key -> ImmutableList.builder()).add((Object)chunk);
            }
        }
        return (Map)ret.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableList.Builder)entry.getValue()).build()));
    }

    @Override
    public boolean isChunkForceLoaded(int x, int z) {
        return this.getHandle().func_217469_z().contains(ChunkPos.func_77272_a((int)x, (int)z));
    }

    @Override
    public void setChunkForceLoaded(int x, int z, boolean forced) {
        this.getHandle().func_217458_b(x, z, forced);
    }

    @Override
    public Collection<Chunk> getForceLoadedChunks() {
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        LongIterator longIterator = this.getHandle().func_217469_z().iterator();
        while (longIterator.hasNext()) {
            long coord = (Long)longIterator.next();
            chunks.add(this.getChunkAt(ChunkPos.func_212578_a((long)coord), ChunkPos.func_212579_b((long)coord)));
        }
        return Collections.unmodifiableCollection(chunks);
    }

    public ServerWorld getHandle() {
        return this.world;
    }

    @Override
    public Item dropItem(Location loc, ItemStack item) {
        return this.dropItem(loc, item, null);
    }

    @Override
    public Item dropItem(Location loc, ItemStack item, Consumer<Item> function) {
        Validate.notNull((Object)item, (String)"Cannot drop a Null item.");
        ItemEntity entity = new ItemEntity((net.minecraft.world.World)this.world, loc.getX(), loc.getY(), loc.getZ(), CraftItemStack.asNMSCopy(item));
        entity.field_145804_b = 10;
        if (function != null) {
            function.accept((Item)((Object)entity.getBukkitEntity()));
        }
        this.world.addEntity((net.minecraft.entity.Entity)entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (Item)((Object)entity.getBukkitEntity());
    }

    @Override
    public Item dropItemNaturally(Location loc, ItemStack item) {
        return this.dropItemNaturally(loc, item, null);
    }

    @Override
    public Item dropItemNaturally(Location loc, ItemStack item, Consumer<Item> function) {
        double xs = (double)(this.world.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double ys = (double)(this.world.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double zs = (double)(this.world.field_73012_v.nextFloat() * 0.5f) + 0.25;
        loc = loc.clone();
        loc.setX(loc.getX() + xs);
        loc.setY(loc.getY() + ys);
        loc.setZ(loc.getZ() + zs);
        return this.dropItem(loc, item, function);
    }

    @Override
    public Arrow spawnArrow(Location loc, Vector velocity, float speed, float spread) {
        return this.spawnArrow(loc, velocity, speed, spread, Arrow.class);
    }

    @Override
    public <T extends AbstractArrow> T spawnArrow(Location loc, Vector velocity, float speed, float spread, Class<T> clazz) {
        AbstractArrowEntity arrow;
        Validate.notNull((Object)loc, (String)"Can not spawn arrow with a null location");
        Validate.notNull((Object)velocity, (String)"Can not spawn arrow with a null velocity");
        Validate.notNull(clazz, (String)"Can not spawn an arrow with no class");
        if (TippedArrow.class.isAssignableFrom(clazz)) {
            arrow = (AbstractArrowEntity)EntityType.field_200790_d.func_200721_a((net.minecraft.world.World)this.world);
            ((ArrowEntity)arrow).setType(CraftPotionUtil.fromBukkit(new PotionData(PotionType.WATER, false, false)));
        } else {
            arrow = SpectralArrow.class.isAssignableFrom(clazz) ? (AbstractArrowEntity)EntityType.field_200747_am.func_200721_a((net.minecraft.world.World)this.world) : (Trident.class.isAssignableFrom(clazz) ? (AbstractArrowEntity)EntityType.field_203098_aL.func_200721_a((net.minecraft.world.World)this.world) : (AbstractArrowEntity)EntityType.field_200790_d.func_200721_a((net.minecraft.world.World)this.world));
        }
        arrow.func_70012_b(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        arrow.func_70186_c(velocity.getX(), velocity.getY(), velocity.getZ(), speed, spread);
        this.world.func_217376_c((net.minecraft.entity.Entity)arrow);
        return (T)((AbstractArrow)((Object)arrow.getBukkitEntity()));
    }

    @Override
    public Entity spawnEntity(Location loc, org.bukkit.entity.EntityType entityType) {
        return this.spawn(loc, entityType.getEntityClass());
    }

    @Override
    public LightningStrike strikeLightning(Location loc) {
        LightningBoltEntity lightning = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a((net.minecraft.world.World)this.world);
        lightning.func_223102_j(loc.getX(), loc.getY(), loc.getZ());
        this.world.strikeLightning((net.minecraft.entity.Entity)lightning);
        return (LightningStrike)((Object)lightning.getBukkitEntity());
    }

    @Override
    public LightningStrike strikeLightningEffect(Location loc) {
        LightningBoltEntity lightning = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a((net.minecraft.world.World)this.world);
        lightning.func_223102_j(loc.getX(), loc.getY(), loc.getZ());
        lightning.func_233623_a_(true);
        this.world.strikeLightning((net.minecraft.entity.Entity)lightning);
        return (LightningStrike)((Object)lightning.getBukkitEntity());
    }

    @Override
    public boolean generateTree(Location loc, TreeType type) {
        ConfiguredFeature gen;
        BlockPos pos = new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        switch (type) {
            case BIG_TREE: {
                gen = Features.field_243869_bO;
                break;
            }
            case BIRCH: {
                gen = Features.field_243864_bJ;
                break;
            }
            case REDWOOD: {
                gen = Features.field_243866_bL;
                break;
            }
            case TALL_REDWOOD: {
                gen = Features.field_243867_bM;
                break;
            }
            case JUNGLE: {
                gen = Features.field_243871_bQ;
                break;
            }
            case SMALL_JUNGLE: {
                gen = Features.field_243870_bP;
                break;
            }
            case COCOA_TREE: {
                gen = Features.field_243868_bN;
                break;
            }
            case JUNGLE_BUSH: {
                gen = Features.field_243876_bV;
                break;
            }
            case RED_MUSHROOM: {
                gen = Features.field_243861_bG;
                break;
            }
            case BROWN_MUSHROOM: {
                gen = Features.field_243860_bF;
                break;
            }
            case SWAMP: {
                gen = Features.field_243875_bU;
                break;
            }
            case ACACIA: {
                gen = Features.field_243865_bK;
                break;
            }
            case DARK_OAK: {
                gen = Features.field_243863_bI;
                break;
            }
            case MEGA_REDWOOD: {
                gen = Features.field_243873_bS;
                break;
            }
            case TALL_BIRCH: {
                gen = Features.field_243877_bW;
                break;
            }
            case CHORUS_PLANT: {
                ChorusFlowerBlock cfr_ignored_0 = (ChorusFlowerBlock)Blocks.field_185766_cS;
                ChorusFlowerBlock.func_185603_a((IWorld)this.world, (BlockPos)pos, (Random)rand, (int)8);
                return true;
            }
            case CRIMSON_FUNGUS: {
                gen = Features.field_243857_bC;
                break;
            }
            case WARPED_FUNGUS: {
                gen = Features.field_243859_bE;
                break;
            }
            default: {
                gen = Features.field_243862_bH;
            }
        }
        return gen.field_222737_a.func_241855_a((ISeedReader)this.world, this.world.func_72863_F().func_201711_g(), rand, pos, gen.field_222738_b);
    }

    @Override
    public boolean generateTree(Location loc, TreeType type, BlockChangeDelegate delegate) {
        this.world.captureTreeGeneration = true;
        boolean grownTree = this.generateTree(loc, type);
        this.world.captureTreeGeneration = false;
        if (grownTree) {
            for (org.bukkit.block.BlockState blockstate : this.world.capturedBlockStates.values()) {
                blockstate.update(true);
            }
            this.world.capturedBlockStates.clear();
            return true;
        }
        this.world.capturedBlockStates.clear();
        return false;
    }

    @Override
    public String getName() {
        return this.world.field_241103_E_.func_76065_j();
    }

    @Override
    public UUID getUID() {
        return this.world.uuid;
    }

    public String toString() {
        return "CraftWorld{name=" + this.getName() + '}';
    }

    @Override
    public long getTime() {
        long time = this.getFullTime() % 24000L;
        if (time < 0L) {
            time += 24000L;
        }
        return time;
    }

    @Override
    public void setTime(long time) {
        long margin = (time - this.getFullTime()) % 24000L;
        if (margin < 0L) {
            margin += 24000L;
        }
        this.setFullTime(this.getFullTime() + margin);
    }

    @Override
    public long getFullTime() {
        return this.world.func_72820_D();
    }

    @Override
    public void setFullTime(long time) {
        TimeSkipEvent event = new TimeSkipEvent(this, TimeSkipEvent.SkipReason.CUSTOM, time - this.world.func_72820_D());
        this.server.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return;
        }
        this.world.func_241114_a_(this.world.func_72820_D() + event.getSkipAmount());
        for (Player p : this.getPlayers()) {
            CraftPlayer cp = (CraftPlayer)p;
            if (cp.getHandle().field_71135_a == null) continue;
            cp.getHandle().field_71135_a.func_147359_a((IPacket)new SUpdateTimePacket(cp.getHandle().field_70170_p.func_82737_E(), cp.getHandle().getPlayerTime(), cp.getHandle().field_70170_p.func_82736_K().func_223586_b(GameRules.field_223607_j)));
        }
    }

    @Override
    public long getGameTime() {
        return this.world.worldDataServer.func_82573_f();
    }

    @Override
    public boolean createExplosion(double x, double y, double z, float power) {
        return this.createExplosion(x, y, z, power, false, true);
    }

    @Override
    public boolean createExplosion(double x, double y, double z, float power, boolean setFire) {
        return this.createExplosion(x, y, z, power, setFire, true);
    }

    @Override
    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(x, y, z, power, setFire, breakBlocks, null);
    }

    @Override
    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks, Entity source) {
        return !this.world.func_217398_a((net.minecraft.entity.Entity)(source == null ? null : ((CraftEntity)source).getHandle()), (double)x, (double)y, (double)z, (float)power, (boolean)setFire, (Explosion.Mode)(breakBlocks ? Explosion.Mode.BREAK : Explosion.Mode.NONE)).wasCanceled;
    }

    @Override
    public boolean createExplosion(Location loc, float power) {
        return this.createExplosion(loc, power, false);
    }

    @Override
    public boolean createExplosion(Location loc, float power, boolean setFire) {
        return this.createExplosion(loc, power, setFire, true);
    }

    @Override
    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(loc, power, setFire, breakBlocks, null);
    }

    @Override
    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks, Entity source) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location is null");
        Preconditions.checkArgument((boolean)this.equals(loc.getWorld()), (Object)"Location not in world");
        return this.createExplosion(loc.getX(), loc.getY(), loc.getZ(), power, setFire, breakBlocks, source);
    }

    @Override
    public World.Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public Block getBlockAt(Location location) {
        return this.getBlockAt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public int getHighestBlockYAt(Location location) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ());
    }

    @Override
    public Chunk getChunkAt(Location location) {
        return this.getChunkAt(location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    @Override
    public ChunkGenerator getGenerator() {
        return this.generator;
    }

    @Override
    public List<BlockPopulator> getPopulators() {
        return this.populators;
    }

    @Override
    public Block getHighestBlockAt(int x, int z) {
        return this.getBlockAt(x, this.getHighestBlockYAt(x, z), z);
    }

    @Override
    public Block getHighestBlockAt(Location location) {
        return this.getHighestBlockAt(location.getBlockX(), location.getBlockZ());
    }

    @Override
    public int getHighestBlockYAt(int x, int z, HeightMap heightMap) {
        return this.world.func_212866_a_(x >> 4, z >> 4).func_201576_a(CraftHeightMap.toNMS(heightMap), x, z);
    }

    @Override
    public int getHighestBlockYAt(Location location, HeightMap heightMap) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ(), heightMap);
    }

    @Override
    public Block getHighestBlockAt(int x, int z, HeightMap heightMap) {
        return this.getBlockAt(x, this.getHighestBlockYAt(x, z, heightMap), z);
    }

    @Override
    public Block getHighestBlockAt(Location location, HeightMap heightMap) {
        return this.getHighestBlockAt(location.getBlockX(), location.getBlockZ(), heightMap);
    }

    @Override
    public org.bukkit.block.Biome getBiome(int x, int z) {
        return this.getBiome(x, 0, z);
    }

    @Override
    public org.bukkit.block.Biome getBiome(int x, int y, int z) {
        return CraftBlock.biomeBaseToBiome((Registry<Biome>)this.getHandle().func_241828_r().func_243612_b(Registry.field_239720_u_), this.world.func_225526_b_(x >> 2, y >> 2, z >> 2));
    }

    @Override
    public void setBiome(int x, int z, org.bukkit.block.Biome bio) {
        for (int y = 0; y < this.getMaxHeight(); ++y) {
            this.setBiome(x, y, z, bio);
        }
    }

    @Override
    public void setBiome(int x, int y, int z, org.bukkit.block.Biome bio) {
        net.minecraft.world.chunk.Chunk chunk;
        Preconditions.checkArgument((bio != org.bukkit.block.Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)bio);
        Biome bb = CraftBlock.biomeToBiomeBase((Registry<Biome>)this.getHandle().func_241828_r().func_243612_b(Registry.field_239720_u_), bio);
        BlockPos pos = new BlockPos(x, 0, z);
        if (this.world.func_175667_e(pos) && (chunk = this.world.func_175726_f(pos)) != null) {
            chunk.func_225549_i_().setBiome(x >> 2, y >> 2, z >> 2, bb);
            chunk.func_76630_e();
        }
    }

    @Override
    public double getTemperature(int x, int z) {
        return this.getTemperature(x, 0, z);
    }

    @Override
    public double getTemperature(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        return this.world.func_225526_b_(x >> 2, y >> 2, z >> 2).func_225486_c(pos);
    }

    @Override
    public double getHumidity(int x, int z) {
        return this.getHumidity(x, 0, z);
    }

    @Override
    public double getHumidity(int x, int y, int z) {
        return this.world.func_225526_b_(x >> 2, y >> 2, z >> 2).func_76727_i();
    }

    @Override
    public List<Entity> getEntities() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Object o : this.world.field_217498_x.values()) {
            net.minecraft.entity.Entity mcEnt;
            CraftEntity bukkitEntity;
            if (!(o instanceof net.minecraft.entity.Entity) || (bukkitEntity = (mcEnt = (net.minecraft.entity.Entity)o).getBukkitEntity()) == null || !bukkitEntity.isValid()) continue;
            list.add(bukkitEntity);
        }
        return list;
    }

    @Override
    public List<LivingEntity> getLivingEntities() {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (Object o : this.world.field_217498_x.values()) {
            net.minecraft.entity.Entity mcEnt;
            CraftEntity bukkitEntity;
            if (!(o instanceof net.minecraft.entity.Entity) || (bukkitEntity = (mcEnt = (net.minecraft.entity.Entity)o).getBukkitEntity()) == null || !(bukkitEntity instanceof LivingEntity) || !bukkitEntity.isValid()) continue;
            list.add((LivingEntity)((Object)bukkitEntity));
        }
        return list;
    }

    @Override
    @Deprecated
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... classes) {
        return this.getEntitiesByClasses(classes);
    }

    @Override
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> clazz) {
        ArrayList<CraftEntity> list = new ArrayList<CraftEntity>();
        for (Object entity : this.world.field_217498_x.values()) {
            Class<?> bukkitClass;
            CraftEntity bukkitEntity;
            if (!(entity instanceof net.minecraft.entity.Entity) || (bukkitEntity = ((net.minecraft.entity.Entity)entity).getBukkitEntity()) == null || !clazz.isAssignableFrom(bukkitClass = bukkitEntity.getClass()) || !bukkitEntity.isValid()) continue;
            list.add(bukkitEntity);
        }
        return list;
    }

    @Override
    public Collection<Entity> getEntitiesByClasses(Class<?> ... classes) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        block0: for (Object entity : this.world.field_217498_x.values()) {
            CraftEntity bukkitEntity;
            if (!(entity instanceof net.minecraft.entity.Entity) || (bukkitEntity = ((net.minecraft.entity.Entity)entity).getBukkitEntity()) == null) continue;
            Class<?> bukkitClass = bukkitEntity.getClass();
            for (Class<?> clazz : classes) {
                if (!clazz.isAssignableFrom(bukkitClass)) continue;
                if (!bukkitEntity.isValid()) continue block0;
                list.add(bukkitEntity);
                continue block0;
            }
        }
        return list;
    }

    @Override
    public Collection<Entity> getNearbyEntities(Location location, double x, double y, double z) {
        return this.getNearbyEntities(location, x, y, z, null);
    }

    @Override
    public Collection<Entity> getNearbyEntities(Location location, double x, double y, double z, Predicate<Entity> filter) {
        Validate.notNull((Object)location, (String)"Location is null!");
        Validate.isTrue((boolean)this.equals(location.getWorld()), (String)"Location is from different world!");
        BoundingBox aabb = BoundingBox.of(location, x, y, z);
        return this.getNearbyEntities(aabb, filter);
    }

    @Override
    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox) {
        return this.getNearbyEntities(boundingBox, null);
    }

    @Override
    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox, Predicate<Entity> filter) {
        Validate.notNull((Object)boundingBox, (String)"Bounding box is null!");
        AxisAlignedBB bb = new AxisAlignedBB(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        List entityList = this.getHandle().func_175674_a((net.minecraft.entity.Entity)null, bb, null);
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(entityList.size());
        for (net.minecraft.entity.Entity entity : entityList) {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (filter != null && !filter.test(bukkitEntity)) continue;
            bukkitEntityList.add(bukkitEntity);
        }
        return bukkitEntityList;
    }

    @Override
    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance) {
        return this.rayTraceEntities(start, direction, maxDistance, null);
    }

    @Override
    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize) {
        return this.rayTraceEntities(start, direction, maxDistance, raySize, null);
    }

    @Override
    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, Predicate<Entity> filter) {
        return this.rayTraceEntities(start, direction, maxDistance, 0.0, filter);
    }

    @Override
    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize, Predicate<Entity> filter) {
        Validate.notNull((Object)start, (String)"Start location is null!");
        Validate.isTrue((boolean)this.equals(start.getWorld()), (String)"Start location is from different world!");
        start.checkFinite();
        Validate.notNull((Object)direction, (String)"Direction is null!");
        direction.checkFinite();
        Validate.isTrue((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude is 0!");
        if (maxDistance < 0.0) {
            return null;
        }
        Vector startPos = start.toVector();
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        BoundingBox aabb = BoundingBox.of(startPos, startPos).expandDirectional(dir).expand(raySize);
        Collection<Entity> entities = this.getNearbyEntities(aabb, filter);
        Entity nearestHitEntity = null;
        RayTraceResult nearestHitResult = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distanceSq;
            BoundingBox boundingBox = entity.getBoundingBox().expand(raySize);
            RayTraceResult hitResult = boundingBox.rayTrace(startPos, direction, maxDistance);
            if (hitResult == null || !((distanceSq = startPos.distanceSquared(hitResult.getHitPosition())) < nearestDistanceSq)) continue;
            nearestHitEntity = entity;
            nearestHitResult = hitResult;
            nearestDistanceSq = distanceSq;
        }
        return nearestHitEntity == null ? null : new RayTraceResult(nearestHitResult.getHitPosition(), nearestHitEntity, nearestHitResult.getHitBlockFace());
    }

    @Override
    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance) {
        return this.rayTraceBlocks(start, direction, maxDistance, FluidCollisionMode.NEVER, false);
    }

    @Override
    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        return this.rayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, false);
    }

    @Override
    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks) {
        Validate.notNull((Object)start, (String)"Start location is null!");
        Validate.isTrue((boolean)this.equals(start.getWorld()), (String)"Start location is from different world!");
        start.checkFinite();
        Validate.notNull((Object)direction, (String)"Direction is null!");
        direction.checkFinite();
        Validate.isTrue((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude is 0!");
        Validate.notNull((Object)((Object)fluidCollisionMode), (String)"Fluid collision mode is null!");
        if (maxDistance < 0.0) {
            return null;
        }
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        Vector3d startPos = new Vector3d(start.getX(), start.getY(), start.getZ());
        Vector3d endPos = new Vector3d(start.getX() + dir.getX(), start.getY() + dir.getY(), start.getZ() + dir.getZ());
        BlockRayTraceResult nmsHitResult = this.getHandle().func_217299_a(new RayTraceContext(startPos, endPos, ignorePassableBlocks ? RayTraceContext.BlockMode.COLLIDER : RayTraceContext.BlockMode.OUTLINE, CraftFluidCollisionMode.toNMS(fluidCollisionMode), null));
        return CraftRayTraceResult.fromNMS(this, (net.minecraft.util.math.RayTraceResult)nmsHitResult);
    }

    @Override
    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, double raySize, Predicate<Entity> filter) {
        RayTraceResult blockHit = this.rayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, ignorePassableBlocks);
        Vector startVec = null;
        double blockHitDistance = maxDistance;
        if (blockHit != null) {
            startVec = start.toVector();
            blockHitDistance = startVec.distance(blockHit.getHitPosition());
        }
        RayTraceResult entityHit = this.rayTraceEntities(start, direction, blockHitDistance, raySize, filter);
        if (blockHit == null) {
            return entityHit;
        }
        if (entityHit == null) {
            return blockHit;
        }
        double entityHitDistanceSquared = startVec.distanceSquared(entityHit.getHitPosition());
        if (entityHitDistanceSquared < blockHitDistance * blockHitDistance) {
            return entityHit;
        }
        return blockHit;
    }

    @Override
    public List<Player> getPlayers() {
        ArrayList<Player> list = new ArrayList<Player>(this.world.func_217369_A().size());
        for (PlayerEntity human : this.world.func_217369_A()) {
            CraftHumanEntity bukkitEntity = human.getBukkitEntity();
            if (bukkitEntity == null || !(bukkitEntity instanceof Player)) continue;
            list.add((Player)((Object)bukkitEntity));
        }
        return list;
    }

    @Override
    public void save() {
        this.server.checkSaveState();
        boolean oldSave = this.world.field_73058_d;
        this.world.field_73058_d = false;
        this.world.func_217445_a(null, false, false);
        this.world.field_73058_d = oldSave;
    }

    @Override
    public boolean isAutoSave() {
        return !this.world.field_73058_d;
    }

    @Override
    public void setAutoSave(boolean value) {
        this.world.field_73058_d = !value;
    }

    @Override
    public void setDifficulty(Difficulty difficulty) {
        this.getHandle().worldDataServer.func_230409_a_(net.minecraft.world.Difficulty.func_151523_a((int)difficulty.getValue()));
    }

    @Override
    public Difficulty getDifficulty() {
        return Difficulty.getByValue(this.getHandle().func_175659_aa().ordinal());
    }

    public BlockMetadataStore getBlockMetadata() {
        return this.blockMetadata;
    }

    @Override
    public boolean hasStorm() {
        return this.world.func_72912_H().func_76059_o();
    }

    @Override
    public void setStorm(boolean hasStorm) {
        this.world.func_72912_H().func_76084_b(hasStorm);
        this.setWeatherDuration(0);
        this.setClearWeatherDuration(0);
    }

    @Override
    public int getWeatherDuration() {
        return this.world.worldDataServer.func_76083_p();
    }

    @Override
    public void setWeatherDuration(int duration) {
        this.world.worldDataServer.func_76080_g(duration);
    }

    @Override
    public boolean isThundering() {
        return this.world.func_72912_H().func_76061_m();
    }

    @Override
    public void setThundering(boolean thundering) {
        this.world.worldDataServer.func_76069_a(thundering);
        this.setThunderDuration(0);
        this.setClearWeatherDuration(0);
    }

    @Override
    public int getThunderDuration() {
        return this.world.worldDataServer.func_76071_n();
    }

    @Override
    public void setThunderDuration(int duration) {
        this.world.worldDataServer.func_76090_f(duration);
    }

    @Override
    public boolean isClearWeather() {
        return !this.hasStorm() && !this.isThundering();
    }

    @Override
    public void setClearWeatherDuration(int duration) {
        this.world.worldDataServer.func_230391_a_(duration);
    }

    @Override
    public int getClearWeatherDuration() {
        return this.world.worldDataServer.func_230395_g_();
    }

    @Override
    public long getSeed() {
        return this.world.func_72905_C();
    }

    @Override
    public boolean getPVP() {
        return this.world.pvpMode;
    }

    @Override
    public void setPVP(boolean pvp) {
        this.world.pvpMode = pvp;
    }

    public void playEffect(Player player, Effect effect, int data) {
        this.playEffect(player.getLocation(), effect, data, 0);
    }

    @Override
    public void playEffect(Location location, Effect effect, int data) {
        this.playEffect(location, effect, data, 64);
    }

    @Override
    public <T> void playEffect(Location loc, Effect effect, T data) {
        this.playEffect(loc, effect, data, 64);
    }

    @Override
    public <T> void playEffect(Location loc, Effect effect, T data, int radius) {
        if (data != null) {
            Validate.isTrue((effect.getData() != null && effect.getData().isAssignableFrom(data.getClass()) ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!");
        } else {
            Validate.isTrue((effect.getData() == null ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!");
        }
        int datavalue = data == null ? 0 : CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue, radius);
    }

    @Override
    public void playEffect(Location location, Effect effect, int data, int radius) {
        Validate.notNull((Object)location, (String)"Location cannot be null");
        Validate.notNull((Object)((Object)effect), (String)"Effect cannot be null");
        Validate.notNull((Object)location.getWorld(), (String)"World cannot be null");
        int packetData = effect.getId();
        SPlaySoundEventPacket packet = new SPlaySoundEventPacket(packetData, new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ()), data, false);
        radius *= radius;
        for (Player player : this.getPlayers()) {
            int distance;
            if (((CraftPlayer)player).getHandle().field_71135_a == null || !location.getWorld().equals(player.getWorld()) || (distance = (int)player.getLocation().distanceSquared(location)) > radius) continue;
            ((CraftPlayer)player).getHandle().field_71135_a.func_147359_a((IPacket)packet);
        }
    }

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> clazz) throws IllegalArgumentException {
        return this.spawn(location, clazz, null, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    @Override
    public FallingBlock spawnFallingBlock(Location location, MaterialData data) throws IllegalArgumentException {
        Validate.notNull((Object)data, (String)"MaterialData cannot be null");
        return this.spawnFallingBlock(location, data.getItemType(), data.getData());
    }

    @Override
    public FallingBlock spawnFallingBlock(Location location, Material material, byte data) throws IllegalArgumentException {
        Validate.notNull((Object)location, (String)"Location cannot be null");
        Validate.notNull((Object)material, (String)"Material cannot be null");
        Validate.isTrue((boolean)material.isBlock(), (String)"Material must be a block");
        FallingBlockEntity entity = new FallingBlockEntity((net.minecraft.world.World)this.world, location.getX(), location.getY(), location.getZ(), CraftMagicNumbers.getBlock(material).func_176223_P());
        entity.field_145812_b = 1;
        this.world.addEntity((net.minecraft.entity.Entity)entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)((Object)entity.getBukkitEntity());
    }

    @Override
    public FallingBlock spawnFallingBlock(Location location, BlockData data) throws IllegalArgumentException {
        Validate.notNull((Object)location, (String)"Location cannot be null");
        Validate.notNull((Object)data, (String)"Material cannot be null");
        FallingBlockEntity entity = new FallingBlockEntity((net.minecraft.world.World)this.world, location.getX(), location.getY(), location.getZ(), ((CraftBlockData)data).getState());
        entity.field_145812_b = 1;
        this.world.addEntity((net.minecraft.entity.Entity)entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)((Object)entity.getBukkitEntity());
    }

    public net.minecraft.entity.Entity createEntity(Location location, Class<? extends Entity> clazz) throws IllegalArgumentException {
        if (location == null || clazz == null) {
            throw new IllegalArgumentException("Location or entity class cannot be null");
        }
        Object entity = null;
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        float pitch = location.getPitch();
        float yaw = location.getYaw();
        if (Boat.class.isAssignableFrom(clazz)) {
            entity = new BoatEntity((net.minecraft.world.World)this.world, x, y, z);
            entity.func_70012_b(x, y, z, yaw, pitch);
        } else if (FallingBlock.class.isAssignableFrom(clazz)) {
            entity = new FallingBlockEntity((net.minecraft.world.World)this.world, x, y, z, this.world.func_180495_p(new BlockPos(x, y, z)));
        } else if (Projectile.class.isAssignableFrom(clazz)) {
            if (Snowball.class.isAssignableFrom(clazz)) {
                entity = new SnowballEntity((net.minecraft.world.World)this.world, x, y, z);
            } else if (Egg.class.isAssignableFrom(clazz)) {
                entity = new EggEntity((net.minecraft.world.World)this.world, x, y, z);
            } else if (AbstractArrow.class.isAssignableFrom(clazz)) {
                if (TippedArrow.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_200790_d.func_200721_a((net.minecraft.world.World)this.world);
                    ((ArrowEntity)entity).setType(CraftPotionUtil.fromBukkit(new PotionData(PotionType.WATER, false, false)));
                } else {
                    entity = SpectralArrow.class.isAssignableFrom(clazz) ? EntityType.field_200747_am.func_200721_a((net.minecraft.world.World)this.world) : (Trident.class.isAssignableFrom(clazz) ? EntityType.field_203098_aL.func_200721_a((net.minecraft.world.World)this.world) : EntityType.field_200790_d.func_200721_a((net.minecraft.world.World)this.world));
                }
                entity.func_70012_b(x, y, z, 0.0f, 0.0f);
            } else if (ThrownExpBottle.class.isAssignableFrom(clazz)) {
                entity = EntityType.field_200753_as.func_200721_a((net.minecraft.world.World)this.world);
                entity.func_70012_b(x, y, z, 0.0f, 0.0f);
            } else if (EnderPearl.class.isAssignableFrom(clazz)) {
                entity = EntityType.field_200752_ar.func_200721_a((net.minecraft.world.World)this.world);
                entity.func_70012_b(x, y, z, 0.0f, 0.0f);
            } else if (ThrownPotion.class.isAssignableFrom(clazz)) {
                if (LingeringPotion.class.isAssignableFrom(clazz)) {
                    entity = new PotionEntity((net.minecraft.world.World)this.world, x, y, z);
                    ((PotionEntity)entity).func_213884_b(CraftItemStack.asNMSCopy(new ItemStack(Material.LINGERING_POTION, 1)));
                } else {
                    entity = new PotionEntity((net.minecraft.world.World)this.world, x, y, z);
                    ((PotionEntity)entity).func_213884_b(CraftItemStack.asNMSCopy(new ItemStack(Material.SPLASH_POTION, 1)));
                }
            } else if (Fireball.class.isAssignableFrom(clazz)) {
                entity = SmallFireball.class.isAssignableFrom(clazz) ? EntityType.field_200744_aj.func_200721_a((net.minecraft.world.World)this.world) : (WitherSkull.class.isAssignableFrom(clazz) ? EntityType.field_200723_aB.func_200721_a((net.minecraft.world.World)this.world) : (DragonFireball.class.isAssignableFrom(clazz) ? EntityType.field_200799_m.func_200721_a((net.minecraft.world.World)this.world) : EntityType.field_200767_G.func_200721_a((net.minecraft.world.World)this.world)));
                entity.func_70012_b(x, y, z, yaw, pitch);
                Vector direction = location.getDirection().multiply(10);
                ((DamagingProjectileEntity)entity).setDirection(direction.getX(), direction.getY(), direction.getZ());
            } else if (ShulkerBullet.class.isAssignableFrom(clazz)) {
                entity = EntityType.field_200739_ae.func_200721_a((net.minecraft.world.World)this.world);
                entity.func_70012_b(x, y, z, yaw, pitch);
            } else if (LlamaSpit.class.isAssignableFrom(clazz)) {
                entity = EntityType.field_200770_J.func_200721_a((net.minecraft.world.World)this.world);
                entity.func_70012_b(x, y, z, yaw, pitch);
            } else if (Firework.class.isAssignableFrom(clazz)) {
                entity = new FireworkRocketEntity((net.minecraft.world.World)this.world, x, y, z, net.minecraft.item.ItemStack.field_190927_a);
            }
        } else if (Minecart.class.isAssignableFrom(clazz)) {
            entity = PoweredMinecart.class.isAssignableFrom(clazz) ? new FurnaceMinecartEntity((net.minecraft.world.World)this.world, x, y, z) : (StorageMinecart.class.isAssignableFrom(clazz) ? new ChestMinecartEntity((net.minecraft.world.World)this.world, x, y, z) : (ExplosiveMinecart.class.isAssignableFrom(clazz) ? new TNTMinecartEntity((net.minecraft.world.World)this.world, x, y, z) : (HopperMinecart.class.isAssignableFrom(clazz) ? new HopperMinecartEntity((net.minecraft.world.World)this.world, x, y, z) : (SpawnerMinecart.class.isAssignableFrom(clazz) ? new SpawnerMinecartEntity((net.minecraft.world.World)this.world, x, y, z) : (CommandMinecart.class.isAssignableFrom(clazz) ? new MinecartEntity((net.minecraft.world.World)this.world, x, y, z) : new MinecartEntity((net.minecraft.world.World)this.world, x, y, z))))));
        } else if (EnderSignal.class.isAssignableFrom(clazz)) {
            entity = new EyeOfEnderEntity((net.minecraft.world.World)this.world, x, y, z);
        } else if (EnderCrystal.class.isAssignableFrom(clazz)) {
            entity = EntityType.field_200801_o.func_200721_a((net.minecraft.world.World)this.world);
            entity.func_70012_b(x, y, z, 0.0f, 0.0f);
        } else if (LivingEntity.class.isAssignableFrom(clazz)) {
            if (Chicken.class.isAssignableFrom(clazz)) {
                entity = EntityType.field_200795_i.func_200721_a((net.minecraft.world.World)this.world);
            } else if (Cow.class.isAssignableFrom(clazz)) {
                entity = MushroomCow.class.isAssignableFrom(clazz) ? EntityType.field_200780_T.func_200721_a((net.minecraft.world.World)this.world) : EntityType.field_200796_j.func_200721_a((net.minecraft.world.World)this.world);
            } else if (Golem.class.isAssignableFrom(clazz)) {
                if (Snowman.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_200745_ak.func_200721_a((net.minecraft.world.World)this.world);
                } else if (IronGolem.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_200757_aw.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Shulker.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_200738_ad.func_200721_a((net.minecraft.world.World)this.world);
                }
            } else if (Creeper.class.isAssignableFrom(clazz)) {
                entity = EntityType.field_200797_k.func_200721_a((net.minecraft.world.World)this.world);
            } else if (Ghast.class.isAssignableFrom(clazz)) {
                entity = EntityType.field_200811_y.func_200721_a((net.minecraft.world.World)this.world);
            } else if (Pig.class.isAssignableFrom(clazz)) {
                entity = EntityType.field_200784_X.func_200721_a((net.minecraft.world.World)this.world);
            } else if (!Player.class.isAssignableFrom(clazz)) {
                if (Sheep.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_200737_ac.func_200721_a((net.minecraft.world.World)this.world);
                } else if (AbstractHorse.class.isAssignableFrom(clazz)) {
                    if (ChestedHorse.class.isAssignableFrom(clazz)) {
                        if (Donkey.class.isAssignableFrom(clazz)) {
                            entity = EntityType.field_200798_l.func_200721_a((net.minecraft.world.World)this.world);
                        } else if (Mule.class.isAssignableFrom(clazz)) {
                            entity = EntityType.field_200779_S.func_200721_a((net.minecraft.world.World)this.world);
                        } else if (Llama.class.isAssignableFrom(clazz)) {
                            entity = TraderLlama.class.isAssignableFrom(clazz) ? EntityType.field_220354_ax.func_200721_a((net.minecraft.world.World)this.world) : EntityType.field_200769_I.func_200721_a((net.minecraft.world.World)this.world);
                        }
                    } else {
                        entity = SkeletonHorse.class.isAssignableFrom(clazz) ? EntityType.field_200742_ah.func_200721_a((net.minecraft.world.World)this.world) : (ZombieHorse.class.isAssignableFrom(clazz) ? EntityType.field_200726_aE.func_200721_a((net.minecraft.world.World)this.world) : EntityType.field_200762_B.func_200721_a((net.minecraft.world.World)this.world));
                    }
                } else if (Skeleton.class.isAssignableFrom(clazz)) {
                    entity = Stray.class.isAssignableFrom(clazz) ? EntityType.field_200750_ap.func_200721_a((net.minecraft.world.World)this.world) : (WitherSkeleton.class.isAssignableFrom(clazz) ? EntityType.field_200722_aA.func_200721_a((net.minecraft.world.World)this.world) : EntityType.field_200741_ag.func_200721_a((net.minecraft.world.World)this.world));
                } else if (Slime.class.isAssignableFrom(clazz)) {
                    entity = MagmaCube.class.isAssignableFrom(clazz) ? EntityType.field_200771_K.func_200721_a((net.minecraft.world.World)this.world) : EntityType.field_200743_ai.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Spider.class.isAssignableFrom(clazz)) {
                    entity = CaveSpider.class.isAssignableFrom(clazz) ? EntityType.field_200794_h.func_200721_a((net.minecraft.world.World)this.world) : EntityType.field_200748_an.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Squid.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_200749_ao.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Tameable.class.isAssignableFrom(clazz)) {
                    if (Wolf.class.isAssignableFrom(clazz)) {
                        entity = EntityType.field_200724_aC.func_200721_a((net.minecraft.world.World)this.world);
                    } else if (Parrot.class.isAssignableFrom(clazz)) {
                        entity = EntityType.field_200783_W.func_200721_a((net.minecraft.world.World)this.world);
                    } else if (Cat.class.isAssignableFrom(clazz)) {
                        entity = EntityType.field_220360_g.func_200721_a((net.minecraft.world.World)this.world);
                    }
                } else if (PigZombie.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_233592_ba_.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Zombie.class.isAssignableFrom(clazz)) {
                    entity = Husk.class.isAssignableFrom(clazz) ? EntityType.field_200763_C.func_200721_a((net.minecraft.world.World)this.world) : (ZombieVillager.class.isAssignableFrom(clazz) ? EntityType.field_200727_aF.func_200721_a((net.minecraft.world.World)this.world) : (Drowned.class.isAssignableFrom(clazz) ? EntityType.field_204724_o.func_200721_a((net.minecraft.world.World)this.world) : new ZombieEntity((net.minecraft.world.World)this.world)));
                } else if (Giant.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_200812_z.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Silverfish.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_200740_af.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Enderman.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_200803_q.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Blaze.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_200792_f.func_200721_a((net.minecraft.world.World)this.world);
                } else if (AbstractVillager.class.isAssignableFrom(clazz)) {
                    if (Villager.class.isAssignableFrom(clazz)) {
                        entity = EntityType.field_200756_av.func_200721_a((net.minecraft.world.World)this.world);
                    } else if (WanderingTrader.class.isAssignableFrom(clazz)) {
                        entity = EntityType.field_220351_aK.func_200721_a((net.minecraft.world.World)this.world);
                    }
                } else if (Witch.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_200759_ay.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Wither.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_200760_az.func_200721_a((net.minecraft.world.World)this.world);
                } else if (ComplexLivingEntity.class.isAssignableFrom(clazz)) {
                    if (EnderDragon.class.isAssignableFrom(clazz)) {
                        entity = EntityType.field_200802_p.func_200721_a((net.minecraft.world.World)this.world);
                    }
                } else if (Ambient.class.isAssignableFrom(clazz)) {
                    if (Bat.class.isAssignableFrom(clazz)) {
                        entity = EntityType.field_200791_e.func_200721_a((net.minecraft.world.World)this.world);
                    }
                } else if (Rabbit.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_200736_ab.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Endermite.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_200804_r.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Guardian.class.isAssignableFrom(clazz)) {
                    entity = ElderGuardian.class.isAssignableFrom(clazz) ? EntityType.field_200800_n.func_200721_a((net.minecraft.world.World)this.world) : EntityType.field_200761_A.func_200721_a((net.minecraft.world.World)this.world);
                } else if (ArmorStand.class.isAssignableFrom(clazz)) {
                    entity = new ArmorStandEntity((net.minecraft.world.World)this.world, x, y, z);
                } else if (PolarBear.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_200786_Z.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Vex.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_200755_au.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Illager.class.isAssignableFrom(clazz)) {
                    if (Spellcaster.class.isAssignableFrom(clazz)) {
                        if (Evoker.class.isAssignableFrom(clazz)) {
                            entity = EntityType.field_200806_t.func_200721_a((net.minecraft.world.World)this.world);
                        } else if (Illusioner.class.isAssignableFrom(clazz)) {
                            entity = EntityType.field_200764_D.func_200721_a((net.minecraft.world.World)this.world);
                        }
                    } else if (Vindicator.class.isAssignableFrom(clazz)) {
                        entity = EntityType.field_200758_ax.func_200721_a((net.minecraft.world.World)this.world);
                    } else if (Pillager.class.isAssignableFrom(clazz)) {
                        entity = EntityType.field_220350_aJ.func_200721_a((net.minecraft.world.World)this.world);
                    }
                } else if (Turtle.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_203099_aq.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Phantom.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_203097_aH.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Fish.class.isAssignableFrom(clazz)) {
                    if (Cod.class.isAssignableFrom(clazz)) {
                        entity = EntityType.field_203780_j.func_200721_a((net.minecraft.world.World)this.world);
                    } else if (PufferFish.class.isAssignableFrom(clazz)) {
                        entity = EntityType.field_203779_Z.func_200721_a((net.minecraft.world.World)this.world);
                    } else if (Salmon.class.isAssignableFrom(clazz)) {
                        entity = EntityType.field_203778_ae.func_200721_a((net.minecraft.world.World)this.world);
                    } else if (TropicalFish.class.isAssignableFrom(clazz)) {
                        entity = EntityType.field_204262_at.func_200721_a((net.minecraft.world.World)this.world);
                    }
                } else if (Dolphin.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_205137_n.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Ocelot.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_200781_U.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Ravager.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_220352_aU.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Panda.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_220353_aa.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Fox.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_220356_B.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Bee.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_226289_e_.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Hoglin.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_233588_G_.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Piglin.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_233591_ai_.func_200721_a((net.minecraft.world.World)this.world);
                } else if (PiglinBrute.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_242287_aj.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Strider.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_233589_aE_.func_200721_a((net.minecraft.world.World)this.world);
                } else if (Zoglin.class.isAssignableFrom(clazz)) {
                    entity = EntityType.field_233590_aW_.func_200721_a((net.minecraft.world.World)this.world);
                }
            }
            if (entity != null) {
                entity.func_70080_a(x, y, z, yaw, pitch);
                entity.func_70034_d(yaw);
            }
        } else if (Hanging.class.isAssignableFrom(clazz)) {
            BlockFace[] blockFaceArray;
            BlockFace face = BlockFace.SELF;
            int width = 16;
            int height = 16;
            if (ItemFrame.class.isAssignableFrom(clazz)) {
                width = 12;
                height = 12;
            } else if (LeashHitch.class.isAssignableFrom(clazz)) {
                width = 9;
                height = 9;
            }
            if (ItemFrame.class.isAssignableFrom(clazz)) {
                BlockFace[] blockFaceArray2 = new BlockFace[6];
                blockFaceArray2[0] = BlockFace.EAST;
                blockFaceArray2[1] = BlockFace.NORTH;
                blockFaceArray2[2] = BlockFace.WEST;
                blockFaceArray2[3] = BlockFace.SOUTH;
                blockFaceArray2[4] = BlockFace.UP;
                blockFaceArray = blockFaceArray2;
                blockFaceArray2[5] = BlockFace.DOWN;
            } else {
                BlockFace[] blockFaceArray3 = new BlockFace[4];
                blockFaceArray3[0] = BlockFace.EAST;
                blockFaceArray3[1] = BlockFace.NORTH;
                blockFaceArray3[2] = BlockFace.WEST;
                blockFaceArray = blockFaceArray3;
                blockFaceArray3[3] = BlockFace.SOUTH;
            }
            BlockFace[] faces = blockFaceArray;
            BlockPos pos = new BlockPos(x, y, z);
            for (BlockFace dir : faces) {
                BlockState nmsBlock = this.world.func_180495_p(pos.func_177972_a(CraftBlock.blockFaceToNotch(dir)));
                if (!nmsBlock.func_185904_a().func_76220_a() && !RedstoneDiodeBlock.func_185546_B((BlockState)nmsBlock)) continue;
                boolean taken = false;
                AxisAlignedBB bb = ItemFrame.class.isAssignableFrom(clazz) ? ItemFrameEntity.calculateBoundingBox(null, (BlockPos)pos, (Direction)CraftBlock.blockFaceToNotch(dir).func_176734_d(), (int)width, (int)height) : HangingEntity.calculateBoundingBox(null, (BlockPos)pos, (Direction)CraftBlock.blockFaceToNotch(dir).func_176734_d(), (int)width, (int)height);
                List list = this.world.func_72839_b(null, bb);
                Iterator it = list.iterator();
                while (!taken && it.hasNext()) {
                    net.minecraft.entity.Entity e = (net.minecraft.entity.Entity)it.next();
                    if (!(e instanceof HangingEntity)) continue;
                    taken = true;
                }
                if (taken) continue;
                face = dir;
                break;
            }
            if (LeashHitch.class.isAssignableFrom(clazz)) {
                entity = new LeashKnotEntity((net.minecraft.world.World)this.world, new BlockPos(x, y, z));
                entity.field_98038_p = true;
            } else {
                Preconditions.checkArgument((face != BlockFace.SELF ? 1 : 0) != 0, (String)"Cannot spawn hanging entity for %s at %s (no free face)", (Object)clazz.getName(), (Object)location);
                Direction dir = CraftBlock.blockFaceToNotch(face).func_176734_d();
                if (Painting.class.isAssignableFrom(clazz)) {
                    entity = new PaintingEntity((net.minecraft.world.World)this.world, new BlockPos(x, y, z), dir);
                } else if (ItemFrame.class.isAssignableFrom(clazz)) {
                    entity = new ItemFrameEntity((net.minecraft.world.World)this.world, new BlockPos(x, y, z), dir);
                }
            }
            if (entity != null && !((HangingEntity)entity).func_70518_d()) {
                throw new IllegalArgumentException("Cannot spawn hanging entity for " + clazz.getName() + " at " + location);
            }
        } else if (TNTPrimed.class.isAssignableFrom(clazz)) {
            entity = new TNTEntity((net.minecraft.world.World)this.world, x, y, z, null);
        } else if (ExperienceOrb.class.isAssignableFrom(clazz)) {
            entity = new ExperienceOrbEntity((net.minecraft.world.World)this.world, x, y, z, 0);
        } else if (LightningStrike.class.isAssignableFrom(clazz)) {
            entity = EntityType.field_200728_aG.func_200721_a((net.minecraft.world.World)this.world);
        } else if (AreaEffectCloud.class.isAssignableFrom(clazz)) {
            entity = new AreaEffectCloudEntity((net.minecraft.world.World)this.world, x, y, z);
        } else if (EvokerFangs.class.isAssignableFrom(clazz)) {
            entity = new EvokerFangsEntity((net.minecraft.world.World)this.world, x, y, z, (float)Math.toRadians(yaw), 0, null);
        }
        if (entity != null) {
            return entity;
        }
        throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName());
    }

    public <T extends Entity> T addEntity(net.minecraft.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.addEntity(entity, reason, null);
    }

    public <T extends Entity> T addEntity(net.minecraft.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason, Consumer<T> function) throws IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Cannot spawn null entity");
        if (entity instanceof MobEntity) {
            ((MobEntity)entity).func_213386_a((IServerWorld)this.getHandle(), this.getHandle().func_175649_E(entity.func_233580_cy_()), SpawnReason.COMMAND, (ILivingEntityData)null, null);
        }
        if (function != null) {
            function.accept(entity.getBukkitEntity());
        }
        this.world.addEntity(entity, reason);
        return (T)entity.getBukkitEntity();
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<T> function, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        net.minecraft.entity.Entity entity = this.createEntity(location, clazz);
        return this.addEntity(entity, reason, function);
    }

    @Override
    public ChunkSnapshot getEmptyChunkSnapshot(int x, int z, boolean includeBiome, boolean includeBiomeTempRain) {
        return CraftChunk.getEmptyChunkSnapshot(x, z, this, includeBiome, includeBiomeTempRain);
    }

    @Override
    public void setSpawnFlags(boolean allowMonsters, boolean allowAnimals) {
        this.world.func_72891_a(allowMonsters, allowAnimals);
    }

    @Override
    public boolean getAllowAnimals() {
        return this.world.func_72863_F().field_217247_m;
    }

    @Override
    public boolean getAllowMonsters() {
        return this.world.func_72863_F().field_217246_l;
    }

    @Override
    public int getMinHeight() {
        return 0;
    }

    @Override
    public int getMaxHeight() {
        return this.world.func_234938_ad_();
    }

    @Override
    public int getSeaLevel() {
        return this.world.func_181545_F();
    }

    @Override
    public boolean getKeepSpawnInMemory() {
        return this.world.keepSpawnInMemory;
    }

    @Override
    public void setKeepSpawnInMemory(boolean keepLoaded) {
        this.world.keepSpawnInMemory = keepLoaded;
        BlockPos chunkcoordinates = this.world.func_241135_u_();
        if (keepLoaded) {
            this.world.func_72863_F().func_217228_a(TicketType.field_219488_a, new ChunkPos(chunkcoordinates), 11, (Object)Unit.INSTANCE);
        } else {
            this.world.func_72863_F().func_217222_b(TicketType.field_219488_a, new ChunkPos(chunkcoordinates), 11, (Object)Unit.INSTANCE);
        }
    }

    public int hashCode() {
        return this.getUID().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftWorld other = (CraftWorld)obj;
        return this.getUID() == other.getUID();
    }

    @Override
    public File getWorldFolder() {
        return this.world.convertable.func_237291_a_(this.world.func_234923_W_());
    }

    @Override
    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage(this.server.getMessenger(), source, channel, message);
        for (Player player : this.getPlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    @Override
    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getPlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    @Override
    public WorldType getWorldType() {
        return this.world.func_241109_A_() ? WorldType.FLAT : WorldType.NORMAL;
    }

    @Override
    public boolean canGenerateStructures() {
        return this.world.func_73046_m().func_240793_aU_().func_230418_z_().func_236222_c_();
    }

    @Override
    public boolean isHardcore() {
        return this.world.func_72912_H().func_76093_s();
    }

    @Override
    public void setHardcore(boolean hardcore) {
        this.world.func_73046_m().func_240793_aU_().func_230408_H_().field_77170_d = hardcore;
    }

    @Override
    public long getTicksPerAnimalSpawns() {
        return this.world.ticksPerAnimalSpawns;
    }

    @Override
    public void setTicksPerAnimalSpawns(int ticksPerAnimalSpawns) {
        this.world.ticksPerAnimalSpawns = ticksPerAnimalSpawns;
    }

    @Override
    public long getTicksPerMonsterSpawns() {
        return this.world.ticksPerMonsterSpawns;
    }

    @Override
    public void setTicksPerMonsterSpawns(int ticksPerMonsterSpawns) {
        this.world.ticksPerMonsterSpawns = ticksPerMonsterSpawns;
    }

    @Override
    public long getTicksPerWaterSpawns() {
        return this.world.ticksPerWaterSpawns;
    }

    @Override
    public void setTicksPerWaterSpawns(int ticksPerWaterSpawns) {
        this.world.ticksPerWaterSpawns = ticksPerWaterSpawns;
    }

    @Override
    public long getTicksPerWaterAmbientSpawns() {
        return this.world.ticksPerWaterAmbientSpawns;
    }

    @Override
    public void setTicksPerWaterAmbientSpawns(int ticksPerWaterAmbientSpawns) {
        this.world.ticksPerWaterAmbientSpawns = ticksPerWaterAmbientSpawns;
    }

    @Override
    public long getTicksPerAmbientSpawns() {
        return this.world.ticksPerAmbientSpawns;
    }

    @Override
    public void setTicksPerAmbientSpawns(int ticksPerAmbientSpawns) {
        this.world.ticksPerAmbientSpawns = ticksPerAmbientSpawns;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getWorldMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getWorldMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getWorldMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getWorldMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public int getMonsterSpawnLimit() {
        if (this.monsterSpawn < 0) {
            return this.server.getMonsterSpawnLimit();
        }
        return this.monsterSpawn;
    }

    @Override
    public void setMonsterSpawnLimit(int limit) {
        this.monsterSpawn = limit;
    }

    @Override
    public int getAnimalSpawnLimit() {
        if (this.animalSpawn < 0) {
            return this.server.getAnimalSpawnLimit();
        }
        return this.animalSpawn;
    }

    @Override
    public void setAnimalSpawnLimit(int limit) {
        this.animalSpawn = limit;
    }

    @Override
    public int getWaterAnimalSpawnLimit() {
        if (this.waterAnimalSpawn < 0) {
            return this.server.getWaterAnimalSpawnLimit();
        }
        return this.waterAnimalSpawn;
    }

    @Override
    public void setWaterAnimalSpawnLimit(int limit) {
        this.waterAnimalSpawn = limit;
    }

    @Override
    public int getWaterAmbientSpawnLimit() {
        if (this.waterAmbientSpawn < 0) {
            return this.server.getWaterAmbientSpawnLimit();
        }
        return this.waterAmbientSpawn;
    }

    @Override
    public void setWaterAmbientSpawnLimit(int limit) {
        this.waterAmbientSpawn = limit;
    }

    @Override
    public int getAmbientSpawnLimit() {
        if (this.ambientSpawn < 0) {
            return this.server.getAmbientSpawnLimit();
        }
        return this.ambientSpawn;
    }

    @Override
    public void setAmbientSpawnLimit(int limit) {
        this.ambientSpawn = limit;
    }

    @Override
    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    @Override
    public void playSound(Location loc, String sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    @Override
    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        this.getHandle().func_184148_a(null, x, y, z, CraftSound.getSoundEffect(sound), net.minecraft.util.SoundCategory.valueOf((String)category.name()), volume, pitch);
    }

    @Override
    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        SPlaySoundPacket packet = new SPlaySoundPacket(new ResourceLocation(sound), net.minecraft.util.SoundCategory.valueOf((String)category.name()), new Vector3d(x, y, z), volume, pitch);
        this.world.func_73046_m().func_184103_al().func_148543_a(null, x, y, z, volume > 1.0f ? (double)(16.0f * volume) : 16.0, this.world.func_234923_W_(), (IPacket)packet);
    }

    public static synchronized Map<String, GameRules.RuleKey<?>> getGameRulesNMS() {
        if (gamerules != null) {
            return gamerules;
        }
        final HashMap gamerules = new HashMap();
        GameRules.func_223590_a((GameRules.IRuleEntryVisitor)new GameRules.IRuleEntryVisitor(){

            public <T extends GameRules.RuleValue<T>> void func_223481_a(GameRules.RuleKey<T> gamerules_gamerulekey, GameRules.RuleType<T> gamerules_gameruledefinition) {
                gamerules.put(gamerules_gamerulekey.func_223576_a(), gamerules_gamerulekey);
            }
        });
        CraftWorld.gamerules = gamerules;
        return CraftWorld.gamerules;
    }

    public static synchronized Map<String, GameRules.RuleType<?>> getGameRuleDefinitions() {
        if (gameruleDefinitions != null) {
            return gameruleDefinitions;
        }
        final HashMap gameruleDefinitions = new HashMap();
        GameRules.func_223590_a((GameRules.IRuleEntryVisitor)new GameRules.IRuleEntryVisitor(){

            public <T extends GameRules.RuleValue<T>> void func_223481_a(GameRules.RuleKey<T> gamerules_gamerulekey, GameRules.RuleType<T> gamerules_gameruledefinition) {
                gameruleDefinitions.put(gamerules_gamerulekey.func_223576_a(), gamerules_gameruledefinition);
            }
        });
        CraftWorld.gameruleDefinitions = gameruleDefinitions;
        return CraftWorld.gameruleDefinitions;
    }

    @Override
    public String getGameRuleValue(String rule) {
        if (rule == null) {
            return null;
        }
        GameRules.RuleValue value = this.getHandle().func_82736_K().func_223585_a(CraftWorld.getGameRulesNMS().get(rule));
        return value != null ? value.toString() : "";
    }

    @Override
    public boolean setGameRuleValue(String rule, String value) {
        if (rule == null || value == null) {
            return false;
        }
        if (!this.isGameRule(rule)) {
            return false;
        }
        GameRules.RuleValue handle = this.getHandle().func_82736_K().func_223585_a(CraftWorld.getGameRulesNMS().get(rule));
        handle.func_223553_a(value);
        handle.func_223556_a(this.getHandle().func_73046_m());
        return true;
    }

    @Override
    public String[] getGameRules() {
        return CraftWorld.getGameRulesNMS().keySet().toArray(new String[CraftWorld.getGameRulesNMS().size()]);
    }

    @Override
    public boolean isGameRule(String rule) {
        Validate.isTrue((rule != null && !rule.isEmpty() ? 1 : 0) != 0, (String)"Rule cannot be null nor empty");
        return CraftWorld.getGameRulesNMS().containsKey(rule);
    }

    @Override
    public <T> T getGameRuleValue(GameRule<T> rule) {
        Validate.notNull(rule, (String)"GameRule cannot be null");
        return this.convert(rule, this.getHandle().func_82736_K().func_223585_a(CraftWorld.getGameRulesNMS().get(rule.getName())));
    }

    @Override
    public <T> T getGameRuleDefault(GameRule<T> rule) {
        Validate.notNull(rule, (String)"GameRule cannot be null");
        return this.convert(rule, CraftWorld.getGameRuleDefinitions().get(rule.getName()).func_223579_a());
    }

    @Override
    public <T> boolean setGameRule(GameRule<T> rule, T newValue) {
        Validate.notNull(rule, (String)"GameRule cannot be null");
        Validate.notNull(newValue, (String)"GameRule value cannot be null");
        if (!this.isGameRule(rule.getName())) {
            return false;
        }
        GameRules.RuleValue handle = this.getHandle().func_82736_K().func_223585_a(CraftWorld.getGameRulesNMS().get(rule.getName()));
        handle.func_223553_a(newValue.toString());
        handle.func_223556_a(this.getHandle().func_73046_m());
        return true;
    }

    private <T> T convert(GameRule<T> rule, GameRules.RuleValue<?> value) {
        if (value == null) {
            return null;
        }
        if (value instanceof GameRules.BooleanValue) {
            return rule.getType().cast(((GameRules.BooleanValue)value).func_223572_a());
        }
        if (value instanceof GameRules.IntegerValue) {
            return rule.getType().cast(value.func_223557_c());
        }
        throw new IllegalArgumentException("Invalid GameRule type (" + value + ") for GameRule " + rule.getName());
    }

    @Override
    public WorldBorder getWorldBorder() {
        if (this.worldBorder == null) {
            this.worldBorder = new CraftWorldBorder(this);
        }
        return this.worldBorder;
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count) {
        this.spawnParticle(particle, x, y, z, count, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, T data) {
        this.spawnParticle(particle, x, y, z, count, 0.0, 0.0, 0.0, data);
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, data, false);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data, force);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        if (data != null && !particle.getDataType().isInstance(data)) {
            throw new IllegalArgumentException("data should be " + particle.getDataType() + " got " + data.getClass());
        }
        this.getHandle().sendParticles(null, CraftParticle.toNMS(particle, data), x, y, z, count, offsetX, offsetY, offsetZ, extra, force);
    }

    @Override
    public Location locateNearestStructure(Location origin, StructureType structureType, int radius, boolean findUnexplored) {
        BlockPos originPos = new BlockPos(origin.getX(), origin.getY(), origin.getZ());
        BlockPos nearest = this.getHandle().func_72863_F().func_201711_g().func_235956_a_(this.getHandle(), (Structure)Structure.field_236365_a_.get((Object)structureType.getName()), originPos, radius, findUnexplored);
        return nearest == null ? null : new Location(this, nearest.func_177958_n(), nearest.func_177956_o(), nearest.func_177952_p());
    }

    @Override
    public Raid locateNearestRaid(Location location, int radius) {
        Validate.notNull((Object)location, (String)"Location cannot be null");
        Validate.isTrue((radius >= 0 ? 1 : 0) != 0, (String)"Radius cannot be negative");
        RaidManager persistentRaid = this.world.func_217452_C();
        net.minecraft.world.raid.Raid raid = persistentRaid.func_215174_a(new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ()), radius * radius);
        return raid == null ? null : new CraftRaid(raid);
    }

    @Override
    public List<Raid> getRaids() {
        RaidManager persistentRaid = this.world.func_217452_C();
        return persistentRaid.field_215175_a.values().stream().map(CraftRaid::new).collect(Collectors.toList());
    }

    @Override
    public DragonBattle getEnderDragonBattle() {
        return this.getHandle().func_241110_C_() == null ? null : new CraftDragonBattle(this.getHandle().func_241110_C_());
    }

    public TileEntity getTileEntityAt(int x, int y, int z) {
        return this.world.func_175625_s(new BlockPos(x, y, z));
    }

    @Override
    public int getViewDistance() {
        return this.world.spigotConfig.viewDistance;
    }

    @Override
    public World.Spigot spigot() {
        return this.spigot;
    }
}

