/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.boss;

import com.google.common.base.Preconditions;
import net.minecraft.entity.Entity;
import net.minecraft.world.end.DragonFightManager;
import net.minecraft.world.end.DragonSpawnState;
import org.bukkit.Location;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_16_R3.boss.CraftBossBar;
import org.bukkit.entity.EnderDragon;

public class CraftDragonBattle
implements DragonBattle {
    private final DragonFightManager handle;

    public CraftDragonBattle(DragonFightManager handle) {
        this.handle = handle;
    }

    @Override
    public EnderDragon getEnderDragon() {
        Entity entity = this.handle.field_186110_d.func_217461_a(this.handle.field_186119_m);
        return entity != null ? (EnderDragon)((Object)entity.getBukkitEntity()) : null;
    }

    @Override
    public BossBar getBossBar() {
        return new CraftBossBar(this.handle.field_186109_c);
    }

    @Override
    public Location getEndPortalLocation() {
        if (this.handle.field_186121_o == null) {
            return null;
        }
        return new Location(this.handle.field_186110_d.getWorld(), this.handle.field_186121_o.func_177958_n(), this.handle.field_186121_o.func_177956_o(), this.handle.field_186121_o.func_177952_p());
    }

    @Override
    public boolean generateEndPortal(boolean withPortals) {
        if (this.handle.field_186121_o != null || this.handle.func_186091_h() != null) {
            return false;
        }
        this.handle.func_186094_a(withPortals);
        return true;
    }

    @Override
    public boolean hasBeenPreviouslyKilled() {
        return this.handle.func_186102_d();
    }

    @Override
    public void initiateRespawn() {
        this.handle.func_186106_e();
    }

    @Override
    public DragonBattle.RespawnPhase getRespawnPhase() {
        return this.toBukkitRespawnPhase(this.handle.field_186122_p);
    }

    @Override
    public boolean setRespawnPhase(DragonBattle.RespawnPhase phase) {
        Preconditions.checkArgument((phase != null && phase != DragonBattle.RespawnPhase.NONE ? 1 : 0) != 0, (String)"Invalid respawn phase provided: %s", (Object)((Object)phase));
        if (this.handle.field_186122_p == null) {
            return false;
        }
        this.handle.func_186095_a(this.toNMSRespawnPhase(phase));
        return true;
    }

    @Override
    public void resetCrystals() {
        this.handle.func_186087_f();
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftDragonBattle && ((CraftDragonBattle)obj).handle == this.handle;
    }

    private DragonBattle.RespawnPhase toBukkitRespawnPhase(DragonSpawnState phase) {
        return phase != null ? DragonBattle.RespawnPhase.values()[phase.ordinal()] : DragonBattle.RespawnPhase.NONE;
    }

    private DragonSpawnState toNMSRespawnPhase(DragonBattle.RespawnPhase phase) {
        return phase != DragonBattle.RespawnPhase.NONE ? DragonSpawnState.values()[phase.ordinal()] : null;
    }
}

