/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.command;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.minecraft.server.dedicated.DedicatedServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.util.Waitable;
import org.bukkit.event.server.TabCompleteEvent;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class ConsoleCommandCompleter
implements Completer {
    private final DedicatedServer server;

    public ConsoleCommandCompleter(DedicatedServer server) {
        this.server = server;
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        final CraftServer server = this.server.server;
        final String buffer = line.line();
        Object completions = new ArrayList();
        AsyncTabCompleteEvent event = new AsyncTabCompleteEvent(server.getConsoleSender(), (List<String>)completions, buffer, true, null);
        event.callEvent();
        Object object = completions = event.isCancelled() ? ImmutableList.of() : event.getCompletions();
        if (event.isCancelled() || event.isHandled()) {
            if (!event.isCancelled() && TabCompleteEvent.getHandlerList().getRegisteredListeners().length > 0) {
                Object finalCompletions = completions;
                Waitable<List<String>> syncCompletions = new Waitable<List<String>>((List)finalCompletions){
                    final /* synthetic */ List val$finalCompletions;
                    {
                        this.val$finalCompletions = list;
                    }

                    @Override
                    protected List<String> evaluate() {
                        TabCompleteEvent syncEvent = new TabCompleteEvent(server.getConsoleSender(), buffer, this.val$finalCompletions);
                        return syncEvent.callEvent() ? syncEvent.getCompletions() : ImmutableList.of();
                    }
                };
                server.getServer().processQueue.add(syncCompletions);
                try {
                    completions = (List)syncCompletions.get();
                }
                catch (InterruptedException | ExecutionException e1) {
                    e1.printStackTrace();
                }
            }
            if (!completions.isEmpty()) {
                candidates.addAll(completions.stream().map(Candidate::new).collect(Collectors.toList()));
            }
            return;
        }
        Waitable<List<String>> waitable = new Waitable<List<String>>(){

            @Override
            protected List<String> evaluate() {
                List<String> offers = server.getCommandMap().tabComplete(server.getConsoleSender(), buffer);
                TabCompleteEvent tabEvent = new TabCompleteEvent(server.getConsoleSender(), buffer, offers == null ? Collections.EMPTY_LIST : offers);
                server.getPluginManager().callEvent(tabEvent);
                return tabEvent.isCancelled() ? Collections.EMPTY_LIST : tabEvent.getCompletions();
            }
        };
        server.getServer().processQueue.add(waitable);
        try {
            List offers = (List)waitable.get();
            if (offers == null) {
                return;
            }
            for (String completion : offers) {
                if (completion.isEmpty()) continue;
                candidates.add(new Candidate(completion));
            }
        }
        catch (ExecutionException e) {
            server.getLogger().log(Level.WARNING, "Unhandled exception when tab completing", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

