/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.entity;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.util.math.Rotations;
import org.bukkit.craftbukkit.v1_16_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftLivingEntity;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class CraftArmorStand
extends CraftLivingEntity
implements ArmorStand {
    public CraftArmorStand(CraftServer server, ArmorStandEntity entity) {
        super(server, (LivingEntity)entity);
    }

    @Override
    public String toString() {
        return "CraftArmorStand";
    }

    @Override
    public EntityType getType() {
        return EntityType.ARMOR_STAND;
    }

    public ArmorStandEntity getHandle() {
        return (ArmorStandEntity)super.getHandle();
    }

    @Override
    public ItemStack getItemInHand() {
        return this.getEquipment().getItemInHand();
    }

    @Override
    public void setItemInHand(ItemStack item) {
        this.getEquipment().setItemInHand(item);
    }

    @Override
    public ItemStack getBoots() {
        return this.getEquipment().getBoots();
    }

    @Override
    public void setBoots(ItemStack item) {
        this.getEquipment().setBoots(item);
    }

    @Override
    public ItemStack getLeggings() {
        return this.getEquipment().getLeggings();
    }

    @Override
    public void setLeggings(ItemStack item) {
        this.getEquipment().setLeggings(item);
    }

    @Override
    public ItemStack getChestplate() {
        return this.getEquipment().getChestplate();
    }

    @Override
    public void setChestplate(ItemStack item) {
        this.getEquipment().setChestplate(item);
    }

    @Override
    public ItemStack getHelmet() {
        return this.getEquipment().getHelmet();
    }

    @Override
    public void setHelmet(ItemStack item) {
        this.getEquipment().setHelmet(item);
    }

    @Override
    public EulerAngle getBodyPose() {
        return CraftArmorStand.fromNMS(this.getHandle().field_175444_bi);
    }

    @Override
    public void setBodyPose(EulerAngle pose) {
        this.getHandle().func_175424_b(CraftArmorStand.toNMS(pose));
    }

    @Override
    public EulerAngle getLeftArmPose() {
        return CraftArmorStand.fromNMS(this.getHandle().field_175438_bj);
    }

    @Override
    public void setLeftArmPose(EulerAngle pose) {
        this.getHandle().func_175405_c(CraftArmorStand.toNMS(pose));
    }

    @Override
    public EulerAngle getRightArmPose() {
        return CraftArmorStand.fromNMS(this.getHandle().field_175439_bk);
    }

    @Override
    public void setRightArmPose(EulerAngle pose) {
        this.getHandle().func_175428_d(CraftArmorStand.toNMS(pose));
    }

    @Override
    public EulerAngle getLeftLegPose() {
        return CraftArmorStand.fromNMS(this.getHandle().field_175440_bl);
    }

    @Override
    public void setLeftLegPose(EulerAngle pose) {
        this.getHandle().func_175417_e(CraftArmorStand.toNMS(pose));
    }

    @Override
    public EulerAngle getRightLegPose() {
        return CraftArmorStand.fromNMS(this.getHandle().field_175441_bm);
    }

    @Override
    public void setRightLegPose(EulerAngle pose) {
        this.getHandle().func_175427_f(CraftArmorStand.toNMS(pose));
    }

    @Override
    public EulerAngle getHeadPose() {
        return CraftArmorStand.fromNMS(this.getHandle().field_175443_bh);
    }

    @Override
    public void setHeadPose(EulerAngle pose) {
        this.getHandle().func_175415_a(CraftArmorStand.toNMS(pose));
    }

    @Override
    public boolean hasBasePlate() {
        return !this.getHandle().func_175414_r();
    }

    @Override
    public void setBasePlate(boolean basePlate) {
        this.getHandle().func_175426_l(!basePlate);
    }

    @Override
    public void setGravity(boolean gravity) {
        super.setGravity(gravity);
        this.getHandle().field_70145_X = !gravity;
    }

    @Override
    public boolean isVisible() {
        return !this.getHandle().func_82150_aj();
    }

    @Override
    public void setVisible(boolean visible) {
        this.getHandle().func_82142_c(!visible);
    }

    @Override
    public boolean hasArms() {
        return this.getHandle().func_175402_q();
    }

    @Override
    public void setArms(boolean arms) {
        this.getHandle().func_175413_k(arms);
    }

    @Override
    public boolean isSmall() {
        return this.getHandle().func_175410_n();
    }

    @Override
    public void setSmall(boolean small) {
        this.getHandle().func_175420_a(small);
    }

    private static EulerAngle fromNMS(Rotations old) {
        return new EulerAngle(Math.toRadians(old.func_179415_b()), Math.toRadians(old.func_179416_c()), Math.toRadians(old.func_179413_d()));
    }

    private static Rotations toNMS(EulerAngle old) {
        return new Rotations((float)Math.toDegrees(old.getX()), (float)Math.toDegrees(old.getY()), (float)Math.toDegrees(old.getZ()));
    }

    @Override
    public boolean isMarker() {
        return this.getHandle().func_181026_s();
    }

    @Override
    public void setMarker(boolean marker) {
        this.getHandle().func_181027_m(marker);
    }

    @Override
    public void addEquipmentLock(EquipmentSlot equipmentSlot, ArmorStand.LockType lockType) {
        this.getHandle().field_175442_bg |= 1 << CraftEquipmentSlot.getNMS(equipmentSlot).func_188452_c() + lockType.ordinal() * 8;
    }

    @Override
    public void removeEquipmentLock(EquipmentSlot equipmentSlot, ArmorStand.LockType lockType) {
        this.getHandle().field_175442_bg &= ~(1 << CraftEquipmentSlot.getNMS(equipmentSlot).func_188452_c() + lockType.ordinal() * 8);
    }

    @Override
    public boolean hasEquipmentLock(EquipmentSlot equipmentSlot, ArmorStand.LockType lockType) {
        return (this.getHandle().field_175442_bg & 1 << CraftEquipmentSlot.getNMS(equipmentSlot).func_188452_c() + lockType.ordinal() * 8) != 0;
    }
}

