/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.entity;

import com.google.common.base.Preconditions;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang.Validate;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.AbstractProjectile;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.EntityType;
import org.bukkit.projectiles.ProjectileSource;

public class CraftArrow
extends AbstractProjectile
implements AbstractArrow {
    public CraftArrow(CraftServer server, AbstractArrowEntity entity) {
        super(server, (Entity)entity);
    }

    @Override
    public void setKnockbackStrength(int knockbackStrength) {
        Validate.isTrue((knockbackStrength >= 0 ? 1 : 0) != 0, (String)"Knockback cannot be negative");
        this.getHandle().func_70240_a(knockbackStrength);
    }

    @Override
    public int getKnockbackStrength() {
        return this.getHandle().field_70256_ap;
    }

    @Override
    public double getDamage() {
        return this.getHandle().func_70242_d();
    }

    @Override
    public void setDamage(double damage) {
        Preconditions.checkArgument((damage >= 0.0 ? 1 : 0) != 0, (Object)"Damage must be positive");
        this.getHandle().func_70239_b(damage);
    }

    @Override
    public int getPierceLevel() {
        return this.getHandle().func_213874_s();
    }

    @Override
    public void setPierceLevel(int pierceLevel) {
        Preconditions.checkArgument((0 <= pierceLevel && pierceLevel <= 127 ? 1 : 0) != 0, (Object)"Pierce level out of range, expected 0 < level < 127");
        this.getHandle().func_213872_b((byte)pierceLevel);
    }

    @Override
    public boolean isCritical() {
        return this.getHandle().func_70241_g();
    }

    @Override
    public void setCritical(boolean critical) {
        this.getHandle().func_70243_d(critical);
    }

    @Override
    public ProjectileSource getShooter() {
        return this.getHandle().projectileSource;
    }

    @Override
    public void setShooter(ProjectileSource shooter) {
        if (shooter instanceof org.bukkit.entity.Entity) {
            this.getHandle().func_212361_a(((CraftEntity)((Object)shooter)).getHandle());
        } else {
            this.getHandle().func_212361_a(null);
        }
        this.getHandle().projectileSource = shooter;
    }

    @Override
    public boolean isInBlock() {
        return this.getHandle().field_70254_i;
    }

    @Override
    public Block getAttachedBlock() {
        if (!this.isInBlock()) {
            return null;
        }
        BlockPos pos = this.getHandle().func_233580_cy_();
        return this.getWorld().getBlockAt(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public AbstractArrow.PickupStatus getPickupStatus() {
        return AbstractArrow.PickupStatus.values()[this.getHandle().field_70251_a.ordinal()];
    }

    @Override
    public void setPickupStatus(AbstractArrow.PickupStatus status) {
        Preconditions.checkNotNull((Object)((Object)status), (Object)"status");
        this.getHandle().field_70251_a = AbstractArrowEntity.PickupStatus.func_188795_a((int)status.ordinal());
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        this.getHandle().field_70252_j = value;
    }

    @Override
    public boolean isShotFromCrossbow() {
        return this.getHandle().func_213873_r();
    }

    @Override
    public void setShotFromCrossbow(boolean shotFromCrossbow) {
        this.getHandle().func_213865_o(shotFromCrossbow);
    }

    public AbstractArrowEntity getHandle() {
        return (AbstractArrowEntity)this.entity;
    }

    @Override
    public String toString() {
        return "CraftArrow";
    }

    @Override
    public EntityType getType() {
        return EntityType.UNKNOWN;
    }
}

