/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.entity;

import com.google.common.base.Preconditions;
import com.mohistmc.forge.ForgeInjectBukkit;
import java.util.Locale;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;

public class CraftVillager
extends CraftAbstractVillager
implements Villager {
    public CraftVillager(CraftServer server, VillagerEntity entity) {
        super(server, (AbstractVillagerEntity)entity);
    }

    public VillagerEntity getHandle() {
        return (VillagerEntity)this.entity;
    }

    @Override
    public String toString() {
        return "CraftVillager";
    }

    @Override
    public EntityType getType() {
        return EntityType.VILLAGER;
    }

    @Override
    public Villager.Profession getProfession() {
        return CraftVillager.nmsToBukkitProfession(this.getHandle().func_213700_eh().func_221130_b());
    }

    @Override
    public void setProfession(Villager.Profession profession) {
        Validate.notNull((Object)profession);
        this.getHandle().func_213753_a(this.getHandle().func_213700_eh().func_221126_a(CraftVillager.bukkitToNmsProfession(profession)));
    }

    @Override
    public Villager.Type getVillagerType() {
        return Villager.Type.valueOf(Registry.field_218369_K.func_177774_c((Object)this.getHandle().func_213700_eh().func_221129_a()).func_110623_a().toUpperCase(Locale.ROOT));
    }

    @Override
    public void setVillagerType(Villager.Type type) {
        Validate.notNull((Object)type);
        this.getHandle().func_213753_a(this.getHandle().func_213700_eh().func_221134_a((VillagerType)Registry.field_218369_K.func_82594_a(CraftNamespacedKey.toMinecraft(type.getKey()))));
    }

    @Override
    public int getVillagerLevel() {
        return this.getHandle().func_213700_eh().func_221132_c();
    }

    @Override
    public void setVillagerLevel(int level) {
        Preconditions.checkArgument((1 <= level && level <= 5 ? 1 : 0) != 0, (Object)"level must be between [1, 5]");
        this.getHandle().func_213753_a(this.getHandle().func_213700_eh().func_221135_a(level));
    }

    @Override
    public int getVillagerExperience() {
        return this.getHandle().func_213708_dV();
    }

    @Override
    public void setVillagerExperience(int experience) {
        Preconditions.checkArgument((experience >= 0 ? 1 : 0) != 0, (Object)"Experience must be positive");
        this.getHandle().func_213761_t(experience);
    }

    @Override
    public boolean sleep(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals(this.getWorld()), (Object)"Cannot sleep across worlds");
        BlockPos position = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        BlockState iblockdata = this.getHandle().field_70170_p.func_180495_p(position);
        if (!(iblockdata.func_177230_c() instanceof BedBlock)) {
            return false;
        }
        this.getHandle().func_213342_e(position);
        return true;
    }

    @Override
    public void wakeup() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        this.getHandle().func_213366_dy();
    }

    public static Villager.Profession nmsToBukkitProfession(VillagerProfession nms) {
        return nms.getRegistryName().func_110624_b().equals("minecraft") ? Villager.Profession.valueOf(Registry.field_218370_L.func_177774_c((Object)nms).func_110623_a().toUpperCase(Locale.ROOT)) : Villager.Profession.valueOf(ForgeInjectBukkit.normalizeName(nms.getRegistryName().toString()));
    }

    public static VillagerProfession bukkitToNmsProfession(Villager.Profession bukkit) {
        return !ForgeInjectBukkit.profession.containsKey(bukkit) ? (VillagerProfession)Registry.field_218370_L.func_82594_a(CraftNamespacedKey.toMinecraft(bukkit.getKey())) : ForgeRegistries.PROFESSIONS.getValue(ForgeInjectBukkit.profession.get(bukkit));
    }
}

