/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.inventory;

import java.util.ArrayList;
import net.minecraft.item.crafting.Ingredient;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;

public interface CraftRecipe
extends Recipe {
    public void addToCraftingManager();

    default public Ingredient toNMS(RecipeChoice bukkit, boolean requireNotEmpty) {
        Ingredient stack;
        if (bukkit == null) {
            stack = Ingredient.field_193370_a;
        } else if (bukkit instanceof RecipeChoice.MaterialChoice) {
            stack = new Ingredient(((RecipeChoice.MaterialChoice)bukkit).getChoices().stream().map(mat -> new Ingredient.SingleItemList(CraftItemStack.asNMSCopy(new ItemStack((Material)mat)))));
        } else if (bukkit instanceof RecipeChoice.ExactChoice) {
            stack = new Ingredient(((RecipeChoice.ExactChoice)bukkit).getChoices().stream().map(mat -> new Ingredient.SingleItemList(CraftItemStack.asNMSCopy(mat))));
            stack.exact = true;
        } else {
            throw new IllegalArgumentException("Unknown recipe stack instance " + bukkit);
        }
        stack.func_199806_d();
        if (requireNotEmpty && stack.field_193371_b.length == 0) {
            throw new IllegalArgumentException("Recipe requires at least one non-air choice!");
        }
        return stack;
    }

    public static RecipeChoice toBukkit(Ingredient list) {
        list.func_199806_d();
        if (list.field_193371_b.length == 0) {
            return null;
        }
        if (list.exact) {
            ArrayList<ItemStack> choices = new ArrayList<ItemStack>(list.field_193371_b.length);
            for (net.minecraft.item.ItemStack i : list.field_193371_b) {
                choices.add(CraftItemStack.asBukkitCopy(i));
            }
            return new RecipeChoice.ExactChoice(choices);
        }
        ArrayList<Material> choices = new ArrayList<Material>(list.field_193371_b.length);
        for (net.minecraft.item.ItemStack i : list.field_193371_b) {
            choices.add(CraftMagicNumbers.getMaterial(i.func_77973_b()));
        }
        return new RecipeChoice.MaterialChoice(choices);
    }
}

