/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import org.bukkit.ChatColor;

public final class CraftChatMessage {
    private static final Pattern LINK_PATTERN = Pattern.compile("((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))");
    private static final Map<Character, TextFormatting> formatMap;
    private static final String COLOR_CHAR_STRING;

    public static TextFormatting getColor(ChatColor color) {
        return formatMap.get(Character.valueOf(color.getChar()));
    }

    public static ChatColor getColor(TextFormatting format) {
        return ChatColor.getByChar(format.field_96329_z);
    }

    public static ITextComponent fromStringOrNull(String message) {
        return CraftChatMessage.fromStringOrNull(message, false);
    }

    public static ITextComponent fromStringOrNull(String message, boolean keepNewlines) {
        return message == null || message.isEmpty() ? null : CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static ITextComponent[] fromString(String message) {
        return CraftChatMessage.fromString(message, false);
    }

    public static ITextComponent[] fromString(String message, boolean keepNewlines) {
        return CraftChatMessage.fromString(message, keepNewlines, false);
    }

    public static ITextComponent[] fromString(String message, boolean keepNewlines, boolean plain) {
        return new StringMessage(message, keepNewlines, plain).getOutput();
    }

    public static String toJSON(ITextComponent component) {
        return ITextComponent.Serializer.func_150696_a((ITextComponent)component);
    }

    public static String toJSONOrNull(ITextComponent component) {
        if (component == null) {
            return null;
        }
        return CraftChatMessage.toJSON(component);
    }

    public static ITextComponent fromJSON(String jsonMessage) throws JsonParseException {
        return ITextComponent.Serializer.func_240643_a_((String)jsonMessage);
    }

    public static ITextComponent fromJSONOrNull(String jsonMessage) {
        if (jsonMessage == null) {
            return null;
        }
        try {
            return CraftChatMessage.fromJSON(jsonMessage);
        }
        catch (JsonParseException ex) {
            return null;
        }
    }

    public static ITextComponent fromJSONOrString(String message) {
        return CraftChatMessage.fromJSONOrString(message, false);
    }

    public static ITextComponent fromJSONOrString(String message, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrString(message, false, keepNewlines);
    }

    private static ITextComponent fromJSONOrString(String message, boolean nullable, boolean keepNewlines) {
        if (message == null) {
            message = "";
        }
        if (nullable && message.isEmpty()) {
            return null;
        }
        if (CraftChatMessage.isLegacy(message)) {
            return CraftChatMessage.fromString(message, keepNewlines)[0];
        }
        ITextComponent component = CraftChatMessage.fromJSONOrNull(message);
        if (component != null) {
            return component;
        }
        return CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static String fromJSONOrStringToJSON(String message) {
        return CraftChatMessage.fromJSONOrStringToJSON(message, false);
    }

    public static String fromJSONOrStringToJSON(String message, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrStringToJSON(message, false, keepNewlines, Integer.MAX_VALUE, false);
    }

    public static String fromJSONOrStringOrNullToJSON(String message) {
        return CraftChatMessage.fromJSONOrStringOrNullToJSON(message, false);
    }

    public static String fromJSONOrStringOrNullToJSON(String message, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrStringToJSON(message, true, keepNewlines, Integer.MAX_VALUE, false);
    }

    public static String fromJSONOrStringToJSON(String message, boolean nullable, boolean keepNewlines, int maxLength, boolean checkJsonContentLength) {
        if (message == null) {
            message = "";
        }
        if (nullable && message.isEmpty()) {
            return null;
        }
        if (CraftChatMessage.isLegacy(message)) {
            message = CraftChatMessage.trimMessage(message, maxLength);
            return CraftChatMessage.fromStringToJSON(message, keepNewlines);
        }
        ITextComponent component = CraftChatMessage.fromJSONOrNull(message);
        if (component != null) {
            String trimmedContent;
            String content;
            if (checkJsonContentLength && (content = CraftChatMessage.fromComponent(component)) != (trimmedContent = CraftChatMessage.trimMessage(content, maxLength))) {
                return CraftChatMessage.fromStringToJSON(trimmedContent, keepNewlines);
            }
            return message;
        }
        message = CraftChatMessage.trimMessage(message, maxLength);
        return CraftChatMessage.fromStringToJSON(message, keepNewlines);
    }

    public static String trimMessage(String message, int maxLength) {
        if (message != null && message.length() > maxLength) {
            return message.substring(0, maxLength);
        }
        return message;
    }

    private static boolean isLegacy(String message) {
        return message.trim().isEmpty() || message.contains(COLOR_CHAR_STRING);
    }

    public static String fromStringToJSON(String message) {
        return CraftChatMessage.fromStringToJSON(message, false);
    }

    public static String fromStringToJSON(String message, boolean keepNewlines) {
        ITextComponent component = CraftChatMessage.fromString(message, keepNewlines)[0];
        return CraftChatMessage.toJSON(component);
    }

    public static String fromStringOrNullToJSON(String message) {
        ITextComponent component = CraftChatMessage.fromStringOrNull(message);
        return CraftChatMessage.toJSONOrNull(component);
    }

    public static String fromJSONComponent(String jsonMessage) {
        ITextComponent component = CraftChatMessage.fromJSONOrNull(jsonMessage);
        return CraftChatMessage.fromComponent(component);
    }

    public static String fromComponent(ITextComponent component) {
        if (component == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        boolean hadFormat = false;
        for (ITextComponent c : component) {
            Style modi = c.func_150256_b();
            Color color = modi.func_240711_a_();
            if (!c.func_150261_e().isEmpty() || color != null) {
                if (color != null) {
                    if (color.format != null) {
                        out.append(color.format);
                    } else {
                        out.append('\u00a7').append("x");
                        for (char magic : color.func_240747_b_().substring(1).toCharArray()) {
                            out.append('\u00a7').append(magic);
                        }
                    }
                    hadFormat = true;
                } else if (hadFormat) {
                    out.append((Object)ChatColor.RESET);
                    hadFormat = false;
                }
            }
            if (modi.func_150223_b()) {
                out.append(TextFormatting.BOLD);
                hadFormat = true;
            }
            if (modi.func_150242_c()) {
                out.append(TextFormatting.ITALIC);
                hadFormat = true;
            }
            if (modi.func_150234_e()) {
                out.append(TextFormatting.UNDERLINE);
                hadFormat = true;
            }
            if (modi.func_150236_d()) {
                out.append(TextFormatting.STRIKETHROUGH);
                hadFormat = true;
            }
            if (modi.func_150233_f()) {
                out.append(TextFormatting.OBFUSCATED);
                hadFormat = true;
            }
            c.func_230533_b_(x -> {
                out.append(x);
                return Optional.empty();
            });
        }
        return out.toString();
    }

    public static ITextComponent fixComponent(ITextComponent component) {
        Matcher matcher = LINK_PATTERN.matcher("");
        return CraftChatMessage.fixComponent(component, matcher);
    }

    private static ITextComponent fixComponent(ITextComponent component, Matcher matcher) {
        StringTextComponent text;
        String msg;
        if (component instanceof StringTextComponent && matcher.reset(msg = (text = (StringTextComponent)component).func_150261_e()).find()) {
            matcher.reset();
            Style modifier = text.func_150256_b();
            ArrayList<Object> extras = new ArrayList<Object>();
            ArrayList extrasOld = new ArrayList(text.func_150253_a());
            text = new StringTextComponent("");
            component = text;
            int pos = 0;
            while (matcher.find()) {
                String match = matcher.group();
                if (!match.startsWith("http://") && !match.startsWith("https://")) {
                    match = "http://" + match;
                }
                StringTextComponent prev = new StringTextComponent(msg.substring(pos, matcher.start()));
                prev.func_230530_a_(modifier);
                extras.add(prev);
                StringTextComponent stringTextComponent = new StringTextComponent(matcher.group());
                Style linkModi = modifier.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, match));
                stringTextComponent.func_230530_a_(linkModi);
                extras.add(stringTextComponent);
                pos = matcher.end();
            }
            StringTextComponent prev = new StringTextComponent(msg.substring(pos));
            prev.func_230530_a_(modifier);
            extras.add(prev);
            extras.addAll(extrasOld);
            for (ITextComponent iTextComponent : extras) {
                text.func_230529_a_(iTextComponent);
            }
        }
        List extras = component.func_150253_a();
        for (int i = 0; i < extras.size(); ++i) {
            ITextComponent comp = (ITextComponent)extras.get(i);
            if (comp.func_150256_b() == null || comp.func_150256_b().func_150235_h() != null) continue;
            extras.set(i, CraftChatMessage.fixComponent(comp, matcher));
        }
        if (component instanceof TranslationTextComponent) {
            Object[] subs = ((TranslationTextComponent)component).func_150271_j();
            for (int i = 0; i < subs.length; ++i) {
                Object comp = subs[i];
                if (comp instanceof ITextComponent) {
                    ITextComponent c = (ITextComponent)comp;
                    if (c.func_150256_b() == null || c.func_150256_b().func_150235_h() != null) continue;
                    subs[i] = CraftChatMessage.fixComponent(c, matcher);
                    continue;
                }
                if (!(comp instanceof String) || !matcher.reset((String)comp).find()) continue;
                subs[i] = CraftChatMessage.fixComponent((ITextComponent)new StringTextComponent((String)comp), matcher);
            }
        }
        return component;
    }

    private CraftChatMessage() {
    }

    static /* synthetic */ Map access$000() {
        return formatMap;
    }

    static {
        COLOR_CHAR_STRING = String.valueOf('\u00a7');
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TextFormatting format : TextFormatting.values()) {
            builder.put((Object)Character.valueOf(Character.toLowerCase(format.toString().charAt(1))), (Object)format);
        }
        formatMap = builder.build();
    }

    private static final class StringMessage {
        private static final Pattern INCREMENTAL_PATTERN = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-orx])|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))|(\\n)", 2);
        private static final Pattern INCREMENTAL_PATTERN_KEEP_NEWLINES = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-orx])|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " ]|$))))", 2);
        private static final Style RESET = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(false)).func_240722_b_(Boolean.valueOf(false)).setUnderlined(Boolean.valueOf(false)).setStrikethrough(Boolean.valueOf(false)).setObfuscated(Boolean.valueOf(false));
        private final List<ITextComponent> list = new ArrayList<ITextComponent>();
        private IFormattableTextComponent currentChatComponent = new StringTextComponent("");
        private Style modifier = Style.field_240709_b_;
        private final ITextComponent[] output;
        private int currentIndex;
        private StringBuilder hex;
        private final String message;

        /*
         * Unable to fully structure code
         */
        private StringMessage(String message, boolean keepNewlines, boolean plain) {
            super();
            this.message = message;
            if (message == null) {
                this.output = new ITextComponent[]{this.currentChatComponent};
                return;
            }
            this.list.add((ITextComponent)this.currentChatComponent);
            matcher = (keepNewlines != false ? StringMessage.INCREMENTAL_PATTERN_KEEP_NEWLINES : StringMessage.INCREMENTAL_PATTERN).matcher(message);
            match = null;
            needsAdd = false;
            while (matcher.find()) {
                groupId = 0;
                while ((match = matcher.group(++groupId)) == null) {
                }
                index = matcher.start(groupId);
                if (index > this.currentIndex) {
                    needsAdd = false;
                    this.appendNewComponent(index);
                }
                switch (groupId) {
                    case 1: {
                        c = match.toLowerCase(Locale.ENGLISH).charAt(1);
                        format = (TextFormatting)CraftChatMessage.access$000().get(Character.valueOf(c));
                        if (c != 'x') ** GOTO lbl29
                        this.hex = new StringBuilder("#");
                        ** GOTO lbl56
lbl29:
                        // 1 sources

                        if (this.hex == null) ** GOTO lbl36
                        this.hex.append(c);
                        if (this.hex.length() == 7) {
                            this.modifier = this.modifier.func_240718_a_(Color.func_240745_a_((String)this.hex.toString()));
                            this.hex = null;
                        }
                        ** GOTO lbl56
lbl36:
                        // 1 sources

                        if (!format.func_96301_b() || format == TextFormatting.RESET) ** GOTO lbl55
                        switch (1.$SwitchMap$net$minecraft$util$text$TextFormatting[format.ordinal()]) {
                            case 1: {
                                this.modifier = this.modifier.func_240713_a_(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 2: {
                                this.modifier = this.modifier.func_240722_b_(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 3: {
                                this.modifier = this.modifier.setStrikethrough(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 4: {
                                this.modifier = this.modifier.setUnderlined(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 5: {
                                this.modifier = this.modifier.setObfuscated(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            default: {
                                throw new AssertionError((Object)"Unexpected message format");
                            }
                        }
lbl55:
                        // 1 sources

                        this.modifier = StringMessage.RESET.func_240712_a_(format);
lbl56:
                        // 8 sources

                        needsAdd = true;
                        break;
                    }
                    case 2: {
                        if (plain) {
                            this.appendNewComponent(matcher.end(groupId));
                            break;
                        }
                        if (!match.startsWith("http://") && !match.startsWith("https://")) {
                            match = "http://" + match;
                        }
                        this.modifier = this.modifier.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, match));
                        this.appendNewComponent(matcher.end(groupId));
                        this.modifier = this.modifier.func_240715_a_((ClickEvent)null);
                        break;
                    }
                    case 3: {
                        if (needsAdd) {
                            this.appendNewComponent(index);
                        }
                        this.currentChatComponent = null;
                    }
                }
                this.currentIndex = matcher.end(groupId);
            }
            if (this.currentIndex < message.length() || needsAdd) {
                this.appendNewComponent(message.length());
            }
            this.output = this.list.toArray(new ITextComponent[this.list.size()]);
        }

        private void appendNewComponent(int index) {
            IFormattableTextComponent addition = new StringTextComponent(this.message.substring(this.currentIndex, index)).func_230530_a_(this.modifier);
            this.currentIndex = index;
            if (this.currentChatComponent == null) {
                this.currentChatComponent = new StringTextComponent("");
                this.list.add((ITextComponent)this.currentChatComponent);
            }
            this.currentChatComponent.func_230529_a_((ITextComponent)addition);
        }

        private ITextComponent[] getOutput() {
            return this.output;
        }
    }
}

