/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import java.util.Arrays;

final class ReusableStringBuilder {
    private static final String EMPTY = "";
    private char[] buf;
    private int pos;

    ReusableStringBuilder(int initialCapacity) {
        this.buf = new char[initialCapacity];
    }

    public void append(char c) {
        if (this.pos == this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, this.buf.length * 2);
        }
        this.buf[this.pos++] = c;
    }

    public void append(char[] src, int srcPos, int length) {
        if (this.pos + length > this.buf.length) {
            int newSize;
            for (newSize = this.buf.length * 2; this.pos + length > newSize; newSize *= 2) {
            }
            this.buf = Arrays.copyOf(this.buf, newSize);
        }
        System.arraycopy(src, srcPos, this.buf, this.pos, length);
        this.pos += length;
    }

    public boolean hasContent() {
        return this.pos > 0;
    }

    public String toStringAndReset() {
        if (this.pos > 0) {
            String s = new String(this.buf, 0, this.pos);
            this.pos = 0;
            return s;
        }
        return EMPTY;
    }
}

