/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.extensions.IForgeAdvancementBuilder;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.craftbukkit.v1_16_R3.advancement.CraftAdvancement;

public class Advancement {
    private final Advancement field_192076_a;
    private final DisplayInfo field_192077_b;
    private final AdvancementRewards field_192078_c;
    private final ResourceLocation field_192079_d;
    private final Map<String, Criterion> field_192080_e;
    private final String[][] field_192081_f;
    private final Set<Advancement> field_192082_g = Sets.newLinkedHashSet();
    private final ITextComponent field_193125_h;
    public final org.bukkit.advancement.Advancement bukkit = new CraftAdvancement(this);

    public Advancement(ResourceLocation p_i47472_1_, @Nullable Advancement p_i47472_2_, @Nullable DisplayInfo p_i47472_3_, AdvancementRewards p_i47472_4_, Map<String, Criterion> p_i47472_5_, String[][] p_i47472_6_) {
        this.field_192079_d = p_i47472_1_;
        this.field_192077_b = p_i47472_3_;
        this.field_192080_e = ImmutableMap.copyOf(p_i47472_5_);
        this.field_192076_a = p_i47472_2_;
        this.field_192078_c = p_i47472_4_;
        this.field_192081_f = p_i47472_6_;
        if (p_i47472_2_ != null) {
            p_i47472_2_.func_192071_a(this);
        }
        if (p_i47472_3_ == null) {
            this.field_193125_h = new StringTextComponent(p_i47472_1_.toString());
        } else {
            ITextComponent itextcomponent = p_i47472_3_.func_192297_a();
            TextFormatting textformatting = p_i47472_3_.func_192291_d().func_193229_c();
            IFormattableTextComponent itextcomponent1 = TextComponentUtils.func_240648_a_((IFormattableTextComponent)itextcomponent.func_230532_e_(), (Style)Style.field_240709_b_.func_240712_a_(textformatting)).func_240702_b_("\n").func_230529_a_(p_i47472_3_.func_193222_b());
            IFormattableTextComponent itextcomponent2 = itextcomponent.func_230532_e_().func_240700_a_(arg_0 -> Advancement.func_211567_a_((ITextComponent)itextcomponent1, arg_0));
            this.field_193125_h = TextComponentUtils.func_240647_a_((ITextComponent)itextcomponent2).func_240699_a_(textformatting);
        }
    }

    public Builder func_192075_a() {
        return new Builder(this.field_192076_a == null ? null : this.field_192076_a.func_192067_g(), this.field_192077_b, this.field_192078_c, this.field_192080_e, this.field_192081_f);
    }

    @Nullable
    public Advancement func_192070_b() {
        return this.field_192076_a;
    }

    @Nullable
    public DisplayInfo func_192068_c() {
        return this.field_192077_b;
    }

    public AdvancementRewards func_192072_d() {
        return this.field_192078_c;
    }

    public String toString() {
        return "SimpleAdvancement{id=" + this.func_192067_g() + ", parent=" + (this.field_192076_a == null ? "null" : this.field_192076_a.func_192067_g()) + ", display=" + this.field_192077_b + ", rewards=" + this.field_192078_c + ", criteria=" + this.field_192080_e + ", requirements=" + Arrays.deepToString((Object[])this.field_192081_f) + '}';
    }

    public Iterable<Advancement> func_192069_e() {
        return this.field_192082_g;
    }

    public Map<String, Criterion> func_192073_f() {
        return this.field_192080_e;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_193124_g() {
        return this.field_192081_f.length;
    }

    public void func_192071_a(Advancement p_192071_1_) {
        this.field_192082_g.add(p_192071_1_);
    }

    public ResourceLocation func_192067_g() {
        return this.field_192079_d;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof Advancement)) {
            return false;
        }
        Advancement advancement = (Advancement)p_equals_1_;
        return this.field_192079_d.equals(advancement.field_192079_d);
    }

    public int hashCode() {
        return this.field_192079_d.hashCode();
    }

    public String[][] func_192074_h() {
        return this.field_192081_f;
    }

    public ITextComponent func_193123_j() {
        return this.field_193125_h;
    }

    private static /* synthetic */ Style func_211567_a_(ITextComponent itextcomponent1, Style p_211567_1_) {
        return p_211567_1_.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, itextcomponent1));
    }

    public static class Builder
    implements IForgeAdvancementBuilder {
        private ResourceLocation field_192061_a;
        private Advancement field_192062_b;
        private DisplayInfo field_192063_c;
        private AdvancementRewards field_192064_d = AdvancementRewards.field_192114_a;
        private Map<String, Criterion> field_192065_e = Maps.newLinkedHashMap();
        private String[][] field_192066_f;
        private IRequirementsStrategy field_199751_g = IRequirementsStrategy.field_223214_a_;

        private Builder(@Nullable ResourceLocation p_i47414_1_, @Nullable DisplayInfo p_i47414_2_, AdvancementRewards p_i47414_3_, Map<String, Criterion> p_i47414_4_, String[][] p_i47414_5_) {
            this.field_192061_a = p_i47414_1_;
            this.field_192063_c = p_i47414_2_;
            this.field_192064_d = p_i47414_3_;
            this.field_192065_e = p_i47414_4_;
            this.field_192066_f = p_i47414_5_;
        }

        private Builder() {
        }

        public static Builder func_200278_a() {
            return new Builder();
        }

        public Builder func_203905_a(Advancement p_203905_1_) {
            this.field_192062_b = p_203905_1_;
            return this;
        }

        public Builder func_200272_a(ResourceLocation p_200272_1_) {
            this.field_192061_a = p_200272_1_;
            return this;
        }

        public Builder func_215092_a(ItemStack p_215092_1_, ITextComponent p_215092_2_, ITextComponent p_215092_3_, @Nullable ResourceLocation p_215092_4_, FrameType p_215092_5_, boolean p_215092_6_, boolean p_215092_7_, boolean p_215092_8_) {
            return this.func_203903_a(new DisplayInfo(p_215092_1_, p_215092_2_, p_215092_3_, p_215092_4_, p_215092_5_, p_215092_6_, p_215092_7_, p_215092_8_));
        }

        public Builder func_203902_a(IItemProvider p_203902_1_, ITextComponent p_203902_2_, ITextComponent p_203902_3_, @Nullable ResourceLocation p_203902_4_, FrameType p_203902_5_, boolean p_203902_6_, boolean p_203902_7_, boolean p_203902_8_) {
            return this.func_203903_a(new DisplayInfo(new ItemStack(p_203902_1_.func_199767_j()), p_203902_2_, p_203902_3_, p_203902_4_, p_203902_5_, p_203902_6_, p_203902_7_, p_203902_8_));
        }

        public Builder func_203903_a(DisplayInfo p_203903_1_) {
            this.field_192063_c = p_203903_1_;
            return this;
        }

        public Builder func_200271_a(AdvancementRewards.Builder p_200271_1_) {
            return this.func_200274_a(p_200271_1_.func_200281_a());
        }

        public Builder func_200274_a(AdvancementRewards p_200274_1_) {
            this.field_192064_d = p_200274_1_;
            return this;
        }

        public Builder func_200275_a(String p_200275_1_, ICriterionInstance p_200275_2_) {
            return this.func_200276_a(p_200275_1_, new Criterion(p_200275_2_));
        }

        public Builder func_200276_a(String p_200276_1_, Criterion p_200276_2_) {
            if (this.field_192065_e.containsKey(p_200276_1_)) {
                throw new IllegalArgumentException("Duplicate criterion " + p_200276_1_);
            }
            this.field_192065_e.put(p_200276_1_, p_200276_2_);
            return this;
        }

        public Builder func_200270_a(IRequirementsStrategy p_200270_1_) {
            this.field_199751_g = p_200270_1_;
            return this;
        }

        public boolean func_192058_a(Function<ResourceLocation, Advancement> p_192058_1_) {
            if (this.field_192061_a == null) {
                return true;
            }
            if (this.field_192062_b == null) {
                this.field_192062_b = p_192058_1_.apply(this.field_192061_a);
            }
            return this.field_192062_b != null;
        }

        public Advancement func_192056_a(ResourceLocation p_192056_1_) {
            if (!this.func_192058_a(p_199750_0_ -> null)) {
                throw new IllegalStateException("Tried to build incomplete advancement!");
            }
            if (this.field_192066_f == null) {
                this.field_192066_f = this.field_199751_g.createRequirements(this.field_192065_e.keySet());
            }
            return new Advancement(p_192056_1_, this.field_192062_b, this.field_192063_c, this.field_192064_d, this.field_192065_e, this.field_192066_f);
        }

        public Advancement func_203904_a(Consumer<Advancement> p_203904_1_, String p_203904_2_) {
            Advancement advancement = this.func_192056_a(new ResourceLocation(p_203904_2_));
            p_203904_1_.accept(advancement);
            return advancement;
        }

        public JsonObject func_200273_b() {
            if (this.field_192066_f == null) {
                this.field_192066_f = this.field_199751_g.createRequirements(this.field_192065_e.keySet());
            }
            JsonObject jsonobject = new JsonObject();
            if (this.field_192062_b != null) {
                jsonobject.addProperty("parent", this.field_192062_b.func_192067_g().toString());
            } else if (this.field_192061_a != null) {
                jsonobject.addProperty("parent", this.field_192061_a.toString());
            }
            if (this.field_192063_c != null) {
                jsonobject.add("display", this.field_192063_c.func_200290_k());
            }
            jsonobject.add("rewards", this.field_192064_d.func_200286_b());
            JsonObject jsonobject1 = new JsonObject();
            for (Map.Entry<String, Criterion> entry : this.field_192065_e.entrySet()) {
                jsonobject1.add(entry.getKey(), entry.getValue().func_200287_b());
            }
            jsonobject.add("criteria", (JsonElement)jsonobject1);
            JsonArray jsonarray1 = new JsonArray();
            for (String[] astring : this.field_192066_f) {
                JsonArray jsonarray = new JsonArray();
                for (String s : astring) {
                    jsonarray.add(s);
                }
                jsonarray1.add((JsonElement)jsonarray);
            }
            jsonobject.add("requirements", (JsonElement)jsonarray1);
            return jsonobject;
        }

        public void func_192057_a(PacketBuffer p_192057_1_) {
            if (this.field_192061_a == null) {
                p_192057_1_.writeBoolean(false);
            } else {
                p_192057_1_.writeBoolean(true);
                p_192057_1_.func_192572_a(this.field_192061_a);
            }
            if (this.field_192063_c == null) {
                p_192057_1_.writeBoolean(false);
            } else {
                p_192057_1_.writeBoolean(true);
                this.field_192063_c.func_192290_a(p_192057_1_);
            }
            Criterion.func_192141_a(this.field_192065_e, (PacketBuffer)p_192057_1_);
            p_192057_1_.func_150787_b(this.field_192066_f.length);
            for (String[] astring : this.field_192066_f) {
                p_192057_1_.func_150787_b(astring.length);
                for (String s : astring) {
                    p_192057_1_.func_180714_a(s);
                }
            }
        }

        public String toString() {
            return "Task Advancement{parentId=" + this.field_192061_a + ", display=" + this.field_192063_c + ", rewards=" + this.field_192064_d + ", criteria=" + this.field_192065_e + ", requirements=" + Arrays.deepToString((Object[])this.field_192066_f) + '}';
        }

        public static Builder func_241043_a_(JsonObject p_241043_0_, ConditionArrayParser p_241043_1_) {
            if ((p_241043_0_ = ConditionalAdvancement.processConditional((JsonObject)p_241043_0_)) == null) {
                return null;
            }
            ResourceLocation resourcelocation = p_241043_0_.has("parent") ? new ResourceLocation(JSONUtils.func_151200_h((JsonObject)p_241043_0_, (String)"parent")) : null;
            DisplayInfo displayinfo = p_241043_0_.has("display") ? DisplayInfo.func_192294_a((JsonObject)JSONUtils.func_152754_s((JsonObject)p_241043_0_, (String)"display")) : null;
            AdvancementRewards advancementrewards = p_241043_0_.has("rewards") ? AdvancementRewards.func_241096_a_(JSONUtils.func_152754_s((JsonObject)p_241043_0_, (String)"rewards")) : AdvancementRewards.field_192114_a;
            Map map = Criterion.func_232634_b_((JsonObject)JSONUtils.func_152754_s((JsonObject)p_241043_0_, (String)"criteria"), (ConditionArrayParser)p_241043_1_);
            if (map.isEmpty()) {
                throw new JsonSyntaxException("Advancement criteria cannot be empty");
            }
            JsonArray jsonarray = JSONUtils.func_151213_a((JsonObject)p_241043_0_, (String)"requirements", (JsonArray)new JsonArray());
            String[][] astring = new String[jsonarray.size()][];
            for (int i = 0; i < jsonarray.size(); ++i) {
                JsonArray jsonarray1 = JSONUtils.func_151207_m((JsonElement)jsonarray.get(i), (String)("requirements[" + i + "]"));
                astring[i] = new String[jsonarray1.size()];
                for (int j = 0; j < jsonarray1.size(); ++j) {
                    astring[i][j] = JSONUtils.func_151206_a((JsonElement)jsonarray1.get(j), (String)("requirements[" + i + "][" + j + "]"));
                }
            }
            if (astring.length == 0) {
                astring = new String[map.size()][];
                int k = 0;
                for (String s2 : map.keySet()) {
                    astring[k++] = new String[]{s2};
                }
            }
            for (String[] astring1 : astring) {
                if (astring1.length == 0 && map.isEmpty()) {
                    throw new JsonSyntaxException("Requirement entry cannot be empty");
                }
                String[] stringArray = astring1;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String s = stringArray[i];
                    if (map.containsKey(s)) continue;
                    throw new JsonSyntaxException("Unknown required criterion '" + s + "'");
                }
            }
            for (String s1 : map.keySet()) {
                boolean flag = false;
                for (Object[] objectArray : astring) {
                    if (!ArrayUtils.contains((Object[])objectArray, (Object)s1)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                throw new JsonSyntaxException("Criterion '" + s1 + "' isn't a requirement for completion. This isn't supported behaviour, all criteria must be required.");
            }
            return new Builder(resourcelocation, displayinfo, advancementrewards, map, astring);
        }

        public static Builder func_192060_b(PacketBuffer p_192060_0_) {
            ResourceLocation resourcelocation = p_192060_0_.readBoolean() ? p_192060_0_.func_192575_l() : null;
            DisplayInfo displayinfo = p_192060_0_.readBoolean() ? DisplayInfo.func_192295_b((PacketBuffer)p_192060_0_) : null;
            Map map = Criterion.func_192142_c((PacketBuffer)p_192060_0_);
            String[][] astring = new String[p_192060_0_.func_150792_a()][];
            for (int i = 0; i < astring.length; ++i) {
                astring[i] = new String[p_192060_0_.func_150792_a()];
                for (int j = 0; j < astring[i].length; ++j) {
                    astring[i][j] = p_192060_0_.func_150789_c(Short.MAX_VALUE);
                }
            }
            return new Builder(resourcelocation, displayinfo, AdvancementRewards.field_192114_a, map, astring);
        }

        public Map<String, Criterion> func_200277_c() {
            return this.field_192065_e;
        }
    }
}

