/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;

public class CactusBlock
extends Block
implements IPlantable {
    public static final IntegerProperty field_176587_a = BlockStateProperties.field_208171_X;
    protected static final VoxelShape field_196400_b = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 15.0, 15.0);
    protected static final VoxelShape field_196401_c = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);

    public CactusBlock(AbstractBlock.Properties p_i48435_1_) {
        super(p_i48435_1_);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176587_a, 0));
    }

    @Override
    public void func_225534_a_(BlockState p_225534_1_, ServerWorld p_225534_2_, BlockPos p_225534_3_, Random p_225534_4_) {
        if (!p_225534_2_.isAreaLoaded(p_225534_3_, 1)) {
            return;
        }
        if (!p_225534_1_.func_196955_c((IWorldReader)((Object)p_225534_2_), p_225534_3_)) {
            p_225534_2_.func_175655_b(p_225534_3_, true);
        }
    }

    @Override
    public void func_225542_b_(BlockState p_225542_1_, ServerWorld p_225542_2_, BlockPos p_225542_3_, Random p_225542_4_) {
        BlockPos blockpos = p_225542_3_.func_177984_a();
        if (p_225542_2_.func_175623_d(blockpos)) {
            int i = 1;
            while (p_225542_2_.func_180495_p(p_225542_3_.func_177979_c(i)).func_203425_a(this)) {
                ++i;
            }
            if (i < 3) {
                int j = p_225542_1_.func_177229_b(field_176587_a);
                if (ForgeHooks.onCropsGrowPre((World)p_225542_2_, (BlockPos)blockpos, (BlockState)p_225542_1_, (boolean)true)) {
                    if (j >= (byte)CactusBlock.range(3.0f, 100.0f / (float)p_225542_2_.spigotConfig.cactusModifier * 15.0f + 0.5f, 15.0f)) {
                        CraftEventFactory.handleBlockGrowEvent((World)p_225542_2_, (BlockPos)blockpos, (BlockState)this.func_176223_P());
                        BlockState blockstate = (BlockState)p_225542_1_.func_206870_a(field_176587_a, 0);
                        p_225542_2_.func_180501_a(p_225542_3_, blockstate, 4);
                        blockstate.func_215697_a(p_225542_2_, blockpos, this, p_225542_3_, false);
                    } else {
                        p_225542_2_.func_180501_a(p_225542_3_, (BlockState)p_225542_1_.func_206870_a(field_176587_a, j + 1), 4);
                    }
                    ForgeHooks.onCropsGrowPost((World)p_225542_2_, (BlockPos)p_225542_3_, (BlockState)p_225542_1_);
                }
            }
        }
    }

    @Override
    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return field_196400_b;
    }

    @Override
    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return field_196401_c;
    }

    @Override
    public BlockState func_196271_a(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, IWorld p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        if (!p_196271_1_.func_196955_c((IWorldReader)((Object)p_196271_4_), p_196271_5_)) {
            p_196271_4_.func_205220_G_().func_205360_a(p_196271_5_, (Object)this, 1);
        }
        return super.func_196271_a(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    @Override
    public boolean func_196260_a(BlockState p_196260_1_, IWorldReader p_196260_2_, BlockPos p_196260_3_) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState blockstate = p_196260_2_.func_180495_p(p_196260_3_.func_177972_a(direction));
            Material material = blockstate.func_185904_a();
            if (!material.func_76220_a() && !p_196260_2_.func_204610_c(p_196260_3_.func_177972_a(direction)).func_206884_a(FluidTags.field_206960_b)) continue;
            return false;
        }
        BlockState blockstate1 = p_196260_2_.func_180495_p(p_196260_3_.func_177977_b());
        return blockstate1.canSustainPlant((IBlockReader)((Object)p_196260_2_), p_196260_3_, Direction.UP, this) && !p_196260_2_.func_180495_p(p_196260_3_.func_177984_a()).func_185904_a().func_76224_d();
    }

    @Override
    public void func_196262_a(BlockState p_196262_1_, World p_196262_2_, BlockPos p_196262_3_, Entity p_196262_4_) {
        CraftEventFactory.blockDamage = p_196262_2_.getWorld().getBlockAt(p_196262_3_.func_177958_n(), p_196262_3_.func_177956_o(), p_196262_3_.func_177952_p());
        p_196262_4_.func_70097_a(DamageSource.field_76367_g, 1.0f);
        CraftEventFactory.blockDamage = null;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{field_176587_a});
    }

    @Override
    public boolean func_196266_a(BlockState p_196266_1_, IBlockReader p_196266_2_, BlockPos p_196266_3_, PathType p_196266_4_) {
        return false;
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.DESERT;
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        return this.func_176223_P();
    }
}

