/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.ImmutableMap;
import com.mohistmc.api.mc.ChunkMcAPI;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;

public class FireBlock
extends AbstractFireBlock {
    public static final IntegerProperty field_176543_a = BlockStateProperties.field_208171_X;
    public static final BooleanProperty field_176545_N = SixWayBlock.field_196488_a;
    public static final BooleanProperty field_176546_O = SixWayBlock.field_196490_b;
    public static final BooleanProperty field_176541_P = SixWayBlock.field_196492_c;
    public static final BooleanProperty field_176539_Q = SixWayBlock.field_196495_y;
    public static final BooleanProperty field_176542_R = SixWayBlock.field_196496_z;
    private static final Map<Direction, BooleanProperty> field_196449_B = SixWayBlock.field_196491_B.entrySet().stream().filter(p_199776_0_ -> p_199776_0_.getKey() != Direction.DOWN).collect(Util.func_199749_a());
    private static final VoxelShape field_242667_i = Block.func_208617_a(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape field_242668_j = Block.func_208617_a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape field_242669_k = Block.func_208617_a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape field_242670_o = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape field_242671_p = Block.func_208617_a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private final Map<BlockState, VoxelShape> field_242672_q;
    private final Object2IntMap<Block> field_149849_a = new Object2IntOpenHashMap();
    private final Object2IntMap<Block> field_149848_b = new Object2IntOpenHashMap();

    public FireBlock(AbstractBlock.Properties p_i48397_1_) {
        super(p_i48397_1_, 1.0f);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176543_a, 0)).func_206870_a(field_176545_N, false)).func_206870_a(field_176546_O, false)).func_206870_a(field_176541_P, false)).func_206870_a(field_176539_Q, false)).func_206870_a(field_176542_R, false));
        this.field_242672_q = ImmutableMap.copyOf(this.field_176227_L.func_177619_a().stream().filter(p_242674_0_ -> p_242674_0_.func_177229_b(field_176543_a) == 0).collect(Collectors.toMap(Function.identity(), FireBlock::func_242673_h)));
    }

    private static VoxelShape func_242673_h(BlockState p_242673_0_) {
        VoxelShape voxelshape = VoxelShapes.func_197880_a();
        if (((Boolean)p_242673_0_.func_177229_b(field_176542_R)).booleanValue()) {
            voxelshape = field_242667_i;
        }
        if (((Boolean)p_242673_0_.func_177229_b(field_176545_N)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a(voxelshape, field_242670_o);
        }
        if (((Boolean)p_242673_0_.func_177229_b(field_176541_P)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a(voxelshape, field_242671_p);
        }
        if (((Boolean)p_242673_0_.func_177229_b(field_176546_O)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a(voxelshape, field_242669_k);
        }
        if (((Boolean)p_242673_0_.func_177229_b(field_176539_Q)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a(voxelshape, field_242668_j);
        }
        return voxelshape.func_197766_b() ? field_235320_b_ : voxelshape;
    }

    @Override
    public BlockState func_196271_a(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, IWorld p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        if (!(p_196271_4_ instanceof ServerWorld)) {
            return this.func_196260_a(p_196271_1_, (IWorldReader)((Object)p_196271_4_), p_196271_5_) ? this.func_235494_a_(p_196271_4_, p_196271_5_, p_196271_1_.func_177229_b(field_176543_a)) : Blocks.field_150350_a.func_176223_P();
        }
        if (!p_196271_1_.func_196955_c((IWorldReader)((Object)p_196271_4_), p_196271_5_)) {
            if (!(p_196271_4_ instanceof World)) {
                return Blocks.field_150350_a.func_176223_P();
            }
            CraftBlockState blockState = CraftBlockState.getBlockState((IWorld)p_196271_4_, (BlockPos)p_196271_5_);
            blockState.setData(Blocks.field_150350_a.func_176223_P());
            BlockFadeEvent event = new BlockFadeEvent((org.bukkit.block.Block)blockState.getBlock(), (org.bukkit.block.BlockState)blockState);
            p_196271_4_.getMinecraftWorld().getCBServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                return blockState.getHandle();
            }
        }
        return this.func_235494_a_(p_196271_4_, p_196271_5_, p_196271_1_.func_177229_b(field_176543_a));
    }

    @Override
    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return this.field_242672_q.get(p_220053_1_.func_206870_a(field_176543_a, 0));
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        return this.func_196448_a((IBlockReader)((Object)p_196258_1_.func_195991_k()), p_196258_1_.func_195995_a());
    }

    protected BlockState func_196448_a(IBlockReader p_196448_1_, BlockPos p_196448_2_) {
        BlockPos blockpos = p_196448_2_.func_177977_b();
        BlockState blockstate = p_196448_1_.func_180495_p(blockpos);
        if (!this.canCatchFire(p_196448_1_, p_196448_2_, Direction.UP) && !blockstate.func_224755_d(p_196448_1_, blockpos, Direction.UP)) {
            BlockState blockstate1 = this.func_176223_P();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanproperty = field_196449_B.get((Object)direction);
                if (booleanproperty == null) continue;
                blockstate1 = (BlockState)blockstate1.func_206870_a(booleanproperty, this.canCatchFire(p_196448_1_, p_196448_2_.func_177972_a(direction), direction.func_176734_d()));
            }
            return blockstate1;
        }
        return this.func_176223_P();
    }

    @Override
    public boolean func_196260_a(BlockState p_196260_1_, IWorldReader p_196260_2_, BlockPos p_196260_3_) {
        BlockPos blockpos = p_196260_3_.func_177977_b();
        return p_196260_2_.func_180495_p(blockpos).func_224755_d((IBlockReader)((Object)p_196260_2_), blockpos, Direction.UP) || this.func_196447_a((IBlockReader)((Object)p_196260_2_), p_196260_3_);
    }

    @Override
    public void func_225534_a_(BlockState p_225534_1_, ServerWorld p_225534_2_, BlockPos p_225534_3_, Random p_225534_4_) {
        p_225534_2_.func_205220_G_().func_205360_a(p_225534_3_, (Object)this, FireBlock.func_235495_a_(p_225534_2_.field_73012_v));
        if (p_225534_2_.func_82736_K().func_223586_b(GameRules.field_223598_a)) {
            if (!p_225534_1_.func_196955_c((IWorldReader)((Object)p_225534_2_), p_225534_3_)) {
                this.fireExtinguished(p_225534_2_, p_225534_3_);
            }
            BlockState blockstate = p_225534_2_.func_180495_p(p_225534_3_.func_177977_b());
            boolean flag = blockstate.isFireSource((IWorldReader)((Object)p_225534_2_), p_225534_3_, Direction.UP);
            int i = p_225534_1_.func_177229_b(field_176543_a);
            if (!flag && p_225534_2_.func_72896_J() && this.func_176537_d(p_225534_2_, p_225534_3_) && p_225534_4_.nextFloat() < 0.2f + (float)i * 0.03f) {
                this.fireExtinguished(p_225534_2_, p_225534_3_);
            } else {
                boolean flag1;
                int j = Math.min(15, i + p_225534_4_.nextInt(3) / 2);
                if (i != j) {
                    p_225534_1_ = (BlockState)p_225534_1_.func_206870_a(field_176543_a, j);
                    p_225534_2_.func_180501_a(p_225534_3_, p_225534_1_, 4);
                }
                if (!flag) {
                    if (!this.func_196447_a((IBlockReader)((Object)p_225534_2_), p_225534_3_)) {
                        BlockPos blockpos = p_225534_3_.func_177977_b();
                        if (!p_225534_2_.func_180495_p(blockpos).func_224755_d((IBlockReader)((Object)p_225534_2_), blockpos, Direction.UP) || i > 3) {
                            this.fireExtinguished(p_225534_2_, p_225534_3_);
                        }
                        return;
                    }
                    if (i == 15 && p_225534_4_.nextInt(4) == 0 && !this.canCatchFire((IBlockReader)((Object)p_225534_2_), p_225534_3_.func_177977_b(), Direction.UP)) {
                        this.fireExtinguished(p_225534_2_, p_225534_3_);
                        return;
                    }
                }
                int k = (flag1 = p_225534_2_.func_180502_D(p_225534_3_)) ? -50 : 0;
                this.tryCatchFire(p_225534_2_, p_225534_3_.func_177974_f(), 300 + k, p_225534_4_, i, Direction.WEST, p_225534_3_);
                this.tryCatchFire(p_225534_2_, p_225534_3_.func_177976_e(), 300 + k, p_225534_4_, i, Direction.EAST, p_225534_3_);
                this.tryCatchFire(p_225534_2_, p_225534_3_.func_177977_b(), 250 + k, p_225534_4_, i, Direction.UP, p_225534_3_);
                this.tryCatchFire(p_225534_2_, p_225534_3_.func_177984_a(), 250 + k, p_225534_4_, i, Direction.DOWN, p_225534_3_);
                this.tryCatchFire(p_225534_2_, p_225534_3_.func_177978_c(), 300 + k, p_225534_4_, i, Direction.SOUTH, p_225534_3_);
                this.tryCatchFire(p_225534_2_, p_225534_3_.func_177968_d(), 300 + k, p_225534_4_, i, Direction.NORTH, p_225534_3_);
                BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
                for (int l = -1; l <= 1; ++l) {
                    for (int i1 = -1; i1 <= 1; ++i1) {
                        for (int j1 = -1; j1 <= 4; ++j1) {
                            int l1;
                            if (l == 0 && j1 == 0 && i1 == 0) continue;
                            int k1 = 100;
                            if (j1 > 1) {
                                k1 += (j1 - 1) * 100;
                            }
                            blockpos$mutable.func_239621_a_(p_225534_3_, l, j1, i1);
                            if (!ChunkMcAPI.isTickingChunkLoaded((ServerWorld)p_225534_2_, (int)(blockpos$mutable.func_177958_n() >> 4), (int)(blockpos$mutable.func_177952_p() >> 4)) || (l1 = this.func_176538_m((IWorldReader)((Object)p_225534_2_), blockpos$mutable)) <= 0) continue;
                            int i2 = (l1 + 40 + p_225534_2_.func_175659_aa().func_151525_a() * 7) / (i + 30);
                            if (flag1) {
                                i2 /= 2;
                            }
                            if (i2 <= 0 || p_225534_4_.nextInt(k1) > i2 || p_225534_2_.func_72896_J() && this.func_176537_d(p_225534_2_, blockpos$mutable)) continue;
                            int j2 = Math.min(15, i + p_225534_4_.nextInt(5) / 4);
                            if (p_225534_2_.func_180495_p(blockpos$mutable).func_177230_c() == Blocks.field_150480_ab || CraftEventFactory.callBlockIgniteEvent((World)p_225534_2_, (BlockPos)blockpos$mutable, (BlockPos)p_225534_3_).isCancelled()) continue;
                            CraftEventFactory.handleBlockSpreadEvent((World)p_225534_2_, (BlockPos)p_225534_3_, (BlockPos)blockpos$mutable, (BlockState)((BlockState)this.func_196448_a((IBlockReader)((Object)p_225534_2_), blockpos$mutable).func_206870_a(field_176543_a, j2)), (int)3);
                        }
                    }
                }
            }
        }
    }

    protected boolean func_176537_d(World p_176537_1_, BlockPos p_176537_2_) {
        return p_176537_1_.func_175727_C(p_176537_2_) || p_176537_1_.func_175727_C(p_176537_2_.func_177976_e()) || p_176537_1_.func_175727_C(p_176537_2_.func_177974_f()) || p_176537_1_.func_175727_C(p_176537_2_.func_177978_c()) || p_176537_1_.func_175727_C(p_176537_2_.func_177968_d());
    }

    @Deprecated
    public int func_220274_q(BlockState p_220274_1_) {
        return p_220274_1_.func_235901_b_(BlockStateProperties.field_208198_y) && (Boolean)p_220274_1_.func_177229_b(BlockStateProperties.field_208198_y) != false ? 0 : this.field_149848_b.getInt((Object)p_220274_1_.func_177230_c());
    }

    @Deprecated
    public int func_220275_r(BlockState p_220275_1_) {
        return p_220275_1_.func_235901_b_(BlockStateProperties.field_208198_y) && (Boolean)p_220275_1_.func_177229_b(BlockStateProperties.field_208198_y) != false ? 0 : this.field_149849_a.getInt((Object)p_220275_1_.func_177230_c());
    }

    private void tryCatchFire(World worldIn, BlockPos pos, int chance, Random random, int age, Direction face, BlockPos sourceposition) {
        int i = worldIn.func_180495_p(pos).getFlammability((IBlockReader)((Object)worldIn), pos, face);
        if (random.nextInt(chance) < i) {
            BlockState blockstate = worldIn.func_180495_p(pos);
            org.bukkit.block.Block theBlock = worldIn.getWorld().getBlockAt(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            org.bukkit.block.Block sourceBlock = worldIn.getWorld().getBlockAt(sourceposition.func_177958_n(), sourceposition.func_177956_o(), sourceposition.func_177952_p());
            BlockBurnEvent event = new BlockBurnEvent(theBlock, sourceBlock);
            worldIn.getCBServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            if (random.nextInt(age + 10) < 5 && !worldIn.func_175727_C(pos)) {
                int j = Math.min(age + random.nextInt(5) / 4, 15);
                worldIn.func_180501_a(pos, this.func_235494_a_(worldIn, pos, j), 3);
            } else {
                worldIn.func_217377_a(pos, false);
            }
            blockstate.catchFire(worldIn, pos, face, null);
        }
    }

    private BlockState func_235494_a_(IWorld p_235494_1_, BlockPos p_235494_2_, int p_235494_3_) {
        BlockState blockstate = FireBlock.func_235326_a_((IBlockReader)((Object)p_235494_1_), p_235494_2_);
        return blockstate.func_203425_a(Blocks.field_150480_ab) ? (BlockState)blockstate.func_206870_a(field_176543_a, p_235494_3_) : blockstate;
    }

    private boolean func_196447_a(IBlockReader p_196447_1_, BlockPos p_196447_2_) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(p_196447_1_, p_196447_2_.func_177972_a(direction), direction.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    private int func_176538_m(IWorldReader p_176538_1_, BlockPos p_176538_2_) {
        if (!p_176538_1_.func_175623_d(p_176538_2_)) {
            return 0;
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            BlockState blockstate = p_176538_1_.func_180495_p(p_176538_2_.func_177972_a(direction));
            i = Math.max(blockstate.getFireSpreadSpeed((IBlockReader)((Object)p_176538_1_), p_176538_2_.func_177972_a(direction), direction.func_176734_d()), i);
        }
        return i;
    }

    @Override
    @Deprecated
    protected boolean func_196446_i(BlockState p_196446_1_) {
        return this.func_220275_r(p_196446_1_) > 0;
    }

    @Override
    public void func_220082_b(BlockState p_220082_1_, World p_220082_2_, BlockPos p_220082_3_, BlockState p_220082_4_, boolean p_220082_5_) {
        super.func_220082_b(p_220082_1_, p_220082_2_, p_220082_3_, p_220082_4_, p_220082_5_);
        p_220082_2_.func_205220_G_().func_205360_a(p_220082_3_, (Object)this, FireBlock.func_235495_a_(p_220082_2_.field_73012_v));
    }

    private static int func_235495_a_(Random p_235495_0_) {
        return 30 + p_235495_0_.nextInt(10);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{field_176543_a, field_176545_N, field_176546_O, field_176541_P, field_176539_Q, field_176542_R});
    }

    private void func_180686_a(Block p_180686_1_, int p_180686_2_, int p_180686_3_) {
        if (p_180686_1_ == Blocks.field_150350_a) {
            throw new IllegalArgumentException("Tried to set air on fire... This is bad.");
        }
        this.field_149849_a.put((Object)p_180686_1_, p_180686_2_);
        this.field_149848_b.put((Object)p_180686_1_, p_180686_3_);
    }

    public boolean canCatchFire(IBlockReader world, BlockPos pos, Direction face) {
        return world.func_180495_p(pos).isFlammable(world, pos, face);
    }

    public static void func_149843_e() {
        FireBlock fireblock = (FireBlock)Blocks.field_150480_ab;
        fireblock.func_180686_a(Blocks.field_196662_n, 5, 20);
        fireblock.func_180686_a(Blocks.field_196664_o, 5, 20);
        fireblock.func_180686_a(Blocks.field_196666_p, 5, 20);
        fireblock.func_180686_a(Blocks.field_196668_q, 5, 20);
        fireblock.func_180686_a(Blocks.field_196670_r, 5, 20);
        fireblock.func_180686_a(Blocks.field_196672_s, 5, 20);
        fireblock.func_180686_a(Blocks.field_196622_bq, 5, 20);
        fireblock.func_180686_a(Blocks.field_196624_br, 5, 20);
        fireblock.func_180686_a(Blocks.field_196627_bs, 5, 20);
        fireblock.func_180686_a(Blocks.field_196630_bt, 5, 20);
        fireblock.func_180686_a(Blocks.field_196632_bu, 5, 20);
        fireblock.func_180686_a(Blocks.field_196635_bv, 5, 20);
        fireblock.func_180686_a(Blocks.field_180390_bo, 5, 20);
        fireblock.func_180686_a(Blocks.field_180391_bp, 5, 20);
        fireblock.func_180686_a(Blocks.field_180392_bq, 5, 20);
        fireblock.func_180686_a(Blocks.field_180386_br, 5, 20);
        fireblock.func_180686_a(Blocks.field_180385_bs, 5, 20);
        fireblock.func_180686_a(Blocks.field_180387_bt, 5, 20);
        fireblock.func_180686_a(Blocks.field_180407_aO, 5, 20);
        fireblock.func_180686_a(Blocks.field_180408_aP, 5, 20);
        fireblock.func_180686_a(Blocks.field_180404_aQ, 5, 20);
        fireblock.func_180686_a(Blocks.field_180403_aR, 5, 20);
        fireblock.func_180686_a(Blocks.field_180406_aS, 5, 20);
        fireblock.func_180686_a(Blocks.field_180405_aT, 5, 20);
        fireblock.func_180686_a(Blocks.field_150476_ad, 5, 20);
        fireblock.func_180686_a(Blocks.field_150487_bG, 5, 20);
        fireblock.func_180686_a(Blocks.field_150485_bF, 5, 20);
        fireblock.func_180686_a(Blocks.field_150481_bH, 5, 20);
        fireblock.func_180686_a(Blocks.field_150400_ck, 5, 20);
        fireblock.func_180686_a(Blocks.field_150401_cl, 5, 20);
        fireblock.func_180686_a(Blocks.field_196617_K, 5, 5);
        fireblock.func_180686_a(Blocks.field_196618_L, 5, 5);
        fireblock.func_180686_a(Blocks.field_196619_M, 5, 5);
        fireblock.func_180686_a(Blocks.field_196620_N, 5, 5);
        fireblock.func_180686_a(Blocks.field_196621_O, 5, 5);
        fireblock.func_180686_a(Blocks.field_196623_P, 5, 5);
        fireblock.func_180686_a(Blocks.field_203204_R, 5, 5);
        fireblock.func_180686_a(Blocks.field_203205_S, 5, 5);
        fireblock.func_180686_a(Blocks.field_203206_T, 5, 5);
        fireblock.func_180686_a(Blocks.field_203207_U, 5, 5);
        fireblock.func_180686_a(Blocks.field_203208_V, 5, 5);
        fireblock.func_180686_a(Blocks.field_203209_W, 5, 5);
        fireblock.func_180686_a(Blocks.field_209389_ab, 5, 5);
        fireblock.func_180686_a(Blocks.field_209390_ac, 5, 5);
        fireblock.func_180686_a(Blocks.field_209391_ad, 5, 5);
        fireblock.func_180686_a(Blocks.field_209392_ae, 5, 5);
        fireblock.func_180686_a(Blocks.field_209393_af, 5, 5);
        fireblock.func_180686_a(Blocks.field_209394_ag, 5, 5);
        fireblock.func_180686_a(Blocks.field_196626_Q, 5, 5);
        fireblock.func_180686_a(Blocks.field_196629_R, 5, 5);
        fireblock.func_180686_a(Blocks.field_196631_S, 5, 5);
        fireblock.func_180686_a(Blocks.field_196634_T, 5, 5);
        fireblock.func_180686_a(Blocks.field_196637_U, 5, 5);
        fireblock.func_180686_a(Blocks.field_196639_V, 5, 5);
        fireblock.func_180686_a(Blocks.field_196642_W, 30, 60);
        fireblock.func_180686_a(Blocks.field_196645_X, 30, 60);
        fireblock.func_180686_a(Blocks.field_196647_Y, 30, 60);
        fireblock.func_180686_a(Blocks.field_196648_Z, 30, 60);
        fireblock.func_180686_a(Blocks.field_196572_aa, 30, 60);
        fireblock.func_180686_a(Blocks.field_196574_ab, 30, 60);
        fireblock.func_180686_a(Blocks.field_150342_X, 30, 20);
        fireblock.func_180686_a(Blocks.field_150335_W, 15, 100);
        fireblock.func_180686_a(Blocks.field_150349_c, 60, 100);
        fireblock.func_180686_a(Blocks.field_196554_aH, 60, 100);
        fireblock.func_180686_a(Blocks.field_196555_aI, 60, 100);
        fireblock.func_180686_a(Blocks.field_196800_gd, 60, 100);
        fireblock.func_180686_a(Blocks.field_196801_ge, 60, 100);
        fireblock.func_180686_a(Blocks.field_196802_gf, 60, 100);
        fireblock.func_180686_a(Blocks.field_196803_gg, 60, 100);
        fireblock.func_180686_a(Blocks.field_196804_gh, 60, 100);
        fireblock.func_180686_a(Blocks.field_196805_gi, 60, 100);
        fireblock.func_180686_a(Blocks.field_196605_bc, 60, 100);
        fireblock.func_180686_a(Blocks.field_196606_bd, 60, 100);
        fireblock.func_180686_a(Blocks.field_196607_be, 60, 100);
        fireblock.func_180686_a(Blocks.field_196609_bf, 60, 100);
        fireblock.func_180686_a(Blocks.field_196610_bg, 60, 100);
        fireblock.func_180686_a(Blocks.field_196612_bh, 60, 100);
        fireblock.func_180686_a(Blocks.field_196613_bi, 60, 100);
        fireblock.func_180686_a(Blocks.field_196614_bj, 60, 100);
        fireblock.func_180686_a(Blocks.field_196615_bk, 60, 100);
        fireblock.func_180686_a(Blocks.field_196616_bl, 60, 100);
        fireblock.func_180686_a(Blocks.field_222387_by, 60, 100);
        fireblock.func_180686_a(Blocks.field_222383_bA, 60, 100);
        fireblock.func_180686_a(Blocks.field_222388_bz, 60, 100);
        fireblock.func_180686_a(Blocks.field_196556_aL, 30, 60);
        fireblock.func_180686_a(Blocks.field_196557_aM, 30, 60);
        fireblock.func_180686_a(Blocks.field_196558_aN, 30, 60);
        fireblock.func_180686_a(Blocks.field_196559_aO, 30, 60);
        fireblock.func_180686_a(Blocks.field_196560_aP, 30, 60);
        fireblock.func_180686_a(Blocks.field_196561_aQ, 30, 60);
        fireblock.func_180686_a(Blocks.field_196562_aR, 30, 60);
        fireblock.func_180686_a(Blocks.field_196563_aS, 30, 60);
        fireblock.func_180686_a(Blocks.field_196564_aT, 30, 60);
        fireblock.func_180686_a(Blocks.field_196565_aU, 30, 60);
        fireblock.func_180686_a(Blocks.field_196566_aV, 30, 60);
        fireblock.func_180686_a(Blocks.field_196567_aW, 30, 60);
        fireblock.func_180686_a(Blocks.field_196568_aX, 30, 60);
        fireblock.func_180686_a(Blocks.field_196569_aY, 30, 60);
        fireblock.func_180686_a(Blocks.field_196570_aZ, 30, 60);
        fireblock.func_180686_a(Blocks.field_196602_ba, 30, 60);
        fireblock.func_180686_a(Blocks.field_150395_bd, 15, 100);
        fireblock.func_180686_a(Blocks.field_150402_ci, 5, 5);
        fireblock.func_180686_a(Blocks.field_150407_cf, 60, 20);
        fireblock.func_180686_a(Blocks.field_235396_nb_, 15, 20);
        fireblock.func_180686_a(Blocks.field_196724_fH, 60, 20);
        fireblock.func_180686_a(Blocks.field_196725_fI, 60, 20);
        fireblock.func_180686_a(Blocks.field_196727_fJ, 60, 20);
        fireblock.func_180686_a(Blocks.field_196729_fK, 60, 20);
        fireblock.func_180686_a(Blocks.field_196731_fL, 60, 20);
        fireblock.func_180686_a(Blocks.field_196733_fM, 60, 20);
        fireblock.func_180686_a(Blocks.field_196735_fN, 60, 20);
        fireblock.func_180686_a(Blocks.field_196737_fO, 60, 20);
        fireblock.func_180686_a(Blocks.field_196739_fP, 60, 20);
        fireblock.func_180686_a(Blocks.field_196741_fQ, 60, 20);
        fireblock.func_180686_a(Blocks.field_196743_fR, 60, 20);
        fireblock.func_180686_a(Blocks.field_196745_fS, 60, 20);
        fireblock.func_180686_a(Blocks.field_196747_fT, 60, 20);
        fireblock.func_180686_a(Blocks.field_196749_fU, 60, 20);
        fireblock.func_180686_a(Blocks.field_196751_fV, 60, 20);
        fireblock.func_180686_a(Blocks.field_196753_fW, 60, 20);
        fireblock.func_180686_a(Blocks.field_203216_jz, 30, 60);
        fireblock.func_180686_a(Blocks.field_222405_kQ, 60, 60);
        fireblock.func_180686_a(Blocks.field_222420_lI, 60, 60);
        fireblock.func_180686_a(Blocks.field_222428_lQ, 30, 20);
        fireblock.func_180686_a(Blocks.field_222436_lZ, 5, 20);
        fireblock.func_180686_a(Blocks.field_222434_lW, 60, 100);
        fireblock.func_180686_a(Blocks.field_226906_mb_, 5, 20);
        fireblock.func_180686_a(Blocks.field_226905_ma_, 30, 20);
    }
}

