/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Maps;
import io.papermc.paper.event.player.PlayerFlowerPotManipulateEvent;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.pathfinding.PathType;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class FlowerPotBlock
extends Block {
    private static final Map<Block, Block> field_196451_b = Maps.newHashMap();
    protected static final VoxelShape field_196450_a = Block.func_208617_a(5.0, 0.0, 5.0, 11.0, 6.0, 11.0);
    private final Block field_196452_c = null;
    private final Map<ResourceLocation, Supplier<? extends Block>> fullPots;
    private final Supplier<FlowerPotBlock> emptyPot;
    private final Supplier<? extends Block> flowerDelegate;

    @Deprecated
    public FlowerPotBlock(Block p_i48395_1_, AbstractBlock.Properties p_i48395_2_) {
        this(Blocks.field_150457_bL == null ? null : () -> (FlowerPotBlock)((Object)((Object)Blocks.field_150457_bL.delegate.get())), () -> (Block)((Object)((Object)p_i48395_1_.delegate.get())), p_i48395_2_);
        if (Blocks.field_150457_bL != null) {
            ((FlowerPotBlock)Blocks.field_150457_bL).addPlant(p_i48395_1_.getRegistryName(), () -> this);
        }
    }

    public FlowerPotBlock(@Nullable Supplier<FlowerPotBlock> emptyPot, Supplier<? extends Block> p_i48395_1_, AbstractBlock.Properties properties) {
        super(properties);
        this.flowerDelegate = p_i48395_1_;
        if (emptyPot == null) {
            this.fullPots = Maps.newHashMap();
            this.emptyPot = null;
        } else {
            this.fullPots = Collections.emptyMap();
            this.emptyPot = emptyPot;
        }
    }

    @Override
    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return field_196450_a;
    }

    @Override
    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        boolean flag1;
        net.minecraft.item.ItemStack itemstack = p_225533_4_.func_184586_b(p_225533_5_);
        Item item = itemstack.func_77973_b();
        Block block = item instanceof BlockItem ? this.getEmptyPot().fullPots.getOrDefault(((BlockItem)item).func_179223_d().getRegistryName(), (Supplier<? extends Block>)Blocks.field_150350_a.delegate).get() : Blocks.field_150350_a;
        boolean flag = block == Blocks.field_150350_a;
        boolean bl = flag1 = this.field_196452_c == Blocks.field_150350_a;
        if (flag != flag1) {
            Player bukkitPlayer = (Player)p_225533_4_.getBukkitEntity();
            CraftBlock bukkitBlock = CraftBlock.at((IWorld)p_225533_2_, (BlockPos)p_225533_3_);
            ItemStack bukkitStack = CraftItemStack.asBukkitCopy((net.minecraft.item.ItemStack)itemstack);
            Material bukkitMat = CraftMagicNumbers.getMaterial((Block)this.field_196452_c);
            ItemStack bukkitStack1 = new ItemStack(bukkitMat, 1);
            ItemStack whichitem = flag1 ? bukkitStack : bukkitStack1;
            PlayerFlowerPotManipulateEvent event = new PlayerFlowerPotManipulateEvent(bukkitPlayer, (org.bukkit.block.Block)bukkitBlock, whichitem, flag1);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                bukkitPlayer.sendBlockChange(bukkitBlock.getLocation(), bukkitBlock.getBlockData());
                bukkitPlayer.updateInventory();
                return ActionResultType.PASS;
            }
            if (flag1) {
                p_225533_2_.func_180501_a(p_225533_3_, block.func_176223_P(), 3);
                p_225533_4_.func_195066_a(Stats.field_188088_V);
                if (!p_225533_4_.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
            } else {
                net.minecraft.item.ItemStack itemstack1 = new net.minecraft.item.ItemStack(this.field_196452_c);
                if (itemstack.func_190926_b()) {
                    p_225533_4_.func_184611_a(p_225533_5_, itemstack1);
                } else if (!p_225533_4_.func_191521_c(itemstack1)) {
                    p_225533_4_.func_71019_a(itemstack1, false);
                }
                p_225533_2_.func_180501_a(p_225533_3_, this.getEmptyPot().func_176223_P(), 3);
            }
            return ActionResultType.func_233537_a_((boolean)p_225533_2_.field_72995_K);
        }
        return ActionResultType.CONSUME;
    }

    @Override
    public net.minecraft.item.ItemStack func_185473_a(IBlockReader p_185473_1_, BlockPos p_185473_2_, BlockState p_185473_3_) {
        return this.field_196452_c == Blocks.field_150350_a ? super.func_185473_a(p_185473_1_, p_185473_2_, p_185473_3_) : new net.minecraft.item.ItemStack(this.field_196452_c);
    }

    @Override
    public BlockState func_196271_a(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, IWorld p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        return p_196271_2_ == Direction.DOWN && !p_196271_1_.func_196955_c((IWorldReader)((Object)p_196271_4_), p_196271_5_) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    public Block func_220276_d() {
        return this.flowerDelegate.get();
    }

    @Override
    public boolean func_196266_a(BlockState p_196266_1_, IBlockReader p_196266_2_, BlockPos p_196266_3_, PathType p_196266_4_) {
        return false;
    }

    public FlowerPotBlock getEmptyPot() {
        return this.emptyPot == null ? this : this.emptyPot.get();
    }

    public void addPlant(ResourceLocation flower, Supplier<? extends Block> fullPot) {
        if (this.getEmptyPot() != this) {
            throw new IllegalArgumentException("Cannot add plant to non-empty pot: " + (Object)((Object)this));
        }
        this.fullPots.put(flower, fullPot);
    }

    public Map<ResourceLocation, Supplier<? extends Block>> getFullPotsView() {
        return Collections.unmodifiableMap(this.fullPots);
    }
}

