/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SaplingBlock;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.server.ServerWorld;
import org.bukkit.TreeType;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;

public class MushroomBlock
extends BushBlock
implements IGrowable {
    protected static final VoxelShape field_196385_a = Block.func_208617_a(5.0, 0.0, 5.0, 11.0, 6.0, 11.0);

    public MushroomBlock(AbstractBlock.Properties p_i48363_1_) {
        super(p_i48363_1_);
    }

    @Override
    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return field_196385_a;
    }

    @Override
    public void func_225542_b_(BlockState p_225542_1_, ServerWorld p_225542_2_, BlockPos p_225542_3_, Random p_225542_4_) {
        if (p_225542_4_.nextInt(Math.max(1, (int)(100.0f / (float)p_225542_2_.spigotConfig.mushroomModifier) * 25)) == 0) {
            int i = 5;
            int j = 4;
            for (BlockPos blockpos : BlockPos.func_218278_a(p_225542_3_.func_177982_a(-4, -1, -4), p_225542_3_.func_177982_a(4, 1, 4))) {
                if (!p_225542_2_.func_180495_p(blockpos).func_203425_a(this) || --i > 0) continue;
                return;
            }
            BlockPos blockpos1 = p_225542_3_.func_177982_a(p_225542_4_.nextInt(3) - 1, p_225542_4_.nextInt(2) - p_225542_4_.nextInt(2), p_225542_4_.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (p_225542_2_.func_175623_d(blockpos1) && p_225542_1_.func_196955_c((IWorldReader)((Object)p_225542_2_), blockpos1)) {
                    p_225542_3_ = blockpos1;
                }
                blockpos1 = p_225542_3_.func_177982_a(p_225542_4_.nextInt(3) - 1, p_225542_4_.nextInt(2) - p_225542_4_.nextInt(2), p_225542_4_.nextInt(3) - 1);
            }
            if (p_225542_2_.func_175623_d(blockpos1) && p_225542_1_.func_196955_c((IWorldReader)((Object)p_225542_2_), blockpos1)) {
                CraftEventFactory.handleBlockSpreadEvent((World)p_225542_2_, (BlockPos)p_225542_3_, (BlockPos)blockpos1, (BlockState)p_225542_1_, (int)2);
            }
        }
    }

    @Override
    protected boolean func_200014_a_(BlockState p_200014_1_, IBlockReader p_200014_2_, BlockPos p_200014_3_) {
        return p_200014_1_.func_200015_d(p_200014_2_, p_200014_3_);
    }

    @Override
    public boolean func_196260_a(BlockState p_196260_1_, IWorldReader p_196260_2_, BlockPos p_196260_3_) {
        BlockPos blockpos = p_196260_3_.func_177977_b();
        BlockState blockstate = p_196260_2_.func_180495_p(blockpos);
        if (blockstate.func_235714_a_(BlockTags.field_242171_aD)) {
            return true;
        }
        return p_196260_2_.func_226659_b_(p_196260_3_, 0) < 13 && blockstate.canSustainPlant((IBlockReader)((Object)p_196260_2_), blockpos, Direction.UP, this);
    }

    public boolean func_226940_a_(ServerWorld p_226940_1_, BlockPos p_226940_2_, BlockState p_226940_3_, Random p_226940_4_) {
        ConfiguredFeature configuredfeature;
        p_226940_1_.func_217377_a(p_226940_2_, false);
        if (this == Blocks.field_150338_P) {
            SaplingBlock.treeType = TreeType.BROWN_MUSHROOM;
            configuredfeature = Features.field_243860_bF;
        } else {
            if (this != Blocks.field_150337_Q) {
                p_226940_1_.func_180501_a(p_226940_2_, p_226940_3_, 3);
                return false;
            }
            SaplingBlock.treeType = TreeType.RED_MUSHROOM;
            configuredfeature = Features.field_243861_bG;
        }
        if (configuredfeature.func_242765_a((ISeedReader)p_226940_1_, p_226940_1_.func_72863_F().func_201711_g(), p_226940_4_, p_226940_2_)) {
            return true;
        }
        p_226940_1_.func_180501_a(p_226940_2_, p_226940_3_, 3);
        return false;
    }

    public boolean func_176473_a(IBlockReader p_176473_1_, BlockPos p_176473_2_, BlockState p_176473_3_, boolean p_176473_4_) {
        return true;
    }

    public boolean func_180670_a(World p_180670_1_, Random p_180670_2_, BlockPos p_180670_3_, BlockState p_180670_4_) {
        return (double)p_180670_2_.nextFloat() < 0.4;
    }

    public void func_225535_a_(ServerWorld p_225535_1_, Random p_225535_2_, BlockPos p_225535_3_, BlockState p_225535_4_) {
        this.func_226940_a_(p_225535_1_, p_225535_3_, p_225535_4_, p_225535_2_);
    }
}

