/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;

public class PoweredRailBlock
extends AbstractRailBlock {
    public static final EnumProperty<RailShape> field_176568_b = BlockStateProperties.field_208166_S;
    public static final BooleanProperty field_176569_M = BlockStateProperties.field_208194_u;
    private final boolean isActivator;

    public PoweredRailBlock(AbstractBlock.Properties p_i48349_1_) {
        this(p_i48349_1_, false);
    }

    protected PoweredRailBlock(AbstractBlock.Properties builder, boolean isPoweredRail) {
        super(true, builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176568_b, RailShape.NORTH_SOUTH)).func_206870_a(field_176569_M, false));
        this.isActivator = !isPoweredRail;
    }

    protected boolean func_176566_a(World p_176566_1_, BlockPos p_176566_2_, BlockState p_176566_3_, boolean p_176566_4_, int p_176566_5_) {
        if (p_176566_5_ >= 8) {
            return false;
        }
        int i = p_176566_2_.func_177958_n();
        int j = p_176566_2_.func_177956_o();
        int k = p_176566_2_.func_177952_p();
        boolean flag = true;
        RailShape railshape = p_176566_3_.func_177229_b(field_176568_b);
        switch (railshape) {
            case NORTH_SOUTH: {
                if (p_176566_4_) {
                    ++k;
                    break;
                }
                --k;
                break;
            }
            case EAST_WEST: {
                if (p_176566_4_) {
                    --i;
                    break;
                }
                ++i;
                break;
            }
            case ASCENDING_EAST: {
                if (p_176566_4_) {
                    --i;
                } else {
                    ++i;
                    ++j;
                    flag = false;
                }
                railshape = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (p_176566_4_) {
                    --i;
                    ++j;
                    flag = false;
                } else {
                    ++i;
                }
                railshape = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (p_176566_4_) {
                    ++k;
                } else {
                    --k;
                    ++j;
                    flag = false;
                }
                railshape = RailShape.NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (p_176566_4_) {
                    ++k;
                    ++j;
                    flag = false;
                } else {
                    --k;
                }
                railshape = RailShape.NORTH_SOUTH;
            }
        }
        if (this.func_208071_a(p_176566_1_, new BlockPos(i, j, k), p_176566_4_, p_176566_5_, railshape)) {
            return true;
        }
        return flag && this.func_208071_a(p_176566_1_, new BlockPos(i, j - 1, k), p_176566_4_, p_176566_5_, railshape);
    }

    protected boolean func_208071_a(World p_208071_1_, BlockPos p_208071_2_, boolean p_208071_3_, int p_208071_4_, RailShape p_208071_5_) {
        BlockState blockstate = p_208071_1_.func_180495_p(p_208071_2_);
        if (!(blockstate.func_177230_c() instanceof PoweredRailBlock)) {
            return false;
        }
        RailShape railshape = this.getRailDirection(blockstate, (IBlockReader)((Object)p_208071_1_), p_208071_2_, null);
        if (p_208071_5_ != RailShape.EAST_WEST || railshape != RailShape.NORTH_SOUTH && railshape != RailShape.ASCENDING_NORTH && railshape != RailShape.ASCENDING_SOUTH) {
            if (p_208071_5_ != RailShape.NORTH_SOUTH || railshape != RailShape.EAST_WEST && railshape != RailShape.ASCENDING_EAST && railshape != RailShape.ASCENDING_WEST) {
                if (this.isActivator == ((PoweredRailBlock)blockstate.func_177230_c()).isActivator) {
                    return p_208071_1_.func_175640_z(p_208071_2_) ? true : this.func_176566_a(p_208071_1_, p_208071_2_, blockstate, p_208071_3_, p_208071_4_ + 1);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    protected void func_189541_b(BlockState p_189541_1_, World p_189541_2_, BlockPos p_189541_3_, Block p_189541_4_) {
        boolean flag1;
        boolean flag = (Boolean)p_189541_1_.func_177229_b(field_176569_M);
        boolean bl = flag1 = p_189541_2_.func_175640_z(p_189541_3_) || this.func_176566_a(p_189541_2_, p_189541_3_, p_189541_1_, true, 0) || this.func_176566_a(p_189541_2_, p_189541_3_, p_189541_1_, false, 0);
        if (flag1 != flag) {
            int power = flag ? 15 : 0;
            int newPower = CraftEventFactory.callRedstoneChange((World)p_189541_2_, (BlockPos)p_189541_3_, (int)power, (int)(15 - power)).getNewCurrent();
            if (newPower == power) {
                return;
            }
            p_189541_2_.func_180501_a(p_189541_3_, (BlockState)p_189541_1_.func_206870_a(field_176569_M, flag1), 3);
            p_189541_2_.func_195593_d(p_189541_3_.func_177977_b(), this);
            if (p_189541_1_.func_177229_b(field_176568_b).func_208092_c()) {
                p_189541_2_.func_195593_d(p_189541_3_.func_177984_a(), this);
            }
        }
    }

    @Override
    public Property<RailShape> func_176560_l() {
        return field_176568_b;
    }

    @Override
    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        switch (p_185499_2_) {
            case CLOCKWISE_180: {
                switch (p_185499_1_.func_177229_b(field_176568_b)) {
                    case ASCENDING_EAST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.SOUTH_WEST);
                    }
                    case NORTH_SOUTH: 
                    case EAST_WEST: {
                        return p_185499_1_;
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch (p_185499_1_.func_177229_b(field_176568_b)) {
                    case NORTH_SOUTH: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.NORTH_WEST);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (p_185499_1_.func_177229_b(field_176568_b)) {
                    case NORTH_SOUTH: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)p_185499_1_.func_206870_a(field_176568_b, RailShape.SOUTH_EAST);
                    }
                }
            }
        }
        return p_185499_1_;
    }

    @Override
    public BlockState func_185471_a(BlockState p_185471_1_, Mirror p_185471_2_) {
        RailShape railshape = p_185471_1_.func_177229_b(field_176568_b);
        block0 : switch (p_185471_2_) {
            case LEFT_RIGHT: {
                switch (railshape) {
                    case ASCENDING_NORTH: {
                        return (BlockState)p_185471_1_.func_206870_a(field_176568_b, RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)p_185471_1_.func_206870_a(field_176568_b, RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_185471_1_.func_206870_a(field_176568_b, RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_185471_1_.func_206870_a(field_176568_b, RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_185471_1_.func_206870_a(field_176568_b, RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)p_185471_1_.func_206870_a(field_176568_b, RailShape.SOUTH_EAST);
                    }
                }
                return super.func_185471_a(p_185471_1_, p_185471_2_);
            }
            case FRONT_BACK: {
                switch (railshape) {
                    case ASCENDING_EAST: {
                        return (BlockState)p_185471_1_.func_206870_a(field_176568_b, RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)p_185471_1_.func_206870_a(field_176568_b, RailShape.ASCENDING_EAST);
                    }
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_185471_1_.func_206870_a(field_176568_b, RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_185471_1_.func_206870_a(field_176568_b, RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_185471_1_.func_206870_a(field_176568_b, RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                return (BlockState)p_185471_1_.func_206870_a(field_176568_b, RailShape.NORTH_WEST);
            }
        }
        return super.func_185471_a(p_185471_1_, p_185471_2_);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{field_176568_b, field_176569_M});
    }

    public boolean isActivatorRail() {
        return this.isActivator;
    }
}

