/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.GameSettings;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventAccessor;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEngine;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundList;
import net.minecraft.client.audio.SoundListSerializer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class SoundHandler
extends ReloadListener<Loader> {
    public static final Sound field_147700_a = new Sound("meta:missing_sound", 1.0f, 1.0f, 1, Sound.Type.FILE, false, false, 16);
    private static final Logger field_147698_b = LogManager.getLogger();
    private static final Gson field_147699_c = new GsonBuilder().registerTypeHierarchyAdapter(ITextComponent.class, (Object)new ITextComponent.Serializer()).registerTypeAdapter(SoundList.class, (Object)new SoundListSerializer()).create();
    private static final TypeToken<Map<String, SoundList>> field_147696_d = new TypeToken<Map<String, SoundList>>(){};
    private final Map<ResourceLocation, SoundEventAccessor> field_147697_e = Maps.newHashMap();
    private final SoundEngine field_147694_f;

    public SoundHandler(IResourceManager p_i45122_1_, GameSettings p_i45122_2_) {
        this.field_147694_f = new SoundEngine(this, p_i45122_2_, p_i45122_1_);
    }

    protected Loader func_212854_a_(IResourceManager p_212854_1_, IProfiler p_212854_2_) {
        Loader soundhandler$loader = new Loader();
        p_212854_2_.func_219894_a();
        for (String s : p_212854_1_.func_199001_a()) {
            p_212854_2_.func_76320_a(s);
            try {
                for (IResource iresource : p_212854_1_.func_199004_b(new ResourceLocation(s, "sounds.json"))) {
                    p_212854_2_.func_76320_a(iresource.func_199026_d());
                    try (InputStream inputstream = iresource.func_199027_b();
                         InputStreamReader reader = new InputStreamReader(inputstream, StandardCharsets.UTF_8);){
                        p_212854_2_.func_76320_a("parse");
                        Map map = (Map)JSONUtils.func_233010_a_((Gson)field_147699_c, (Reader)reader, field_147696_d);
                        p_212854_2_.func_219895_b("register");
                        for (Map.Entry entry : map.entrySet()) {
                            soundhandler$loader.func_217944_a(new ResourceLocation(s, (String)entry.getKey()), (SoundList)entry.getValue(), p_212854_1_);
                        }
                        p_212854_2_.func_76319_b();
                    }
                    catch (RuntimeException runtimeexception) {
                        field_147698_b.warn("Invalid sounds.json in resourcepack: '{}'", (Object)iresource.func_199026_d(), (Object)runtimeexception);
                    }
                    p_212854_2_.func_76319_b();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            p_212854_2_.func_76319_b();
        }
        p_212854_2_.func_219897_b();
        return soundhandler$loader;
    }

    protected void func_212853_a_(Loader p_212853_1_, IResourceManager p_212853_2_, IProfiler p_212853_3_) {
        p_212853_1_.func_217946_a(this.field_147697_e, this.field_147694_f);
        for (ResourceLocation resourcelocation : this.field_147697_e.keySet()) {
            String s;
            SoundEventAccessor soundeventaccessor = this.field_147697_e.get(resourcelocation);
            if (!(soundeventaccessor.func_188712_c() instanceof TranslationTextComponent) || I18n.func_188566_a(s = ((TranslationTextComponent)((Object)soundeventaccessor.func_188712_c())).func_150268_i())) continue;
            field_147698_b.debug("Missing subtitle {} for event: {}", (Object)s, (Object)resourcelocation);
        }
        if (field_147698_b.isDebugEnabled()) {
            for (ResourceLocation resourcelocation1 : this.field_147697_e.keySet()) {
                if (Registry.field_212633_v.func_212607_c(resourcelocation1)) continue;
                field_147698_b.debug("Not having sound event for: {}", (Object)resourcelocation1);
            }
        }
        this.field_147694_f.func_148596_a();
    }

    private static boolean func_215292_b(Sound p_215292_0_, ResourceLocation p_215292_1_, IResourceManager p_215292_2_) {
        ResourceLocation resourcelocation = p_215292_0_.func_188721_b();
        if (!p_215292_2_.func_219533_b(resourcelocation)) {
            field_147698_b.warn("File {} does not exist, cannot add it to event {}", (Object)resourcelocation, (Object)p_215292_1_);
            return false;
        }
        return true;
    }

    @Nullable
    public SoundEventAccessor func_184398_a(ResourceLocation p_184398_1_) {
        return this.field_147697_e.get(p_184398_1_);
    }

    public Collection<ResourceLocation> func_195477_a() {
        return this.field_147697_e.keySet();
    }

    public void func_229364_a_(ITickableSound p_229364_1_) {
        this.field_147694_f.func_229363_a_(p_229364_1_);
    }

    public void func_147682_a(ISound p_147682_1_) {
        this.field_147694_f.func_148611_c(p_147682_1_);
    }

    public void func_147681_a(ISound p_147681_1_, int p_147681_2_) {
        this.field_147694_f.func_148599_a(p_147681_1_, p_147681_2_);
    }

    public void func_215289_a(ActiveRenderInfo p_215289_1_) {
        this.field_147694_f.func_217920_a(p_215289_1_);
    }

    public void func_147689_b() {
        this.field_147694_f.func_148610_e();
    }

    public void func_147690_c() {
        this.field_147694_f.func_148614_c();
    }

    public void func_147685_d() {
        this.field_147694_f.func_148613_b();
    }

    public void func_215290_a(boolean p_215290_1_) {
        this.field_147694_f.func_217921_a(p_215290_1_);
    }

    public void func_147687_e() {
        this.field_147694_f.func_148604_f();
    }

    public void func_184399_a(SoundCategory p_184399_1_, float p_184399_2_) {
        if (p_184399_1_ == SoundCategory.MASTER && p_184399_2_ <= 0.0f) {
            this.func_147690_c();
        }
        this.field_147694_f.func_188771_a(p_184399_1_, p_184399_2_);
    }

    public void func_147683_b(ISound p_147683_1_) {
        this.field_147694_f.func_148602_b(p_147683_1_);
    }

    public boolean func_215294_c(ISound p_215294_1_) {
        return this.field_147694_f.func_217933_b(p_215294_1_);
    }

    public void func_184402_a(ISoundEventListener p_184402_1_) {
        this.field_147694_f.func_188774_a(p_184402_1_);
    }

    public void func_184400_b(ISoundEventListener p_184400_1_) {
        this.field_147694_f.func_188773_b(p_184400_1_);
    }

    public void func_195478_a(@Nullable ResourceLocation p_195478_1_, @Nullable SoundCategory p_195478_2_) {
        this.field_147694_f.func_195855_a(p_195478_1_, p_195478_2_);
    }

    public IResourceType getResourceType() {
        return VanillaResourceType.SOUNDS;
    }

    public String func_215293_f() {
        return this.field_147694_f.func_217932_f();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Loader {
        private final Map<ResourceLocation, SoundEventAccessor> field_217948_a = Maps.newHashMap();

        protected Loader() {
        }

        private void func_217944_a(ResourceLocation p_217944_1_, SoundList p_217944_2_, IResourceManager p_217944_3_) {
            boolean flag;
            SoundEventAccessor soundeventaccessor = this.field_217948_a.get(p_217944_1_);
            boolean bl = flag = soundeventaccessor == null;
            if (flag || p_217944_2_.func_148574_b()) {
                if (!flag) {
                    field_147698_b.debug("Replaced sound event location {}", (Object)p_217944_1_);
                }
                soundeventaccessor = new SoundEventAccessor(p_217944_1_, p_217944_2_.func_188701_c());
                this.field_217948_a.put(p_217944_1_, soundeventaccessor);
            }
            block4: for (final Sound sound : p_217944_2_.func_188700_a()) {
                Object isoundeventaccessor;
                final ResourceLocation resourcelocation = sound.func_188719_a();
                switch (sound.func_188722_g()) {
                    case FILE: {
                        if (!SoundHandler.func_215292_b(sound, p_217944_1_, p_217944_3_)) continue block4;
                        isoundeventaccessor = sound;
                        break;
                    }
                    case SOUND_EVENT: {
                        isoundeventaccessor = new ISoundEventAccessor<Sound>(){

                            public int func_148721_a() {
                                SoundEventAccessor soundeventaccessor1 = (SoundEventAccessor)field_217948_a.get(resourcelocation);
                                return soundeventaccessor1 == null ? 0 : soundeventaccessor1.func_148721_a();
                            }

                            public Sound func_148720_g() {
                                SoundEventAccessor soundeventaccessor1 = (SoundEventAccessor)field_217948_a.get(resourcelocation);
                                if (soundeventaccessor1 == null) {
                                    return field_147700_a;
                                }
                                Sound sound1 = soundeventaccessor1.func_148720_g();
                                return new Sound(sound1.func_188719_a().toString(), sound1.func_188724_c() * sound.func_188724_c(), sound1.func_188725_d() * sound.func_188725_d(), sound.func_148721_a(), Sound.Type.FILE, sound1.func_188723_h() || sound.func_188723_h(), sound1.func_204257_i(), sound1.func_206255_j());
                            }

                            public void func_217867_a(SoundEngine p_217867_1_) {
                                SoundEventAccessor soundeventaccessor1 = (SoundEventAccessor)field_217948_a.get(resourcelocation);
                                if (soundeventaccessor1 != null) {
                                    soundeventaccessor1.func_217867_a(p_217867_1_);
                                }
                            }
                        };
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown SoundEventRegistration type: " + sound.func_188722_g());
                    }
                }
                soundeventaccessor.func_188715_a((ISoundEventAccessor)isoundeventaccessor);
            }
        }

        public void func_217946_a(Map<ResourceLocation, SoundEventAccessor> p_217946_1_, SoundEngine p_217946_2_) {
            p_217946_1_.clear();
            for (Map.Entry<ResourceLocation, SoundEventAccessor> entry : this.field_217948_a.entrySet()) {
                p_217946_1_.put(entry.getKey(), entry.getValue());
                entry.getValue().func_217867_a(p_217946_2_);
            }
        }
    }
}

