/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MapItemRenderer
implements AutoCloseable {
    private static final ResourceLocation field_148253_a = new ResourceLocation("textures/map/map_icons.png");
    private static final RenderType field_228085_d_ = RenderType.func_228658_l_(field_148253_a);
    private final TextureManager field_148251_b;
    private final Map<String, Instance> field_148252_c = Maps.newHashMap();

    public MapItemRenderer(TextureManager p_i45009_1_) {
        this.field_148251_b = p_i45009_1_;
    }

    public void func_148246_a(MapData p_148246_1_) {
        this.func_148248_b(p_148246_1_).func_148236_a();
    }

    public void func_228086_a_(MatrixStack p_228086_1_, IRenderTypeBuffer p_228086_2_, MapData p_228086_3_, boolean p_228086_4_, int p_228086_5_) {
        this.func_148248_b(p_228086_3_).func_228089_a_(p_228086_1_, p_228086_2_, p_228086_4_, p_228086_5_);
    }

    private Instance func_148248_b(MapData p_148248_1_) {
        Instance mapitemrenderer$instance = this.field_148252_c.get(p_148248_1_.func_195925_e());
        if (mapitemrenderer$instance == null) {
            mapitemrenderer$instance = new Instance(p_148248_1_);
            this.field_148252_c.put(p_148248_1_.func_195925_e(), mapitemrenderer$instance);
        }
        return mapitemrenderer$instance;
    }

    @Nullable
    public Instance func_191205_a(String p_191205_1_) {
        return this.field_148252_c.get(p_191205_1_);
    }

    public void func_148249_a() {
        for (Instance mapitemrenderer$instance : this.field_148252_c.values()) {
            mapitemrenderer$instance.close();
        }
        this.field_148252_c.clear();
    }

    @Nullable
    public MapData func_191207_a(@Nullable Instance p_191207_1_) {
        return p_191207_1_ != null ? p_191207_1_.field_148242_b : null;
    }

    @Override
    public void close() {
        this.func_148249_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    class Instance
    implements AutoCloseable {
        private final MapData field_148242_b;
        private final DynamicTexture field_148243_c;
        private final RenderType field_228088_d_;

        private Instance(MapData p_i45007_2_) {
            this.field_148242_b = p_i45007_2_;
            this.field_148243_c = new DynamicTexture(128, 128, true);
            ResourceLocation resourcelocation = MapItemRenderer.this.field_148251_b.func_110578_a("map/" + p_i45007_2_.func_195925_e(), this.field_148243_c);
            this.field_228088_d_ = RenderType.func_228658_l_(resourcelocation);
        }

        private void func_148236_a() {
            for (int i = 0; i < 128; ++i) {
                for (int j = 0; j < 128; ++j) {
                    int k = j + i * 128;
                    int l = this.field_148242_b.field_76198_e[k] & 0xFF;
                    if (l / 4 == 0) {
                        this.field_148243_c.func_195414_e().func_195700_a(j, i, 0);
                        continue;
                    }
                    this.field_148243_c.func_195414_e().func_195700_a(j, i, MaterialColor.field_76281_a[l / 4].func_151643_b(l & 3));
                }
            }
            this.field_148243_c.func_110564_a();
        }

        private void func_228089_a_(MatrixStack p_228089_1_, IRenderTypeBuffer p_228089_2_, boolean p_228089_3_, int p_228089_4_) {
            boolean i = false;
            boolean j = false;
            float f = 0.0f;
            Matrix4f matrix4f = p_228089_1_.func_227866_c_().func_227870_a_();
            IVertexBuilder ivertexbuilder = p_228089_2_.getBuffer(this.field_228088_d_);
            ivertexbuilder.func_227888_a_(matrix4f, 0.0f, 128.0f, -0.01f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_227886_a_(p_228089_4_).func_181675_d();
            ivertexbuilder.func_227888_a_(matrix4f, 128.0f, 128.0f, -0.01f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_227886_a_(p_228089_4_).func_181675_d();
            ivertexbuilder.func_227888_a_(matrix4f, 128.0f, 0.0f, -0.01f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_227886_a_(p_228089_4_).func_181675_d();
            ivertexbuilder.func_227888_a_(matrix4f, 0.0f, 0.0f, -0.01f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_227886_a_(p_228089_4_).func_181675_d();
            int k = 0;
            for (MapDecoration mapdecoration : this.field_148242_b.field_76203_h.values()) {
                if (p_228089_3_ && !mapdecoration.func_191180_f()) continue;
                if (mapdecoration.render(k)) {
                    ++k;
                    continue;
                }
                p_228089_1_.func_227860_a_();
                p_228089_1_.func_227861_a_((double)(0.0f + (float)mapdecoration.func_176112_b() / 2.0f + 64.0f), (double)(0.0f + (float)mapdecoration.func_176113_c() / 2.0f + 64.0f), (double)-0.02f);
                p_228089_1_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(mapdecoration.func_176111_d() * 360) / 16.0f));
                p_228089_1_.func_227862_a_(4.0f, 4.0f, 3.0f);
                p_228089_1_.func_227861_a_(-0.125, 0.125, 0.0);
                byte b0 = mapdecoration.func_176110_a();
                float f1 = (float)(b0 % 16 + 0) / 16.0f;
                float f2 = (float)(b0 / 16 + 0) / 16.0f;
                float f3 = (float)(b0 % 16 + 1) / 16.0f;
                float f4 = (float)(b0 / 16 + 1) / 16.0f;
                Matrix4f matrix4f1 = p_228089_1_.func_227866_c_().func_227870_a_();
                float f5 = -0.001f;
                IVertexBuilder ivertexbuilder1 = p_228089_2_.getBuffer(field_228085_d_);
                ivertexbuilder1.func_227888_a_(matrix4f1, -1.0f, 1.0f, (float)k * -0.001f).func_225586_a_(255, 255, 255, 255).func_225583_a_(f1, f2).func_227886_a_(p_228089_4_).func_181675_d();
                ivertexbuilder1.func_227888_a_(matrix4f1, 1.0f, 1.0f, (float)k * -0.001f).func_225586_a_(255, 255, 255, 255).func_225583_a_(f3, f2).func_227886_a_(p_228089_4_).func_181675_d();
                ivertexbuilder1.func_227888_a_(matrix4f1, 1.0f, -1.0f, (float)k * -0.001f).func_225586_a_(255, 255, 255, 255).func_225583_a_(f3, f4).func_227886_a_(p_228089_4_).func_181675_d();
                ivertexbuilder1.func_227888_a_(matrix4f1, -1.0f, -1.0f, (float)k * -0.001f).func_225586_a_(255, 255, 255, 255).func_225583_a_(f1, f4).func_227886_a_(p_228089_4_).func_181675_d();
                p_228089_1_.func_227865_b_();
                if (mapdecoration.func_204309_g() != null) {
                    FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
                    ITextComponent itextcomponent = mapdecoration.func_204309_g();
                    float f6 = fontrenderer.func_238414_a_((ITextProperties)itextcomponent);
                    float f7 = MathHelper.func_76131_a((float)(25.0f / f6), (float)0.0f, (float)0.6666667f);
                    p_228089_1_.func_227860_a_();
                    p_228089_1_.func_227861_a_((double)(0.0f + (float)mapdecoration.func_176112_b() / 2.0f + 64.0f - f6 * f7 / 2.0f), (double)(0.0f + (float)mapdecoration.func_176113_c() / 2.0f + 64.0f + 4.0f), (double)-0.025f);
                    p_228089_1_.func_227862_a_(f7, f7, 1.0f);
                    p_228089_1_.func_227861_a_(0.0, 0.0, (double)-0.1f);
                    fontrenderer.func_243247_a(itextcomponent, 0.0f, 0.0f, -1, false, p_228089_1_.func_227866_c_().func_227870_a_(), p_228089_2_, false, Integer.MIN_VALUE, p_228089_4_);
                    p_228089_1_.func_227865_b_();
                }
                ++k;
            }
        }

        @Override
        public void close() {
            this.field_148243_c.close();
        }
    }
}

