/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.network.LanServerInfo;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.ClientHooks;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ServerSelectionList
extends ExtendedList<Entry> {
    private static final Logger field_214357_a = LogManager.getLogger();
    private static final ThreadPoolExecutor field_214358_b = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_214357_a)).build());
    private static final ResourceLocation field_214359_c = new ResourceLocation("textures/misc/unknown_server.png");
    private static final ResourceLocation field_214360_d = new ResourceLocation("textures/gui/server_selection.png");
    private static final ITextComponent field_243365_r = new TranslationTextComponent("lanServer.scanning");
    private static final ITextComponent field_243366_s = new TranslationTextComponent("multiplayer.status.cannot_resolve").func_240699_a_(TextFormatting.DARK_RED);
    private static final ITextComponent field_243367_t = new TranslationTextComponent("multiplayer.status.cannot_connect").func_240699_a_(TextFormatting.DARK_RED);
    private static final ITextComponent field_244607_u = new TranslationTextComponent("multiplayer.status.incompatible");
    private static final ITextComponent field_243370_w = new TranslationTextComponent("multiplayer.status.no_connection");
    private static final ITextComponent field_243371_x = new TranslationTextComponent("multiplayer.status.pinging");
    private final MultiplayerScreen field_148200_k;
    private final List<NormalEntry> field_148198_l = Lists.newArrayList();
    private final Entry field_148196_n = new LanScanEntry();
    private final List<LanDetectedEntry> field_148199_m = Lists.newArrayList();

    public ServerSelectionList(MultiplayerScreen p_i45049_1_, Minecraft p_i45049_2_, int p_i45049_3_, int p_i45049_4_, int p_i45049_5_, int p_i45049_6_, int p_i45049_7_) {
        super(p_i45049_2_, p_i45049_3_, p_i45049_4_, p_i45049_5_, p_i45049_6_, p_i45049_7_);
        this.field_148200_k = p_i45049_1_;
    }

    private void func_195094_h() {
        this.func_230963_j_();
        this.field_148198_l.forEach(arg_0 -> this.func_230513_b_(arg_0));
        this.func_230513_b_((AbstractList.AbstractListEntry)((Object)this.field_148196_n));
        this.field_148199_m.forEach(arg_0 -> this.func_230513_b_(arg_0));
    }

    public void func_241215_a_(@Nullable Entry p_241215_1_) {
        super.func_241215_a_((AbstractList.AbstractListEntry)((Object)p_241215_1_));
        if (this.func_230958_g_() instanceof NormalEntry) {
            NarratorChatListener.field_193643_a.func_216864_a(new TranslationTextComponent("narrator.select", ((NormalEntry)((NormalEntry)((Object)this.func_230958_g_()))).field_148301_e.field_78847_a).getString());
        }
        this.field_148200_k.func_214295_b();
    }

    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        Entry serverselectionlist$entry = (Entry)((Object)this.func_230958_g_());
        return serverselectionlist$entry != null && serverselectionlist$entry.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_) || super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    protected void func_241219_a_(AbstractList.Ordering p_241219_1_) {
        this.func_241572_a_(p_241219_1_, p_241612_0_ -> !(p_241612_0_ instanceof LanScanEntry));
    }

    public void func_148195_a(ServerList p_148195_1_) {
        this.field_148198_l.clear();
        for (int i = 0; i < p_148195_1_.func_78856_c(); ++i) {
            this.field_148198_l.add(new NormalEntry(this.field_148200_k, p_148195_1_.func_78850_a(i)));
        }
        this.func_195094_h();
    }

    public void func_148194_a(List<LanServerInfo> p_148194_1_) {
        this.field_148199_m.clear();
        for (LanServerInfo lanserverinfo : p_148194_1_) {
            this.field_148199_m.add(new LanDetectedEntry(this.field_148200_k, lanserverinfo));
        }
        this.func_195094_h();
    }

    protected int func_230952_d_() {
        return super.func_230952_d_() + 30;
    }

    public int func_230949_c_() {
        return super.func_230949_c_() + 85;
    }

    protected boolean func_230971_aw__() {
        return this.field_148200_k.func_241217_q_() == this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class NormalEntry
    extends Entry {
        private final MultiplayerScreen field_148303_c;
        private final Minecraft field_148300_d;
        private final ServerData field_148301_e;
        private final ResourceLocation field_148306_i;
        private String field_148299_g;
        private DynamicTexture field_148305_h;
        private long field_148298_f;

        protected NormalEntry(MultiplayerScreen p_i50669_2_, ServerData p_i50669_3_) {
            this.field_148303_c = p_i50669_2_;
            this.field_148301_e = p_i50669_3_;
            this.field_148300_d = Minecraft.func_71410_x();
            this.field_148306_i = new ResourceLocation("servers/" + Hashing.sha1().hashUnencodedChars((CharSequence)p_i50669_3_.field_78845_b) + "/icon");
            this.field_148305_h = (DynamicTexture)this.field_148300_d.func_110434_K().func_229267_b_(this.field_148306_i);
        }

        public void func_230432_a_(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            List<ITextComponent> list1;
            Object itextcomponent;
            int l;
            if (!this.field_148301_e.field_78841_f) {
                this.field_148301_e.field_78841_f = true;
                this.field_148301_e.field_78844_e = -2L;
                this.field_148301_e.field_78843_d = StringTextComponent.field_240750_d_;
                this.field_148301_e.field_78846_c = StringTextComponent.field_240750_d_;
                field_214358_b.submit(() -> {
                    try {
                        this.field_148303_c.func_146789_i().func_147224_a(this.field_148301_e, () -> this.field_148300_d.execute(this::func_241613_a_));
                    }
                    catch (UnknownHostException unknownhostexception) {
                        this.field_148301_e.field_78844_e = -1L;
                        this.field_148301_e.field_78843_d = field_243366_s;
                    }
                    catch (Exception exception) {
                        this.field_148301_e.field_78844_e = -1L;
                        this.field_148301_e.field_78843_d = field_243367_t;
                    }
                });
            }
            boolean flag = this.field_148301_e.field_82821_f != SharedConstants.func_215069_a().getProtocolVersion();
            this.field_148300_d.field_71466_p.func_238421_b_(p_230432_1_, this.field_148301_e.field_78847_a, (float)(p_230432_4_ + 32 + 3), (float)(p_230432_3_ + 1), 0xFFFFFF);
            List list = this.field_148300_d.field_71466_p.func_238425_b_((ITextProperties)this.field_148301_e.field_78843_d, p_230432_5_ - 32 - 2);
            for (int i = 0; i < Math.min(list.size(), 2); ++i) {
                this.field_148300_d.field_71466_p.func_238422_b_(p_230432_1_, (IReorderingProcessor)list.get(i), (float)(p_230432_4_ + 32 + 3), (float)(p_230432_3_ + 12 + 9 * i), 0x808080);
            }
            ITextComponent itextcomponent1 = flag ? this.field_148301_e.field_82822_g.func_230532_e_().func_240699_a_(TextFormatting.RED) : this.field_148301_e.field_78846_c;
            int j = this.field_148300_d.field_71466_p.func_238414_a_((ITextProperties)itextcomponent1);
            this.field_148300_d.field_71466_p.func_243248_b(p_230432_1_, itextcomponent1, (float)(p_230432_4_ + p_230432_5_ - j - 15 - 2), (float)(p_230432_3_ + 1), 0x808080);
            int k = 0;
            if (flag) {
                l = 5;
                itextcomponent = field_244607_u;
                list1 = this.field_148301_e.field_147412_i;
            } else if (this.field_148301_e.field_78841_f && this.field_148301_e.field_78844_e != -2L) {
                l = this.field_148301_e.field_78844_e < 0L ? 5 : (this.field_148301_e.field_78844_e < 150L ? 0 : (this.field_148301_e.field_78844_e < 300L ? 1 : (this.field_148301_e.field_78844_e < 600L ? 2 : (this.field_148301_e.field_78844_e < 1000L ? 3 : 4))));
                if (this.field_148301_e.field_78844_e < 0L) {
                    itextcomponent = field_243370_w;
                    list1 = Collections.emptyList();
                } else {
                    itextcomponent = new TranslationTextComponent("multiplayer.status.ping", this.field_148301_e.field_78844_e);
                    list1 = this.field_148301_e.field_147412_i;
                }
            } else {
                k = 1;
                l = (int)(Util.func_211177_b() / 100L + (long)(p_230432_2_ * 2) & 7L);
                if (l > 4) {
                    l = 8 - l;
                }
                itextcomponent = field_243371_x;
                list1 = Collections.emptyList();
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_148300_d.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
            AbstractGui.func_238463_a_((MatrixStack)p_230432_1_, (int)(p_230432_4_ + p_230432_5_ - 15), (int)p_230432_3_, (float)(k * 10), (float)(176 + l * 8), (int)10, (int)8, (int)256, (int)256);
            String s = this.field_148301_e.func_147409_e();
            if (!Objects.equals(s, this.field_148299_g)) {
                if (this.func_241614_a_(s)) {
                    this.field_148299_g = s;
                } else {
                    this.field_148301_e.func_147407_a(null);
                    this.func_241613_a_();
                }
            }
            if (this.field_148305_h != null) {
                this.func_238859_a_(p_230432_1_, p_230432_4_, p_230432_3_, this.field_148306_i);
            } else {
                this.func_238859_a_(p_230432_1_, p_230432_4_, p_230432_3_, field_214359_c);
            }
            int i1 = p_230432_7_ - p_230432_4_;
            int j1 = p_230432_8_ - p_230432_3_;
            if (i1 >= p_230432_5_ - 15 && i1 <= p_230432_5_ - 5 && j1 >= 0 && j1 <= 8) {
                this.field_148303_c.func_238854_b_(Collections.singletonList(itextcomponent));
            } else if (i1 >= p_230432_5_ - j - 15 - 2 && i1 <= p_230432_5_ - 15 - 2 && j1 >= 0 && j1 <= 8) {
                this.field_148303_c.func_238854_b_(list1);
            }
            ClientHooks.drawForgePingInfo((MultiplayerScreen)this.field_148303_c, (ServerData)this.field_148301_e, (MatrixStack)p_230432_1_, (int)p_230432_4_, (int)p_230432_3_, (int)p_230432_5_, (int)i1, (int)j1);
            if (this.field_148300_d.field_71474_y.field_85185_A || p_230432_9_) {
                this.field_148300_d.func_110434_K().func_110577_a(field_214360_d);
                AbstractGui.func_238467_a_((MatrixStack)p_230432_1_, (int)p_230432_4_, (int)p_230432_3_, (int)(p_230432_4_ + 32), (int)(p_230432_3_ + 32), (int)-1601138544);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int k1 = p_230432_7_ - p_230432_4_;
                int l1 = p_230432_8_ - p_230432_3_;
                if (this.func_178013_b()) {
                    if (k1 < 32 && k1 > 16) {
                        AbstractGui.func_238463_a_((MatrixStack)p_230432_1_, (int)p_230432_4_, (int)p_230432_3_, (float)0.0f, (float)32.0f, (int)32, (int)32, (int)256, (int)256);
                    } else {
                        AbstractGui.func_238463_a_((MatrixStack)p_230432_1_, (int)p_230432_4_, (int)p_230432_3_, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
                    }
                }
                if (p_230432_2_ > 0) {
                    if (k1 < 16 && l1 < 16) {
                        AbstractGui.func_238463_a_((MatrixStack)p_230432_1_, (int)p_230432_4_, (int)p_230432_3_, (float)96.0f, (float)32.0f, (int)32, (int)32, (int)256, (int)256);
                    } else {
                        AbstractGui.func_238463_a_((MatrixStack)p_230432_1_, (int)p_230432_4_, (int)p_230432_3_, (float)96.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
                    }
                }
                if (p_230432_2_ < this.field_148303_c.func_146795_p().func_78856_c() - 1) {
                    if (k1 < 16 && l1 > 16) {
                        AbstractGui.func_238463_a_((MatrixStack)p_230432_1_, (int)p_230432_4_, (int)p_230432_3_, (float)64.0f, (float)32.0f, (int)32, (int)32, (int)256, (int)256);
                    } else {
                        AbstractGui.func_238463_a_((MatrixStack)p_230432_1_, (int)p_230432_4_, (int)p_230432_3_, (float)64.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
                    }
                }
            }
        }

        public void func_241613_a_() {
            this.field_148303_c.func_146795_p().func_78855_b();
        }

        protected void func_238859_a_(MatrixStack p_238859_1_, int p_238859_2_, int p_238859_3_, ResourceLocation p_238859_4_) {
            this.field_148300_d.func_110434_K().func_110577_a(p_238859_4_);
            RenderSystem.enableBlend();
            AbstractGui.func_238463_a_((MatrixStack)p_238859_1_, (int)p_238859_2_, (int)p_238859_3_, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            RenderSystem.disableBlend();
        }

        private boolean func_178013_b() {
            return true;
        }

        private boolean func_241614_a_(@Nullable String p_241614_1_) {
            if (p_241614_1_ == null) {
                this.field_148300_d.func_110434_K().func_147645_c(this.field_148306_i);
                if (this.field_148305_h != null && this.field_148305_h.func_195414_e() != null) {
                    this.field_148305_h.func_195414_e().close();
                }
                this.field_148305_h = null;
            } else {
                try {
                    NativeImage nativeimage = NativeImage.func_216511_b(p_241614_1_);
                    Validate.validState((nativeimage.func_195702_a() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                    Validate.validState((nativeimage.func_195714_b() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                    if (this.field_148305_h == null) {
                        this.field_148305_h = new DynamicTexture(nativeimage);
                    } else {
                        this.field_148305_h.func_195415_a(nativeimage);
                        this.field_148305_h.func_110564_a();
                    }
                    this.field_148300_d.func_110434_K().func_229263_a_(this.field_148306_i, (Texture)this.field_148305_h);
                }
                catch (Throwable throwable) {
                    field_214357_a.error("Invalid icon for server {} ({})", (Object)this.field_148301_e.field_78847_a, (Object)this.field_148301_e.field_78845_b, (Object)throwable);
                    return false;
                }
            }
            return true;
        }

        public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
            if (Screen.func_231173_s_()) {
                ServerSelectionList serverselectionlist = this.field_148303_c.field_146803_h;
                int i = serverselectionlist.func_231039_at__().indexOf((Object)this);
                if (p_231046_1_ == 264 && i < this.field_148303_c.func_146795_p().func_78856_c() - 1 || p_231046_1_ == 265 && i > 0) {
                    this.func_228196_a_(i, p_231046_1_ == 264 ? i + 1 : i - 1);
                    return true;
                }
            }
            return super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
        }

        private void func_228196_a_(int p_228196_1_, int p_228196_2_) {
            this.field_148303_c.func_146795_p().func_78857_a(p_228196_1_, p_228196_2_);
            this.field_148303_c.field_146803_h.func_148195_a(this.field_148303_c.func_146795_p());
            Entry serverselectionlist$entry = (Entry)((Object)this.field_148303_c.field_146803_h.func_231039_at__().get(p_228196_2_));
            this.field_148303_c.field_146803_h.func_241215_a_(serverselectionlist$entry);
            ServerSelectionList.this.func_230954_d_((AbstractList.AbstractListEntry)((Object)serverselectionlist$entry));
        }

        public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
            double d0 = p_231044_1_ - (double)ServerSelectionList.this.func_230968_n_();
            double d1 = p_231044_3_ - (double)ServerSelectionList.this.func_230962_i_(ServerSelectionList.this.func_231039_at__().indexOf((Object)this));
            if (d0 <= 32.0) {
                if (d0 < 32.0 && d0 > 16.0 && this.func_178013_b()) {
                    this.field_148303_c.func_214287_a(this);
                    this.field_148303_c.func_146796_h();
                    return true;
                }
                int i = this.field_148303_c.field_146803_h.func_231039_at__().indexOf((Object)this);
                if (d0 < 16.0 && d1 < 16.0 && i > 0) {
                    this.func_228196_a_(i, i - 1);
                    return true;
                }
                if (d0 < 16.0 && d1 > 16.0 && i < this.field_148303_c.func_146795_p().func_78856_c() - 1) {
                    this.func_228196_a_(i, i + 1);
                    return true;
                }
            }
            this.field_148303_c.func_214287_a(this);
            if (Util.func_211177_b() - this.field_148298_f < 250L) {
                this.field_148303_c.func_146796_h();
            }
            this.field_148298_f = Util.func_211177_b();
            return false;
        }

        public ServerData func_148296_a() {
            return this.field_148301_e;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LanScanEntry
    extends Entry {
        private final Minecraft field_148288_a = Minecraft.func_71410_x();

        public void func_230432_a_(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            String s;
            int i = p_230432_3_ + p_230432_6_ / 2 - 4;
            this.field_148288_a.field_71466_p.func_243248_b(p_230432_1_, field_243365_r, (float)(this.field_148288_a.field_71462_r.field_230708_k_ / 2 - this.field_148288_a.field_71466_p.func_238414_a_((ITextProperties)field_243365_r) / 2), (float)i, 0xFFFFFF);
            switch ((int)(Util.func_211177_b() / 300L % 4L)) {
                default: {
                    s = "O o o";
                    break;
                }
                case 1: 
                case 3: {
                    s = "o O o";
                    break;
                }
                case 2: {
                    s = "o o O";
                }
            }
            this.field_148288_a.field_71466_p.func_238421_b_(p_230432_1_, s, (float)(this.field_148288_a.field_71462_r.field_230708_k_ / 2 - this.field_148288_a.field_71466_p.func_78256_a(s) / 2), (float)(i + 9), 0x808080);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LanDetectedEntry
    extends Entry {
        private static final ITextComponent field_243386_c = new TranslationTextComponent("lanServer.title");
        private static final ITextComponent field_243387_d = new TranslationTextComponent("selectServer.hiddenAddress");
        private final MultiplayerScreen field_148292_c;
        protected final Minecraft field_148293_a;
        protected final LanServerInfo field_148291_b;
        private long field_148290_d;

        protected LanDetectedEntry(MultiplayerScreen p_i47141_1_, LanServerInfo p_i47141_2_) {
            this.field_148292_c = p_i47141_1_;
            this.field_148291_b = p_i47141_2_;
            this.field_148293_a = Minecraft.func_71410_x();
        }

        public void func_230432_a_(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            this.field_148293_a.field_71466_p.func_243248_b(p_230432_1_, field_243386_c, (float)(p_230432_4_ + 32 + 3), (float)(p_230432_3_ + 1), 0xFFFFFF);
            this.field_148293_a.field_71466_p.func_238421_b_(p_230432_1_, this.field_148291_b.func_77487_a(), (float)(p_230432_4_ + 32 + 3), (float)(p_230432_3_ + 12), 0x808080);
            if (this.field_148293_a.field_71474_y.field_80005_w) {
                this.field_148293_a.field_71466_p.func_243248_b(p_230432_1_, field_243387_d, (float)(p_230432_4_ + 32 + 3), (float)(p_230432_3_ + 12 + 11), 0x303030);
            } else {
                this.field_148293_a.field_71466_p.func_238421_b_(p_230432_1_, this.field_148291_b.func_77488_b(), (float)(p_230432_4_ + 32 + 3), (float)(p_230432_3_ + 12 + 11), 0x303030);
            }
        }

        public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
            this.field_148292_c.func_214287_a(this);
            if (Util.func_211177_b() - this.field_148290_d < 250L) {
                this.field_148292_c.func_146796_h();
            }
            this.field_148290_d = Util.func_211177_b();
            return false;
        }

        public LanServerInfo func_189995_a() {
            return this.field_148291_b;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ExtendedList.AbstractListEntry<Entry> {
    }
}

