/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.LightType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public abstract class EntityRenderer<T extends Entity> {
    protected final EntityRendererManager field_76990_c;
    protected float field_76989_e;
    protected float field_76987_f = 1.0f;

    protected EntityRenderer(EntityRendererManager p_i46179_1_) {
        this.field_76990_c = p_i46179_1_;
    }

    public final int func_229100_c_(T p_229100_1_, float p_229100_2_) {
        BlockPos blockpos = new BlockPos(((Entity)p_229100_1_).func_241842_k(p_229100_2_));
        return LightTexture.func_228451_a_(this.func_225624_a_(p_229100_1_, blockpos), this.func_239381_b_(p_229100_1_, blockpos));
    }

    protected int func_239381_b_(T p_239381_1_, BlockPos p_239381_2_) {
        return ((Entity)p_239381_1_).field_70170_p.func_226658_a_(LightType.SKY, p_239381_2_);
    }

    protected int func_225624_a_(T p_225624_1_, BlockPos p_225624_2_) {
        return ((Entity)p_225624_1_).func_70027_ad() ? 15 : ((Entity)p_225624_1_).field_70170_p.func_226658_a_(LightType.BLOCK, p_225624_2_);
    }

    public boolean func_225626_a_(T p_225626_1_, ClippingHelper p_225626_2_, double p_225626_3_, double p_225626_5_, double p_225626_7_) {
        if (!((Entity)p_225626_1_).func_145770_h(p_225626_3_, p_225626_5_, p_225626_7_)) {
            return false;
        }
        if (((Entity)p_225626_1_).field_70158_ak) {
            return true;
        }
        AxisAlignedBB axisalignedbb = ((Entity)p_225626_1_).func_184177_bl().func_186662_g(0.5);
        if (axisalignedbb.func_181656_b() || axisalignedbb.func_72320_b() == 0.0) {
            axisalignedbb = new AxisAlignedBB(((Entity)p_225626_1_).func_226277_ct_() - 2.0, ((Entity)p_225626_1_).func_226278_cu_() - 2.0, ((Entity)p_225626_1_).func_226281_cx_() - 2.0, ((Entity)p_225626_1_).func_226277_ct_() + 2.0, ((Entity)p_225626_1_).func_226278_cu_() + 2.0, ((Entity)p_225626_1_).func_226281_cx_() + 2.0);
        }
        return p_225626_2_.func_228957_a_(axisalignedbb);
    }

    public Vector3d func_225627_b_(T p_225627_1_, float p_225627_2_) {
        return Vector3d.field_186680_a;
    }

    public void func_225623_a_(T p_225623_1_, float p_225623_2_, float p_225623_3_, MatrixStack p_225623_4_, IRenderTypeBuffer p_225623_5_, int p_225623_6_) {
        RenderNameplateEvent renderNameplateEvent = new RenderNameplateEvent(p_225623_1_, ((Entity)p_225623_1_).func_145748_c_(), this, p_225623_4_, p_225623_5_, p_225623_6_, p_225623_3_);
        MinecraftForge.EVENT_BUS.post((Event)renderNameplateEvent);
        if (renderNameplateEvent.getResult() != Event.Result.DENY && (renderNameplateEvent.getResult() == Event.Result.ALLOW || this.func_177070_b(p_225623_1_))) {
            this.func_225629_a_(p_225623_1_, renderNameplateEvent.getContent(), p_225623_4_, p_225623_5_, p_225623_6_);
        }
    }

    protected boolean func_177070_b(T p_177070_1_) {
        return ((Entity)p_177070_1_).func_94059_bO() && ((Entity)p_177070_1_).func_145818_k_();
    }

    public abstract ResourceLocation func_110775_a(T var1);

    public FontRenderer func_76983_a() {
        return this.field_76990_c.func_78716_a();
    }

    protected void func_225629_a_(T p_225629_1_, ITextComponent p_225629_2_, MatrixStack p_225629_3_, IRenderTypeBuffer p_225629_4_, int p_225629_5_) {
        double d0 = this.field_76990_c.func_229099_b_((Entity)p_225629_1_);
        if (ForgeHooksClient.isNameplateInRenderDistance(p_225629_1_, (double)d0)) {
            boolean flag = !((Entity)p_225629_1_).func_226273_bm_();
            float f = ((Entity)p_225629_1_).func_213302_cg() + 0.5f;
            int i = "deadmau5".equals(p_225629_2_.getString()) ? -10 : 0;
            p_225629_3_.func_227860_a_();
            p_225629_3_.func_227861_a_(0.0, (double)f, 0.0);
            p_225629_3_.func_227863_a_(this.field_76990_c.func_229098_b_());
            p_225629_3_.func_227862_a_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = p_225629_3_.func_227866_c_().func_227870_a_();
            float f1 = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
            int j = (int)(f1 * 255.0f) << 24;
            FontRenderer fontrenderer = this.func_76983_a();
            float f2 = -fontrenderer.func_238414_a_((ITextProperties)p_225629_2_) / 2;
            fontrenderer.func_243247_a(p_225629_2_, f2, (float)i, 0x20FFFFFF, false, matrix4f, p_225629_4_, flag, j, p_225629_5_);
            if (flag) {
                fontrenderer.func_243247_a(p_225629_2_, f2, (float)i, -1, false, matrix4f, p_225629_4_, false, 0, p_225629_5_);
            }
            p_225629_3_.func_227865_b_();
        }
    }

    public EntityRendererManager func_177068_d() {
        return this.field_76990_c;
    }
}

