/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public abstract class LivingRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements IEntityRenderer<T, M> {
    private static final Logger field_147923_a = LogManager.getLogger();
    protected M field_77045_g;
    protected final List<LayerRenderer<T, M>> field_177097_h = Lists.newArrayList();

    public LivingRenderer(EntityRendererManager p_i50965_1_, M p_i50965_2_, float p_i50965_3_) {
        super(p_i50965_1_);
        this.field_77045_g = p_i50965_2_;
        this.field_76989_e = p_i50965_3_;
    }

    public final boolean func_177094_a(LayerRenderer<T, M> p_177094_1_) {
        return this.field_177097_h.add(p_177094_1_);
    }

    public M func_217764_d() {
        return this.field_77045_g;
    }

    @Override
    public void func_225623_a_(T p_225623_1_, float p_225623_2_, float p_225623_3_, MatrixStack p_225623_4_, IRenderTypeBuffer p_225623_5_, int p_225623_6_) {
        Direction direction;
        boolean shouldSit;
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre(p_225623_1_, this, p_225623_3_, p_225623_4_, p_225623_5_, p_225623_6_))) {
            return;
        }
        p_225623_4_.func_227860_a_();
        ((EntityModel)this.field_77045_g).field_217112_c = this.func_77040_d(p_225623_1_, p_225623_3_);
        ((EntityModel)this.field_77045_g).field_217113_d = shouldSit = ((Entity)p_225623_1_).func_184218_aH() && ((Entity)p_225623_1_).func_184187_bx() != null && ((Entity)p_225623_1_).func_184187_bx().shouldRiderSit();
        ((EntityModel)this.field_77045_g).field_217114_e = ((LivingEntity)p_225623_1_).func_70631_g_();
        float f = MathHelper.func_219805_h((float)p_225623_3_, (float)((LivingEntity)p_225623_1_).field_70760_ar, (float)((LivingEntity)p_225623_1_).field_70761_aq);
        float f1 = MathHelper.func_219805_h((float)p_225623_3_, (float)((LivingEntity)p_225623_1_).field_70758_at, (float)((LivingEntity)p_225623_1_).field_70759_as);
        float f2 = f1 - f;
        if (shouldSit && ((Entity)p_225623_1_).func_184187_bx() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)((Entity)p_225623_1_).func_184187_bx();
            f = MathHelper.func_219805_h((float)p_225623_3_, (float)livingentity.field_70760_ar, (float)livingentity.field_70761_aq);
            f2 = f1 - f;
            float f3 = MathHelper.func_76142_g((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = MathHelper.func_219799_g((float)p_225623_3_, (float)((LivingEntity)p_225623_1_).field_70127_C, (float)((LivingEntity)p_225623_1_).field_70125_A);
        if (((Entity)p_225623_1_).func_213283_Z() == Pose.SLEEPING && (direction = ((LivingEntity)p_225623_1_).func_213376_dz()) != null) {
            float f4 = ((Entity)p_225623_1_).func_213307_e(Pose.STANDING) - 0.1f;
            p_225623_4_.func_227861_a_((double)((float)(-direction.func_82601_c()) * f4), 0.0, (double)((float)(-direction.func_82599_e()) * f4));
        }
        float f7 = this.func_77044_a(p_225623_1_, p_225623_3_);
        this.func_225621_a_(p_225623_1_, p_225623_4_, f7, f, p_225623_3_);
        p_225623_4_.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.func_225620_a_(p_225623_1_, p_225623_4_, p_225623_3_);
        p_225623_4_.func_227861_a_(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && ((LivingEntity)p_225623_1_).func_70089_S()) {
            f8 = MathHelper.func_219799_g((float)p_225623_3_, (float)((LivingEntity)p_225623_1_).field_184618_aE, (float)((LivingEntity)p_225623_1_).field_70721_aZ);
            f5 = ((LivingEntity)p_225623_1_).field_184619_aG - ((LivingEntity)p_225623_1_).field_70721_aZ * (1.0f - p_225623_3_);
            if (((LivingEntity)p_225623_1_).func_70631_g_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        this.field_77045_g.func_212843_a_(p_225623_1_, f5, f8, p_225623_3_);
        this.field_77045_g.func_225597_a_(p_225623_1_, f5, f8, f7, f2, f6);
        Minecraft minecraft = Minecraft.func_71410_x();
        boolean flag = this.func_225622_a_(p_225623_1_);
        boolean flag1 = !flag && !((Entity)p_225623_1_).func_98034_c(minecraft.field_71439_g);
        boolean flag2 = minecraft.func_238206_b_((Entity)p_225623_1_);
        RenderType rendertype = this.func_230496_a_(p_225623_1_, flag, flag1, flag2);
        if (rendertype != null) {
            IVertexBuilder ivertexbuilder = p_225623_5_.getBuffer(rendertype);
            int i = LivingRenderer.func_229117_c_(p_225623_1_, this.func_225625_b_(p_225623_1_, p_225623_3_));
            this.field_77045_g.func_225598_a_(p_225623_4_, ivertexbuilder, p_225623_6_, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        if (!((Entity)p_225623_1_).func_175149_v()) {
            for (LayerRenderer<T, M> layerrenderer : this.field_177097_h) {
                layerrenderer.func_225628_a_(p_225623_4_, p_225623_5_, p_225623_6_, p_225623_1_, f5, f8, p_225623_3_, f7, f2, f6);
            }
        }
        p_225623_4_.func_227865_b_();
        super.func_225623_a_(p_225623_1_, p_225623_2_, p_225623_3_, p_225623_4_, p_225623_5_, p_225623_6_);
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post(p_225623_1_, this, p_225623_3_, p_225623_4_, p_225623_5_, p_225623_6_));
    }

    @Nullable
    protected RenderType func_230496_a_(T p_230496_1_, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        ResourceLocation resourcelocation = this.func_110775_a(p_230496_1_);
        if (p_230496_3_) {
            return RenderType.func_239268_f_(resourcelocation);
        }
        if (p_230496_2_) {
            return this.field_77045_g.func_228282_a_(resourcelocation);
        }
        return p_230496_4_ ? RenderType.func_228654_j_(resourcelocation) : null;
    }

    public static int func_229117_c_(LivingEntity p_229117_0_, float p_229117_1_) {
        return OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)p_229117_1_), (int)OverlayTexture.func_229202_a_((p_229117_0_.field_70737_aN > 0 || p_229117_0_.field_70725_aQ > 0 ? 1 : 0) != 0));
    }

    protected boolean func_225622_a_(T p_225622_1_) {
        return !((Entity)p_225622_1_).func_82150_aj();
    }

    private static float func_217765_a(Direction p_217765_0_) {
        switch (p_217765_0_) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected boolean func_230495_a_(T p_230495_1_) {
        return false;
    }

    protected void func_225621_a_(T p_225621_1_, MatrixStack p_225621_2_, float p_225621_3_, float p_225621_4_, float p_225621_5_) {
        String s;
        Pose pose;
        if (this.func_230495_a_(p_225621_1_)) {
            p_225621_4_ += (float)(Math.cos((double)((LivingEntity)p_225621_1_).field_70173_aa * 3.25) * Math.PI * (double)0.4f);
        }
        if ((pose = ((Entity)p_225621_1_).func_213283_Z()) != Pose.SLEEPING) {
            p_225621_2_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - p_225621_4_));
        }
        if (((LivingEntity)p_225621_1_).field_70725_aQ > 0) {
            float f = ((float)((LivingEntity)p_225621_1_).field_70725_aQ + p_225621_5_ - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            p_225621_2_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f * this.func_77037_a(p_225621_1_)));
        } else if (((LivingEntity)p_225621_1_).func_204805_cN()) {
            p_225621_2_.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f - ((LivingEntity)p_225621_1_).field_70125_A));
            p_225621_2_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)((LivingEntity)p_225621_1_).field_70173_aa + p_225621_5_) * -75.0f));
        } else if (pose == Pose.SLEEPING) {
            Direction direction = ((LivingEntity)p_225621_1_).func_213376_dz();
            float f1 = direction != null ? LivingRenderer.func_217765_a(direction) : p_225621_4_;
            p_225621_2_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f1));
            p_225621_2_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(this.func_77037_a(p_225621_1_)));
            p_225621_2_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
        } else if ((((Entity)p_225621_1_).func_145818_k_() || p_225621_1_ instanceof PlayerEntity) && ("Dinnerbone".equals(s = TextFormatting.func_110646_a(((Entity)p_225621_1_).func_200200_C_().getString())) || "Grumm".equals(s)) && (!(p_225621_1_ instanceof PlayerEntity) || ((PlayerEntity)p_225621_1_).func_175148_a(PlayerModelPart.CAPE))) {
            p_225621_2_.func_227861_a_(0.0, (double)(((Entity)p_225621_1_).func_213302_cg() + 0.1f), 0.0);
            p_225621_2_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        }
    }

    protected float func_77040_d(T p_77040_1_, float p_77040_2_) {
        return ((LivingEntity)p_77040_1_).func_70678_g(p_77040_2_);
    }

    protected float func_77044_a(T p_77044_1_, float p_77044_2_) {
        return (float)((LivingEntity)p_77044_1_).field_70173_aa + p_77044_2_;
    }

    protected float func_77037_a(T p_77037_1_) {
        return 90.0f;
    }

    protected float func_225625_b_(T p_225625_1_, float p_225625_2_) {
        return 0.0f;
    }

    protected void func_225620_a_(T p_225620_1_, MatrixStack p_225620_2_, float p_225620_3_) {
    }

    @Override
    protected boolean func_177070_b(T p_177070_1_) {
        boolean flag;
        float f;
        double d0 = this.field_76990_c.func_229099_b_((Entity)p_177070_1_);
        float f2 = f = ((Entity)p_177070_1_).func_226273_bm_() ? 32.0f : 64.0f;
        if (d0 >= (double)(f * f)) {
            return false;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity clientplayerentity = minecraft.field_71439_g;
        boolean bl = flag = !((Entity)p_177070_1_).func_98034_c(clientplayerentity);
        if (p_177070_1_ != clientplayerentity) {
            Team team = ((Entity)p_177070_1_).func_96124_cp();
            Team team1 = clientplayerentity.func_96124_cp();
            if (team != null) {
                Team.Visible team$visible = team.func_178770_i();
                switch (team$visible) {
                    case ALWAYS: {
                        return flag;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return team1 == null ? flag : team.func_142054_a(team1) && (team.func_98297_h() || flag);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return team1 == null ? flag : !team.func_142054_a(team1) && flag;
                    }
                }
                return true;
            }
        }
        return Minecraft.func_71382_s() && p_177070_1_ != minecraft.func_175606_aa() && flag && !((Entity)p_177070_1_).func_184207_aI();
    }
}

