/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BuiltInModel;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.BlockModelConfiguration;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BlockModel
implements IUnbakedModel {
    private static final Logger field_178313_f = LogManager.getLogger();
    private static final FaceBakery field_217647_g = new FaceBakery();
    @VisibleForTesting
    static final Gson field_178319_a = new GsonBuilder().registerTypeAdapter(BlockModel.class, (Object)new Deserializer()).registerTypeAdapter(BlockPart.class, (Object)new BlockPart.Deserializer()).registerTypeAdapter(BlockPartFace.class, (Object)new BlockPartFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(ItemTransformVec3f.class, (Object)new ItemTransformVec3f.Deserializer()).registerTypeAdapter(ItemCameraTransforms.class, (Object)new ItemCameraTransforms.Deserializer()).registerTypeAdapter(ItemOverride.class, (Object)new ItemOverride.Deserializer()).create();
    private final List<BlockPart> field_178314_g;
    @Nullable
    private final GuiLight field_230174_i_;
    public final boolean field_178322_i;
    private final ItemCameraTransforms field_178320_j;
    private final List<ItemOverride> field_187968_k;
    public String field_178317_b = "";
    @VisibleForTesting
    public final Map<String, Either<RenderMaterial, String>> field_178318_c;
    @Nullable
    public BlockModel field_178315_d;
    @Nullable
    protected ResourceLocation field_178316_e;
    public final BlockModelConfiguration customData = new BlockModelConfiguration(this);

    public static BlockModel func_178307_a(Reader p_178307_0_) {
        return (BlockModel)JSONUtils.func_193839_a((Gson)ModelLoaderRegistry.ExpandedBlockModelDeserializer.INSTANCE, (Reader)p_178307_0_, BlockModel.class);
    }

    public static BlockModel func_178294_a(String p_178294_0_) {
        return BlockModel.func_178307_a(new StringReader(p_178294_0_));
    }

    public BlockModel(@Nullable ResourceLocation p_i230056_1_, List<BlockPart> p_i230056_2_, Map<String, Either<RenderMaterial, String>> p_i230056_3_, boolean p_i230056_4_, @Nullable GuiLight p_i230056_5_, ItemCameraTransforms p_i230056_6_, List<ItemOverride> p_i230056_7_) {
        this.field_178314_g = p_i230056_2_;
        this.field_178322_i = p_i230056_4_;
        this.field_230174_i_ = p_i230056_5_;
        this.field_178318_c = p_i230056_3_;
        this.field_178316_e = p_i230056_1_;
        this.field_178320_j = p_i230056_6_;
        this.field_187968_k = p_i230056_7_;
    }

    @Deprecated
    public List<BlockPart> func_178298_a() {
        if (this.customData.hasCustomGeometry()) {
            return Collections.emptyList();
        }
        return this.field_178314_g.isEmpty() && this.field_178315_d != null ? this.field_178315_d.func_178298_a() : this.field_178314_g;
    }

    @Nullable
    public ResourceLocation getParentLocation() {
        return this.field_178316_e;
    }

    public boolean func_178309_b() {
        return this.field_178315_d != null ? this.field_178315_d.func_178309_b() : this.field_178322_i;
    }

    public GuiLight func_230176_c_() {
        if (this.field_230174_i_ != null) {
            return this.field_230174_i_;
        }
        return this.field_178315_d != null ? this.field_178315_d.func_230176_c_() : GuiLight.SIDE;
    }

    public List<ItemOverride> func_187966_f() {
        return this.field_187968_k;
    }

    private ItemOverrideList func_217646_a(ModelBakery p_217646_1_, BlockModel p_217646_2_) {
        return this.field_187968_k.isEmpty() ? ItemOverrideList.field_188022_a : new ItemOverrideList(p_217646_1_, p_217646_2_, p_217646_1_::func_209597_a, this.field_187968_k);
    }

    public ItemOverrideList getOverrides(ModelBakery p_217646_1_, BlockModel p_217646_2_, Function<RenderMaterial, TextureAtlasSprite> textureGetter) {
        return this.field_187968_k.isEmpty() ? ItemOverrideList.field_188022_a : new ItemOverrideList(p_217646_1_, p_217646_2_, p_217646_1_::func_209597_a, textureGetter, this.field_187968_k);
    }

    @Override
    public Collection<ResourceLocation> func_187965_e() {
        HashSet set = Sets.newHashSet();
        for (ItemOverride itemoverride : this.field_187968_k) {
            set.add(itemoverride.func_188026_a());
        }
        if (this.field_178316_e != null) {
            set.add(this.field_178316_e);
        }
        return set;
    }

    @Override
    public Collection<RenderMaterial> func_225614_a_(Function<ResourceLocation, IUnbakedModel> p_225614_1_, Set<Pair<String, String>> p_225614_2_) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        BlockModel blockmodel = this;
        while (blockmodel.field_178316_e != null && blockmodel.field_178315_d == null) {
            set.add(blockmodel);
            IUnbakedModel iunbakedmodel = p_225614_1_.apply(blockmodel.field_178316_e);
            if (iunbakedmodel == null) {
                field_178313_f.warn("No parent '{}' while loading model '{}'", (Object)this.field_178316_e, (Object)blockmodel);
            }
            if (set.contains(iunbakedmodel)) {
                field_178313_f.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", (Object)blockmodel, (Object)set.stream().map(Object::toString).collect(Collectors.joining(" -> ")), (Object)this.field_178316_e);
                iunbakedmodel = null;
            }
            if (iunbakedmodel == null) {
                blockmodel.field_178316_e = ModelBakery.field_177604_a;
                iunbakedmodel = p_225614_1_.apply(blockmodel.field_178316_e);
            }
            if (!(iunbakedmodel instanceof BlockModel)) {
                throw new IllegalStateException("BlockModel parent has to be a block model.");
            }
            blockmodel = blockmodel.field_178315_d = (BlockModel)iunbakedmodel;
        }
        HashSet set1 = Sets.newHashSet((Object[])new RenderMaterial[]{this.func_228816_c_("particle")});
        if (this.customData.hasCustomGeometry()) {
            set1.addAll(this.customData.getTextureDependencies(p_225614_1_, p_225614_2_));
        } else {
            for (BlockPart blockpart : this.func_178298_a()) {
                for (BlockPartFace blockpartface : blockpart.field_178240_c.values()) {
                    RenderMaterial rendermaterial = this.func_228816_c_(blockpartface.field_178242_d);
                    if (Objects.equals(rendermaterial.func_229313_b_(), MissingTextureSprite.func_195675_b())) {
                        p_225614_2_.add((Pair<String, String>)Pair.of((Object)blockpartface.field_178242_d, (Object)this.field_178317_b));
                    }
                    set1.add(rendermaterial);
                }
            }
        }
        this.field_187968_k.forEach(p_228815_4_ -> {
            IUnbakedModel iunbakedmodel1 = (IUnbakedModel)p_225614_1_.apply(p_228815_4_.func_188026_a());
            if (!Objects.equals(iunbakedmodel1, this)) {
                set1.addAll(iunbakedmodel1.func_225614_a_(p_225614_1_, p_225614_2_));
            }
        });
        if (this.func_178310_f() == ModelBakery.field_177606_o) {
            ItemModelGenerator.field_178398_a.forEach(p_228814_2_ -> set1.add(this.func_228816_c_((String)p_228814_2_)));
        }
        return set1;
    }

    @Override
    @Deprecated
    public IBakedModel func_225613_a_(ModelBakery p_225613_1_, Function<RenderMaterial, TextureAtlasSprite> p_225613_2_, IModelTransform p_225613_3_, ResourceLocation p_225613_4_) {
        return this.func_228813_a_(p_225613_1_, this, p_225613_2_, p_225613_3_, p_225613_4_, true);
    }

    public IBakedModel func_228813_a_(ModelBakery p_228813_1_, BlockModel p_228813_2_, Function<RenderMaterial, TextureAtlasSprite> p_228813_3_, IModelTransform p_228813_4_, ResourceLocation p_228813_5_, boolean p_228813_6_) {
        return ModelLoaderRegistry.bakeHelper((BlockModel)this, (ModelBakery)p_228813_1_, (BlockModel)p_228813_2_, p_228813_3_, (IModelTransform)p_228813_4_, (ResourceLocation)p_228813_5_, (boolean)p_228813_6_);
    }

    @Deprecated
    public IBakedModel bakeVanilla(ModelBakery p_228813_1_, BlockModel p_228813_2_, Function<RenderMaterial, TextureAtlasSprite> p_228813_3_, IModelTransform p_228813_4_, ResourceLocation p_228813_5_, boolean p_228813_6_) {
        TextureAtlasSprite textureatlassprite = p_228813_3_.apply(this.func_228816_c_("particle"));
        if (this.func_178310_f() == ModelBakery.field_177616_r) {
            return new BuiltInModel(this.func_181682_g(), this.func_217646_a(p_228813_1_, p_228813_2_), textureatlassprite, this.func_230176_c_().func_230178_a_());
        }
        SimpleBakedModel.Builder simplebakedmodel$builder = new SimpleBakedModel.Builder(this, this.func_217646_a(p_228813_1_, p_228813_2_), p_228813_6_).func_177646_a(textureatlassprite);
        for (BlockPart blockpart : this.func_178298_a()) {
            for (Direction direction : blockpart.field_178240_c.keySet()) {
                BlockPartFace blockpartface = (BlockPartFace)blockpart.field_178240_c.get((Object)direction);
                TextureAtlasSprite textureatlassprite1 = p_228813_3_.apply(this.func_228816_c_(blockpartface.field_178242_d));
                if (blockpartface.field_178244_b == null) {
                    simplebakedmodel$builder.func_177648_a(BlockModel.func_228812_a_(blockpart, blockpartface, textureatlassprite1, direction, p_228813_4_, p_228813_5_));
                    continue;
                }
                simplebakedmodel$builder.func_177650_a(Direction.func_229385_a_(p_228813_4_.func_225615_b_().func_227988_c_(), blockpartface.field_178244_b), BlockModel.func_228812_a_(blockpart, blockpartface, textureatlassprite1, direction, p_228813_4_, p_228813_5_));
            }
        }
        return simplebakedmodel$builder.func_177645_b();
    }

    private static BakedQuad func_228812_a_(BlockPart p_228812_0_, BlockPartFace p_228812_1_, TextureAtlasSprite p_228812_2_, Direction p_228812_3_, IModelTransform p_228812_4_, ResourceLocation p_228812_5_) {
        return field_217647_g.func_228824_a_(p_228812_0_.field_178241_a, p_228812_0_.field_178239_b, p_228812_1_, p_228812_2_, p_228812_3_, p_228812_4_, p_228812_0_.field_178237_d, p_228812_0_.field_178238_e, p_228812_5_);
    }

    public static BakedQuad makeBakedQuad(BlockPart p_228812_0_, BlockPartFace p_228812_1_, TextureAtlasSprite p_228812_2_, Direction p_228812_3_, IModelTransform p_228812_4_, ResourceLocation p_228812_5_) {
        return BlockModel.func_228812_a_(p_228812_0_, p_228812_1_, p_228812_2_, p_228812_3_, p_228812_4_, p_228812_5_);
    }

    public boolean func_178300_b(String p_178300_1_) {
        return !MissingTextureSprite.func_195675_b().equals(this.func_228816_c_(p_178300_1_).func_229313_b_());
    }

    public RenderMaterial func_228816_c_(String p_228816_1_) {
        if (BlockModel.func_178304_d(p_228816_1_)) {
            p_228816_1_ = p_228816_1_.substring(1);
        }
        ArrayList list = Lists.newArrayList();
        Either<RenderMaterial, String> either;
        Optional optional;
        while (!(optional = (either = this.func_228818_e_(p_228816_1_)).left()).isPresent()) {
            p_228816_1_ = (String)either.right().get();
            if (list.contains(p_228816_1_)) {
                field_178313_f.warn("Unable to resolve texture due to reference chain {}->{} in {}", (Object)Joiner.on((String)"->").join((Iterable)list), (Object)p_228816_1_, (Object)this.field_178317_b);
                return new RenderMaterial(AtlasTexture.field_110575_b, MissingTextureSprite.func_195675_b());
            }
            list.add(p_228816_1_);
        }
        return (RenderMaterial)optional.get();
    }

    private Either<RenderMaterial, String> func_228818_e_(String p_228818_1_) {
        BlockModel blockmodel = this;
        while (blockmodel != null) {
            Either<RenderMaterial, String> either = blockmodel.field_178318_c.get(p_228818_1_);
            if (either != null) {
                return either;
            }
            blockmodel = blockmodel.field_178315_d;
        }
        return Either.left((Object)new RenderMaterial(AtlasTexture.field_110575_b, MissingTextureSprite.func_195675_b()));
    }

    private static boolean func_178304_d(String p_178304_0_) {
        return p_178304_0_.charAt(0) == '#';
    }

    public BlockModel func_178310_f() {
        return this.field_178315_d == null ? this : this.field_178315_d.func_178310_f();
    }

    public ItemCameraTransforms func_181682_g() {
        ItemTransformVec3f itemtransformvec3f = this.func_181681_a(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND);
        ItemTransformVec3f itemtransformvec3f1 = this.func_181681_a(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        ItemTransformVec3f itemtransformvec3f2 = this.func_181681_a(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND);
        ItemTransformVec3f itemtransformvec3f3 = this.func_181681_a(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
        ItemTransformVec3f itemtransformvec3f4 = this.func_181681_a(ItemCameraTransforms.TransformType.HEAD);
        ItemTransformVec3f itemtransformvec3f5 = this.func_181681_a(ItemCameraTransforms.TransformType.GUI);
        ItemTransformVec3f itemtransformvec3f6 = this.func_181681_a(ItemCameraTransforms.TransformType.GROUND);
        ItemTransformVec3f itemtransformvec3f7 = this.func_181681_a(ItemCameraTransforms.TransformType.FIXED);
        return new ItemCameraTransforms(itemtransformvec3f, itemtransformvec3f1, itemtransformvec3f2, itemtransformvec3f3, itemtransformvec3f4, itemtransformvec3f5, itemtransformvec3f6, itemtransformvec3f7);
    }

    private ItemTransformVec3f func_181681_a(ItemCameraTransforms.TransformType p_181681_1_) {
        return this.field_178315_d != null && !this.field_178320_j.func_181687_c(p_181681_1_) ? this.field_178315_d.func_181681_a(p_181681_1_) : this.field_178320_j.func_181688_b(p_181681_1_);
    }

    public String toString() {
        return this.field_178317_b;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum GuiLight {
        FRONT("front"),
        SIDE("side");

        private final String field_230177_c_;

        private GuiLight(String p_i230057_3_) {
            this.field_230177_c_ = p_i230057_3_;
        }

        public static GuiLight func_230179_a_(String p_230179_0_) {
            for (GuiLight blockmodel$guilight : GuiLight.values()) {
                if (!blockmodel$guilight.field_230177_c_.equals(p_230179_0_)) continue;
                return blockmodel$guilight;
            }
            throw new IllegalArgumentException("Invalid gui light: " + p_230179_0_);
        }

        public boolean func_230178_a_() {
            return this == SIDE;
        }

        public String getSerializedName() {
            return this.field_230177_c_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<BlockModel> {
        public BlockModel deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = p_deserialize_1_.getAsJsonObject();
            List<BlockPart> list = this.func_178325_a(p_deserialize_3_, jsonobject);
            String s = this.func_178326_c(jsonobject);
            Map<String, Either<RenderMaterial, String>> map = this.func_178329_b(jsonobject);
            boolean flag = this.func_178328_a(jsonobject);
            ItemCameraTransforms itemcameratransforms = ItemCameraTransforms.field_178357_a;
            if (jsonobject.has("display")) {
                JsonObject jsonobject1 = JSONUtils.func_152754_s((JsonObject)jsonobject, (String)"display");
                itemcameratransforms = (ItemCameraTransforms)p_deserialize_3_.deserialize((JsonElement)jsonobject1, ItemCameraTransforms.class);
            }
            List<ItemOverride> list1 = this.func_187964_a(p_deserialize_3_, jsonobject);
            GuiLight blockmodel$guilight = null;
            if (jsonobject.has("gui_light")) {
                blockmodel$guilight = GuiLight.func_230179_a_(JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"gui_light"));
            }
            ResourceLocation resourcelocation = s.isEmpty() ? null : new ResourceLocation(s);
            return new BlockModel(resourcelocation, list, map, flag, blockmodel$guilight, itemcameratransforms, list1);
        }

        protected List<ItemOverride> func_187964_a(JsonDeserializationContext p_187964_1_, JsonObject p_187964_2_) {
            ArrayList list = Lists.newArrayList();
            if (p_187964_2_.has("overrides")) {
                for (JsonElement jsonelement : JSONUtils.func_151214_t((JsonObject)p_187964_2_, (String)"overrides")) {
                    list.add((ItemOverride)p_187964_1_.deserialize(jsonelement, ItemOverride.class));
                }
            }
            return list;
        }

        private Map<String, Either<RenderMaterial, String>> func_178329_b(JsonObject p_178329_1_) {
            ResourceLocation resourcelocation = AtlasTexture.field_110575_b;
            HashMap map = Maps.newHashMap();
            if (p_178329_1_.has("textures")) {
                JsonObject jsonobject = JSONUtils.func_152754_s((JsonObject)p_178329_1_, (String)"textures");
                for (Map.Entry entry : jsonobject.entrySet()) {
                    map.put((String)entry.getKey(), Deserializer.func_228819_a_(resourcelocation, ((JsonElement)entry.getValue()).getAsString()));
                }
            }
            return map;
        }

        private static Either<RenderMaterial, String> func_228819_a_(ResourceLocation p_228819_0_, String p_228819_1_) {
            if (BlockModel.func_178304_d(p_228819_1_)) {
                return Either.right((Object)p_228819_1_.substring(1));
            }
            ResourceLocation resourcelocation = ResourceLocation.func_208304_a(p_228819_1_);
            if (resourcelocation == null) {
                throw new JsonParseException(p_228819_1_ + " is not valid resource location");
            }
            return Either.left((Object)new RenderMaterial(p_228819_0_, resourcelocation));
        }

        private String func_178326_c(JsonObject p_178326_1_) {
            return JSONUtils.func_151219_a((JsonObject)p_178326_1_, (String)"parent", (String)"");
        }

        protected boolean func_178328_a(JsonObject p_178328_1_) {
            return JSONUtils.func_151209_a((JsonObject)p_178328_1_, (String)"ambientocclusion", (boolean)true);
        }

        protected List<BlockPart> func_178325_a(JsonDeserializationContext p_178325_1_, JsonObject p_178325_2_) {
            ArrayList list = Lists.newArrayList();
            if (p_178325_2_.has("elements")) {
                for (JsonElement jsonelement : JSONUtils.func_151214_t((JsonObject)p_178325_2_, (String)"elements")) {
                    list.add((BlockPart)p_178325_1_.deserialize(jsonelement, BlockPart.class));
                }
            }
            return list;
        }
    }
}

