/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ResultConsumer;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BinaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_16_R3.command.VanillaCommandWrapper;
import org.spigotmc.SpigotConfig;

public class CommandSource
implements ISuggestionProvider {
    public static final SimpleCommandExceptionType field_197039_a = new SimpleCommandExceptionType((Message)new TranslationTextComponent("permissions.requires.player"));
    public static final SimpleCommandExceptionType field_197040_b = new SimpleCommandExceptionType((Message)new TranslationTextComponent("permissions.requires.entity"));
    public final ICommandSource field_197041_c;
    private final Vector3d field_197042_d;
    private final ServerWorld field_197043_e;
    private final int field_197044_f;
    private final String field_197045_g;
    private final ITextComponent field_197046_h;
    private final MinecraftServer field_197047_i;
    private final boolean field_197048_j;
    @Nullable
    private final Entity field_197049_k;
    private final ResultConsumer<CommandSource> field_197050_l;
    private final EntityAnchorArgument.Type field_201011_m;
    private final Vector2f field_201012_n;
    public volatile CommandNode currentCommand;

    public CommandSource(ICommandSource p_i49552_1_, Vector3d p_i49552_2_, Vector2f p_i49552_3_, ServerWorld p_i49552_4_, int p_i49552_5_, String p_i49552_6_, ITextComponent p_i49552_7_, MinecraftServer p_i49552_8_, @Nullable Entity p_i49552_9_) {
        this(p_i49552_1_, p_i49552_2_, p_i49552_3_, p_i49552_4_, p_i49552_5_, p_i49552_6_, p_i49552_7_, p_i49552_8_, p_i49552_9_, false, (ResultConsumer<CommandSource>)((ResultConsumer)(p_197032_0_, p_197032_1_, p_197032_2_) -> {}), EntityAnchorArgument.Type.FEET);
    }

    protected CommandSource(ICommandSource p_i49553_1_, Vector3d p_i49553_2_, Vector2f p_i49553_3_, ServerWorld p_i49553_4_, int p_i49553_5_, String p_i49553_6_, ITextComponent p_i49553_7_, MinecraftServer p_i49553_8_, @Nullable Entity p_i49553_9_, boolean p_i49553_10_, ResultConsumer<CommandSource> p_i49553_11_, EntityAnchorArgument.Type p_i49553_12_) {
        this.field_197041_c = p_i49553_1_;
        this.field_197042_d = p_i49553_2_;
        this.field_197043_e = p_i49553_4_;
        this.field_197048_j = p_i49553_10_;
        this.field_197049_k = p_i49553_9_;
        this.field_197044_f = p_i49553_5_;
        this.field_197045_g = p_i49553_6_;
        this.field_197046_h = p_i49553_7_;
        this.field_197047_i = p_i49553_8_;
        this.field_197050_l = p_i49553_11_;
        this.field_201011_m = p_i49553_12_;
        this.field_201012_n = p_i49553_3_;
    }

    public CommandSource func_197024_a(Entity p_197024_1_) {
        return this.field_197049_k == p_197024_1_ ? this : new CommandSource(this.field_197041_c, this.field_197042_d, this.field_201012_n, this.field_197043_e, this.field_197044_f, p_197024_1_.func_200200_C_().getString(), p_197024_1_.func_145748_c_(), this.field_197047_i, p_197024_1_, this.field_197048_j, this.field_197050_l, this.field_201011_m);
    }

    public CommandSource func_201009_a(Vector3d p_201009_1_) {
        return this.field_197042_d.equals(p_201009_1_) ? this : new CommandSource(this.field_197041_c, p_201009_1_, this.field_201012_n, this.field_197043_e, this.field_197044_f, this.field_197045_g, this.field_197046_h, this.field_197047_i, this.field_197049_k, this.field_197048_j, this.field_197050_l, this.field_201011_m);
    }

    public CommandSource func_201007_a(Vector2f p_201007_1_) {
        return this.field_201012_n.func_201069_c(p_201007_1_) ? this : new CommandSource(this.field_197041_c, this.field_197042_d, p_201007_1_, this.field_197043_e, this.field_197044_f, this.field_197045_g, this.field_197046_h, this.field_197047_i, this.field_197049_k, this.field_197048_j, this.field_197050_l, this.field_201011_m);
    }

    public CommandSource func_197029_a(ResultConsumer<CommandSource> p_197029_1_) {
        return this.field_197050_l.equals(p_197029_1_) ? this : new CommandSource(this.field_197041_c, this.field_197042_d, this.field_201012_n, this.field_197043_e, this.field_197044_f, this.field_197045_g, this.field_197046_h, this.field_197047_i, this.field_197049_k, this.field_197048_j, p_197029_1_, this.field_201011_m);
    }

    public CommandSource func_209550_a(ResultConsumer<CommandSource> p_209550_1_, BinaryOperator<ResultConsumer<CommandSource>> p_209550_2_) {
        ResultConsumer resultconsumer = (ResultConsumer)p_209550_2_.apply(this.field_197050_l, p_209550_1_);
        return this.func_197029_a((ResultConsumer<CommandSource>)resultconsumer);
    }

    public CommandSource func_197031_a() {
        return this.field_197048_j ? this : new CommandSource(this.field_197041_c, this.field_197042_d, this.field_201012_n, this.field_197043_e, this.field_197044_f, this.field_197045_g, this.field_197046_h, this.field_197047_i, this.field_197049_k, true, this.field_197050_l, this.field_201011_m);
    }

    public CommandSource func_197033_a(int p_197033_1_) {
        return p_197033_1_ == this.field_197044_f ? this : new CommandSource(this.field_197041_c, this.field_197042_d, this.field_201012_n, this.field_197043_e, p_197033_1_, this.field_197045_g, this.field_197046_h, this.field_197047_i, this.field_197049_k, this.field_197048_j, this.field_197050_l, this.field_201011_m);
    }

    public CommandSource func_197026_b(int p_197026_1_) {
        return p_197026_1_ <= this.field_197044_f ? this : new CommandSource(this.field_197041_c, this.field_197042_d, this.field_201012_n, this.field_197043_e, p_197026_1_, this.field_197045_g, this.field_197046_h, this.field_197047_i, this.field_197049_k, this.field_197048_j, this.field_197050_l, this.field_201011_m);
    }

    public CommandSource func_201010_a(EntityAnchorArgument.Type p_201010_1_) {
        return p_201010_1_ == this.field_201011_m ? this : new CommandSource(this.field_197041_c, this.field_197042_d, this.field_201012_n, this.field_197043_e, this.field_197044_f, this.field_197045_g, this.field_197046_h, this.field_197047_i, this.field_197049_k, this.field_197048_j, this.field_197050_l, p_201010_1_);
    }

    public CommandSource func_201003_a(ServerWorld p_201003_1_) {
        if (p_201003_1_ == this.field_197043_e) {
            return this;
        }
        double d0 = DimensionType.func_242715_a((DimensionType)this.field_197043_e.func_230315_m_(), (DimensionType)p_201003_1_.func_230315_m_());
        Vector3d vector3d = new Vector3d(this.field_197042_d.field_72450_a * d0, this.field_197042_d.field_72448_b, this.field_197042_d.field_72449_c * d0);
        return new CommandSource(this.field_197041_c, vector3d, this.field_201012_n, p_201003_1_, this.field_197044_f, this.field_197045_g, this.field_197046_h, this.field_197047_i, this.field_197049_k, this.field_197048_j, this.field_197050_l, this.field_201011_m);
    }

    public CommandSource func_201006_a(Entity p_201006_1_, EntityAnchorArgument.Type p_201006_2_) throws CommandSyntaxException {
        return this.func_201005_b(p_201006_2_.func_201017_a(p_201006_1_));
    }

    public CommandSource func_201005_b(Vector3d p_201005_1_) throws CommandSyntaxException {
        Vector3d vector3d = this.field_201011_m.func_201015_a(this);
        double d0 = p_201005_1_.field_72450_a - vector3d.field_72450_a;
        double d1 = p_201005_1_.field_72448_b - vector3d.field_72448_b;
        double d2 = p_201005_1_.field_72449_c - vector3d.field_72449_c;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = MathHelper.func_76142_g((float)((float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875))));
        float f1 = MathHelper.func_76142_g((float)((float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
        return this.func_201007_a(new Vector2f(f, f1));
    }

    public ITextComponent func_197019_b() {
        return this.field_197046_h;
    }

    public String func_197037_c() {
        return this.field_197045_g;
    }

    public boolean func_197034_c(int p_197034_1_) {
        CommandNode currentCommand = this.currentCommand;
        if (currentCommand != null) {
            return this.hasPermission(p_197034_1_, VanillaCommandWrapper.getPermission((CommandNode)currentCommand));
        }
        return this.field_197044_f >= p_197034_1_;
    }

    public boolean hasPermission(int i, String bukkitPermission) {
        return (this.func_197023_e() == null || !this.func_197023_e().getCBServer().ignoreVanillaPermissions) && this.field_197044_f >= i || this.getBukkitSender().hasPermission(bukkitPermission);
    }

    public Vector3d func_197036_d() {
        return this.field_197042_d;
    }

    public ServerWorld func_197023_e() {
        return this.field_197043_e;
    }

    @Nullable
    public Entity func_197022_f() {
        return this.field_197049_k;
    }

    public Entity func_197027_g() throws CommandSyntaxException {
        if (this.field_197049_k == null) {
            throw field_197040_b.create();
        }
        return this.field_197049_k;
    }

    public ServerPlayerEntity func_197035_h() throws CommandSyntaxException {
        if (!(this.field_197049_k instanceof ServerPlayerEntity)) {
            throw field_197039_a.create();
        }
        return (ServerPlayerEntity)this.field_197049_k;
    }

    public Vector2f func_201004_i() {
        return this.field_201012_n;
    }

    public MinecraftServer func_197028_i() {
        return this.field_197047_i;
    }

    public EntityAnchorArgument.Type func_201008_k() {
        return this.field_201011_m;
    }

    public void func_197030_a(ITextComponent p_197030_1_, boolean p_197030_2_) {
        if (this.field_197041_c.func_195039_a() && !this.field_197048_j) {
            this.field_197041_c.func_145747_a(p_197030_1_, Util.field_240973_b_);
        }
        if (p_197030_2_ && this.field_197041_c.func_195041_r_() && !this.field_197048_j) {
            this.func_197020_b(p_197030_1_);
        }
    }

    private void func_197020_b(ITextComponent p_197020_1_) {
        IFormattableTextComponent itextcomponent = new TranslationTextComponent("chat.type.admin", this.func_197019_b(), p_197020_1_).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC});
        if (this.field_197047_i.func_200252_aR().func_223586_b(GameRules.field_223611_n)) {
            for (ServerPlayerEntity serverplayerentity : this.field_197047_i.func_184103_al().func_181057_v()) {
                if (serverplayerentity == this.field_197041_c || !this.field_197047_i.func_184103_al().func_152596_g(serverplayerentity.func_146103_bH())) continue;
                serverplayerentity.func_145747_a((ITextComponent)itextcomponent, Util.field_240973_b_);
            }
        }
        if (this.field_197041_c != this.field_197047_i && this.field_197047_i.func_200252_aR().func_223586_b(GameRules.field_223608_k) && !SpigotConfig.silentCommandBlocks) {
            this.field_197047_i.func_145747_a((ITextComponent)itextcomponent, Util.field_240973_b_);
        }
    }

    public void func_197021_a(ITextComponent p_197021_1_) {
        if (this.field_197041_c.func_195040_b() && !this.field_197048_j) {
            this.field_197041_c.func_145747_a((ITextComponent)new StringTextComponent("").func_230529_a_(p_197021_1_).func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
        }
    }

    public void func_197038_a(CommandContext<CommandSource> p_197038_1_, boolean p_197038_2_, int p_197038_3_) {
        if (this.field_197050_l != null) {
            this.field_197050_l.onCommandComplete(p_197038_1_, p_197038_2_, p_197038_3_);
        }
    }

    public Collection<String> func_197011_j() {
        return Lists.newArrayList((Object[])this.field_197047_i.func_71213_z());
    }

    public Collection<String> func_197012_k() {
        return this.field_197047_i.func_200251_aP().func_96531_f();
    }

    public Collection<ResourceLocation> func_197010_l() {
        return Registry.field_212633_v.func_148742_b();
    }

    public Stream<ResourceLocation> func_199612_m() {
        return this.field_197047_i.func_199529_aN().func_215378_c();
    }

    public CompletableFuture<Suggestions> func_197009_a(CommandContext<ISuggestionProvider> p_197009_1_, SuggestionsBuilder p_197009_2_) {
        return null;
    }

    public Set<RegistryKey<World>> func_230390_p_() {
        return this.field_197047_i.func_240770_D_();
    }

    public DynamicRegistries func_241861_q() {
        return this.field_197047_i.func_244267_aX();
    }

    public CommandSender getBukkitSender() {
        return this.field_197041_c.getBukkitSender(this);
    }
}

