/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.mohistmc.forge.ModsCommandDispatcher;
import com.mohistmc.util.i18n.i18n;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.command.impl.AdvancementCommand;
import net.minecraft.command.impl.AttributeCommand;
import net.minecraft.command.impl.BanCommand;
import net.minecraft.command.impl.BanIpCommand;
import net.minecraft.command.impl.BanListCommand;
import net.minecraft.command.impl.BossBarCommand;
import net.minecraft.command.impl.ClearCommand;
import net.minecraft.command.impl.CloneCommand;
import net.minecraft.command.impl.DataPackCommand;
import net.minecraft.command.impl.DeOpCommand;
import net.minecraft.command.impl.DebugCommand;
import net.minecraft.command.impl.DefaultGameModeCommand;
import net.minecraft.command.impl.DifficultyCommand;
import net.minecraft.command.impl.EffectCommand;
import net.minecraft.command.impl.EnchantCommand;
import net.minecraft.command.impl.ExecuteCommand;
import net.minecraft.command.impl.ExperienceCommand;
import net.minecraft.command.impl.FillCommand;
import net.minecraft.command.impl.ForceLoadCommand;
import net.minecraft.command.impl.FunctionCommand;
import net.minecraft.command.impl.GameModeCommand;
import net.minecraft.command.impl.GameRuleCommand;
import net.minecraft.command.impl.GiveCommand;
import net.minecraft.command.impl.HelpCommand;
import net.minecraft.command.impl.KickCommand;
import net.minecraft.command.impl.KillCommand;
import net.minecraft.command.impl.ListCommand;
import net.minecraft.command.impl.LocateBiomeCommand;
import net.minecraft.command.impl.LocateCommand;
import net.minecraft.command.impl.LootCommand;
import net.minecraft.command.impl.MeCommand;
import net.minecraft.command.impl.MessageCommand;
import net.minecraft.command.impl.OpCommand;
import net.minecraft.command.impl.PardonCommand;
import net.minecraft.command.impl.PardonIpCommand;
import net.minecraft.command.impl.ParticleCommand;
import net.minecraft.command.impl.PlaySoundCommand;
import net.minecraft.command.impl.PublishCommand;
import net.minecraft.command.impl.RecipeCommand;
import net.minecraft.command.impl.ReloadCommand;
import net.minecraft.command.impl.ReplaceItemCommand;
import net.minecraft.command.impl.SaveAllCommand;
import net.minecraft.command.impl.SaveOffCommand;
import net.minecraft.command.impl.SaveOnCommand;
import net.minecraft.command.impl.SayCommand;
import net.minecraft.command.impl.ScheduleCommand;
import net.minecraft.command.impl.ScoreboardCommand;
import net.minecraft.command.impl.SeedCommand;
import net.minecraft.command.impl.SetBlockCommand;
import net.minecraft.command.impl.SetIdleTimeoutCommand;
import net.minecraft.command.impl.SetWorldSpawnCommand;
import net.minecraft.command.impl.SpawnPointCommand;
import net.minecraft.command.impl.SpectateCommand;
import net.minecraft.command.impl.SpreadPlayersCommand;
import net.minecraft.command.impl.StopCommand;
import net.minecraft.command.impl.StopSoundCommand;
import net.minecraft.command.impl.SummonCommand;
import net.minecraft.command.impl.TagCommand;
import net.minecraft.command.impl.TeamCommand;
import net.minecraft.command.impl.TeamMsgCommand;
import net.minecraft.command.impl.TeleportCommand;
import net.minecraft.command.impl.TellRawCommand;
import net.minecraft.command.impl.TimeCommand;
import net.minecraft.command.impl.TitleCommand;
import net.minecraft.command.impl.TriggerCommand;
import net.minecraft.command.impl.WeatherCommand;
import net.minecraft.command.impl.WhitelistCommand;
import net.minecraft.command.impl.WorldBorderCommand;
import net.minecraft.command.impl.data.DataCommand;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SCommandListPacket;
import net.minecraft.test.TestCommand;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.spigotmc.SpigotConfig;

public class Commands {
    private static final Logger field_197061_a = LogManager.getLogger();
    private final CommandDispatcher<CommandSource> field_197062_b = new ModsCommandDispatcher(this);
    public String labell;
    private static final Field BRIGADIER_CHILDREN;
    private static final Field BRIGADIER_LITERALS;
    private static final Field BRIGADIER_ARGUMENTS;

    public Commands(EnvironmentType p_i232148_1_) {
        AdvancementCommand.func_198199_a(this.field_197062_b);
        AttributeCommand.func_241003_a_(this.field_197062_b);
        ExecuteCommand.func_198378_a(this.field_197062_b);
        BossBarCommand.func_201413_a(this.field_197062_b);
        ClearCommand.func_198243_a(this.field_197062_b);
        CloneCommand.func_198265_a(this.field_197062_b);
        DataCommand.func_198937_a(this.field_197062_b);
        DataPackCommand.func_198299_a(this.field_197062_b);
        DebugCommand.func_198330_a(this.field_197062_b);
        DefaultGameModeCommand.func_198340_a(this.field_197062_b);
        DifficultyCommand.func_198344_a(this.field_197062_b);
        EffectCommand.func_198353_a(this.field_197062_b);
        MeCommand.func_198364_a(this.field_197062_b);
        EnchantCommand.func_202649_a(this.field_197062_b);
        ExperienceCommand.func_198437_a(this.field_197062_b);
        FillCommand.func_198465_a(this.field_197062_b);
        ForceLoadCommand.func_212712_a(this.field_197062_b);
        FunctionCommand.func_198476_a(this.field_197062_b);
        GameModeCommand.func_198482_a(this.field_197062_b);
        GameRuleCommand.func_198487_a(this.field_197062_b);
        GiveCommand.func_198494_a(this.field_197062_b);
        HelpCommand.func_198510_a(this.field_197062_b);
        KickCommand.func_198514_a(this.field_197062_b);
        KillCommand.func_198518_a(this.field_197062_b);
        ListCommand.func_198522_a(this.field_197062_b);
        LocateCommand.func_198528_a(this.field_197062_b);
        LocateBiomeCommand.func_241046_a_(this.field_197062_b);
        LootCommand.func_218886_a(this.field_197062_b);
        MessageCommand.func_198537_a(this.field_197062_b);
        ParticleCommand.func_198563_a(this.field_197062_b);
        PlaySoundCommand.func_198572_a(this.field_197062_b);
        ReloadCommand.func_198597_a(this.field_197062_b);
        RecipeCommand.func_198589_a(this.field_197062_b);
        ReplaceItemCommand.func_198602_a(this.field_197062_b);
        SayCommand.func_198625_a(this.field_197062_b);
        ScheduleCommand.func_218909_a(this.field_197062_b);
        ScoreboardCommand.func_198647_a(this.field_197062_b);
        SeedCommand.func_241067_a_(this.field_197062_b, (p_i232148_1_ != EnvironmentType.INTEGRATED ? 1 : 0) != 0);
        SetBlockCommand.func_198684_a(this.field_197062_b);
        SpawnPointCommand.func_198695_a(this.field_197062_b);
        SetWorldSpawnCommand.func_198702_a(this.field_197062_b);
        SpectateCommand.func_229826_a_(this.field_197062_b);
        SpreadPlayersCommand.func_198716_a(this.field_197062_b);
        StopSoundCommand.func_198730_a(this.field_197062_b);
        SummonCommand.func_198736_a(this.field_197062_b);
        TagCommand.func_198743_a(this.field_197062_b);
        TeamCommand.func_198771_a(this.field_197062_b);
        TeamMsgCommand.func_218915_a(this.field_197062_b);
        TeleportCommand.func_198809_a(this.field_197062_b);
        TellRawCommand.func_198818_a(this.field_197062_b);
        TimeCommand.func_198823_a(this.field_197062_b);
        TitleCommand.func_198839_a(this.field_197062_b);
        TriggerCommand.func_198852_a(this.field_197062_b);
        WeatherCommand.func_198862_a(this.field_197062_b);
        WorldBorderCommand.func_198894_a(this.field_197062_b);
        if (SharedConstants.field_206244_b) {
            TestCommand.func_229613_a_(this.field_197062_b);
        }
        if (p_i232148_1_.field_237220_e_) {
            BanIpCommand.func_198220_a(this.field_197062_b);
            BanListCommand.func_198229_a(this.field_197062_b);
            BanCommand.func_198235_a(this.field_197062_b);
            DeOpCommand.func_198321_a(this.field_197062_b);
            OpCommand.func_198541_a(this.field_197062_b);
            PardonCommand.func_198547_a(this.field_197062_b);
            PardonIpCommand.func_198553_a(this.field_197062_b);
            SaveAllCommand.func_198611_a(this.field_197062_b);
            SaveOffCommand.func_198617_a(this.field_197062_b);
            SaveOnCommand.func_198621_a(this.field_197062_b);
            SetIdleTimeoutCommand.func_198690_a(this.field_197062_b);
            StopCommand.func_198725_a(this.field_197062_b);
            WhitelistCommand.func_198873_a(this.field_197062_b);
        }
        if (p_i232148_1_.field_237219_d_) {
            PublishCommand.func_198581_a(this.field_197062_b);
        }
        ForgeEventFactory.onCommandRegister(this.field_197062_b, (EnvironmentType)p_i232148_1_);
        this.field_197062_b.findAmbiguities((p_201302_1_, p_201302_2_, p_201302_3_, p_201302_4_) -> {});
        this.field_197062_b.setConsumer((p_197058_0_, p_197058_1_, p_197058_2_) -> ((CommandSource)p_197058_0_.getSource()).func_197038_a((CommandContext<CommandSource>)p_197058_0_, p_197058_1_, p_197058_2_));
    }

    public Commands() {
        this.field_197062_b.setConsumer((p_197058_0_, p_197058_1_, p_197058_2_) -> ((CommandSource)p_197058_0_.getSource()).func_197038_a((CommandContext<CommandSource>)p_197058_0_, p_197058_1_, p_197058_2_));
    }

    public int dispatchServerCommand(CommandSource sender, String command) {
        Joiner joiner = Joiner.on((String)" ");
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        ServerCommandEvent event = new ServerCommandEvent(sender.getBukkitSender(), command);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return 0;
        }
        command = event.getCommand();
        Object[] args = command.split(" ");
        String cmd = args[0];
        if (cmd.startsWith("minecraft:")) {
            cmd = cmd.substring("minecraft:".length());
        }
        if (cmd.startsWith("bukkit:")) {
            cmd = cmd.substring("bukkit:".length());
        }
        for (ModInfo modInfo : FMLLoader.getLoadingModList().getMods()) {
            if (!cmd.startsWith(modInfo.getModId() + ":")) continue;
            cmd = cmd.substring((modInfo.getModId() + ":").length());
        }
        if (cmd.equalsIgnoreCase("stop") || cmd.equalsIgnoreCase("kick") || cmd.equalsIgnoreCase("op") || cmd.equalsIgnoreCase("deop") || cmd.equalsIgnoreCase("ban") || cmd.equalsIgnoreCase("ban-ip") || cmd.equalsIgnoreCase("pardon") || cmd.equalsIgnoreCase("pardon-ip") || cmd.equalsIgnoreCase("reload")) {
            return 0;
        }
        if (sender.func_197023_e().getCBServer().getCommandBlockOverride(args[0])) {
            args[0] = "minecraft:" + args[0];
        }
        if (sender.func_197023_e().getCBServer().getCommandBlockOverride(args[0])) {
            for (ModInfo modInfo : FMLLoader.getLoadingModList().getMods()) {
                args[0] = modInfo.getModId() + ":" + (String)args[0];
            }
        }
        return this.func_197059_a(sender, joiner.join(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int func_197059_a(CommandSource p_197059_1_, String p_197059_2_) {
        int n;
        StringReader stringreader;
        if (this.labell == null) {
            this.labell = p_197059_2_;
        }
        if ((stringreader = new StringReader(p_197059_2_)).canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        p_197059_1_.func_197028_i().func_213185_aS().func_76320_a(p_197059_2_);
        try {
            ParseResults parse = this.field_197062_b.parse(stringreader, (Object)p_197059_1_);
            CommandEvent event = new CommandEvent(parse);
            if (MinecraftForge.EVENT_BUS.post((net.minecraftforge.eventbus.api.Event)event)) {
                if (event.getException() != null) {
                    Throwables.throwIfUnchecked((Throwable)event.getException());
                }
                int n2 = 1;
                return n2;
            }
            int n3 = this.field_197062_b.execute(event.getParseResults());
            return n3;
        }
        catch (CommandException commandexception) {
            p_197059_1_.func_197021_a(commandexception.func_197003_a());
            int event = 0;
            return event;
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            p_197059_1_.func_197021_a(TextComponentUtils.func_202465_a((Message)commandsyntaxexception.getRawMessage()));
            if (commandsyntaxexception.getInput() != null && commandsyntaxexception.getCursor() >= 0) {
                int j = Math.min(commandsyntaxexception.getInput().length(), commandsyntaxexception.getCursor());
                IFormattableTextComponent iformattabletextcomponent1 = new StringTextComponent("").func_240699_a_(TextFormatting.GRAY).func_240700_a_(p_211705_1_ -> p_211705_1_.func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, this.labell)));
                if (j > 10) {
                    iformattabletextcomponent1.func_240702_b_("...");
                }
                iformattabletextcomponent1.func_240702_b_(commandsyntaxexception.getInput().substring(Math.max(0, j - 10), j));
                if (j < commandsyntaxexception.getInput().length()) {
                    IFormattableTextComponent itextcomponent = new StringTextComponent(commandsyntaxexception.getInput().substring(j)).func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.UNDERLINE});
                    iformattabletextcomponent1.func_230529_a_((ITextComponent)itextcomponent);
                }
                iformattabletextcomponent1.func_230529_a_((ITextComponent)new TranslationTextComponent("command.context.here").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.ITALIC}));
                p_197059_1_.func_197021_a((ITextComponent)iformattabletextcomponent1);
            }
        }
        catch (Exception exception) {
            StringTextComponent iformattabletextcomponent = new StringTextComponent(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage());
            if (field_197061_a.isDebugEnabled()) {
                field_197061_a.error(i18n.get((String)"commands.1", (Object[])new Object[]{p_197059_2_, exception}));
                StackTraceElement[] astacktraceelement = exception.getStackTrace();
                for (int i = 0; i < Math.min(astacktraceelement.length, 3); ++i) {
                    iformattabletextcomponent.func_240702_b_("\n\n").func_240702_b_(astacktraceelement[i].getMethodName()).func_240702_b_("\n ").func_240702_b_(astacktraceelement[i].getFileName()).func_240702_b_(":").func_240702_b_(String.valueOf(astacktraceelement[i].getLineNumber()));
                }
            }
            p_197059_1_.func_197021_a((ITextComponent)new TranslationTextComponent("command.failed").func_240700_a_(arg_0 -> Commands.lambda$performCommand$4((IFormattableTextComponent)iformattabletextcomponent, arg_0)));
            if (SharedConstants.field_206244_b) {
                p_197059_1_.func_197021_a((ITextComponent)new StringTextComponent(Util.func_229758_d_(exception)));
                field_197061_a.error("'" + p_197059_2_ + "' threw an exception", (Throwable)exception);
            }
            int n4 = 0;
            return n4;
        }
        {
            n = 0;
        }
        return n;
        finally {
            p_197059_1_.func_197028_i().func_213185_aS().func_76319_b();
            this.labell = null;
        }
    }

    public int handleCommand(CommandSource source, String command, String l) {
        this.labell = l;
        return this.func_197059_a(source, command);
    }

    public void func_197051_a(ServerPlayerEntity p_197051_1_) {
        if (SpigotConfig.tabComplete < 0) {
            return;
        }
        IdentityHashMap map = Maps.newIdentityHashMap();
        RootCommandNode vanillaRoot = new RootCommandNode();
        RootCommandNode vanilla = p_197051_1_.field_71133_b.vanillaCommandDispatcher.func_197054_a().getRoot();
        map.put(vanilla, vanillaRoot);
        this.func_197052_a((CommandNode<CommandSource>)vanilla, (CommandNode<ISuggestionProvider>)vanillaRoot, p_197051_1_.func_195051_bN(), map);
        RootCommandNode rootcommandnode = new RootCommandNode();
        map.put(this.field_197062_b.getRoot(), rootcommandnode);
        this.func_197052_a((CommandNode<CommandSource>)this.field_197062_b.getRoot(), (CommandNode<ISuggestionProvider>)rootcommandnode, p_197051_1_.func_195051_bN(), map);
        LinkedHashSet<String> bukkit = new LinkedHashSet<String>();
        for (CommandNode node : rootcommandnode.getChildren()) {
            bukkit.add(node.getName());
        }
        PlayerCommandSendEvent event = new PlayerCommandSendEvent((Player)p_197051_1_.getBukkitEntity(), new LinkedHashSet(bukkit));
        event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
        for (String orig : bukkit) {
            if (event.getCommands().contains(orig)) continue;
            try {
                ((Map)BRIGADIER_CHILDREN.get(rootcommandnode)).remove(orig);
                ((Map)BRIGADIER_LITERALS.get(rootcommandnode)).remove(orig);
                ((Map)BRIGADIER_ARGUMENTS.get(rootcommandnode)).remove(orig);
            }
            catch (Exception ex) {
                field_197061_a.warn("Mohist wasn't able to remove command '" + orig + "' from Brigadier's CommandNode!");
                ex.printStackTrace();
                break;
            }
        }
        p_197051_1_.field_71135_a.func_147359_a(new SCommandListPacket((RootCommandNode<ISuggestionProvider>)rootcommandnode));
    }

    private void func_197052_a(CommandNode<CommandSource> p_197052_1_, CommandNode<ISuggestionProvider> p_197052_2_, CommandSource p_197052_3_, Map<CommandNode<CommandSource>, CommandNode<ISuggestionProvider>> p_197052_4_) {
        for (CommandNode commandnode : p_197052_1_.getChildren()) {
            RequiredArgumentBuilder requiredargumentbuilder;
            if (!SpigotConfig.sendNamespaced && commandnode.getName().contains(":") || !commandnode.canUse((Object)p_197052_3_)) continue;
            ArgumentBuilder argumentbuilder = commandnode.createBuilder();
            argumentbuilder.requires(p_197060_0_ -> true);
            if (argumentbuilder.getCommand() != null) {
                argumentbuilder.executes(p_197053_0_ -> 0);
            }
            if (argumentbuilder instanceof RequiredArgumentBuilder && (requiredargumentbuilder = (RequiredArgumentBuilder)argumentbuilder).getSuggestionsProvider() != null) {
                requiredargumentbuilder.suggests(SuggestionProviders.func_197496_b((SuggestionProvider)requiredargumentbuilder.getSuggestionsProvider()));
            }
            if (argumentbuilder.getRedirect() != null) {
                argumentbuilder.redirect(p_197052_4_.get(argumentbuilder.getRedirect()));
            }
            CommandNode commandnode1 = argumentbuilder.build();
            p_197052_4_.put((CommandNode<CommandSource>)commandnode, (CommandNode<ISuggestionProvider>)commandnode1);
            p_197052_2_.addChild(commandnode1);
            if (commandnode.getChildren().isEmpty()) continue;
            this.func_197052_a((CommandNode<CommandSource>)commandnode, (CommandNode<ISuggestionProvider>)commandnode1, p_197052_3_, p_197052_4_);
        }
    }

    public static LiteralArgumentBuilder<CommandSource> func_197057_a(String p_197057_0_) {
        return LiteralArgumentBuilder.literal((String)p_197057_0_);
    }

    public static <T> RequiredArgumentBuilder<CommandSource, T> func_197056_a(String p_197056_0_, ArgumentType<T> p_197056_1_) {
        return RequiredArgumentBuilder.argument((String)p_197056_0_, p_197056_1_);
    }

    public static Predicate<String> func_212590_a(IParser p_212590_0_) {
        return p_212591_1_ -> {
            try {
                p_212590_0_.parse(new StringReader(p_212591_1_));
                return true;
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                return false;
            }
        };
    }

    public CommandDispatcher<CommandSource> func_197054_a() {
        return this.field_197062_b;
    }

    @Nullable
    public static <S> CommandSyntaxException func_227481_a_(ParseResults<S> p_227481_0_) {
        if (!p_227481_0_.getReader().canRead()) {
            return null;
        }
        if (p_227481_0_.getExceptions().size() == 1) {
            return (CommandSyntaxException)((Object)p_227481_0_.getExceptions().values().iterator().next());
        }
        return p_227481_0_.getContext().getRange().isEmpty() ? CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(p_227481_0_.getReader()) : CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(p_227481_0_.getReader());
    }

    public static void func_242986_b() {
        RootCommandNode rootcommandnode = new Commands(EnvironmentType.ALL).func_197054_a().getRoot();
        Set<ArgumentType<?>> set = ArgumentTypes.func_243511_a(rootcommandnode);
        Set set1 = set.stream().filter(p_242987_0_ -> !ArgumentTypes.func_243510_a(p_242987_0_)).collect(Collectors.toSet());
        if (!set1.isEmpty()) {
            field_197061_a.warn("Missing type registration for following arguments:\n {}", (Object)set1.stream().map(p_242985_0_ -> "\t" + p_242985_0_).collect(Collectors.joining(",\n")));
            throw new IllegalStateException("Unregistered argument types");
        }
    }

    private static /* synthetic */ Style lambda$performCommand$4(IFormattableTextComponent iformattabletextcomponent, Style p_211704_1_) {
        return p_211704_1_.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, iformattabletextcomponent));
    }

    static {
        Field children = null;
        Field literals = null;
        Field arguments = null;
        try {
            children = CommandNode.class.getDeclaredField("children");
            literals = CommandNode.class.getDeclaredField("literals");
            arguments = CommandNode.class.getDeclaredField("arguments");
            children.setAccessible(true);
            literals.setAccessible(true);
            arguments.setAccessible(true);
        }
        catch (Exception ex) {
            field_197061_a.error("Mohist wasn't able to prepare reflection for Brigadier's CommandNode!");
            ex.printStackTrace();
        }
        BRIGADIER_CHILDREN = children;
        BRIGADIER_LITERALS = literals;
        BRIGADIER_ARGUMENTS = arguments;
    }

    @FunctionalInterface
    public static interface IParser {
        public void parse(StringReader var1) throws CommandSyntaxException;
    }

    public static enum EnvironmentType {
        ALL(true, true),
        DEDICATED(false, true),
        INTEGRATED(true, false);

        private final boolean field_237219_d_;
        private final boolean field_237220_e_;

        private EnvironmentType(boolean p_i232149_3_, boolean p_i232149_4_) {
            this.field_237219_d_ = p_i232149_3_;
            this.field_237220_e_ = p_i232149_4_;
        }
    }
}

