/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntitySelector;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TranslationTextComponent;

public class EntityArgument
implements ArgumentType<EntitySelector> {
    private static final Collection<String> field_201310_f = Arrays.asList("Player", "0123", "@e", "@e[type=foo]", "dd12be42-52a9-4a91-a8a1-11c01849e498");
    public static final SimpleCommandExceptionType field_197098_a = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.entity.toomany"));
    public static final SimpleCommandExceptionType field_197099_b = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.player.toomany"));
    public static final SimpleCommandExceptionType field_197100_c = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.player.entities"));
    public static final SimpleCommandExceptionType field_197101_d = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.entity.notfound.entity"));
    public static final SimpleCommandExceptionType field_197102_e = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.entity.notfound.player"));
    public static final SimpleCommandExceptionType field_210323_f = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.entity.selector.not_allowed"));
    private final boolean field_197103_f;
    private final boolean field_197104_g;

    protected EntityArgument(boolean p_i47969_1_, boolean p_i47969_2_) {
        this.field_197103_f = p_i47969_1_;
        this.field_197104_g = p_i47969_2_;
    }

    public static EntityArgument func_197086_a() {
        return new EntityArgument(true, false);
    }

    public static Entity func_197088_a(CommandContext<CommandSource> p_197088_0_, String p_197088_1_) throws CommandSyntaxException {
        return ((EntitySelector)p_197088_0_.getArgument(p_197088_1_, EntitySelector.class)).func_197340_a((CommandSource)p_197088_0_.getSource());
    }

    public static EntityArgument func_197093_b() {
        return new EntityArgument(false, false);
    }

    public static Collection<? extends Entity> func_197097_b(CommandContext<CommandSource> p_197097_0_, String p_197097_1_) throws CommandSyntaxException {
        Collection<? extends Entity> collection = EntityArgument.func_197087_c(p_197097_0_, p_197097_1_);
        if (collection.isEmpty()) {
            throw field_197101_d.create();
        }
        return collection;
    }

    public static Collection<? extends Entity> func_197087_c(CommandContext<CommandSource> p_197087_0_, String p_197087_1_) throws CommandSyntaxException {
        return ((EntitySelector)p_197087_0_.getArgument(p_197087_1_, EntitySelector.class)).func_197341_b((CommandSource)p_197087_0_.getSource());
    }

    public static Collection<ServerPlayerEntity> func_201309_d(CommandContext<CommandSource> p_201309_0_, String p_201309_1_) throws CommandSyntaxException {
        return ((EntitySelector)p_201309_0_.getArgument(p_201309_1_, EntitySelector.class)).func_197342_d((CommandSource)p_201309_0_.getSource());
    }

    public static EntityArgument func_197096_c() {
        return new EntityArgument(true, true);
    }

    public static ServerPlayerEntity func_197089_d(CommandContext<CommandSource> p_197089_0_, String p_197089_1_) throws CommandSyntaxException {
        return ((EntitySelector)p_197089_0_.getArgument(p_197089_1_, EntitySelector.class)).func_197347_c((CommandSource)p_197089_0_.getSource());
    }

    public static EntityArgument func_197094_d() {
        return new EntityArgument(false, true);
    }

    public static Collection<ServerPlayerEntity> func_197090_e(CommandContext<CommandSource> p_197090_0_, String p_197090_1_) throws CommandSyntaxException {
        List<ServerPlayerEntity> list = ((EntitySelector)p_197090_0_.getArgument(p_197090_1_, EntitySelector.class)).func_197342_d((CommandSource)p_197090_0_.getSource());
        if (list.isEmpty()) {
            throw field_197102_e.create();
        }
        return list;
    }

    public EntitySelector parse(StringReader p_parse_1_) throws CommandSyntaxException {
        return this.parse(p_parse_1_, false);
    }

    public EntitySelector parse(StringReader p_parse_1_, boolean overridePermissions) throws CommandSyntaxException {
        boolean i = false;
        EntitySelectorParser entityselectorparser = new EntitySelectorParser(p_parse_1_);
        EntitySelector entityselector = entityselectorparser.parse(overridePermissions);
        if (entityselector.func_197346_a() > 1 && this.field_197103_f) {
            if (this.field_197104_g) {
                p_parse_1_.setCursor(0);
                throw field_197099_b.createWithContext((ImmutableStringReader)p_parse_1_);
            }
            p_parse_1_.setCursor(0);
            throw field_197098_a.createWithContext((ImmutableStringReader)p_parse_1_);
        }
        if (entityselector.func_197351_b() && this.field_197104_g && !entityselector.func_197352_c()) {
            p_parse_1_.setCursor(0);
            throw field_197100_c.createWithContext((ImmutableStringReader)p_parse_1_);
        }
        return entityselector;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_listSuggestions_1_, SuggestionsBuilder p_listSuggestions_2_) {
        if (p_listSuggestions_1_.getSource() instanceof ISuggestionProvider) {
            StringReader stringreader = new StringReader(p_listSuggestions_2_.getInput());
            stringreader.setCursor(p_listSuggestions_2_.getStart());
            ISuggestionProvider isuggestionprovider = (ISuggestionProvider)p_listSuggestions_1_.getSource();
            EntitySelectorParser entityselectorparser = new EntitySelectorParser(stringreader, isuggestionprovider.func_197034_c(2));
            try {
                entityselectorparser.func_201345_m();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return entityselectorparser.func_201993_a(p_listSuggestions_2_, p_201942_2_ -> {
                Collection collection = isuggestionprovider.func_197011_j();
                Collection iterable = this.field_197104_g ? collection : Iterables.concat((Iterable)collection, (Iterable)isuggestionprovider.func_211270_p());
                ISuggestionProvider.func_197005_b((Iterable)iterable, (SuggestionsBuilder)p_201942_2_);
            });
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return field_201310_f;
    }

    public static class Serializer
    implements IArgumentSerializer<EntityArgument> {
        public void func_197072_a(EntityArgument p_197072_1_, PacketBuffer p_197072_2_) {
            byte b0 = 0;
            if (p_197072_1_.field_197103_f) {
                b0 = (byte)(b0 | 1);
            }
            if (p_197072_1_.field_197104_g) {
                b0 = (byte)(b0 | 2);
            }
            p_197072_2_.writeByte(b0);
        }

        public EntityArgument func_197071_b(PacketBuffer p_197071_1_) {
            byte b0 = p_197071_1_.readByte();
            return new EntityArgument((b0 & 1) != 0, (b0 & 2) != 0);
        }

        public void func_212244_a(EntityArgument p_212244_1_, JsonObject p_212244_2_) {
            p_212244_2_.addProperty("amount", p_212244_1_.field_197103_f ? "single" : "multiple");
            p_212244_2_.addProperty("type", p_212244_1_.field_197104_g ? "players" : "entities");
        }
    }
}

