/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.primitives.Doubles;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.MinMaxBoundsWrapped;
import net.minecraft.command.arguments.EntityOptions;
import net.minecraft.command.arguments.EntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.command.EntitySelectorManager;

public class EntitySelectorParser {
    public static final SimpleCommandExceptionType field_197408_a = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.entity.invalid"));
    public static final DynamicCommandExceptionType field_197409_b = new DynamicCommandExceptionType(p_208703_0_ -> new TranslationTextComponent("argument.entity.selector.unknown", p_208703_0_));
    public static final SimpleCommandExceptionType field_210328_c = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.entity.selector.not_allowed"));
    public static final SimpleCommandExceptionType field_197410_c = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.entity.selector.missing"));
    public static final SimpleCommandExceptionType field_197411_d = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.entity.options.unterminated"));
    public static final DynamicCommandExceptionType field_197412_e = new DynamicCommandExceptionType(p_208711_0_ -> new TranslationTextComponent("argument.entity.options.valueless", p_208711_0_));
    public static final BiConsumer<Vector3d, List<? extends Entity>> field_197413_f = (p_197402_0_, p_197402_1_) -> {};
    public static final BiConsumer<Vector3d, List<? extends Entity>> field_197414_g = (p_197392_0_, p_197392_1_) -> p_197392_1_.sort((p_197393_1_, p_197393_2_) -> Doubles.compare((double)p_197393_1_.func_195048_a((Vector3d)p_197392_0_), (double)p_197393_2_.func_195048_a((Vector3d)p_197392_0_)));
    public static final BiConsumer<Vector3d, List<? extends Entity>> field_197415_h = (p_197383_0_, p_197383_1_) -> p_197383_1_.sort((p_197369_1_, p_197369_2_) -> Doubles.compare((double)p_197369_2_.func_195048_a((Vector3d)p_197383_0_), (double)p_197369_1_.func_195048_a((Vector3d)p_197383_0_)));
    public static final BiConsumer<Vector3d, List<? extends Entity>> field_197416_i = (p_197368_0_, p_197368_1_) -> Collections.shuffle(p_197368_1_);
    public static final BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> field_201355_j = (p_201342_0_, p_201342_1_) -> p_201342_0_.buildFuture();
    private final StringReader field_197417_j;
    private final boolean field_210329_m;
    private int field_197418_k;
    private boolean field_197419_l;
    private boolean field_197420_m;
    private MinMaxBounds.FloatBound field_197421_n = MinMaxBounds.FloatBound.field_211359_e;
    private MinMaxBounds.IntBound field_197422_o = MinMaxBounds.IntBound.field_211347_e;
    @Nullable
    private Double field_197423_p;
    @Nullable
    private Double field_197424_q;
    @Nullable
    private Double field_197425_r;
    @Nullable
    private Double field_197426_s;
    @Nullable
    private Double field_197427_t;
    @Nullable
    private Double field_197428_u;
    private MinMaxBoundsWrapped field_197429_v = MinMaxBoundsWrapped.field_207926_a;
    private MinMaxBoundsWrapped field_197430_w = MinMaxBoundsWrapped.field_207926_a;
    private Predicate<Entity> field_197431_x = p_197375_0_ -> true;
    private BiConsumer<Vector3d, List<? extends Entity>> field_197432_y = field_197413_f;
    private boolean field_197433_z;
    @Nullable
    private String field_197406_A;
    private int field_201999_C;
    @Nullable
    private UUID field_197407_B;
    private BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> field_201354_D = field_201355_j;
    private boolean field_202000_F;
    private boolean field_202001_G;
    private boolean field_202002_H;
    private boolean field_202003_I;
    private boolean field_202004_J;
    private boolean field_202005_K;
    private boolean field_202006_L;
    private boolean field_202007_M;
    @Nullable
    private EntityType<?> field_202008_N;
    private boolean field_202009_O;
    private boolean field_202010_P;
    private boolean field_202011_Q;
    private boolean field_210327_T;

    public EntitySelectorParser(StringReader p_i47958_1_) {
        this(p_i47958_1_, true);
    }

    public EntitySelectorParser(StringReader p_i49550_1_, boolean p_i49550_2_) {
        this.field_197417_j = p_i49550_1_;
        this.field_210329_m = p_i49550_2_;
    }

    public EntitySelector func_197400_a() {
        AxisAlignedBB axisalignedbb;
        if (this.field_197426_s == null && this.field_197427_t == null && this.field_197428_u == null) {
            if (this.field_197421_n.func_196977_b() != null) {
                float f = ((Float)this.field_197421_n.func_196977_b()).floatValue();
                axisalignedbb = new AxisAlignedBB(-f, -f, -f, f + 1.0f, f + 1.0f, f + 1.0f);
            } else {
                axisalignedbb = null;
            }
        } else {
            axisalignedbb = this.func_197390_a(this.field_197426_s == null ? 0.0 : this.field_197426_s, this.field_197427_t == null ? 0.0 : this.field_197427_t, this.field_197428_u == null ? 0.0 : this.field_197428_u);
        }
        Function<Vector3d, Vector3d> function = this.field_197423_p == null && this.field_197424_q == null && this.field_197425_r == null ? p_197379_0_ -> p_197379_0_ : p_197367_1_ -> new Vector3d(this.field_197423_p == null ? p_197367_1_.field_72450_a : this.field_197423_p, this.field_197424_q == null ? p_197367_1_.field_72448_b : this.field_197424_q, this.field_197425_r == null ? p_197367_1_.field_72449_c : this.field_197425_r);
        return new EntitySelector(this.field_197418_k, this.field_197419_l, this.field_197420_m, this.field_197431_x, this.field_197421_n, function, axisalignedbb, this.field_197432_y, this.field_197433_z, this.field_197406_A, this.field_197407_B, this.field_202008_N, this.field_210327_T);
    }

    private AxisAlignedBB func_197390_a(double p_197390_1_, double p_197390_3_, double p_197390_5_) {
        boolean flag = p_197390_1_ < 0.0;
        boolean flag1 = p_197390_3_ < 0.0;
        boolean flag2 = p_197390_5_ < 0.0;
        double d0 = flag ? p_197390_1_ : 0.0;
        double d1 = flag1 ? p_197390_3_ : 0.0;
        double d2 = flag2 ? p_197390_5_ : 0.0;
        double d3 = (flag ? 0.0 : p_197390_1_) + 1.0;
        double d4 = (flag1 ? 0.0 : p_197390_3_) + 1.0;
        double d5 = (flag2 ? 0.0 : p_197390_5_) + 1.0;
        return new AxisAlignedBB(d0, d1, d2, d3, d4, d5);
    }

    public void func_197396_n() {
        if (this.field_197429_v != MinMaxBoundsWrapped.field_207926_a) {
            this.field_197431_x = this.field_197431_x.and(this.func_197366_a(this.field_197429_v, p_197386_0_ -> p_197386_0_.field_70125_A));
        }
        if (this.field_197430_w != MinMaxBoundsWrapped.field_207926_a) {
            this.field_197431_x = this.field_197431_x.and(this.func_197366_a(this.field_197430_w, p_197385_0_ -> p_197385_0_.field_70177_z));
        }
        if (!this.field_197422_o.func_211335_c()) {
            this.field_197431_x = this.field_197431_x.and(p_197371_1_ -> !(p_197371_1_ instanceof ServerPlayerEntity) ? false : this.field_197422_o.func_211339_d(((ServerPlayerEntity)p_197371_1_).field_71068_ca));
        }
    }

    private Predicate<Entity> func_197366_a(MinMaxBoundsWrapped p_197366_1_, ToDoubleFunction<Entity> p_197366_2_) {
        double d0 = MathHelper.func_76142_g((float)(p_197366_1_.func_207923_a() == null ? 0.0f : p_197366_1_.func_207923_a().floatValue()));
        double d1 = MathHelper.func_76142_g((float)(p_197366_1_.func_207925_b() == null ? 359.0f : p_197366_1_.func_207925_b().floatValue()));
        return p_197374_5_ -> {
            double d2 = MathHelper.func_76138_g((double)p_197366_2_.applyAsDouble((Entity)p_197374_5_));
            if (d0 > d1) {
                return d2 >= d0 || d2 <= d1;
            }
            return d2 >= d0 && d2 <= d1;
        };
    }

    protected void func_197403_b() throws CommandSyntaxException {
        this.parseSelector(true);
    }

    protected void parseSelector(boolean overridePermissions) throws CommandSyntaxException {
        this.field_210327_T = !overridePermissions;
        this.field_201354_D = this::func_201959_d;
        if (!this.field_197417_j.canRead()) {
            throw field_197410_c.createWithContext((ImmutableStringReader)this.field_197417_j);
        }
        int i = this.field_197417_j.getCursor();
        char c0 = this.field_197417_j.read();
        if (c0 == 'p') {
            this.field_197418_k = 1;
            this.field_197419_l = false;
            this.field_197432_y = field_197414_g;
            this.func_218114_a(EntityType.field_200729_aH);
        } else if (c0 == 'a') {
            this.field_197418_k = Integer.MAX_VALUE;
            this.field_197419_l = false;
            this.field_197432_y = field_197413_f;
            this.func_218114_a(EntityType.field_200729_aH);
        } else if (c0 == 'r') {
            this.field_197418_k = 1;
            this.field_197419_l = false;
            this.field_197432_y = field_197416_i;
            this.func_218114_a(EntityType.field_200729_aH);
        } else if (c0 == 's') {
            this.field_197418_k = 1;
            this.field_197419_l = true;
            this.field_197433_z = true;
        } else {
            if (c0 != 'e') {
                this.field_197417_j.setCursor(i);
                throw field_197409_b.createWithContext((ImmutableStringReader)this.field_197417_j, (Object)('@' + String.valueOf(c0)));
            }
            this.field_197418_k = Integer.MAX_VALUE;
            this.field_197419_l = true;
            this.field_197432_y = field_197413_f;
            this.field_197431_x = Entity::func_70089_S;
        }
        this.field_201354_D = this::func_201989_e;
        if (this.field_197417_j.canRead() && this.field_197417_j.peek() == '[') {
            this.field_197417_j.skip();
            this.field_201354_D = this::func_201996_f;
            this.func_197404_d();
        }
    }

    protected void func_197382_c() throws CommandSyntaxException {
        if (this.field_197417_j.canRead()) {
            this.field_201354_D = this::func_201974_c;
        }
        int i = this.field_197417_j.getCursor();
        String s = this.field_197417_j.readString();
        try {
            this.field_197407_B = UUID.fromString(s);
            this.field_197419_l = true;
        }
        catch (IllegalArgumentException illegalargumentexception) {
            if (s.isEmpty() || s.length() > 16) {
                this.field_197417_j.setCursor(i);
                throw field_197408_a.createWithContext((ImmutableStringReader)this.field_197417_j);
            }
            this.field_197419_l = false;
            this.field_197406_A = s;
        }
        this.field_197418_k = 1;
    }

    public void func_197404_d() throws CommandSyntaxException {
        this.field_201354_D = this::func_201994_g;
        this.field_197417_j.skipWhitespace();
        while (this.field_197417_j.canRead() && this.field_197417_j.peek() != ']') {
            this.field_197417_j.skipWhitespace();
            int i = this.field_197417_j.getCursor();
            String s = this.field_197417_j.readString();
            EntityOptions.IFilter entityoptions$ifilter = EntityOptions.func_202017_a((EntitySelectorParser)this, (String)s, (int)i);
            this.field_197417_j.skipWhitespace();
            if (!this.field_197417_j.canRead() || this.field_197417_j.peek() != '=') {
                this.field_197417_j.setCursor(i);
                throw field_197412_e.createWithContext((ImmutableStringReader)this.field_197417_j, (Object)s);
            }
            this.field_197417_j.skip();
            this.field_197417_j.skipWhitespace();
            this.field_201354_D = field_201355_j;
            entityoptions$ifilter.handle(this);
            this.field_197417_j.skipWhitespace();
            this.field_201354_D = this::func_201969_h;
            if (!this.field_197417_j.canRead()) continue;
            if (this.field_197417_j.peek() == ',') {
                this.field_197417_j.skip();
                this.field_201354_D = this::func_201994_g;
                continue;
            }
            if (this.field_197417_j.peek() == ']') break;
            throw field_197411_d.createWithContext((ImmutableStringReader)this.field_197417_j);
        }
        if (this.field_197417_j.canRead()) {
            this.field_197417_j.skip();
            this.field_201354_D = field_201355_j;
            return;
        }
        throw field_197411_d.createWithContext((ImmutableStringReader)this.field_197417_j);
    }

    public boolean func_197378_e() {
        this.field_197417_j.skipWhitespace();
        if (this.field_197417_j.canRead() && this.field_197417_j.peek() == '!') {
            this.field_197417_j.skip();
            this.field_197417_j.skipWhitespace();
            return true;
        }
        return false;
    }

    public boolean func_218115_f() {
        this.field_197417_j.skipWhitespace();
        if (this.field_197417_j.canRead() && this.field_197417_j.peek() == '#') {
            this.field_197417_j.skip();
            this.field_197417_j.skipWhitespace();
            return true;
        }
        return false;
    }

    public StringReader func_197398_f() {
        return this.field_197417_j;
    }

    public void func_197401_a(Predicate<Entity> p_197401_1_) {
        this.field_197431_x = this.field_197431_x.and(p_197401_1_);
    }

    public void func_197365_g() {
        this.field_197420_m = true;
    }

    public MinMaxBounds.FloatBound func_197370_h() {
        return this.field_197421_n;
    }

    public void func_197397_a(MinMaxBounds.FloatBound p_197397_1_) {
        this.field_197421_n = p_197397_1_;
    }

    public MinMaxBounds.IntBound func_197394_i() {
        return this.field_197422_o;
    }

    public void func_197399_b(MinMaxBounds.IntBound p_197399_1_) {
        this.field_197422_o = p_197399_1_;
    }

    public MinMaxBoundsWrapped func_201968_j() {
        return this.field_197429_v;
    }

    public void func_197389_c(MinMaxBoundsWrapped p_197389_1_) {
        this.field_197429_v = p_197389_1_;
    }

    public MinMaxBoundsWrapped func_201980_k() {
        return this.field_197430_w;
    }

    public void func_197387_d(MinMaxBoundsWrapped p_197387_1_) {
        this.field_197430_w = p_197387_1_;
    }

    @Nullable
    public Double func_201965_l() {
        return this.field_197423_p;
    }

    @Nullable
    public Double func_201991_m() {
        return this.field_197424_q;
    }

    @Nullable
    public Double func_201983_n() {
        return this.field_197425_r;
    }

    public void func_197384_a(double p_197384_1_) {
        this.field_197423_p = p_197384_1_;
    }

    public void func_197395_b(double p_197395_1_) {
        this.field_197424_q = p_197395_1_;
    }

    public void func_197372_c(double p_197372_1_) {
        this.field_197425_r = p_197372_1_;
    }

    public void func_197377_d(double p_197377_1_) {
        this.field_197426_s = p_197377_1_;
    }

    public void func_197391_e(double p_197391_1_) {
        this.field_197427_t = p_197391_1_;
    }

    public void func_197405_f(double p_197405_1_) {
        this.field_197428_u = p_197405_1_;
    }

    @Nullable
    public Double func_201977_o() {
        return this.field_197426_s;
    }

    @Nullable
    public Double func_201971_p() {
        return this.field_197427_t;
    }

    @Nullable
    public Double func_201962_q() {
        return this.field_197428_u;
    }

    public void func_197388_a(int p_197388_1_) {
        this.field_197418_k = p_197388_1_;
    }

    public void func_197373_a(boolean p_197373_1_) {
        this.field_197419_l = p_197373_1_;
    }

    public void func_197376_a(BiConsumer<Vector3d, List<? extends Entity>> p_197376_1_) {
        this.field_197432_y = p_197376_1_;
    }

    public EntitySelector func_201345_m() throws CommandSyntaxException {
        return this.parse(false);
    }

    public EntitySelector parse(boolean overridePermissions) throws CommandSyntaxException {
        this.field_201999_C = this.field_197417_j.getCursor();
        this.field_201354_D = this::func_201981_b;
        if (this.field_197417_j.canRead() && this.field_197417_j.peek() == '@') {
            if (!this.field_210329_m) {
                throw field_210328_c.createWithContext((ImmutableStringReader)this.field_197417_j);
            }
            this.field_197417_j.skip();
            EntitySelector forgeSelector = EntitySelectorManager.parseSelector((EntitySelectorParser)this);
            if (forgeSelector != null) {
                return forgeSelector;
            }
            this.parseSelector(overridePermissions);
        } else {
            this.func_197382_c();
        }
        this.func_197396_n();
        return this.func_197400_a();
    }

    private static void func_210326_a(SuggestionsBuilder p_210326_0_) {
        p_210326_0_.suggest("@p", (Message)new TranslationTextComponent("argument.entity.selector.nearestPlayer"));
        p_210326_0_.suggest("@a", (Message)new TranslationTextComponent("argument.entity.selector.allPlayers"));
        p_210326_0_.suggest("@r", (Message)new TranslationTextComponent("argument.entity.selector.randomPlayer"));
        p_210326_0_.suggest("@s", (Message)new TranslationTextComponent("argument.entity.selector.self"));
        p_210326_0_.suggest("@e", (Message)new TranslationTextComponent("argument.entity.selector.allEntities"));
        EntitySelectorManager.fillSelectorSuggestions((SuggestionsBuilder)p_210326_0_);
    }

    private CompletableFuture<Suggestions> func_201981_b(SuggestionsBuilder p_201981_1_, Consumer<SuggestionsBuilder> p_201981_2_) {
        p_201981_2_.accept(p_201981_1_);
        if (this.field_210329_m) {
            EntitySelectorParser.func_210326_a(p_201981_1_);
        }
        return p_201981_1_.buildFuture();
    }

    private CompletableFuture<Suggestions> func_201974_c(SuggestionsBuilder p_201974_1_, Consumer<SuggestionsBuilder> p_201974_2_) {
        SuggestionsBuilder suggestionsbuilder = p_201974_1_.createOffset(this.field_201999_C);
        p_201974_2_.accept(suggestionsbuilder);
        return p_201974_1_.add(suggestionsbuilder).buildFuture();
    }

    private CompletableFuture<Suggestions> func_201959_d(SuggestionsBuilder p_201959_1_, Consumer<SuggestionsBuilder> p_201959_2_) {
        SuggestionsBuilder suggestionsbuilder = p_201959_1_.createOffset(p_201959_1_.getStart() - 1);
        EntitySelectorParser.func_210326_a(suggestionsbuilder);
        p_201959_1_.add(suggestionsbuilder);
        return p_201959_1_.buildFuture();
    }

    private CompletableFuture<Suggestions> func_201989_e(SuggestionsBuilder p_201989_1_, Consumer<SuggestionsBuilder> p_201989_2_) {
        p_201989_1_.suggest(String.valueOf('['));
        return p_201989_1_.buildFuture();
    }

    private CompletableFuture<Suggestions> func_201996_f(SuggestionsBuilder p_201996_1_, Consumer<SuggestionsBuilder> p_201996_2_) {
        p_201996_1_.suggest(String.valueOf(']'));
        EntityOptions.func_202049_a((EntitySelectorParser)this, (SuggestionsBuilder)p_201996_1_);
        return p_201996_1_.buildFuture();
    }

    private CompletableFuture<Suggestions> func_201994_g(SuggestionsBuilder p_201994_1_, Consumer<SuggestionsBuilder> p_201994_2_) {
        EntityOptions.func_202049_a((EntitySelectorParser)this, (SuggestionsBuilder)p_201994_1_);
        return p_201994_1_.buildFuture();
    }

    private CompletableFuture<Suggestions> func_201969_h(SuggestionsBuilder p_201969_1_, Consumer<SuggestionsBuilder> p_201969_2_) {
        p_201969_1_.suggest(String.valueOf(','));
        p_201969_1_.suggest(String.valueOf(']'));
        return p_201969_1_.buildFuture();
    }

    public boolean func_197381_m() {
        return this.field_197433_z;
    }

    public void func_201978_a(BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> p_201978_1_) {
        this.field_201354_D = p_201978_1_;
    }

    public CompletableFuture<Suggestions> func_201993_a(SuggestionsBuilder p_201993_1_, Consumer<SuggestionsBuilder> p_201993_2_) {
        return this.field_201354_D.apply(p_201993_1_.createOffset(this.field_197417_j.getCursor()), p_201993_2_);
    }

    public boolean func_201984_u() {
        return this.field_202000_F;
    }

    public void func_201990_c(boolean p_201990_1_) {
        this.field_202000_F = p_201990_1_;
    }

    public boolean func_201997_v() {
        return this.field_202001_G;
    }

    public void func_201998_d(boolean p_201998_1_) {
        this.field_202001_G = p_201998_1_;
    }

    public boolean func_201967_w() {
        return this.field_202002_H;
    }

    public void func_201979_e(boolean p_201979_1_) {
        this.field_202002_H = p_201979_1_;
    }

    public boolean func_201976_x() {
        return this.field_202003_I;
    }

    public void func_201986_f(boolean p_201986_1_) {
        this.field_202003_I = p_201986_1_;
    }

    public boolean func_201987_y() {
        return this.field_202004_J;
    }

    public void func_201988_g(boolean p_201988_1_) {
        this.field_202004_J = p_201988_1_;
    }

    public boolean func_201961_z() {
        return this.field_202005_K;
    }

    public void func_201973_h(boolean p_201973_1_) {
        this.field_202005_K = p_201973_1_;
    }

    public boolean func_201960_A() {
        return this.field_202006_L;
    }

    public void func_201975_i(boolean p_201975_1_) {
        this.field_202006_L = p_201975_1_;
    }

    public void func_201958_j(boolean p_201958_1_) {
        this.field_202007_M = p_201958_1_;
    }

    public void func_218114_a(EntityType<?> p_218114_1_) {
        this.field_202008_N = p_218114_1_;
    }

    public void func_201982_C() {
        this.field_202009_O = true;
    }

    public boolean func_201963_E() {
        return this.field_202008_N != null;
    }

    public boolean func_201985_F() {
        return this.field_202009_O;
    }

    public boolean func_201995_G() {
        return this.field_202010_P;
    }

    public void func_201970_k(boolean p_201970_1_) {
        this.field_202010_P = p_201970_1_;
    }

    public boolean func_201966_H() {
        return this.field_202011_Q;
    }

    public void func_201992_l(boolean p_201992_1_) {
        this.field_202011_Q = p_201992_1_;
    }
}

