/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mohistmc.util.i18n.i18n;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DirectoryCache {
    private static final Logger field_208324_a = LogManager.getLogger();
    private final Path field_208325_b;
    private final Path field_208326_c;
    private int field_208327_d;
    private final Map<Path, String> field_208328_e = Maps.newHashMap();
    private final Map<Path, String> field_208329_f = Maps.newHashMap();
    private final Set<Path> field_218457_g = Sets.newHashSet();

    public DirectoryCache(Path p_i49352_1_, String p_i49352_2_) throws IOException {
        this.field_208325_b = p_i49352_1_;
        Path path = p_i49352_1_.resolve(".cache");
        Files.createDirectories(path, new FileAttribute[0]);
        this.field_208326_c = path.resolve(p_i49352_2_);
        this.func_209398_c().forEach(p_209395_1_ -> {
            String s = this.field_208328_e.put((Path)p_209395_1_, "");
        });
        if (Files.isReadable(this.field_208326_c)) {
            IOUtils.readLines((InputStream)Files.newInputStream(this.field_208326_c, new OpenOption[0]), (Charset)Charsets.UTF_8).forEach(p_208315_2_ -> {
                int i = p_208315_2_.indexOf(32);
                this.field_208328_e.put(p_i49352_1_.resolve(p_208315_2_.substring(i + 1)), p_208315_2_.substring(0, i));
            });
        }
    }

    public void func_208317_a() throws IOException {
        BufferedWriter writer;
        this.func_209400_b();
        try {
            writer = Files.newBufferedWriter(this.field_208326_c, new OpenOption[0]);
        }
        catch (IOException ioexception) {
            field_208324_a.warn(i18n.get((String)"directorycache.1", (Object[])new Object[]{this.field_208326_c}), (Object)ioexception.toString());
            return;
        }
        IOUtils.writeLines((Collection)this.field_208329_f.entrySet().stream().map(p_208319_1_ -> (String)p_208319_1_.getValue() + ' ' + this.field_208325_b.relativize((Path)p_208319_1_.getKey()).toString().replace('\\', '/')).sorted(Comparator.comparing(a -> a.split(" ")[1])).collect(Collectors.toList()), (String)System.lineSeparator(), (Writer)writer);
        ((Writer)writer).close();
        field_208324_a.debug(i18n.get((String)"directorycache.2", (Object[])new Object[]{this.field_208327_d, this.field_208329_f.size() - this.field_208327_d, this.field_208328_e.size()}));
    }

    @Nullable
    public String func_208323_a(Path p_208323_1_) {
        return this.field_208328_e.get(p_208323_1_);
    }

    public void func_208316_a(Path p_208316_1_, String p_208316_2_) {
        this.field_208329_f.put(p_208316_1_, p_208316_2_);
        if (Objects.equals(this.field_208328_e.remove(p_208316_1_), p_208316_2_)) {
            ++this.field_208327_d;
        }
    }

    public boolean func_208320_b(Path p_208320_1_) {
        return this.field_208328_e.containsKey(p_208320_1_);
    }

    public void func_218456_c(Path p_218456_1_) {
        this.field_218457_g.add(p_218456_1_);
    }

    private void func_209400_b() throws IOException {
        this.func_209398_c().forEach(p_208322_1_ -> {
            if (this.func_208320_b((Path)p_208322_1_) && !this.field_218457_g.contains(p_208322_1_)) {
                try {
                    Files.delete(p_208322_1_);
                }
                catch (IOException ioexception) {
                    field_208324_a.debug(i18n.get((String)"directorycache.3", (Object[])new Object[]{p_208322_1_, ioexception.toString()}));
                }
            }
        });
    }

    private Stream<Path> func_209398_c() throws IOException {
        return Files.walk(this.field_208325_b, new FileVisitOption[0]).filter(p_209397_1_ -> !Objects.equals(this.field_208326_c, p_209397_1_) && !Files.isDirectory(p_209397_1_, new LinkOption[0]));
    }
}

