/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.mohistmc.util.i18n.i18n;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NBTToSNBTConverter
implements IDataProvider {
    private static final Logger field_200418_a = LogManager.getLogger();
    private final DataGenerator field_200419_b;

    public NBTToSNBTConverter(DataGenerator p_i48258_1_) {
        this.field_200419_b = p_i48258_1_;
    }

    public void func_200398_a(DirectoryCache p_200398_1_) throws IOException {
        Path path = this.field_200419_b.func_200391_b();
        for (Path path1 : this.field_200419_b.func_200389_a()) {
            Files.walk(path1, new FileVisitOption[0]).filter(p_200416_0_ -> p_200416_0_.toString().endsWith(".nbt")).forEach(p_200415_3_ -> NBTToSNBTConverter.func_229443_a_(p_200415_3_, this.func_200417_a(path1, (Path)p_200415_3_), path));
        }
    }

    public String func_200397_b() {
        return "NBT to SNBT";
    }

    private String func_200417_a(Path p_200417_1_, Path p_200417_2_) {
        String s = p_200417_1_.relativize(p_200417_2_).toString().replaceAll("\\\\", "/");
        return s.substring(0, s.length() - ".nbt".length());
    }

    @Nullable
    public static Path func_229443_a_(Path p_229443_0_, String p_229443_1_, Path p_229443_2_) {
        try {
            CompoundNBT compoundnbt = CompressedStreamTools.func_74796_a(Files.newInputStream(p_229443_0_, new OpenOption[0]));
            ITextComponent itextcomponent = compoundnbt.func_199850_a("    ", 0);
            String s = itextcomponent.getString() + "\n";
            Path path = p_229443_2_.resolve(p_229443_1_ + ".snbt");
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                bufferedwriter.write(s);
            }
            field_200418_a.info(i18n.get((String)"nbttosnbtconverter.1", (Object[])new Object[]{p_229443_1_}));
            return path;
        }
        catch (IOException ioexception) {
            field_200418_a.error(i18n.get((String)"nbttosnbtconverter.2", (Object[])new Object[]{p_229443_1_, p_229443_0_, ioexception}));
            return null;
        }
    }
}

