/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mohistmc.util.i18n.i18n;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.command.arguments.ParticleArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class AreaEffectCloudEntity
extends Entity {
    private static final Logger field_195060_a = LogManager.getLogger();
    private static final DataParameter<Float> field_184498_a = EntityDataManager.func_187226_a(AreaEffectCloudEntity.class, DataSerializers.field_187193_c);
    private static final DataParameter<Integer> field_184499_b = EntityDataManager.func_187226_a(AreaEffectCloudEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_184500_c = EntityDataManager.func_187226_a(AreaEffectCloudEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<IParticleData> field_184501_d = EntityDataManager.func_187226_a(AreaEffectCloudEntity.class, DataSerializers.field_198166_i);
    private Potion field_184502_e = Potions.field_185229_a;
    public final List<EffectInstance> field_184503_f = Lists.newArrayList();
    private final Map<Entity, Integer> field_184504_g = Maps.newHashMap();
    private int field_184505_h = 600;
    public int field_184506_as = 20;
    public int field_184507_at = 20;
    private boolean field_184508_au;
    public int field_184509_av;
    public float field_184510_aw;
    public float field_184511_ax;
    private LivingEntity field_184512_ay;
    private UUID field_184513_az;

    public AreaEffectCloudEntity(EntityType<? extends AreaEffectCloudEntity> p_i50389_1_, World p_i50389_2_) {
        super(p_i50389_1_, p_i50389_2_);
        this.field_70145_X = true;
        this.func_184483_a(3.0f);
    }

    public AreaEffectCloudEntity(World p_i46810_1_, double p_i46810_2_, double p_i46810_4_, double p_i46810_6_) {
        this((EntityType<? extends AreaEffectCloudEntity>)EntityType.field_200788_b, p_i46810_1_);
        this.func_70107_b(p_i46810_2_, p_i46810_4_, p_i46810_6_);
    }

    @Override
    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(field_184499_b, 0);
        this.func_184212_Q().func_187214_a(field_184498_a, Float.valueOf(0.5f));
        this.func_184212_Q().func_187214_a(field_184500_c, false);
        this.func_184212_Q().func_187214_a(field_184501_d, ParticleTypes.field_197625_r);
    }

    public void func_184483_a(float p_184483_1_) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(field_184498_a, Float.valueOf(p_184483_1_));
        }
    }

    @Override
    public void func_213323_x_() {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(d0, d1, d2);
    }

    public float func_184490_j() {
        return this.func_184212_Q().func_187225_a(field_184498_a).floatValue();
    }

    public void func_184484_a(Potion p_184484_1_) {
        this.field_184502_e = p_184484_1_;
        if (!this.field_184508_au) {
            this.func_190618_C();
        }
    }

    private void func_190618_C() {
        if (this.field_184502_e == Potions.field_185229_a && this.field_184503_f.isEmpty()) {
            this.func_184212_Q().func_187227_b(field_184499_b, 0);
        } else {
            this.func_184212_Q().func_187227_b(field_184499_b, PotionUtils.func_185181_a(PotionUtils.func_185186_a(this.field_184502_e, this.field_184503_f)));
        }
    }

    public void func_184496_a(EffectInstance p_184496_1_) {
        this.field_184503_f.add(p_184496_1_);
        if (!this.field_184508_au) {
            this.func_190618_C();
        }
    }

    public void refreshEffects() {
        if (!this.field_184508_au) {
            this.func_184212_Q().func_187227_b(field_184499_b, PotionUtils.func_185181_a(PotionUtils.func_185186_a(this.field_184502_e, this.field_184503_f)));
        }
    }

    public String getTypeCB() {
        return Registry.field_212621_j.func_177774_c((Object)this.field_184502_e).toString();
    }

    public void setType(String string) {
        this.func_184484_a((Potion)((Object)Registry.field_212621_j.func_82594_a(new ResourceLocation(string))));
    }

    public int func_184492_k() {
        return this.func_184212_Q().func_187225_a(field_184499_b);
    }

    public void func_184482_a(int p_184482_1_) {
        this.field_184508_au = true;
        this.func_184212_Q().func_187227_b(field_184499_b, p_184482_1_);
    }

    public IParticleData func_195058_l() {
        return this.func_184212_Q().func_187225_a(field_184501_d);
    }

    public void func_195059_a(IParticleData p_195059_1_) {
        this.func_184212_Q().func_187227_b(field_184501_d, p_195059_1_);
    }

    protected void func_184488_a(boolean p_184488_1_) {
        this.func_184212_Q().func_187227_b(field_184500_c, p_184488_1_);
    }

    public boolean func_184497_n() {
        return this.func_184212_Q().func_187225_a(field_184500_c);
    }

    public int func_184489_o() {
        return this.field_184505_h;
    }

    public void func_184486_b(int p_184486_1_) {
        this.field_184505_h = p_184486_1_;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.field_70173_aa >= this.field_184506_as + this.field_184505_h) {
            this.func_70106_y();
            return;
        }
    }

    @Override
    public void func_70071_h_() {
        block26: {
            boolean flag1;
            float f;
            boolean flag;
            block24: {
                IParticleData iparticledata;
                block25: {
                    super.func_70071_h_();
                    flag = this.func_184497_n();
                    f = this.func_184490_j();
                    if (f < 0.0f) {
                        this.func_70106_y();
                        return;
                    }
                    if (!this.field_70170_p.field_72995_K) break block24;
                    iparticledata = this.func_195058_l();
                    if (!flag) break block25;
                    if (!this.field_70146_Z.nextBoolean()) break block26;
                    for (int i = 0; i < 2; ++i) {
                        float f1 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                        float f2 = MathHelper.func_76129_c((float)this.field_70146_Z.nextFloat()) * 0.2f;
                        float f3 = MathHelper.func_76134_b((float)f1) * f2;
                        float f4 = MathHelper.func_76126_a((float)f1) * f2;
                        if (iparticledata.func_197554_b() == ParticleTypes.field_197625_r) {
                            int j = this.field_70146_Z.nextBoolean() ? 0xFFFFFF : this.func_184492_k();
                            int k = j >> 16 & 0xFF;
                            int l = j >> 8 & 0xFF;
                            int i1 = j & 0xFF;
                            this.field_70170_p.func_195589_b(iparticledata, this.func_226277_ct_() + (double)f3, this.func_226278_cu_(), this.func_226281_cx_() + (double)f4, (float)k / 255.0f, (float)l / 255.0f, (float)i1 / 255.0f);
                            continue;
                        }
                        this.field_70170_p.func_195589_b(iparticledata, this.func_226277_ct_() + (double)f3, this.func_226278_cu_(), this.func_226281_cx_() + (double)f4, 0.0, 0.0, 0.0);
                    }
                    break block26;
                }
                float f5 = (float)Math.PI * f * f;
                int k1 = 0;
                while ((float)k1 < f5) {
                    float f6 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                    float f7 = MathHelper.func_76129_c((float)this.field_70146_Z.nextFloat()) * f;
                    float f8 = MathHelper.func_76134_b((float)f6) * f7;
                    float f9 = MathHelper.func_76126_a((float)f6) * f7;
                    if (iparticledata.func_197554_b() == ParticleTypes.field_197625_r) {
                        int l1 = this.func_184492_k();
                        int i2 = l1 >> 16 & 0xFF;
                        int j2 = l1 >> 8 & 0xFF;
                        int j1 = l1 & 0xFF;
                        this.field_70170_p.func_195589_b(iparticledata, this.func_226277_ct_() + (double)f8, this.func_226278_cu_(), this.func_226281_cx_() + (double)f9, (float)i2 / 255.0f, (float)j2 / 255.0f, (float)j1 / 255.0f);
                    } else {
                        this.field_70170_p.func_195589_b(iparticledata, this.func_226277_ct_() + (double)f8, this.func_226278_cu_(), this.func_226281_cx_() + (double)f9, (0.5 - this.field_70146_Z.nextDouble()) * 0.15, 0.01f, (0.5 - this.field_70146_Z.nextDouble()) * 0.15);
                    }
                    ++k1;
                }
                break block26;
            }
            if (this.field_70173_aa >= this.field_184506_as + this.field_184505_h) {
                this.func_70106_y();
                return;
            }
            boolean bl = flag1 = this.field_70173_aa < this.field_184506_as;
            if (flag != flag1) {
                this.func_184488_a(flag1);
            }
            if (flag1) {
                return;
            }
            if (this.field_184511_ax != 0.0f) {
                if ((f += this.field_184511_ax) < 0.5f) {
                    this.func_70106_y();
                    return;
                }
                this.func_184483_a(f);
            }
            if (this.field_70173_aa % 5 == 0) {
                Iterator<Map.Entry<Entity, Integer>> iterator = this.field_184504_g.entrySet().iterator();
                ArrayList<org.bukkit.entity.LivingEntity> entities = new ArrayList<org.bukkit.entity.LivingEntity>();
                while (iterator.hasNext()) {
                    Map.Entry<Entity, Integer> entry = iterator.next();
                    if (this.field_70173_aa < entry.getValue()) continue;
                    iterator.remove();
                }
                ArrayList list = Lists.newArrayList();
                for (EffectInstance effectInstance : this.field_184502_e.func_185170_a()) {
                    list.add(new EffectInstance(effectInstance.func_188419_a(), effectInstance.func_76459_b() / 4, effectInstance.func_76458_c(), effectInstance.func_82720_e(), effectInstance.func_188418_e()));
                }
                list.addAll(this.field_184503_f);
                if (list.isEmpty()) {
                    this.field_184504_g.clear();
                } else {
                    List list1 = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ());
                    if (!list1.isEmpty()) {
                        for (LivingEntity livingentity : list1) {
                            double d1;
                            double d0;
                            double d2;
                            if (this.field_184504_g.containsKey(livingentity) || !livingentity.func_184603_cC() || !((d2 = (d0 = livingentity.func_226277_ct_() - this.func_226277_ct_()) * d0 + (d1 = livingentity.func_226281_cx_() - this.func_226281_cx_()) * d1) <= (double)(f * f))) continue;
                            entities.add((org.bukkit.entity.LivingEntity)livingentity.getBukkitEntity());
                        }
                        AreaEffectCloudApplyEvent areaEffectCloudApplyEvent = CraftEventFactory.callAreaEffectCloudApplyEvent((AreaEffectCloudEntity)this, entities);
                        if (!areaEffectCloudApplyEvent.isCancelled()) {
                            for (org.bukkit.entity.LivingEntity entity : areaEffectCloudApplyEvent.getAffectedEntities()) {
                                if (!(entity instanceof CraftLivingEntity)) continue;
                                LivingEntity livingentity = ((CraftLivingEntity)entity).getHandle();
                                this.field_184504_g.put(livingentity, this.field_70173_aa + this.field_184507_at);
                                for (EffectInstance effectinstance : list) {
                                    if (effectinstance.func_188419_a().func_76403_b()) {
                                        effectinstance.func_188419_a().func_180793_a(this, this.func_184494_w(), livingentity, effectinstance.func_76458_c(), 0.5);
                                        continue;
                                    }
                                    livingentity.addEffect(new EffectInstance(effectinstance), EntityPotionEffectEvent.Cause.AREA_EFFECT_CLOUD);
                                }
                                if (this.field_184510_aw != 0.0f) {
                                    if ((f += this.field_184510_aw) < 0.5f) {
                                        this.func_70106_y();
                                        return;
                                    }
                                    this.func_184483_a(f);
                                }
                                if (this.field_184509_av == 0) continue;
                                this.field_184505_h += this.field_184509_av;
                                if (this.field_184505_h > 0) continue;
                                this.func_70106_y();
                                return;
                            }
                        }
                    }
                }
            }
        }
    }

    public void func_184495_b(float p_184495_1_) {
        this.field_184510_aw = p_184495_1_;
    }

    public void func_184487_c(float p_184487_1_) {
        this.field_184511_ax = p_184487_1_;
    }

    public void func_184485_d(int p_184485_1_) {
        this.field_184506_as = p_184485_1_;
    }

    public void func_184481_a(@Nullable LivingEntity p_184481_1_) {
        this.field_184512_ay = p_184481_1_;
        this.field_184513_az = p_184481_1_ == null ? null : p_184481_1_.func_110124_au();
    }

    @Nullable
    public LivingEntity func_184494_w() {
        Entity entity;
        if (this.field_184512_ay == null && this.field_184513_az != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.field_184513_az)) instanceof LivingEntity) {
            this.field_184512_ay = (LivingEntity)entity;
        }
        return this.field_184512_ay;
    }

    @Override
    protected void func_70037_a(CompoundNBT p_70037_1_) {
        this.field_70173_aa = p_70037_1_.func_74762_e("Age");
        this.field_184505_h = p_70037_1_.func_74762_e("Duration");
        this.field_184506_as = p_70037_1_.func_74762_e("WaitTime");
        this.field_184507_at = p_70037_1_.func_74762_e("ReapplicationDelay");
        this.field_184509_av = p_70037_1_.func_74762_e("DurationOnUse");
        this.field_184510_aw = p_70037_1_.func_74760_g("RadiusOnUse");
        this.field_184511_ax = p_70037_1_.func_74760_g("RadiusPerTick");
        this.func_184483_a(p_70037_1_.func_74760_g("Radius"));
        if (p_70037_1_.func_186855_b("Owner")) {
            this.field_184513_az = p_70037_1_.func_186857_a("Owner");
        }
        if (p_70037_1_.func_150297_b("Particle", 8)) {
            try {
                this.func_195059_a(ParticleArgument.func_197189_a((StringReader)new StringReader(p_70037_1_.func_74779_i("Particle"))));
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                field_195060_a.warn(i18n.get((String)"areaeffectcloudentity.1", (Object[])new Object[]{p_70037_1_.func_74779_i("Particle")}), (Throwable)commandsyntaxexception);
            }
        }
        if (p_70037_1_.func_150297_b("Color", 99)) {
            this.func_184482_a(p_70037_1_.func_74762_e("Color"));
        }
        if (p_70037_1_.func_150297_b("Potion", 8)) {
            this.func_184484_a(PotionUtils.func_185187_c(p_70037_1_));
        }
        if (p_70037_1_.func_150297_b("Effects", 9)) {
            ListNBT listnbt = p_70037_1_.func_150295_c("Effects", 10);
            this.field_184503_f.clear();
            for (int i = 0; i < listnbt.size(); ++i) {
                EffectInstance effectinstance = EffectInstance.func_82722_b(listnbt.func_150305_b(i));
                if (effectinstance == null) continue;
                this.func_184496_a(effectinstance);
            }
        }
    }

    @Override
    protected void func_213281_b(CompoundNBT p_213281_1_) {
        p_213281_1_.func_74768_a("Age", this.field_70173_aa);
        p_213281_1_.func_74768_a("Duration", this.field_184505_h);
        p_213281_1_.func_74768_a("WaitTime", this.field_184506_as);
        p_213281_1_.func_74768_a("ReapplicationDelay", this.field_184507_at);
        p_213281_1_.func_74768_a("DurationOnUse", this.field_184509_av);
        p_213281_1_.func_74776_a("RadiusOnUse", this.field_184510_aw);
        p_213281_1_.func_74776_a("RadiusPerTick", this.field_184511_ax);
        p_213281_1_.func_74776_a("Radius", this.func_184490_j());
        p_213281_1_.func_74778_a("Particle", this.func_195058_l().func_197555_a());
        if (this.field_184513_az != null) {
            p_213281_1_.func_186854_a("Owner", this.field_184513_az);
        }
        if (this.field_184508_au) {
            p_213281_1_.func_74768_a("Color", this.func_184492_k());
        }
        if (this.field_184502_e != Potions.field_185229_a && this.field_184502_e != null) {
            p_213281_1_.func_74778_a("Potion", Registry.field_212621_j.func_177774_c((Object)this.field_184502_e).toString());
        }
        if (!this.field_184503_f.isEmpty()) {
            ListNBT listnbt = new ListNBT();
            for (EffectInstance effectinstance : this.field_184503_f) {
                listnbt.add((Object)effectinstance.func_82719_a(new CompoundNBT()));
            }
            p_213281_1_.func_218657_a("Effects", (INBT)listnbt);
        }
    }

    @Override
    public void func_184206_a(DataParameter<?> p_184206_1_) {
        if (field_184498_a.equals(p_184206_1_)) {
            this.func_213323_x_();
        }
        super.func_184206_a(p_184206_1_);
    }

    @Override
    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }

    @Override
    public EntitySize func_213305_a(Pose p_213305_1_) {
        return EntitySize.func_220314_b((float)(this.func_184490_j() * 2.0f), (float)0.5f);
    }
}

