/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.Validate;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;

public abstract class HangingEntity
extends Entity {
    protected static final Predicate<Entity> field_184524_c = p_210144_0_ -> p_210144_0_ instanceof HangingEntity;
    private int field_70520_f;
    public BlockPos field_174861_a;
    protected Direction field_174860_b = Direction.SOUTH;

    protected HangingEntity(EntityType<? extends HangingEntity> p_i48561_1_, World p_i48561_2_) {
        super(p_i48561_1_, p_i48561_2_);
    }

    protected HangingEntity(EntityType<? extends HangingEntity> p_i48562_1_, World p_i48562_2_, BlockPos p_i48562_3_) {
        this(p_i48562_1_, p_i48562_2_);
        this.field_174861_a = p_i48562_3_;
    }

    @Override
    protected void func_70088_a() {
    }

    public void func_174859_a(Direction p_174859_1_) {
        Validate.notNull((Object)((Object)p_174859_1_));
        Validate.isTrue((boolean)p_174859_1_.func_176740_k().func_176722_c());
        this.field_174860_b = p_174859_1_;
        this.field_70126_B = this.field_70177_z = (float)(this.field_174860_b.func_176736_b() * 90);
        this.func_174856_o();
    }

    protected void func_174856_o() {
        if (this.field_174860_b != null) {
            this.func_174826_a(HangingEntity.calculateBoundingBox(this, this.field_174861_a, this.field_174860_b, this.func_82329_d(), this.func_82330_g()));
        }
    }

    public static AxisAlignedBB calculateBoundingBox(@Nullable Entity entity, BlockPos blockPosition, Direction direction, int width, int height) {
        double d0 = (double)blockPosition.func_177958_n() + 0.5;
        double d1 = (double)blockPosition.func_177956_o() + 0.5;
        double d2 = (double)blockPosition.func_177952_p() + 0.5;
        double d3 = 0.46875;
        double d4 = HangingEntity.func_190202_a(width);
        double d5 = HangingEntity.func_190202_a(height);
        d0 -= (double)direction.func_82601_c() * 0.46875;
        d2 -= (double)direction.func_82599_e() * 0.46875;
        d1 += d5;
        Direction direction1 = direction.func_176735_f();
        d0 += d4 * (double)direction1.func_82601_c();
        d2 += d4 * (double)direction1.func_82599_e();
        if (entity != null) {
            entity.func_226288_n_(d0, d1, d2);
        }
        double d6 = width;
        double d7 = height;
        double d8 = width;
        if (direction.func_176740_k() == Direction.Axis.Z) {
            d8 = 1.0;
        } else {
            d6 = 1.0;
        }
        return new AxisAlignedBB(d0 - (d6 /= 32.0), d1 - (d7 /= 32.0), d2 - (d8 /= 32.0), d0 + d6, d1 + d7, d2 + d8);
    }

    private static double func_190202_a(int p_190202_1_) {
        return p_190202_1_ % 32 == 0 ? 0.5 : 0.0;
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_226278_cu_() < -64.0) {
                this.func_70076_C();
            }
            if (this.field_70520_f++ == this.field_70170_p.spigotConfig.hangingTickFrequency) {
                this.field_70520_f = 0;
                if (!this.field_70128_L && !this.func_70518_d()) {
                    Material material = this.field_70170_p.func_180495_p(new BlockPos(this)).func_185904_a();
                    HangingBreakEvent.RemoveCause cause = !material.equals(Material.field_151579_a) ? HangingBreakEvent.RemoveCause.OBSTRUCTION : HangingBreakEvent.RemoveCause.PHYSICS;
                    HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), cause);
                    this.field_70170_p.getCBServer().getPluginManager().callEvent((Event)event);
                    if (this.field_70128_L || event.isCancelled()) {
                        return;
                    }
                    this.func_70106_y();
                    this.func_110128_b(null);
                }
            }
        }
    }

    public boolean func_70518_d() {
        if (!this.field_70170_p.func_226669_j_(this)) {
            return false;
        }
        int i = Math.max(1, this.func_82329_d() / 16);
        int j = Math.max(1, this.func_82330_g() / 16);
        BlockPos blockpos = this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d());
        Direction direction = this.field_174860_b.func_176735_f();
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k = 0; k < i; ++k) {
            for (int l = 0; l < j; ++l) {
                int i1 = (i - 1) / -2;
                int j1 = (j - 1) / -2;
                blockpos$mutable.func_189533_g(blockpos).func_189534_c(direction, k + i1).func_189534_c(Direction.UP, l + j1);
                BlockState blockstate = this.field_70170_p.func_180495_p(blockpos$mutable);
                if (Block.func_220055_a((IWorldReader)((Object)this.field_70170_p), blockpos$mutable, this.field_174860_b) || blockstate.func_185904_a().func_76220_a() || RedstoneDiodeBlock.func_185546_B(blockstate)) continue;
                return false;
            }
        }
        return this.field_70170_p.func_175674_a(this, this.func_174813_aQ(), field_184524_c).isEmpty();
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    @Override
    public boolean func_85031_j(Entity p_85031_1_) {
        if (p_85031_1_ instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)p_85031_1_;
            return !this.field_70170_p.func_175660_a(playerentity, this.field_174861_a) ? true : this.func_70097_a(DamageSource.func_76365_a(playerentity), 0.0f);
        }
        return false;
    }

    @Override
    public Direction func_174811_aO() {
        return this.field_174860_b;
    }

    @Override
    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            Entity damager;
            Entity entity = damager = p_70097_1_ instanceof IndirectEntityDamageSource ? ((IndirectEntityDamageSource)p_70097_1_).getProximateDamageSource() : p_70097_1_.func_76346_g();
            Object event = damager != null ? new HangingBreakByEntityEvent((Hanging)this.getBukkitEntity(), (org.bukkit.entity.Entity)damager.getBukkitEntity(), p_70097_1_.func_94541_c() ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.ENTITY) : new HangingBreakEvent((Hanging)this.getBukkitEntity(), p_70097_1_.func_94541_c() ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.DEFAULT);
            this.field_70170_p.getCBServer().getPluginManager().callEvent((Event)event);
            if (this.field_70128_L || event.isCancelled()) {
                return true;
            }
            this.func_70106_y();
            this.func_70018_K();
            this.func_110128_b(p_70097_1_.func_76346_g());
        }
        return true;
    }

    @Override
    public void func_213315_a(MoverType p_213315_1_, Vector3d p_213315_2_) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && p_213315_2_.func_189985_c() > 0.0) {
            if (this.field_70128_L) {
                return;
            }
            HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), HangingBreakEvent.RemoveCause.PHYSICS);
            this.field_70170_p.getCBServer().getPluginManager().callEvent((Event)event);
            if (this.field_70128_L || event.isCancelled()) {
                return;
            }
            this.func_70106_y();
            this.func_110128_b(null);
        }
    }

    @Override
    public void func_70024_g(double p_70024_1_, double p_70024_3_, double p_70024_5_) {
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        p_213281_1_.func_74774_a("Facing", (byte)this.field_174860_b.func_176736_b());
        BlockPos blockpos = this.func_174857_n();
        p_213281_1_.func_74768_a("TileX", blockpos.func_177958_n());
        p_213281_1_.func_74768_a("TileY", blockpos.func_177956_o());
        p_213281_1_.func_74768_a("TileZ", blockpos.func_177952_p());
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        this.field_174861_a = new BlockPos(p_70037_1_.func_74762_e("TileX"), p_70037_1_.func_74762_e("TileY"), p_70037_1_.func_74762_e("TileZ"));
        this.field_174860_b = Direction.func_176731_b(p_70037_1_.func_74771_c("Facing"));
    }

    public abstract int func_82329_d();

    public abstract int func_82330_g();

    public abstract void func_110128_b(@Nullable Entity var1);

    public abstract void func_184523_o();

    @Override
    public ItemEntity func_70099_a(ItemStack p_70099_1_, float p_70099_2_) {
        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + (double)((float)this.field_174860_b.func_82601_c() * 0.15f), this.func_226278_cu_() + (double)p_70099_2_, this.func_226281_cx_() + (double)((float)this.field_174860_b.func_82599_e() * 0.15f), p_70099_1_);
        itementity.func_174869_p();
        this.field_70170_p.func_217376_c(itementity);
        return itementity;
    }

    @Override
    protected boolean func_142008_O() {
        return false;
    }

    @Override
    public void func_70107_b(double p_70107_1_, double p_70107_3_, double p_70107_5_) {
        this.field_174861_a = new BlockPos(p_70107_1_, p_70107_3_, p_70107_5_);
        this.func_174856_o();
        this.field_70160_al = true;
    }

    public BlockPos func_174857_n() {
        return this.field_174861_a;
    }

    @Override
    public float func_184229_a(Rotation p_184229_1_) {
        if (this.field_174860_b.func_176740_k() != Direction.Axis.Y) {
            switch (p_184229_1_) {
                case CLOCKWISE_180: {
                    this.field_174860_b = this.field_174860_b.func_176734_d();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    this.field_174860_b = this.field_174860_b.func_176735_f();
                    break;
                }
                case CLOCKWISE_90: {
                    this.field_174860_b = this.field_174860_b.func_176746_e();
                }
            }
        }
        float f = MathHelper.func_76142_g((float)this.field_70177_z);
        switch (p_184229_1_) {
            case CLOCKWISE_180: {
                return f + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f + 90.0f;
            }
            case CLOCKWISE_90: {
                return f + 270.0f;
            }
        }
        return f;
    }

    @Override
    public float func_184217_a(Mirror p_184217_1_) {
        return this.func_184229_a(p_184217_1_.func_185800_a(this.field_174860_b));
    }

    @Override
    public void func_241841_a(ServerWorld p_241841_1_, LightningBoltEntity p_241841_2_) {
    }

    @Override
    public void func_213323_x_() {
    }
}

