/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Collection;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IChargeableMob;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.CreeperSwellGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

@OnlyIn(value=Dist.CLIENT, _interface=IChargeableMob.class)
public class CreeperEntity
extends MonsterEntity
implements IChargeableMob {
    private static final DataParameter<Integer> field_184713_a = EntityDataManager.func_187226_a(CreeperEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_184714_b = EntityDataManager.func_187226_a(CreeperEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_184715_c = EntityDataManager.func_187226_a(CreeperEntity.class, DataSerializers.field_187198_h);
    private int field_70834_e;
    public int field_70833_d;
    public int field_82225_f = 30;
    public int field_82226_g = 3;
    private int field_175494_bm;

    public CreeperEntity(EntityType<? extends CreeperEntity> p_i50213_1_, World p_i50213_2_) {
        super((EntityType<? extends MonsterEntity>)p_i50213_1_, p_i50213_2_);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new CreeperSwellGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, OcelotEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, CatEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal(this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal(this, new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute func_234278_m_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    @Override
    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    @Override
    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        boolean flag = super.func_225503_b_(p_225503_1_, p_225503_2_);
        this.field_70833_d = (int)((float)this.field_70833_d + p_225503_1_ * 1.5f);
        if (this.field_70833_d > this.field_82225_f - 5) {
            this.field_70833_d = this.field_82225_f - 5;
        }
        return flag;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184713_a, -1);
        this.field_70180_af.func_187214_a(field_184714_b, false);
        this.field_70180_af.func_187214_a(field_184715_c, false);
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        if (this.field_70180_af.func_187225_a(field_184714_b).booleanValue()) {
            p_213281_1_.func_74757_a("powered", true);
        }
        p_213281_1_.func_74777_a("Fuse", (short)this.field_82225_f);
        p_213281_1_.func_74774_a("ExplosionRadius", (byte)this.field_82226_g);
        p_213281_1_.func_74757_a("ignited", this.func_146078_ca());
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.field_70180_af.func_187227_b(field_184714_b, p_70037_1_.func_74767_n("powered"));
        if (p_70037_1_.func_150297_b("Fuse", 99)) {
            this.field_82225_f = p_70037_1_.func_74765_d("Fuse");
        }
        if (p_70037_1_.func_150297_b("ExplosionRadius", 99)) {
            this.field_82226_g = p_70037_1_.func_74771_c("ExplosionRadius");
        }
        if (p_70037_1_.func_74767_n("ignited")) {
            this.func_146079_cb();
        }
    }

    @Override
    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            this.field_70834_e = this.field_70833_d;
            if (this.func_146078_ca()) {
                this.func_70829_a(1);
            }
            if ((i = this.func_70832_p()) > 0 && this.field_70833_d == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.field_70833_d += i;
            if (this.field_70833_d < 0) {
                this.field_70833_d = 0;
            }
            if (this.field_70833_d >= this.field_82225_f) {
                this.field_70833_d = this.field_82225_f;
                this.func_146077_cc();
            }
        }
        super.func_70071_h_();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187570_aq;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187568_ap;
    }

    @Override
    protected void func_213333_a(DamageSource p_213333_1_, int p_213333_2_, boolean p_213333_3_) {
        CreeperEntity creeperentity;
        super.func_213333_a(p_213333_1_, p_213333_2_, p_213333_3_);
        Entity entity = p_213333_1_.func_76346_g();
        if (entity != this && entity instanceof CreeperEntity && (creeperentity = (CreeperEntity)entity).func_70650_aV()) {
            creeperentity.func_175493_co();
            this.func_199703_a(Items.field_196185_dy);
        }
    }

    @Override
    public boolean func_70652_k(Entity p_70652_1_) {
        return true;
    }

    public boolean func_225509_J__() {
        return this.field_70180_af.func_187225_a(field_184714_b);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_70831_j(float p_70831_1_) {
        return MathHelper.func_219799_g((float)p_70831_1_, (float)this.field_70834_e, (float)this.field_70833_d) / (float)(this.field_82225_f - 2);
    }

    public int func_70832_p() {
        return this.field_70180_af.func_187225_a(field_184713_a);
    }

    public void func_70829_a(int p_70829_1_) {
        this.field_70180_af.func_187227_b(field_184713_a, p_70829_1_);
    }

    @Override
    public void func_241841_a(ServerWorld p_241841_1_, LightningBoltEntity p_241841_2_) {
        super.func_241841_a(p_241841_1_, p_241841_2_);
        if (CraftEventFactory.callCreeperPowerEvent((Entity)this, (Entity)p_241841_2_, (CreeperPowerEvent.PowerCause)CreeperPowerEvent.PowerCause.LIGHTNING).isCancelled()) {
            return;
        }
        this.setPowered(true);
    }

    public void setPowered(boolean powered) {
        this.field_70180_af.func_187227_b(field_184714_b, powered);
    }

    @Override
    protected ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (itemstack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(p_230254_1_, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            if (!this.field_70170_p.field_72995_K) {
                this.func_146079_cb();
                itemstack.func_222118_a(1, p_230254_1_, p_213625_1_ -> p_213625_1_.func_213334_d(p_230254_2_));
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    public void func_146077_cc() {
        if (!this.field_70170_p.field_72995_K) {
            Explosion.Mode explosion$mode = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
            float f = this.func_225509_J__() ? 2.0f : 1.0f;
            ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (float)this.field_82226_g * f, false);
            this.field_70170_p.getCBServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.field_70729_aU = true;
                this.field_70170_p.func_217398_a(this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), event.getRadius(), event.getFire(), explosion$mode);
                this.func_70106_y();
                this.func_190741_do();
            } else {
                this.field_70833_d = 0;
            }
        }
    }

    private void func_190741_do() {
        Collection<EffectInstance> collection = this.func_70651_bq();
        if (!collection.isEmpty()) {
            AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            areaeffectcloudentity.func_184481_a(this);
            areaeffectcloudentity.func_184483_a(2.5f);
            areaeffectcloudentity.func_184495_b(-0.5f);
            areaeffectcloudentity.func_184485_d(10);
            areaeffectcloudentity.func_184486_b(areaeffectcloudentity.func_184489_o() / 2);
            areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
            for (EffectInstance effectinstance : collection) {
                areaeffectcloudentity.func_184496_a(new EffectInstance(effectinstance));
            }
            this.field_70170_p.addEntity(areaeffectcloudentity, CreatureSpawnEvent.SpawnReason.EXPLOSION);
        }
    }

    public boolean func_146078_ca() {
        return this.field_70180_af.func_187225_a(field_184715_c);
    }

    public void func_146079_cb() {
        this.field_70180_af.func_187227_b(field_184715_c, true);
    }

    public boolean func_70650_aV() {
        return this.func_225509_J__() && this.field_175494_bm < 1;
    }

    public void func_175493_co() {
        ++this.field_175494_bm;
    }
}

