/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GhastEntity
extends FlyingEntity
implements IMob {
    private static final DataParameter<Boolean> field_184683_a = EntityDataManager.func_187226_a(GhastEntity.class, DataSerializers.field_187198_h);
    private int field_92014_j = 1;

    public GhastEntity(EntityType<? extends GhastEntity> p_i50206_1_, World p_i50206_2_) {
        super((EntityType<? extends FlyingEntity>)p_i50206_1_, p_i50206_2_);
        this.field_70728_aV = 5;
        this.field_70765_h = new MoveHelperController(this);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomFlyGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAroundGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new FireballAttackGoal(this));
        this.field_70715_bh.func_75776_a(1, new NearestAttackableTargetGoal<PlayerEntity>(this, PlayerEntity.class, 10, true, false, p_213812_1_ -> Math.abs(p_213812_1_.func_226278_cu_() - this.func_226278_cu_()) <= 4.0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_110182_bF() {
        return this.field_70180_af.func_187225_a(field_184683_a);
    }

    public void func_175454_a(boolean p_175454_1_) {
        this.field_70180_af.func_187227_b(field_184683_a, p_175454_1_);
    }

    public int func_175453_cd() {
        return this.field_92014_j;
    }

    @Override
    protected boolean func_225511_J_() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        if (p_70097_1_.func_76364_f() instanceof FireballEntity && p_70097_1_.func_76346_g() instanceof PlayerEntity) {
            super.func_70097_a(p_70097_1_, 1000.0f);
            return true;
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184683_a, false);
    }

    public static AttributeModifierMap.MutableAttribute func_234290_eH_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233819_b_, 100.0);
    }

    @Override
    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187551_bH;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187555_bJ;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187553_bI;
    }

    @Override
    protected float func_70599_aP() {
        return 5.0f;
    }

    public static boolean func_223368_b(EntityType<GhastEntity> p_223368_0_, IWorld p_223368_1_, SpawnReason p_223368_2_, BlockPos p_223368_3_, Random p_223368_4_) {
        return p_223368_1_.func_175659_aa() != Difficulty.PEACEFUL && p_223368_4_.nextInt(20) == 0 && GhastEntity.func_223315_a(p_223368_0_, p_223368_1_, p_223368_2_, p_223368_3_, p_223368_4_);
    }

    @Override
    public int func_70641_bl() {
        return 1;
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74768_a("ExplosionPower", this.field_92014_j);
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        if (p_70037_1_.func_150297_b("ExplosionPower", 99)) {
            this.field_92014_j = p_70037_1_.func_74762_e("ExplosionPower");
        }
    }

    @Override
    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return 2.6f;
    }

    static class RandomFlyGoal
    extends Goal {
        private final GhastEntity field_179454_a;

        public RandomFlyGoal(GhastEntity p_i45836_1_) {
            this.field_179454_a = p_i45836_1_;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            MovementController movementcontroller = this.field_179454_a.func_70605_aq();
            if (!movementcontroller.func_75640_a()) {
                return true;
            }
            double d0 = movementcontroller.func_179917_d() - this.field_179454_a.func_226277_ct_();
            double d3 = d0 * d0 + (d1 = movementcontroller.func_179919_e() - this.field_179454_a.func_226278_cu_()) * d1 + (d2 = movementcontroller.func_179918_f() - this.field_179454_a.func_226281_cx_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.field_179454_a.func_70681_au();
            double d0 = this.field_179454_a.func_226277_ct_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.field_179454_a.func_226278_cu_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.field_179454_a.func_226281_cx_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.field_179454_a.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final GhastEntity field_179927_g;
        private int field_179928_h;

        public MoveHelperController(GhastEntity p_i45838_1_) {
            super((MobEntity)p_i45838_1_);
            this.field_179927_g = p_i45838_1_;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && this.field_179928_h-- <= 0) {
                this.field_179928_h += this.field_179927_g.func_70681_au().nextInt(5) + 2;
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.field_179927_g.func_226277_ct_(), this.field_75647_c - this.field_179927_g.func_226278_cu_(), this.field_75644_d - this.field_179927_g.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                if (this.func_220673_a(vector3d = vector3d.func_72432_b(), MathHelper.func_76143_f((double)d0))) {
                    this.field_179927_g.func_213317_d(this.field_179927_g.func_213322_ci().func_178787_e(vector3d.func_186678_a(0.1)));
                } else {
                    this.field_188491_h = MovementController.Action.WAIT;
                }
            }
        }

        private boolean func_220673_a(Vector3d p_220673_1_, int p_220673_2_) {
            AxisAlignedBB axisalignedbb = this.field_179927_g.func_174813_aQ();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.field_179927_g.field_70170_p.func_226665_a__(this.field_179927_g, axisalignedbb = axisalignedbb.func_191194_a(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final GhastEntity field_179472_a;

        public LookAroundGoal(GhastEntity p_i45839_1_) {
            this.field_179472_a = p_i45839_1_;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.field_179472_a.func_70638_az() == null) {
                Vector3d vector3d = this.field_179472_a.func_213322_ci();
                this.field_179472_a.field_70761_aq = this.field_179472_a.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c)) * 57.295776f;
            } else {
                LivingEntity livingentity = this.field_179472_a.func_70638_az();
                double d0 = 64.0;
                if (livingentity.func_70068_e(this.field_179472_a) < 4096.0) {
                    double d1 = livingentity.func_226277_ct_() - this.field_179472_a.func_226277_ct_();
                    double d2 = livingentity.func_226281_cx_() - this.field_179472_a.func_226281_cx_();
                    this.field_179472_a.field_70761_aq = this.field_179472_a.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    static class FireballAttackGoal
    extends Goal {
        private final GhastEntity field_179470_b;
        public int field_179471_a;

        public FireballAttackGoal(GhastEntity p_i45837_1_) {
            this.field_179470_b = p_i45837_1_;
        }

        public boolean func_75250_a() {
            return this.field_179470_b.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.field_179471_a = 0;
        }

        public void func_75251_c() {
            this.field_179470_b.func_175454_a(false);
        }

        public void func_75246_d() {
            LivingEntity livingentity = this.field_179470_b.func_70638_az();
            double d0 = 64.0;
            if (livingentity.func_70068_e(this.field_179470_b) < 4096.0 && this.field_179470_b.func_70685_l(livingentity)) {
                World world = this.field_179470_b.field_70170_p;
                ++this.field_179471_a;
                if (this.field_179471_a == 10 && !this.field_179470_b.func_174814_R()) {
                    world.func_217378_a(null, 1015, this.field_179470_b.func_233580_cy_(), 0);
                }
                if (this.field_179471_a == 20) {
                    double d1 = 4.0;
                    Vector3d vector3d = this.field_179470_b.func_70676_i(1.0f);
                    double d2 = livingentity.func_226277_ct_() - (this.field_179470_b.func_226277_ct_() + vector3d.field_72450_a * 4.0);
                    double d3 = livingentity.func_226283_e_(0.5) - (0.5 + this.field_179470_b.func_226283_e_(0.5));
                    double d4 = livingentity.func_226281_cx_() - (this.field_179470_b.func_226281_cx_() + vector3d.field_72449_c * 4.0);
                    if (!this.field_179470_b.func_174814_R()) {
                        world.func_217378_a(null, 1016, this.field_179470_b.func_233580_cy_(), 0);
                    }
                    FireballEntity fireballentity = new FireballEntity(world, this.field_179470_b, d2, d3, d4);
                    fireballentity.field_92057_e = this.field_179470_b.func_175453_cd();
                    fireballentity.bukkitYield = fireballentity.field_92057_e;
                    fireballentity.func_70107_b(this.field_179470_b.func_226277_ct_() + vector3d.field_72450_a * 4.0, this.field_179470_b.func_226283_e_(0.5) + 0.5, fireballentity.func_226281_cx_() + vector3d.field_72449_c * 4.0);
                    world.func_217376_c(fireballentity);
                    this.field_179471_a = -40;
                }
            } else if (this.field_179471_a > 0) {
                --this.field_179471_a;
            }
            this.field_179470_b.func_175454_a(this.field_179471_a > 10);
        }
    }
}

