/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.bukkit.event.entity.EntityTargetEvent;

public class PhantomEntity
extends FlyingEntity
implements IMob {
    private static final DataParameter<Integer> field_203035_a = EntityDataManager.func_187226_a(PhantomEntity.class, DataSerializers.field_187192_b);
    private Vector3d field_203036_b = Vector3d.field_186680_a;
    private BlockPos field_203037_c = BlockPos.field_177992_a;
    private AttackPhase field_203038_bx = AttackPhase.CIRCLE;

    public PhantomEntity(EntityType<? extends PhantomEntity> p_i50200_1_, World p_i50200_2_) {
        super((EntityType<? extends FlyingEntity>)p_i50200_1_, p_i50200_2_);
        this.field_70728_aV = 5;
        this.field_70765_h = new MoveHelperController(this);
        this.field_70749_g = new LookHelperController(this);
    }

    @Override
    protected BodyController func_184650_s() {
        return new BodyHelperController(this);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new PickAttackGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new SweepAttackGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new OrbitPointGoal());
        this.field_70715_bh.func_75776_a(1, (Goal)new AttackPlayerGoal());
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_203035_a, 0);
    }

    public void func_203034_a(int p_203034_1_) {
        this.field_70180_af.func_187227_b(field_203035_a, MathHelper.func_76125_a((int)p_203034_1_, (int)0, (int)64));
    }

    private void func_203033_m() {
        this.func_213323_x_();
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(6 + this.func_203032_dq());
    }

    public int func_203032_dq() {
        return this.field_70180_af.func_187225_a(field_203035_a);
    }

    @Override
    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return p_213348_2_.field_220316_b * 0.35f;
    }

    @Override
    public void func_184206_a(DataParameter<?> p_184206_1_) {
        if (field_203035_a.equals(p_184206_1_)) {
            this.func_203033_m();
        }
        super.func_184206_a(p_184206_1_);
    }

    @Override
    protected boolean func_225511_J_() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            float f = MathHelper.func_76134_b((float)((float)(this.func_145782_y() * 3 + this.field_70173_aa) * 0.13f + (float)Math.PI));
            float f1 = MathHelper.func_76134_b((float)((float)(this.func_145782_y() * 3 + this.field_70173_aa + 1) * 0.13f + (float)Math.PI));
            if (f > 0.0f && f1 <= 0.0f) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_206944_gn, this.func_184176_by(), 0.95f + this.field_70146_Z.nextFloat() * 0.05f, 0.95f + this.field_70146_Z.nextFloat() * 0.05f, false);
            }
            int i = this.func_203032_dq();
            float f2 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f3 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f4 = (0.3f + f * 0.45f) * ((float)i * 0.2f + 1.0f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197596_G, this.func_226277_ct_() + (double)f2, this.func_226278_cu_() + (double)f4, this.func_226281_cx_() + (double)f3, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197596_G, this.func_226277_ct_() - (double)f2, this.func_226278_cu_() + (double)f4, this.func_226281_cx_() - (double)f3, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void func_70636_d() {
        if (this.func_70089_S() && this.func_204609_dp()) {
            this.func_70015_d(8);
        }
        super.func_70636_d();
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        this.field_203037_c = this.func_233580_cy_().func_177981_b(5);
        this.func_203034_a(0);
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        if (p_70037_1_.func_74764_b("AX")) {
            this.field_203037_c = new BlockPos(p_70037_1_.func_74762_e("AX"), p_70037_1_.func_74762_e("AY"), p_70037_1_.func_74762_e("AZ"));
        }
        this.func_203034_a(p_70037_1_.func_74762_e("Size"));
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74768_a("AX", this.field_203037_c.func_177958_n());
        p_213281_1_.func_74768_a("AY", this.field_203037_c.func_177956_o());
        p_213281_1_.func_74768_a("AZ", this.field_203037_c.func_177952_p());
        p_213281_1_.func_74768_a("Size", this.func_203032_dq());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        return true;
    }

    @Override
    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203256_ft;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_203259_fw;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203258_fv;
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    @Override
    protected float func_70599_aP() {
        return 1.0f;
    }

    @Override
    public boolean func_213358_a(EntityType<?> p_213358_1_) {
        return true;
    }

    @Override
    public EntitySize func_213305_a(Pose p_213305_1_) {
        int i = this.func_203032_dq();
        EntitySize entitysize = super.func_213305_a(p_213305_1_);
        float f = (entitysize.field_220315_a + 0.2f * (float)i) / entitysize.field_220315_a;
        return entitysize.func_220313_a(f);
    }

    class SweepAttackGoal
    extends MoveGoal {
        private SweepAttackGoal() {
        }

        public boolean func_75250_a() {
            return PhantomEntity.this.func_70638_az() != null && PhantomEntity.this.field_203038_bx == AttackPhase.SWOOP;
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = PhantomEntity.this.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            if (!(livingentity instanceof PlayerEntity) || !((PlayerEntity)livingentity).func_175149_v() && !((PlayerEntity)livingentity).func_184812_l_()) {
                List<Entity> list;
                if (!this.func_75250_a()) {
                    return false;
                }
                if (PhantomEntity.this.field_70173_aa % 20 == 0 && !(list = PhantomEntity.this.field_70170_p.func_175647_a(CatEntity.class, PhantomEntity.this.func_174813_aQ().func_186662_g(16.0), EntityPredicates.field_94557_a)).isEmpty()) {
                    for (CatEntity catEntity : list) {
                        catEntity.func_213420_ej();
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        public void func_75249_e() {
        }

        public void func_75251_c() {
            PhantomEntity.this.func_70624_b(null);
            PhantomEntity.this.field_203038_bx = AttackPhase.CIRCLE;
        }

        public void func_75246_d() {
            LivingEntity livingentity = PhantomEntity.this.func_70638_az();
            PhantomEntity.this.field_203036_b = new Vector3d(livingentity.func_226277_ct_(), livingentity.func_226283_e_(0.5), livingentity.func_226281_cx_());
            if (PhantomEntity.this.func_174813_aQ().func_186662_g(0.2f).func_72326_a(livingentity.func_174813_aQ())) {
                PhantomEntity.this.func_70652_k(livingentity);
                PhantomEntity.this.field_203038_bx = AttackPhase.CIRCLE;
                if (!PhantomEntity.this.func_174814_R()) {
                    PhantomEntity.this.field_70170_p.func_217379_c(1039, PhantomEntity.this.func_233580_cy_(), 0);
                }
            } else if (PhantomEntity.this.field_70123_F || PhantomEntity.this.field_70737_aN > 0) {
                PhantomEntity.this.field_203038_bx = AttackPhase.CIRCLE;
            }
        }
    }

    class PickAttackGoal
    extends Goal {
        private int field_203145_b;

        private PickAttackGoal() {
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = PhantomEntity.this.func_70638_az();
            return livingentity != null ? PhantomEntity.this.func_213344_a(PhantomEntity.this.func_70638_az(), EntityPredicate.field_221016_a) : false;
        }

        public void func_75249_e() {
            this.field_203145_b = 10;
            PhantomEntity.this.field_203038_bx = AttackPhase.CIRCLE;
            this.func_203143_f();
        }

        public void func_75251_c() {
            PhantomEntity.this.field_203037_c = PhantomEntity.this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, PhantomEntity.this.field_203037_c).func_177981_b(10 + PhantomEntity.this.field_70146_Z.nextInt(20));
        }

        public void func_75246_d() {
            if (PhantomEntity.this.field_203038_bx == AttackPhase.CIRCLE) {
                --this.field_203145_b;
                if (this.field_203145_b <= 0) {
                    PhantomEntity.this.field_203038_bx = AttackPhase.SWOOP;
                    this.func_203143_f();
                    this.field_203145_b = (8 + PhantomEntity.this.field_70146_Z.nextInt(4)) * 20;
                    PhantomEntity.this.func_184185_a(SoundEvents.field_203260_fx, 10.0f, 0.95f + PhantomEntity.this.field_70146_Z.nextFloat() * 0.1f);
                }
            }
        }

        private void func_203143_f() {
            PhantomEntity.this.field_203037_c = PhantomEntity.this.func_70638_az().func_233580_cy_().func_177981_b(20 + PhantomEntity.this.field_70146_Z.nextInt(20));
            if (PhantomEntity.this.field_203037_c.func_177956_o() < PhantomEntity.this.field_70170_p.func_181545_F()) {
                PhantomEntity.this.field_203037_c = new BlockPos(PhantomEntity.this.field_203037_c.func_177958_n(), PhantomEntity.this.field_70170_p.func_181545_F() + 1, PhantomEntity.this.field_203037_c.func_177952_p());
            }
        }
    }

    class OrbitPointGoal
    extends MoveGoal {
        private float field_203150_c;
        private float field_203151_d;
        private float field_203152_e;
        private float field_203153_f;

        private OrbitPointGoal() {
        }

        public boolean func_75250_a() {
            return PhantomEntity.this.func_70638_az() == null || PhantomEntity.this.field_203038_bx == AttackPhase.CIRCLE;
        }

        public void func_75249_e() {
            this.field_203151_d = 5.0f + PhantomEntity.this.field_70146_Z.nextFloat() * 10.0f;
            this.field_203152_e = -4.0f + PhantomEntity.this.field_70146_Z.nextFloat() * 9.0f;
            this.field_203153_f = PhantomEntity.this.field_70146_Z.nextBoolean() ? 1.0f : -1.0f;
            this.func_203148_i();
        }

        public void func_75246_d() {
            if (PhantomEntity.this.field_70146_Z.nextInt(350) == 0) {
                this.field_203152_e = -4.0f + PhantomEntity.this.field_70146_Z.nextFloat() * 9.0f;
            }
            if (PhantomEntity.this.field_70146_Z.nextInt(250) == 0) {
                this.field_203151_d += 1.0f;
                if (this.field_203151_d > 15.0f) {
                    this.field_203151_d = 5.0f;
                    this.field_203153_f = -this.field_203153_f;
                }
            }
            if (PhantomEntity.this.field_70146_Z.nextInt(450) == 0) {
                this.field_203150_c = PhantomEntity.this.field_70146_Z.nextFloat() * 2.0f * (float)Math.PI;
                this.func_203148_i();
            }
            if (this.func_203146_f()) {
                this.func_203148_i();
            }
            if (((PhantomEntity)PhantomEntity.this).field_203036_b.field_72448_b < PhantomEntity.this.func_226278_cu_() && !PhantomEntity.this.field_70170_p.func_175623_d(PhantomEntity.this.func_233580_cy_().func_177979_c(1))) {
                this.field_203152_e = Math.max(1.0f, this.field_203152_e);
                this.func_203148_i();
            }
            if (((PhantomEntity)PhantomEntity.this).field_203036_b.field_72448_b > PhantomEntity.this.func_226278_cu_() && !PhantomEntity.this.field_70170_p.func_175623_d(PhantomEntity.this.func_233580_cy_().func_177981_b(1))) {
                this.field_203152_e = Math.min(-1.0f, this.field_203152_e);
                this.func_203148_i();
            }
        }

        private void func_203148_i() {
            if (BlockPos.field_177992_a.equals(PhantomEntity.this.field_203037_c)) {
                PhantomEntity.this.field_203037_c = PhantomEntity.this.func_233580_cy_();
            }
            this.field_203150_c += this.field_203153_f * 15.0f * ((float)Math.PI / 180);
            PhantomEntity.this.field_203036_b = Vector3d.func_237491_b_(PhantomEntity.this.field_203037_c).func_72441_c(this.field_203151_d * MathHelper.func_76134_b((float)this.field_203150_c), -4.0f + this.field_203152_e, this.field_203151_d * MathHelper.func_76126_a((float)this.field_203150_c));
        }
    }

    class MoveHelperController
    extends MovementController {
        private float field_203105_j;

        public MoveHelperController(MobEntity p_i48801_2_) {
            super(p_i48801_2_);
            this.field_203105_j = 0.1f;
        }

        public void func_75641_c() {
            float f7;
            if (PhantomEntity.this.field_70123_F) {
                PhantomEntity.this.field_70177_z += 180.0f;
                this.field_203105_j = 0.1f;
            }
            float f = (float)(((PhantomEntity)PhantomEntity.this).field_203036_b.field_72450_a - PhantomEntity.this.func_226277_ct_());
            float f1 = (float)(((PhantomEntity)PhantomEntity.this).field_203036_b.field_72448_b - PhantomEntity.this.func_226278_cu_());
            float f2 = (float)(((PhantomEntity)PhantomEntity.this).field_203036_b.field_72449_c - PhantomEntity.this.func_226281_cx_());
            double d0 = MathHelper.func_76129_c((float)(f * f + f2 * f2));
            double d1 = 1.0 - (double)MathHelper.func_76135_e((float)(f1 * 0.7f)) / d0;
            f = (float)((double)f * d1);
            f2 = (float)((double)f2 * d1);
            d0 = MathHelper.func_76129_c((float)(f * f + f2 * f2));
            double d2 = MathHelper.func_76129_c((float)(f * f + f2 * f2 + f1 * f1));
            float f3 = PhantomEntity.this.field_70177_z;
            float f4 = (float)MathHelper.func_181159_b((double)f2, (double)f);
            float f5 = MathHelper.func_76142_g((float)(PhantomEntity.this.field_70177_z + 90.0f));
            float f6 = MathHelper.func_76142_g((float)(f4 * 57.295776f));
            PhantomEntity.this.field_70761_aq = PhantomEntity.this.field_70177_z = MathHelper.func_203303_c((float)f5, (float)f6, (float)4.0f) - 90.0f;
            this.field_203105_j = MathHelper.func_203301_d((float)f3, (float)PhantomEntity.this.field_70177_z) < 3.0f ? MathHelper.func_203300_b((float)this.field_203105_j, (float)1.8f, (float)(0.005f * (1.8f / this.field_203105_j))) : MathHelper.func_203300_b((float)this.field_203105_j, (float)0.2f, (float)0.025f);
            PhantomEntity.this.field_70125_A = f7 = (float)(-(MathHelper.func_181159_b((double)(-f1), (double)d0) * 57.2957763671875));
            float f8 = PhantomEntity.this.field_70177_z + 90.0f;
            double d3 = (double)(this.field_203105_j * MathHelper.func_76134_b((float)(f8 * ((float)Math.PI / 180)))) * Math.abs((double)f / d2);
            double d4 = (double)(this.field_203105_j * MathHelper.func_76126_a((float)(f8 * ((float)Math.PI / 180)))) * Math.abs((double)f2 / d2);
            double d5 = (double)(this.field_203105_j * MathHelper.func_76126_a((float)(f7 * ((float)Math.PI / 180)))) * Math.abs((double)f1 / d2);
            Vector3d vector3d = PhantomEntity.this.func_213322_ci();
            PhantomEntity.this.func_213317_d(vector3d.func_178787_e(new Vector3d(d3, d5, d4).func_178788_d(vector3d).func_186678_a(0.2)));
        }
    }

    abstract class MoveGoal
    extends Goal {
        public MoveGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean func_203146_f() {
            return PhantomEntity.this.field_203036_b.func_186679_c(PhantomEntity.this.func_226277_ct_(), PhantomEntity.this.func_226278_cu_(), PhantomEntity.this.func_226281_cx_()) < 4.0;
        }
    }

    class LookHelperController
    extends LookController {
        public LookHelperController(MobEntity p_i48802_2_) {
            super(p_i48802_2_);
        }

        public void func_75649_a() {
        }
    }

    class BodyHelperController
    extends BodyController {
        public BodyHelperController(MobEntity p_i49925_2_) {
            super(p_i49925_2_);
        }

        public void func_75664_a() {
            PhantomEntity.this.field_70759_as = PhantomEntity.this.field_70761_aq;
            PhantomEntity.this.field_70761_aq = PhantomEntity.this.field_70177_z;
        }
    }

    class AttackPlayerGoal
    extends Goal {
        private final EntityPredicate field_220842_b = new EntityPredicate().func_221013_a(64.0);
        private int field_203142_b = 20;

        private AttackPlayerGoal() {
        }

        public boolean func_75250_a() {
            if (this.field_203142_b > 0) {
                --this.field_203142_b;
                return false;
            }
            this.field_203142_b = 60;
            List list = PhantomEntity.this.field_70170_p.func_217373_a(this.field_220842_b, PhantomEntity.this, PhantomEntity.this.func_174813_aQ().func_72314_b(16.0, 64.0, 16.0));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(Entity::func_226278_cu_).reversed());
                for (PlayerEntity playerentity : list) {
                    if (!PhantomEntity.this.func_213344_a(playerentity, EntityPredicate.field_221016_a)) continue;
                    PhantomEntity.this.setGoalTarget(playerentity, EntityTargetEvent.TargetReason.CLOSEST_PLAYER, true);
                    return true;
                }
            }
            return false;
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = PhantomEntity.this.func_70638_az();
            return livingentity != null ? PhantomEntity.this.func_213344_a(livingentity, EntityPredicate.field_221016_a) : false;
        }
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }
}

