/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;

public abstract class SpellcastingIllagerEntity
extends AbstractIllagerEntity {
    private static final DataParameter<Byte> field_193088_c = EntityDataManager.func_187226_a(SpellcastingIllagerEntity.class, DataSerializers.field_187191_a);
    protected int field_193087_b;
    private SpellType field_193089_bx = SpellType.NONE;

    protected SpellcastingIllagerEntity(EntityType<? extends SpellcastingIllagerEntity> p_i48551_1_, World p_i48551_2_) {
        super(p_i48551_1_, p_i48551_2_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_193088_c, (byte)0);
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.field_193087_b = p_70037_1_.func_74762_e("SpellTicks");
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74768_a("SpellTicks", this.field_193087_b);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractIllagerEntity.ArmPose func_193077_p() {
        if (this.func_193082_dl()) {
            return AbstractIllagerEntity.ArmPose.SPELLCASTING;
        }
        return this.func_213656_en() ? AbstractIllagerEntity.ArmPose.CELEBRATING : AbstractIllagerEntity.ArmPose.CROSSED;
    }

    public boolean func_193082_dl() {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_187225_a(field_193088_c) > 0;
        }
        return this.field_193087_b > 0;
    }

    public void func_193081_a(SpellType p_193081_1_) {
        this.field_193089_bx = p_193081_1_;
        this.field_70180_af.func_187227_b(field_193088_c, (byte)p_193081_1_.field_193345_g);
    }

    public SpellType func_193083_dm() {
        return !this.field_70170_p.field_72995_K ? this.field_193089_bx : SpellType.func_193337_a(this.field_70180_af.func_187225_a(field_193088_c).byteValue());
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.field_193087_b > 0) {
            --this.field_193087_b;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.func_193082_dl()) {
            SpellType spellcastingillagerentity$spelltype = this.func_193083_dm();
            double d0 = spellcastingillagerentity$spelltype.field_193346_h[0];
            double d1 = spellcastingillagerentity$spelltype.field_193346_h[1];
            double d2 = spellcastingillagerentity$spelltype.field_193346_h[2];
            float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.25f;
            float f1 = MathHelper.func_76134_b((float)f);
            float f2 = MathHelper.func_76126_a((float)f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + (double)f1 * 0.6, this.func_226278_cu_() + 1.8, this.func_226281_cx_() + (double)f2 * 0.6, d0, d1, d2);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() - (double)f1 * 0.6, this.func_226278_cu_() + 1.8, this.func_226281_cx_() - (double)f2 * 0.6, d0, d1, d2);
        }
    }

    protected int func_193085_dn() {
        return this.field_193087_b;
    }

    protected abstract SoundEvent func_193086_dk();

    public abstract class UseSpellGoal
    extends Goal {
        protected int field_193321_c;
        protected int field_193322_d;

        protected UseSpellGoal() {
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = SpellcastingIllagerEntity.this.func_70638_az();
            if (livingentity != null && livingentity.func_70089_S()) {
                if (SpellcastingIllagerEntity.this.func_193082_dl()) {
                    return false;
                }
                return SpellcastingIllagerEntity.this.field_70173_aa >= this.field_193322_d;
            }
            return false;
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = SpellcastingIllagerEntity.this.func_70638_az();
            return livingentity != null && livingentity.func_70089_S() && this.field_193321_c > 0;
        }

        public void func_75249_e() {
            this.field_193321_c = this.func_190867_m();
            SpellcastingIllagerEntity.this.field_193087_b = this.func_190869_f();
            this.field_193322_d = SpellcastingIllagerEntity.this.field_70173_aa + this.func_190872_i();
            SoundEvent soundevent = this.func_190871_k();
            if (soundevent != null) {
                SpellcastingIllagerEntity.this.func_184185_a(soundevent, 1.0f, 1.0f);
            }
            SpellcastingIllagerEntity.this.func_193081_a(this.func_193320_l());
        }

        public void func_75246_d() {
            --this.field_193321_c;
            if (this.field_193321_c == 0) {
                if (!CraftEventFactory.handleEntitySpellCastEvent((SpellcastingIllagerEntity)SpellcastingIllagerEntity.this, (SpellType)this.func_193320_l())) {
                    return;
                }
                this.func_190868_j();
                SpellcastingIllagerEntity.this.func_184185_a(SpellcastingIllagerEntity.this.func_193086_dk(), 1.0f, 1.0f);
            }
        }

        protected abstract void func_190868_j();

        protected int func_190867_m() {
            return 20;
        }

        protected abstract int func_190869_f();

        protected abstract int func_190872_i();

        @Nullable
        protected abstract SoundEvent func_190871_k();

        protected abstract SpellType func_193320_l();
    }

    public static enum SpellType {
        NONE(0, 0.0, 0.0, 0.0),
        SUMMON_VEX(1, 0.7, 0.7, 0.8),
        FANGS(2, 0.4, 0.3, 0.35),
        WOLOLO(3, 0.7, 0.5, 0.2),
        DISAPPEAR(4, 0.3, 0.3, 0.8),
        BLINDNESS(5, 0.1, 0.1, 0.2);

        private final int field_193345_g;
        private final double[] field_193346_h;

        private SpellType(int p_i47561_3_, double p_i47561_4_, double p_i47561_6_, double p_i47561_8_) {
            this.field_193345_g = p_i47561_3_;
            this.field_193346_h = new double[]{p_i47561_4_, p_i47561_6_, p_i47561_8_};
        }

        public static SpellType func_193337_a(int p_193337_0_) {
            for (SpellType spellcastingillagerentity$spelltype : SpellType.values()) {
                if (p_193337_0_ != spellcastingillagerentity$spelltype.field_193345_g) continue;
                return spellcastingillagerentity$spelltype;
            }
            return NONE;
        }
    }

    public class CastingASpellGoal
    extends Goal {
        public CastingASpellGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return SpellcastingIllagerEntity.this.func_193085_dn() > 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
            SpellcastingIllagerEntity.this.field_70699_by.func_75499_g();
        }

        public void func_75251_c() {
            super.func_75251_c();
            SpellcastingIllagerEntity.this.func_193081_a(SpellType.NONE);
        }

        public void func_75246_d() {
            if (SpellcastingIllagerEntity.this.func_70638_az() != null) {
                SpellcastingIllagerEntity.this.func_70671_ap().func_75651_a((Entity)SpellcastingIllagerEntity.this.func_70638_az(), (float)SpellcastingIllagerEntity.this.func_184649_cE(), (float)SpellcastingIllagerEntity.this.func_70646_bf());
            }
        }
    }
}

