/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LandOnOwnersShoulderGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.passive.ShoulderRidingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class ParrotEntity
extends ShoulderRidingEntity
implements IFlyingAnimal {
    private static final DataParameter<Integer> field_192013_bG = EntityDataManager.func_187226_a(ParrotEntity.class, DataSerializers.field_187192_b);
    private static final Predicate<MobEntity> field_192014_bH = new Predicate<MobEntity>(){

        @Override
        public boolean test(@Nullable MobEntity p_test_1_) {
            return p_test_1_ != null && field_192017_bK.containsKey(p_test_1_.func_200600_R());
        }
    };
    private static final Item field_192015_bI = Items.field_151106_aX;
    private static final Set<Item> field_192016_bJ = Sets.newHashSet((Object[])new Item[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    private static final Map<EntityType<?>, SoundEvent> field_192017_bK = Util.func_200696_a(Maps.newHashMap(), p_200609_0_ -> {
        p_200609_0_.put(EntityType.field_200792_f, SoundEvents.field_193791_eM);
        p_200609_0_.put(EntityType.field_200794_h, SoundEvents.field_193813_fc);
        p_200609_0_.put(EntityType.field_200797_k, SoundEvents.field_193792_eN);
        p_200609_0_.put(EntityType.field_204724_o, SoundEvents.field_206942_fI);
        p_200609_0_.put(EntityType.field_200800_n, SoundEvents.field_193793_eO);
        p_200609_0_.put(EntityType.field_200802_p, SoundEvents.field_193794_eP);
        p_200609_0_.put(EntityType.field_200804_r, SoundEvents.field_193796_eR);
        p_200609_0_.put(EntityType.field_200806_t, SoundEvents.field_193797_eS);
        p_200609_0_.put(EntityType.field_200811_y, SoundEvents.field_193798_eT);
        p_200609_0_.put(EntityType.field_200761_A, SoundEvents.field_219654_hI);
        p_200609_0_.put(EntityType.field_233588_G_, SoundEvents.field_232796_kj_);
        p_200609_0_.put(EntityType.field_200763_C, SoundEvents.field_193799_eU);
        p_200609_0_.put(EntityType.field_200764_D, SoundEvents.field_193800_eV);
        p_200609_0_.put(EntityType.field_200771_K, SoundEvents.field_193801_eW);
        p_200609_0_.put(EntityType.field_203097_aH, SoundEvents.field_206943_fS);
        p_200609_0_.put(EntityType.field_233591_ai_, SoundEvents.field_232797_ko_);
        p_200609_0_.put(EntityType.field_242287_aj, SoundEvents.field_242131_kp);
        p_200609_0_.put(EntityType.field_220350_aJ, SoundEvents.field_219656_hO);
        p_200609_0_.put(EntityType.field_220352_aU, SoundEvents.field_219657_hQ);
        p_200609_0_.put(EntityType.field_200738_ad, SoundEvents.field_193803_eY);
        p_200609_0_.put(EntityType.field_200740_af, SoundEvents.field_193804_eZ);
        p_200609_0_.put(EntityType.field_200741_ag, SoundEvents.field_193811_fa);
        p_200609_0_.put(EntityType.field_200743_ai, SoundEvents.field_193812_fb);
        p_200609_0_.put(EntityType.field_200748_an, SoundEvents.field_193813_fc);
        p_200609_0_.put(EntityType.field_200750_ap, SoundEvents.field_193814_fd);
        p_200609_0_.put(EntityType.field_200755_au, SoundEvents.field_193815_fe);
        p_200609_0_.put(EntityType.field_200758_ax, SoundEvents.field_193816_ff);
        p_200609_0_.put(EntityType.field_200759_ay, SoundEvents.field_193817_fg);
        p_200609_0_.put(EntityType.field_200760_az, SoundEvents.field_193818_fh);
        p_200609_0_.put(EntityType.field_200722_aA, SoundEvents.field_193819_fi);
        p_200609_0_.put(EntityType.field_233590_aW_, SoundEvents.field_232786_kC_);
        p_200609_0_.put(EntityType.field_200725_aD, SoundEvents.field_193821_fk);
        p_200609_0_.put(EntityType.field_200727_aF, SoundEvents.field_193823_fm);
    });
    public float field_192008_bB;
    public float field_192009_bC;
    public float field_192010_bD;
    public float field_192011_bE;
    private float field_192012_bF = 1.0f;
    private boolean field_192018_bL;
    private BlockPos field_192019_bM;

    public ParrotEntity(EntityType<? extends ParrotEntity> p_i50251_1_, World p_i50251_2_) {
        super(p_i50251_1_, p_i50251_2_);
        this.field_70765_h = new FlyingMovementController((MobEntity)((Object)this), 10, false);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        this.func_191997_m(this.field_70146_Z.nextInt(5));
        if (p_213386_4_ == null) {
            p_213386_4_ = new AgeableEntity.AgeableData(false);
        }
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    public boolean func_70631_g_() {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)((Object)this), 1.25));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 5.0f, 1.0f, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)((Object)this), 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new LandOnOwnersShoulderGoal((ShoulderRidingEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowMobGoal((MobEntity)((Object)this), 1.0, 3.0f, 7.0f));
    }

    public static AttributeModifierMap.MutableAttribute func_234213_eS_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233822_e_, 0.4f).func_233815_a_(Attributes.field_233821_d_, 0.2f);
    }

    protected PathNavigator func_175447_b(World p_175447_1_) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)((Object)this), p_175447_1_);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(true);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return p_213348_2_.field_220316_b * 0.6f;
    }

    public void func_70636_d() {
        if (this.field_192019_bM == null || !this.field_192019_bM.func_218137_a(this.func_213303_ch(), 3.46) || !this.field_70170_p.func_180495_p(this.field_192019_bM).func_203425_a(Blocks.field_150421_aI)) {
            this.field_192018_bL = false;
            this.field_192019_bM = null;
        }
        if (this.field_70170_p.field_73012_v.nextInt(400) == 0) {
            ParrotEntity.func_192006_b(this.field_70170_p, (Entity)((Object)this));
        }
        super.func_70636_d();
        this.func_192001_dv();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_191987_a(BlockPos p_191987_1_, boolean p_191987_2_) {
        this.field_192019_bM = p_191987_1_;
        this.field_192018_bL = p_191987_2_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_192004_dr() {
        return this.field_192018_bL;
    }

    private void func_192001_dv() {
        this.field_192011_bE = this.field_192008_bB;
        this.field_192010_bD = this.field_192009_bC;
        this.field_192009_bC = (float)((double)this.field_192009_bC + (double)(!this.field_70122_E && !this.func_184218_aH() ? 4 : -1) * 0.3);
        this.field_192009_bC = MathHelper.func_76131_a((float)this.field_192009_bC, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.field_192012_bF < 1.0f) {
            this.field_192012_bF = 1.0f;
        }
        this.field_192012_bF = (float)((double)this.field_192012_bF * 0.9);
        Vector3d vector3d = this.func_213322_ci();
        if (!this.field_70122_E && vector3d.field_72448_b < 0.0) {
            this.func_213317_d(vector3d.func_216372_d(1.0, 0.6, 1.0));
        }
        this.field_192008_bB += this.field_192012_bF * 2.0f;
    }

    public static boolean func_192006_b(World p_192006_0_, Entity p_192006_1_) {
        if (p_192006_1_.func_70089_S() && !p_192006_1_.func_174814_R() && p_192006_0_.field_73012_v.nextInt(2) == 0) {
            MobEntity mobentity;
            List<MobEntity> list = p_192006_0_.func_175647_a(MobEntity.class, p_192006_1_.func_174813_aQ().func_186662_g(20.0), field_192014_bH);
            if (!list.isEmpty() && !(mobentity = list.get(p_192006_0_.field_73012_v.nextInt(list.size()))).func_174814_R()) {
                SoundEvent soundevent = ParrotEntity.func_200610_a(mobentity.func_200600_R());
                p_192006_0_.func_184148_a(null, p_192006_1_.func_226277_ct_(), p_192006_1_.func_226278_cu_(), p_192006_1_.func_226281_cx_(), soundevent, p_192006_1_.func_184176_by(), 0.7f, ParrotEntity.func_192000_b(p_192006_0_.field_73012_v));
                return true;
            }
            return false;
        }
        return false;
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (!this.func_70909_n() && field_192016_bJ.contains((Object)itemstack.func_77973_b())) {
            if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_192797_eu, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(10) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)((Object)this), (PlayerEntity)p_230254_1_) && !CraftEventFactory.callEntityTameEvent((MobEntity)((Object)this), (PlayerEntity)p_230254_1_).isCancelled()) {
                    this.func_193101_c(p_230254_1_);
                    this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)7);
                } else {
                    this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)6);
                }
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (itemstack.func_77973_b() == field_192015_bI) {
            if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.addEffect(new EffectInstance(Effects.field_76436_u, 900), EntityPotionEffectEvent.Cause.FOOD);
            if (p_230254_1_.func_184812_l_() || !this.func_190530_aW()) {
                this.func_70097_a(DamageSource.func_76365_a(p_230254_1_), Float.MAX_VALUE);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (!this.func_192002_a() && this.func_70909_n() && this.func_152114_e(p_230254_1_)) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_233687_w_(!this.func_233685_eM_());
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    public boolean func_70877_b(ItemStack p_70877_1_) {
        return false;
    }

    public static boolean func_223317_c(EntityType<ParrotEntity> p_223317_0_, IWorld p_223317_1_, SpawnReason p_223317_2_, BlockPos p_223317_3_, Random p_223317_4_) {
        BlockState blockstate = p_223317_1_.func_180495_p(p_223317_3_.func_177977_b());
        return (blockstate.func_235714_a_(BlockTags.field_206952_E) || blockstate.func_203425_a(Blocks.field_196658_i) || blockstate.func_235714_a_(BlockTags.field_200031_h) || blockstate.func_203425_a(Blocks.field_150350_a)) && p_223317_1_.func_226659_b_(p_223317_3_, 0) > 8;
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    protected void func_184231_a(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
    }

    public boolean func_70878_b(AnimalEntity p_70878_1_) {
        return false;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        return p_70652_1_.func_70097_a(DamageSource.func_76358_a((LivingEntity)((Object)this)), 3.0f);
    }

    @Nullable
    public SoundEvent func_184639_G() {
        return ParrotEntity.func_234212_a_(this.field_70170_p, this.field_70170_p.field_73012_v);
    }

    public static SoundEvent func_234212_a_(World p_234212_0_, Random p_234212_1_) {
        if (p_234212_0_.func_175659_aa() != Difficulty.PEACEFUL && p_234212_1_.nextInt(1000) == 0) {
            ArrayList list = Lists.newArrayList(field_192017_bK.keySet());
            return ParrotEntity.func_200610_a((EntityType)((Object)list.get(p_234212_1_.nextInt(list.size()))));
        }
        return SoundEvents.field_192792_ep;
    }

    private static SoundEvent func_200610_a(EntityType<?> p_200610_0_) {
        return field_192017_bK.getOrDefault(p_200610_0_, SoundEvents.field_192792_ep);
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_192794_er;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_192793_eq;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(SoundEvents.field_192795_es, 0.15f, 1.0f);
    }

    protected float func_191954_d(float p_191954_1_) {
        this.func_184185_a(SoundEvents.field_192796_et, 0.15f, 1.0f);
        return p_191954_1_ + this.field_192009_bC / 2.0f;
    }

    protected boolean func_191957_ae() {
        return true;
    }

    protected float func_70647_i() {
        return ParrotEntity.func_192000_b(this.field_70146_Z);
    }

    public static float func_192000_b(Random p_192000_0_) {
        return (p_192000_0_.nextFloat() - p_192000_0_.nextFloat()) * 0.2f + 1.0f;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    public boolean func_70104_M() {
        return super.func_70104_M();
    }

    protected void func_82167_n(Entity p_82167_1_) {
        if (!(p_82167_1_ instanceof PlayerEntity)) {
            super.func_82167_n(p_82167_1_);
        }
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    public int func_191998_ds() {
        return MathHelper.func_76125_a((int)this.field_70180_af.func_187225_a(field_192013_bG), (int)0, (int)4);
    }

    public void func_191997_m(int p_191997_1_) {
        this.field_70180_af.func_187227_b(field_192013_bG, p_191997_1_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_192013_bG, 0);
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74768_a("Variant", this.func_191998_ds());
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.func_191997_m(p_70037_1_.func_74762_e("Variant"));
    }

    public boolean func_192002_a() {
        return !this.field_70122_E;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, 0.5f * this.func_70047_e(), this.func_213311_cf() * 0.4f);
    }
}

