/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.BoostHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEquipable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRideable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;

public class StriderEntity
extends AnimalEntity
implements IRideable,
IEquipable {
    private static final Ingredient field_234308_bu_ = Ingredient.func_199804_a(Items.field_234723_bx_);
    private static final Ingredient field_234309_bv_ = Ingredient.func_199804_a(Items.field_234723_bx_, Items.field_234774_pk_);
    private static final DataParameter<Integer> field_234310_bw_ = EntityDataManager.func_187226_a(StriderEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_234311_bx_ = EntityDataManager.func_187226_a(StriderEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_234312_by_ = EntityDataManager.func_187226_a(StriderEntity.class, DataSerializers.field_187198_h);
    public final BoostHelper field_234313_bz_;
    private TemptGoal field_234306_bA_;
    private PanicGoal field_234307_bB_;

    public StriderEntity(EntityType<? extends StriderEntity> p_i231562_1_, World p_i231562_2_) {
        super((EntityType<? extends AnimalEntity>)p_i231562_1_, p_i231562_2_);
        this.field_234313_bz_ = new BoostHelper(this.field_70180_af, field_234310_bw_, field_234312_by_);
        this.field_70156_m = true;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
    }

    public static boolean func_234314_c_(EntityType<StriderEntity> p_234314_0_, IWorld p_234314_1_, SpawnReason p_234314_2_, BlockPos p_234314_3_, Random p_234314_4_) {
        BlockPos.Mutable blockpos$mutable = p_234314_3_.func_239590_i_();
        do {
            blockpos$mutable.func_189536_c(Direction.UP);
        } while (p_234314_1_.func_204610_c(blockpos$mutable).func_206884_a(FluidTags.field_206960_b));
        return p_234314_1_.func_180495_p(blockpos$mutable).func_196958_f();
    }

    @Override
    public void func_184206_a(DataParameter<?> p_184206_1_) {
        if (field_234310_bw_.equals(p_184206_1_) && this.field_70170_p.field_72995_K) {
            this.field_234313_bz_.func_233616_a_();
        }
        super.func_184206_a(p_184206_1_);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_234310_bw_, 0);
        this.field_70180_af.func_187214_a(field_234311_bx_, false);
        this.field_70180_af.func_187214_a(field_234312_by_, false);
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        this.field_234313_bz_.func_233618_a_(p_213281_1_);
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.field_234313_bz_.func_233621_b_(p_70037_1_);
    }

    public boolean func_110257_ck() {
        return this.field_234313_bz_.func_233620_b_();
    }

    public boolean func_230264_L__() {
        return this.func_70089_S() && !this.func_70631_g_();
    }

    public void func_230266_a_(@Nullable SoundCategory p_230266_1_) {
        this.field_234313_bz_.func_233619_a_(true);
        if (p_230266_1_ != null) {
            this.field_70170_p.func_217384_a(null, this, SoundEvents.field_232841_ob_, p_230266_1_, 0.5f, 1.0f);
        }
    }

    @Override
    protected void func_184651_r() {
        this.field_234307_bB_ = new PanicGoal(this, 1.65);
        this.field_70714_bg.func_75776_a(1, (Goal)this.field_234307_bB_);
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_234306_bA_ = new TemptGoal((CreatureEntity)this, 1.4, false, field_234309_bv_);
        this.field_70714_bg.func_75776_a(3, (Goal)this.field_234306_bA_);
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveToLavaGoal(this, 1.5));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0, 60));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, StriderEntity.class, 8.0f));
    }

    public void func_234319_t_(boolean p_234319_1_) {
        this.field_70180_af.func_187227_b(field_234311_bx_, p_234319_1_);
    }

    public boolean func_234315_eI_() {
        return this.func_184187_bx() instanceof StriderEntity ? ((StriderEntity)this.func_184187_bx()).func_234315_eI_() : this.field_70180_af.func_187225_a(field_234311_bx_).booleanValue();
    }

    @Override
    public boolean func_230285_a_(Fluid p_230285_1_) {
        return p_230285_1_.func_207185_a(FluidTags.field_206960_b);
    }

    @Override
    public double func_70042_X() {
        float f = Math.min(0.25f, this.field_70721_aZ);
        float f1 = this.field_184619_aG;
        return (double)this.func_213302_cg() - 0.19 + (double)(0.12f * MathHelper.func_76134_b((float)(f1 * 1.5f)) * 2.0f * f);
    }

    @Override
    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity playerentity = (PlayerEntity)entity;
        return playerentity.func_184614_ca().func_77973_b() == Items.field_234774_pk_ || playerentity.func_184592_cb().func_77973_b() == Items.field_234774_pk_;
    }

    @Override
    public boolean func_205019_a(IWorldReader p_205019_1_) {
        return p_205019_1_.func_226668_i_(this);
    }

    @Override
    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : this.func_184188_bt().get(0);
    }

    @Override
    public Vector3d func_230268_c_(LivingEntity p_230268_1_) {
        Vector3d[] avector3d = new Vector3d[]{StriderEntity.func_233559_a_(this.func_213311_cf(), p_230268_1_.func_213311_cf(), p_230268_1_.field_70177_z), StriderEntity.func_233559_a_(this.func_213311_cf(), p_230268_1_.func_213311_cf(), p_230268_1_.field_70177_z - 22.5f), StriderEntity.func_233559_a_(this.func_213311_cf(), p_230268_1_.func_213311_cf(), p_230268_1_.field_70177_z + 22.5f), StriderEntity.func_233559_a_(this.func_213311_cf(), p_230268_1_.func_213311_cf(), p_230268_1_.field_70177_z - 45.0f), StriderEntity.func_233559_a_(this.func_213311_cf(), p_230268_1_.func_213311_cf(), p_230268_1_.field_70177_z + 45.0f)};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.func_174813_aQ().field_72337_e;
        double d1 = this.func_174813_aQ().field_72338_b - 0.5;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Vector3d vector3d : avector3d) {
            blockpos$mutable.func_189532_c(this.func_226277_ct_() + vector3d.field_72450_a, d0, this.func_226281_cx_() + vector3d.field_72449_c);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockpos$mutable.func_185334_h());
                blockpos$mutable.func_189536_c(Direction.DOWN);
            }
        }
        for (BlockPos blockpos : set) {
            double d3;
            if (this.field_70170_p.func_204610_c(blockpos).func_206884_a(FluidTags.field_206960_b) || !TransportationHelper.func_234630_a_((double)(d3 = this.field_70170_p.func_242403_h(blockpos)))) continue;
            Vector3d vector3d1 = Vector3d.func_237490_a_(blockpos, d3);
            for (Pose pose : p_230268_1_.func_230297_ef_()) {
                AxisAlignedBB axisalignedbb = p_230268_1_.func_233648_f_(pose);
                if (!TransportationHelper.func_234631_a_((ICollisionReader)this.field_70170_p, (LivingEntity)p_230268_1_, (AxisAlignedBB)axisalignedbb.func_191194_a(vector3d1))) continue;
                p_230268_1_.func_213301_b(pose);
                return vector3d1;
            }
        }
        return new Vector3d(this.func_226277_ct_(), this.func_174813_aQ().field_72337_e, this.func_226281_cx_());
    }

    @Override
    public void func_213352_e(Vector3d p_213352_1_) {
        this.func_70659_e(this.func_234316_eJ_());
        this.func_233622_a_(this, this.field_234313_bz_, p_213352_1_);
    }

    public float func_234316_eJ_() {
        return (float)this.func_233637_b_(Attributes.field_233821_d_) * (this.func_234315_eI_() ? 0.66f : 1.0f);
    }

    public float func_230265_N__() {
        return (float)this.func_233637_b_(Attributes.field_233821_d_) * (this.func_234315_eI_() ? 0.23f : 0.55f);
    }

    public void func_230267_a__(Vector3d p_230267_1_) {
        super.func_213352_e(p_230267_1_);
    }

    @Override
    protected float func_203009_ad() {
        return this.field_82151_R + 0.6f;
    }

    @Override
    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(this.func_180799_ab() ? SoundEvents.field_232838_nZ_ : SoundEvents.field_232837_nY_, 1.0f, 1.0f);
    }

    public boolean func_184762_da() {
        return this.field_234313_bz_.func_233617_a_(this.func_70681_au());
    }

    @Override
    protected void func_184231_a(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
        this.func_145775_I();
        if (this.func_180799_ab()) {
            this.field_70143_R = 0.0f;
        } else {
            super.func_184231_a(p_184231_1_, p_184231_3_, p_184231_4_, p_184231_5_);
        }
    }

    @Override
    public void func_70071_h_() {
        if (this.func_241398_eP_() && this.field_70146_Z.nextInt(140) == 0) {
            this.func_184185_a(SoundEvents.field_232833_nU_, 1.0f, this.func_70647_i());
        } else if (this.func_241397_eO_() && this.field_70146_Z.nextInt(60) == 0) {
            this.func_184185_a(SoundEvents.field_232834_nV_, 1.0f, this.func_70647_i());
        }
        BlockState blockstate = this.field_70170_p.func_180495_p(this.func_233580_cy_());
        BlockState blockstate1 = this.func_233568_aJ_();
        boolean flag = blockstate.func_235714_a_(BlockTags.field_232881_aw_) || blockstate1.func_235714_a_(BlockTags.field_232881_aw_) || this.func_233571_b_(FluidTags.field_206960_b) > 0.0;
        if (!flag ^ this.func_234315_eI_()) {
            CraftEventFactory.callStriderTemperatureChangeEvent((StriderEntity)this, (!flag ? 1 : 0) != 0);
            this.func_234319_t_(!flag);
        }
        super.func_70071_h_();
        this.func_234318_eL_();
        this.func_145775_I();
    }

    private boolean func_241397_eO_() {
        return this.field_234307_bB_ != null && this.field_234307_bB_.func_234044_h_();
    }

    private boolean func_241398_eP_() {
        return this.field_234306_bA_ != null && this.field_234306_bA_.func_75277_f();
    }

    @Override
    protected boolean func_230286_q_() {
        return true;
    }

    private void func_234318_eL_() {
        if (this.func_180799_ab()) {
            ISelectionContext iselectioncontext = ISelectionContext.func_216374_a(this);
            if (iselectioncontext.func_216378_a(FlowingFluidBlock.field_235510_c_, this.func_233580_cy_(), true) && !this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177984_a()).func_206884_a(FluidTags.field_206960_b)) {
                this.field_70122_E = true;
            } else {
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.5).func_72441_c(0.0, 0.05, 0.0));
            }
        }
    }

    public static AttributeModifierMap.MutableAttribute func_234317_eK_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, 0.175f).func_233815_a_(Attributes.field_233819_b_, 16.0);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return !this.func_241397_eO_() && !this.func_241398_eP_() ? SoundEvents.field_232832_nT_ : null;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_232836_nX_;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_232835_nW_;
    }

    @Override
    protected boolean func_184219_q(Entity p_184219_1_) {
        return this.func_184188_bt().isEmpty() && !this.func_208600_a(FluidTags.field_206960_b);
    }

    @Override
    public boolean func_230270_dK_() {
        return true;
    }

    @Override
    public boolean func_70027_ad() {
        return false;
    }

    @Override
    protected PathNavigator func_175447_b(World p_175447_1_) {
        return new LavaPathNavigator(this, p_175447_1_);
    }

    @Override
    public float func_205022_a(BlockPos p_205022_1_, IWorldReader p_205022_2_) {
        if (p_205022_2_.func_180495_p(p_205022_1_).func_204520_s().func_206884_a(FluidTags.field_206960_b)) {
            return 10.0f;
        }
        return this.func_180799_ab() ? Float.NEGATIVE_INFINITY : 0.0f;
    }

    @Override
    public StriderEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return EntityType.field_233589_aE_.func_200721_a(p_241840_1_);
    }

    @Override
    public boolean func_70877_b(ItemStack p_70877_1_) {
        return field_234308_bu_.test(p_70877_1_);
    }

    @Override
    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.func_110257_ck()) {
            this.func_199703_a(Items.field_151141_av);
        }
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        boolean flag = this.func_70877_b(p_230254_1_.func_184586_b(p_230254_2_));
        if (!flag && this.func_110257_ck() && !this.func_184207_aI() && !p_230254_1_.func_226563_dT_()) {
            if (!this.field_70170_p.field_72995_K) {
                p_230254_1_.func_184220_m(this);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        ActionResultType actionresulttype = super.func_230254_b_(p_230254_1_, p_230254_2_);
        if (!actionresulttype.func_226246_a_()) {
            ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
            return itemstack.func_77973_b() == Items.field_151141_av ? itemstack.func_111282_a_(p_230254_1_, this, p_230254_2_) : ActionResultType.PASS;
        }
        if (flag && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_232840_oa_, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
        return actionresulttype;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, 0.6f * this.func_70047_e(), this.func_213311_cf() * 0.4f);
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        AgeableEntity.AgeableData object;
        if (this.func_70631_g_()) {
            return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        }
        if (this.field_70146_Z.nextInt(30) == 0) {
            MobEntity mobentity = EntityType.field_233592_ba_.func_200721_a(p_213386_1_.func_201672_e());
            object = this.func_242331_a(p_213386_1_, p_213386_2_, mobentity, new ZombieEntity.GroupData(ZombieEntity.func_241399_a_(this.field_70146_Z), false));
            mobentity.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_234774_pk_));
            this.func_230266_a_(null);
        } else if (this.field_70146_Z.nextInt(10) == 0) {
            AgeableEntity ageableentity = EntityType.field_233589_aE_.func_200721_a(p_213386_1_.func_201672_e());
            ageableentity.func_70873_a(-24000);
            object = this.func_242331_a(p_213386_1_, p_213386_2_, ageableentity, null);
        } else {
            object = new AgeableEntity.AgeableData(0.5f);
        }
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, object, p_213386_5_);
    }

    private ILivingEntityData func_242331_a(IServerWorld p_242331_1_, DifficultyInstance p_242331_2_, MobEntity p_242331_3_, @Nullable ILivingEntityData p_242331_4_) {
        p_242331_3_.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, 0.0f);
        p_242331_3_.func_213386_a(p_242331_1_, p_242331_2_, SpawnReason.JOCKEY, p_242331_4_, null);
        p_242331_3_.func_184205_a(this, true);
        return new AgeableEntity.AgeableData(0.0f);
    }

    static class MoveToLavaGoal
    extends MoveToBlockGoal {
        private final StriderEntity field_242332_g;

        private MoveToLavaGoal(StriderEntity p_i241913_1_, double p_i241913_2_) {
            super((CreatureEntity)p_i241913_1_, p_i241913_2_, 8, 2);
            this.field_242332_g = p_i241913_1_;
        }

        public BlockPos func_241846_j() {
            return this.field_179494_b;
        }

        public boolean func_75253_b() {
            return !this.field_242332_g.func_180799_ab() && this.func_179488_a((IWorldReader)((Object)this.field_242332_g.field_70170_p), this.field_179494_b);
        }

        public boolean func_75250_a() {
            return !this.field_242332_g.func_180799_ab() && super.func_75250_a();
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 20 == 0;
        }

        protected boolean func_179488_a(IWorldReader p_179488_1_, BlockPos p_179488_2_) {
            return p_179488_1_.func_180495_p(p_179488_2_).func_203425_a(Blocks.field_150353_l) && p_179488_1_.func_180495_p(p_179488_2_.func_177984_a()).func_196957_g((IBlockReader)((Object)p_179488_1_), p_179488_2_, PathType.LAND);
        }
    }

    static class LavaPathNavigator
    extends GroundPathNavigator {
        LavaPathNavigator(StriderEntity p_i231565_1_, World p_i231565_2_) {
            super((MobEntity)p_i231565_1_, p_i231565_2_);
        }

        protected PathFinder func_179679_a(int p_179679_1_) {
            this.field_179695_a = new WalkNodeProcessor();
            return new PathFinder(this.field_179695_a, p_179679_1_);
        }

        protected boolean func_230287_a_(PathNodeType p_230287_1_) {
            return p_230287_1_ != PathNodeType.LAVA && p_230287_1_ != PathNodeType.DAMAGE_FIRE && p_230287_1_ != PathNodeType.DANGER_FIRE ? super.func_230287_a_(p_230287_1_) : true;
        }

        public boolean func_188555_b(BlockPos p_188555_1_) {
            return this.field_75513_b.func_180495_p(p_188555_1_).func_203425_a(Blocks.field_150353_l) || super.func_188555_b(p_188555_1_);
        }
    }
}

