/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class PotionEntity
extends ProjectileItemEntity
implements IRendersAsItem {
    public static final Predicate<LivingEntity> field_190546_d = LivingEntity::func_230270_dK_;

    public PotionEntity(EntityType<? extends PotionEntity> p_i50149_1_, World p_i50149_2_) {
        super((EntityType<? extends ProjectileItemEntity>)p_i50149_1_, p_i50149_2_);
    }

    public PotionEntity(World p_i50150_1_, LivingEntity p_i50150_2_) {
        super((EntityType<? extends ProjectileItemEntity>)EntityType.field_200754_at, p_i50150_2_, p_i50150_1_);
    }

    public PotionEntity(World p_i50151_1_, double p_i50151_2_, double p_i50151_4_, double p_i50151_6_) {
        super((EntityType<? extends ProjectileItemEntity>)EntityType.field_200754_at, p_i50151_2_, p_i50151_4_, p_i50151_6_, p_i50151_1_);
    }

    @Override
    protected Item func_213885_i() {
        return Items.field_185155_bH;
    }

    @Override
    protected float func_70185_h() {
        return 0.05f;
    }

    @Override
    protected void func_230299_a_(BlockRayTraceResult p_230299_1_) {
        super.func_230299_a_(p_230299_1_);
        if (!this.field_70170_p.field_72995_K) {
            ItemStack itemstack = this.func_184543_l();
            Potion potion = PotionUtils.func_185191_c(itemstack);
            List<EffectInstance> list = PotionUtils.func_185189_a(itemstack);
            boolean flag = potion == Potions.field_185230_b && list.isEmpty();
            Direction direction = p_230299_1_.func_216354_b();
            BlockPos blockpos = p_230299_1_.func_216350_a();
            BlockPos blockpos1 = blockpos.func_177972_a(direction);
            if (flag) {
                this.func_184542_a(blockpos1, direction);
                this.func_184542_a(blockpos1.func_177972_a(direction.func_176734_d()), direction);
                for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                    this.func_184542_a(blockpos1.func_177972_a(direction1), direction1);
                }
            }
        }
    }

    @Override
    protected void func_70227_a(RayTraceResult p_70227_1_) {
        super.func_70227_a(p_70227_1_);
        if (!this.field_70170_p.field_72995_K) {
            boolean flag;
            ItemStack itemstack = this.func_184543_l();
            Potion potion = PotionUtils.func_185191_c(itemstack);
            List<EffectInstance> list = PotionUtils.func_185189_a(itemstack);
            boolean bl = flag = potion == Potions.field_185230_b && list.isEmpty();
            if (flag) {
                this.func_190545_n();
            } else if (this.func_184544_n()) {
                this.func_190542_a(itemstack, potion);
            } else {
                this.func_213888_a(list, p_70227_1_.func_216346_c() == RayTraceResult.Type.ENTITY ? ((EntityRayTraceResult)p_70227_1_).func_216348_a() : null);
            }
            int i = potion.func_185172_c() ? 2007 : 2002;
            this.field_70170_p.func_217379_c(i, this.func_233580_cy_(), PotionUtils.func_190932_c(itemstack));
            this.func_70106_y();
        }
    }

    private void func_190545_n() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List<LivingEntity> list = this.field_70170_p.func_175647_a(LivingEntity.class, axisalignedbb, field_190546_d);
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                double d0 = this.func_70068_e(livingentity);
                if (!(d0 < 16.0) || !livingentity.func_230270_dK_()) continue;
                livingentity.func_70097_a(DamageSource.func_76354_b(livingentity, this.func_234616_v_()), 1.0f);
            }
        }
    }

    private void func_213888_a(List<EffectInstance> p_213888_1_, @Nullable Entity p_213888_2_) {
        PotionSplashEvent event;
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List list = this.field_70170_p.func_217357_a(LivingEntity.class, axisalignedbb);
        HashMap<org.bukkit.entity.LivingEntity, Double> affected = new HashMap<org.bukkit.entity.LivingEntity, Double>();
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                double d0;
                if (!livingentity.func_184603_cC() || !((d0 = this.func_70068_e(livingentity)) < 16.0)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                if (livingentity == p_213888_2_) {
                    d1 = 1.0;
                }
                affected.put((org.bukkit.entity.LivingEntity)livingentity.getBukkitEntity(), d1);
            }
        }
        if (!(event = CraftEventFactory.callPotionSplashEvent((PotionEntity)this, affected)).isCancelled() && list != null && !list.isEmpty()) {
            for (org.bukkit.entity.LivingEntity victim : event.getAffectedEntities()) {
                if (!(victim instanceof CraftLivingEntity)) continue;
                LivingEntity livingentity = ((CraftLivingEntity)victim).getHandle();
                double dl = event.getIntensity(victim);
                for (EffectInstance effectinstance : p_213888_1_) {
                    int i;
                    Effect effect = effectinstance.func_188419_a();
                    if (!this.field_70170_p.pvpMode && this.func_234616_v_() instanceof ServerPlayerEntity && livingentity instanceof ServerPlayerEntity && livingentity != this.func_234616_v_() && ((i = Effect.func_188409_a(effect)) == 2 || i == 4 || i == 7 || i == 15 || i == 17 || i == 18 || i == 19)) continue;
                    if (effect.func_76403_b()) {
                        effect.func_180793_a(this, this.func_234616_v_(), livingentity, effectinstance.func_76458_c(), dl);
                        continue;
                    }
                    i = (int)(dl * (double)effectinstance.func_76459_b() + 0.5);
                    if (i <= 20) continue;
                    livingentity.addEffect(new EffectInstance(effect, i, effectinstance.func_76458_c(), effectinstance.func_82720_e(), effectinstance.func_188418_e()), EntityPotionEffectEvent.Cause.POTION_SPLASH);
                }
            }
        }
    }

    private void func_190542_a(ItemStack p_190542_1_, Potion p_190542_2_) {
        LingeringPotionSplashEvent event;
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        Entity entity = this.func_234616_v_();
        if (entity instanceof LivingEntity) {
            areaeffectcloudentity.func_184481_a((LivingEntity)entity);
        }
        areaeffectcloudentity.func_184483_a(3.0f);
        areaeffectcloudentity.func_184495_b(-0.5f);
        areaeffectcloudentity.func_184485_d(10);
        areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
        areaeffectcloudentity.func_184484_a(p_190542_2_);
        for (EffectInstance effectinstance : PotionUtils.func_185190_b(p_190542_1_)) {
            areaeffectcloudentity.func_184496_a(new EffectInstance(effectinstance));
        }
        CompoundNBT compoundnbt = p_190542_1_.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("CustomPotionColor", 99)) {
            areaeffectcloudentity.func_184482_a(compoundnbt.func_74762_e("CustomPotionColor"));
        }
        if (!(event = CraftEventFactory.callLingeringPotionSplashEvent((PotionEntity)this, (AreaEffectCloudEntity)areaeffectcloudentity)).isCancelled() && !areaeffectcloudentity.field_70128_L) {
            this.field_70170_p.func_217376_c(areaeffectcloudentity);
        } else {
            areaeffectcloudentity.field_70128_L = true;
        }
    }

    private boolean func_184544_n() {
        return this.func_184543_l().func_77973_b() == Items.field_185156_bI;
    }

    private void func_184542_a(BlockPos p_184542_1_, Direction p_184542_2_) {
        BlockState blockstate = this.field_70170_p.func_180495_p(p_184542_1_);
        if (blockstate.func_235714_a_(BlockTags.field_232872_am_)) {
            if (!CraftEventFactory.callEntityChangeBlockEvent((Entity)this, (BlockPos)p_184542_1_, (BlockState)Blocks.field_150350_a.func_176223_P()).isCancelled()) {
                this.field_70170_p.func_217377_a(p_184542_1_, false);
            }
        } else if (CampfireBlock.func_226915_i_(blockstate) && !CraftEventFactory.callEntityChangeBlockEvent((Entity)this, (BlockPos)p_184542_1_, (BlockState)((BlockState)blockstate.func_206870_a(CampfireBlock.field_220101_b, false))).isCancelled()) {
            this.field_70170_p.func_217378_a(null, 1009, p_184542_1_, 0);
            CampfireBlock.func_235475_c_(this.field_70170_p, p_184542_1_, blockstate);
            this.field_70170_p.func_175656_a(p_184542_1_, (BlockState)blockstate.func_206870_a(CampfireBlock.field_220101_b, false));
        }
    }
}

