/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public abstract class Container {
    public NonNullList<net.minecraft.item.ItemStack> field_75153_a = NonNullList.func_191196_a();
    public List<Slot> field_75151_b = Lists.newArrayList();
    private final List<IntReferenceHolder> field_216964_d = Lists.newArrayList();
    @Nullable
    private final ContainerType<?> field_216965_e;
    public final int field_75152_c;
    @OnlyIn(value=Dist.CLIENT)
    private short field_75150_e;
    private int field_94535_f = -1;
    private int field_94536_g;
    private final Set<Slot> field_94537_h = Sets.newHashSet();
    private final List<IContainerListener> field_75149_d = Lists.newArrayList();
    private final Set<PlayerEntity> field_75148_f = Sets.newHashSet();
    public boolean checkReachable = true;
    private ITextComponent title;
    public InventoryView bukkitView = null;

    public InventoryView getBukkitView() {
        return this.bukkitView;
    }

    public void setBukkitView(InventoryView iv) {
        this.bukkitView = iv;
    }

    public void transferTo(Container other, CraftHumanEntity player) {
        InventoryView source = this.getBukkitView();
        InventoryView destination = other.getBukkitView();
        if (source != null) {
            try {
                ((CraftInventory)source.getTopInventory()).getInventory().onClose(player);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
            try {
                ((CraftInventory)source.getBottomInventory()).getInventory().onClose(player);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
        if (destination != null) {
            try {
                ((CraftInventory)destination.getTopInventory()).getInventory().onOpen(player);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
            try {
                ((CraftInventory)destination.getBottomInventory()).getInventory().onOpen(player);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
    }

    public ITextComponent getTitle() {
        if (this.title == null) {
            this.title = new StringTextComponent("");
        }
        return this.title;
    }

    public final void setTitle(ITextComponent title) {
        this.title = title;
    }

    protected Container(@Nullable ContainerType<?> p_i50105_1_, int p_i50105_2_) {
        this.field_216965_e = p_i50105_1_;
        this.field_75152_c = p_i50105_2_;
    }

    protected static boolean func_216963_a(IWorldPosCallable p_216963_0_, PlayerEntity p_216963_1_, Block p_216963_2_) {
        return p_216963_0_.func_221485_a((p_216960_2_, p_216960_3_) -> !p_216960_2_.func_180495_p((BlockPos)p_216960_3_).func_203425_a(p_216963_2_) ? false : p_216963_1_.func_70092_e((double)p_216960_3_.func_177958_n() + 0.5, (double)p_216960_3_.func_177956_o() + 0.5, (double)p_216960_3_.func_177952_p() + 0.5) <= 64.0, true);
    }

    public ContainerType<?> func_216957_a() {
        if (this.field_216965_e == null) {
            throw new UnsupportedOperationException("Unable to construct this menu by type");
        }
        return this.field_216965_e;
    }

    protected static void func_216962_a(IInventory p_216962_0_, int p_216962_1_) {
        int i = p_216962_0_.func_70302_i_();
        if (i < p_216962_1_) {
            throw new IllegalArgumentException("Container size " + i + " is smaller than expected " + p_216962_1_);
        }
    }

    protected static void func_216959_a(IIntArray p_216959_0_, int p_216959_1_) {
        int i = p_216959_0_.func_221478_a();
        if (i < p_216959_1_) {
            throw new IllegalArgumentException("Container data count " + i + " is smaller than expected " + p_216959_1_);
        }
    }

    protected Slot func_75146_a(Slot p_75146_1_) {
        p_75146_1_.field_75222_d = this.field_75151_b.size();
        this.field_75151_b.add(p_75146_1_);
        this.field_75153_a.add(net.minecraft.item.ItemStack.field_190927_a);
        return p_75146_1_;
    }

    protected IntReferenceHolder func_216958_a(IntReferenceHolder p_216958_1_) {
        this.field_216964_d.add(p_216958_1_);
        return p_216958_1_;
    }

    protected void func_216961_a(IIntArray p_216961_1_) {
        for (int i = 0; i < p_216961_1_.func_221478_a(); ++i) {
            this.func_216958_a(IntReferenceHolder.func_221493_a((IIntArray)p_216961_1_, (int)i));
        }
    }

    public void func_75132_a(IContainerListener p_75132_1_) {
        if (!this.field_75149_d.contains(p_75132_1_)) {
            this.field_75149_d.add(p_75132_1_);
            p_75132_1_.func_71110_a(this, this.func_75138_a());
            this.func_75142_b();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_82847_b(IContainerListener p_82847_1_) {
        this.field_75149_d.remove(p_82847_1_);
    }

    public NonNullList<net.minecraft.item.ItemStack> func_75138_a() {
        NonNullList<net.minecraft.item.ItemStack> nonnulllist = NonNullList.func_191196_a();
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            nonnulllist.add(this.field_75151_b.get(i).func_75211_c());
        }
        return nonnulllist;
    }

    public void func_75142_b() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            net.minecraft.item.ItemStack itemstack = this.field_75151_b.get(i).func_75211_c();
            net.minecraft.item.ItemStack itemstack1 = this.field_75153_a.get(i);
            if (net.minecraft.item.ItemStack.func_77989_b(itemstack1, itemstack)) continue;
            boolean clientStackChanged = !itemstack1.equals(itemstack, true);
            net.minecraft.item.ItemStack itemstack2 = itemstack.func_77946_l();
            this.field_75153_a.set(i, itemstack2);
            if (!clientStackChanged) continue;
            for (IContainerListener icontainerlistener : this.field_75149_d) {
                icontainerlistener.func_71111_a(this, i, itemstack2);
            }
        }
        for (int j = 0; j < this.field_216964_d.size(); ++j) {
            IntReferenceHolder intreferenceholder = this.field_216964_d.get(j);
            if (!intreferenceholder.func_221496_c()) continue;
            for (IContainerListener icontainerlistener1 : this.field_75149_d) {
                icontainerlistener1.func_71112_a(this, j, intreferenceholder.func_221495_b());
            }
        }
    }

    public boolean func_75140_a(PlayerEntity p_75140_1_, int p_75140_2_) {
        return false;
    }

    public Slot func_75139_a(int p_75139_1_) {
        return this.field_75151_b.get(p_75139_1_);
    }

    public net.minecraft.item.ItemStack func_82846_b(PlayerEntity p_82846_1_, int p_82846_2_) {
        Slot slot = this.field_75151_b.get(p_82846_2_);
        return slot != null ? slot.func_75211_c() : net.minecraft.item.ItemStack.field_190927_a;
    }

    public net.minecraft.item.ItemStack func_184996_a(int p_184996_1_, int p_184996_2_, ClickType p_184996_3_, PlayerEntity p_184996_4_) {
        try {
            return this.func_241440_b_(p_184996_1_, p_184996_2_, p_184996_3_, p_184996_4_);
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.func_85055_a(exception, "Container click");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Click info");
            crashreportcategory.func_189529_a("Menu Type", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_216965_e != null ? Registry.field_218366_G.func_177774_c(this.field_216965_e).toString() : "<no type>"));
            crashreportcategory.func_189529_a("Menu Class", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.getClass().getCanonicalName()));
            crashreportcategory.func_71507_a("Slot Count", this.field_75151_b.size());
            crashreportcategory.func_71507_a("Slot", p_184996_1_);
            crashreportcategory.func_71507_a("Button", p_184996_2_);
            crashreportcategory.func_71507_a("Type", p_184996_3_);
            throw new ReportedException(crashreport);
        }
    }

    private net.minecraft.item.ItemStack func_241440_b_(int p_241440_1_, int p_241440_2_, ClickType p_241440_3_, PlayerEntity p_241440_4_) {
        net.minecraft.item.ItemStack itemstack = net.minecraft.item.ItemStack.field_190927_a;
        PlayerInventory playerinventory = p_241440_4_.field_71071_by;
        if (p_241440_3_ == ClickType.QUICK_CRAFT) {
            int i1 = this.field_94536_g;
            this.field_94536_g = Container.func_94532_c(p_241440_2_);
            if ((i1 != 1 || this.field_94536_g != 2) && i1 != this.field_94536_g) {
                this.func_94533_d();
            } else if (playerinventory.func_70445_o().func_190926_b()) {
                this.func_94533_d();
            } else if (this.field_94536_g == 0) {
                this.field_94535_f = Container.func_94529_b(p_241440_2_);
                if (Container.func_180610_a(this.field_94535_f, p_241440_4_)) {
                    this.field_94536_g = 1;
                    this.field_94537_h.clear();
                } else {
                    this.func_94533_d();
                }
            } else if (this.field_94536_g == 1) {
                Slot slot7 = this.field_75151_b.get(p_241440_1_);
                net.minecraft.item.ItemStack itemstack12 = playerinventory.func_70445_o();
                if (slot7 != null && Container.func_94527_a(slot7, itemstack12, true) && slot7.func_75214_a(itemstack12) && (this.field_94535_f == 2 || itemstack12.func_190916_E() > this.field_94537_h.size()) && this.func_94531_b(slot7)) {
                    this.field_94537_h.add(slot7);
                }
            } else if (this.field_94536_g == 2) {
                if (!this.field_94537_h.isEmpty()) {
                    boolean needsUpdate;
                    net.minecraft.item.ItemStack itemstack10 = playerinventory.func_70445_o().func_77946_l();
                    int k1 = playerinventory.func_70445_o().func_190916_E();
                    HashMap<Integer, Object> draggedSlots = new HashMap<Integer, Object>();
                    for (Slot slot8 : this.field_94537_h) {
                        net.minecraft.item.ItemStack itemstack13 = playerinventory.func_70445_o();
                        if (slot8 == null || !Container.func_94527_a(slot8, itemstack13, true) || !slot8.func_75214_a(itemstack13) || this.field_94535_f != 2 && itemstack13.func_190916_E() < this.field_94537_h.size() || !this.func_94531_b(slot8)) continue;
                        net.minecraft.item.ItemStack itemstack14 = itemstack10.func_77946_l();
                        int j3 = slot8.func_75216_d() ? slot8.func_75211_c().func_190916_E() : 0;
                        Container.func_94525_a(this.field_94537_h, this.field_94535_f, itemstack14, j3);
                        int k3 = Math.min(itemstack14.func_77976_d(), slot8.func_178170_b(itemstack14));
                        if (itemstack14.func_190916_E() > k3) {
                            itemstack14.func_190920_e(k3);
                        }
                        k1 -= itemstack14.func_190916_E() - j3;
                        slot8.func_75215_d(itemstack14);
                        draggedSlots.put(slot8.field_75222_d, (Object)itemstack14);
                    }
                    InventoryView view = this.getBukkitView();
                    CraftItemStack newcursor = CraftItemStack.asCraftMirror((net.minecraft.item.ItemStack)itemstack10);
                    newcursor.setAmount(k1);
                    HashMap<Integer, ItemStack> eventmap = new HashMap<Integer, ItemStack>();
                    for (Map.Entry ditem : draggedSlots.entrySet()) {
                        eventmap.put((Integer)ditem.getKey(), CraftItemStack.asBukkitCopy((net.minecraft.item.ItemStack)((net.minecraft.item.ItemStack)((Object)ditem.getValue()))));
                    }
                    net.minecraft.item.ItemStack oldCursor = playerinventory.func_70445_o();
                    playerinventory.func_70437_b(CraftItemStack.asNMSCopy((ItemStack)newcursor));
                    InventoryDragEvent event = new InventoryDragEvent(view, (ItemStack)(newcursor.getType() != Material.AIR ? newcursor : null), CraftItemStack.asBukkitCopy((net.minecraft.item.ItemStack)oldCursor), this.field_94535_f == 1, eventmap);
                    p_241440_4_.field_70170_p.getCBServer().getPluginManager().callEvent((Event)event);
                    boolean bl = needsUpdate = event.getResult() != Event.Result.DEFAULT;
                    if (event.getResult() != Event.Result.DENY) {
                        for (Map.Entry dslot : draggedSlots.entrySet()) {
                            view.setItem(((Integer)dslot.getKey()).intValue(), CraftItemStack.asBukkitCopy((net.minecraft.item.ItemStack)((net.minecraft.item.ItemStack)((Object)dslot.getValue()))));
                        }
                        if (playerinventory.func_70445_o() != null) {
                            playerinventory.func_70437_b(CraftItemStack.asNMSCopy((ItemStack)event.getCursor()));
                            needsUpdate = true;
                        }
                    } else {
                        playerinventory.func_70437_b(oldCursor);
                    }
                    if (needsUpdate && p_241440_4_ instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)p_241440_4_).func_71120_a(this);
                    }
                }
                this.func_94533_d();
            } else {
                this.func_94533_d();
            }
        } else if (this.field_94536_g != 0) {
            this.func_94533_d();
        } else if (!(p_241440_3_ != ClickType.PICKUP && p_241440_3_ != ClickType.QUICK_MOVE || p_241440_2_ != 0 && p_241440_2_ != 1)) {
            if (p_241440_1_ == -999) {
                if (!playerinventory.func_70445_o().func_190926_b()) {
                    if (p_241440_2_ == 0) {
                        net.minecraft.item.ItemStack carried = playerinventory.func_70445_o();
                        playerinventory.func_70437_b(net.minecraft.item.ItemStack.field_190927_a);
                        p_241440_4_.func_71019_a(carried, true);
                    }
                    if (p_241440_2_ == 1) {
                        p_241440_4_.func_71019_a(playerinventory.func_70445_o().func_77979_a(1), true);
                    }
                }
            } else if (p_241440_3_ == ClickType.QUICK_MOVE) {
                if (p_241440_1_ < 0) {
                    return net.minecraft.item.ItemStack.field_190927_a;
                }
                Slot slot5 = this.field_75151_b.get(p_241440_1_);
                if (slot5 == null || !slot5.func_82869_a(p_241440_4_)) {
                    return net.minecraft.item.ItemStack.field_190927_a;
                }
                net.minecraft.item.ItemStack itemstack8 = this.func_82846_b(p_241440_4_, p_241440_1_);
                while (!itemstack8.func_190926_b() && net.minecraft.item.ItemStack.func_179545_c(slot5.func_75211_c(), itemstack8)) {
                    itemstack = itemstack8.func_77946_l();
                    itemstack8 = this.func_82846_b(p_241440_4_, p_241440_1_);
                }
            } else {
                if (p_241440_1_ < 0) {
                    return net.minecraft.item.ItemStack.field_190927_a;
                }
                Slot slot6 = this.field_75151_b.get(p_241440_1_);
                if (slot6 != null) {
                    net.minecraft.item.ItemStack itemstack9 = slot6.func_75211_c();
                    net.minecraft.item.ItemStack itemstack11 = playerinventory.func_70445_o();
                    if (!itemstack9.func_190926_b()) {
                        itemstack = itemstack9.func_77946_l();
                    }
                    if (itemstack9.func_190926_b()) {
                        if (!itemstack11.func_190926_b() && slot6.func_75214_a(itemstack11)) {
                            int j2;
                            int n = j2 = p_241440_2_ == 0 ? itemstack11.func_190916_E() : 1;
                            if (j2 > slot6.func_178170_b(itemstack11)) {
                                j2 = slot6.func_178170_b(itemstack11);
                            }
                            slot6.func_75215_d(itemstack11.func_77979_a(j2));
                        }
                    } else if (slot6.func_82869_a(p_241440_4_)) {
                        int i3;
                        if (itemstack11.func_190926_b()) {
                            if (itemstack9.func_190926_b()) {
                                slot6.func_75215_d(net.minecraft.item.ItemStack.field_190927_a);
                                playerinventory.func_70437_b(net.minecraft.item.ItemStack.field_190927_a);
                            } else {
                                int k2 = p_241440_2_ == 0 ? itemstack9.func_190916_E() : (itemstack9.func_190916_E() + 1) / 2;
                                playerinventory.func_70437_b(slot6.func_75209_a(k2));
                                if (itemstack9.func_190926_b()) {
                                    slot6.func_75215_d(net.minecraft.item.ItemStack.field_190927_a);
                                }
                                slot6.func_190901_a(p_241440_4_, playerinventory.func_70445_o());
                            }
                        } else if (slot6.func_75214_a(itemstack11)) {
                            if (Container.func_195929_a(itemstack9, itemstack11)) {
                                int l2;
                                int n = l2 = p_241440_2_ == 0 ? itemstack11.func_190916_E() : 1;
                                if (l2 > slot6.func_178170_b(itemstack11) - itemstack9.func_190916_E()) {
                                    l2 = slot6.func_178170_b(itemstack11) - itemstack9.func_190916_E();
                                }
                                if (l2 > itemstack11.func_77976_d() - itemstack9.func_190916_E()) {
                                    l2 = itemstack11.func_77976_d() - itemstack9.func_190916_E();
                                }
                                itemstack11.func_190918_g(l2);
                                itemstack9.func_190917_f(l2);
                            } else if (itemstack11.func_190916_E() <= slot6.func_178170_b(itemstack11)) {
                                slot6.func_75215_d(itemstack11);
                                playerinventory.func_70437_b(itemstack9);
                            }
                        } else if (itemstack11.func_77976_d() > 1 && Container.func_195929_a(itemstack9, itemstack11) && !itemstack9.func_190926_b() && (i3 = itemstack9.func_190916_E()) + itemstack11.func_190916_E() <= itemstack11.func_77976_d()) {
                            itemstack11.func_190917_f(i3);
                            itemstack9 = slot6.func_75209_a(i3);
                            if (itemstack9.func_190926_b()) {
                                slot6.func_75215_d(net.minecraft.item.ItemStack.field_190927_a);
                            }
                            slot6.func_190901_a(p_241440_4_, playerinventory.func_70445_o());
                        }
                    }
                    slot6.func_75218_e();
                    if (p_241440_4_ instanceof ServerPlayerEntity && slot6.func_75219_a() != 64) {
                        ((ServerPlayerEntity)p_241440_4_).field_71135_a.func_147359_a((IPacket<?>)new SSetSlotPacket(this.field_75152_c, slot6.field_75222_d, slot6.func_75211_c()));
                        if (this.getBukkitView().getType() == InventoryType.WORKBENCH || this.getBukkitView().getType() == InventoryType.CRAFTING) {
                            ((ServerPlayerEntity)p_241440_4_).field_71135_a.func_147359_a((IPacket<?>)new SSetSlotPacket(this.field_75152_c, 0, this.func_75139_a(0).func_75211_c()));
                        }
                    }
                }
            }
        } else if (p_241440_3_ == ClickType.SWAP) {
            Slot slot = this.field_75151_b.get(p_241440_1_);
            net.minecraft.item.ItemStack itemstack1 = playerinventory.func_70301_a(p_241440_2_);
            net.minecraft.item.ItemStack itemstack2 = slot.func_75211_c();
            if (!itemstack1.func_190926_b() || !itemstack2.func_190926_b()) {
                if (itemstack1.func_190926_b()) {
                    if (slot.func_82869_a(p_241440_4_)) {
                        playerinventory.func_70299_a(p_241440_2_, itemstack2);
                        slot.func_190900_b(itemstack2.func_190916_E());
                        slot.func_75215_d(net.minecraft.item.ItemStack.field_190927_a);
                        slot.func_190901_a(p_241440_4_, itemstack2);
                    }
                } else if (itemstack2.func_190926_b()) {
                    if (slot.func_75214_a(itemstack1)) {
                        int i = slot.func_178170_b(itemstack1);
                        if (itemstack1.func_190916_E() > i) {
                            slot.func_75215_d(itemstack1.func_77979_a(i));
                        } else {
                            slot.func_75215_d(itemstack1);
                            playerinventory.func_70299_a(p_241440_2_, net.minecraft.item.ItemStack.field_190927_a);
                        }
                    }
                } else if (slot.func_82869_a(p_241440_4_) && slot.func_75214_a(itemstack1)) {
                    int l1 = slot.func_178170_b(itemstack1);
                    if (itemstack1.func_190916_E() > l1) {
                        slot.func_75215_d(itemstack1.func_77979_a(l1));
                        slot.func_190901_a(p_241440_4_, itemstack2);
                        if (!playerinventory.func_70441_a(itemstack2)) {
                            p_241440_4_.func_71019_a(itemstack2, true);
                        }
                    } else {
                        slot.func_75215_d(itemstack1);
                        playerinventory.func_70299_a(p_241440_2_, itemstack2);
                        slot.func_190901_a(p_241440_4_, itemstack2);
                    }
                }
            }
        } else if (p_241440_3_ == ClickType.CLONE && p_241440_4_.field_71075_bZ.field_75098_d && playerinventory.func_70445_o().func_190926_b() && p_241440_1_ >= 0) {
            Slot slot4 = this.field_75151_b.get(p_241440_1_);
            if (slot4 != null && slot4.func_75216_d()) {
                net.minecraft.item.ItemStack itemstack7 = slot4.func_75211_c().func_77946_l();
                itemstack7.func_190920_e(itemstack7.func_77976_d());
                playerinventory.func_70437_b(itemstack7);
            }
        } else if (p_241440_3_ == ClickType.THROW && playerinventory.func_70445_o().func_190926_b() && p_241440_1_ >= 0) {
            Slot slot3 = this.field_75151_b.get(p_241440_1_);
            if (slot3 != null && slot3.func_75216_d() && slot3.func_82869_a(p_241440_4_)) {
                net.minecraft.item.ItemStack itemstack6 = slot3.func_75209_a(p_241440_2_ == 0 ? 1 : slot3.func_75211_c().func_190916_E());
                slot3.func_190901_a(p_241440_4_, itemstack6);
                p_241440_4_.func_71019_a(itemstack6, true);
            }
        } else if (p_241440_3_ == ClickType.PICKUP_ALL && p_241440_1_ >= 0) {
            Slot slot2 = this.field_75151_b.get(p_241440_1_);
            net.minecraft.item.ItemStack itemstack5 = playerinventory.func_70445_o();
            if (!(itemstack5.func_190926_b() || slot2 != null && slot2.func_75216_d() && slot2.func_82869_a(p_241440_4_))) {
                int j1 = p_241440_2_ == 0 ? 0 : this.field_75151_b.size() - 1;
                int i2 = p_241440_2_ == 0 ? 1 : -1;
                for (int j = 0; j < 2; ++j) {
                    for (int k = j1; k >= 0 && k < this.field_75151_b.size() && itemstack5.func_190916_E() < itemstack5.func_77976_d(); k += i2) {
                        Slot slot1 = this.field_75151_b.get(k);
                        if (!slot1.func_75216_d() || !Container.func_94527_a(slot1, itemstack5, true) || !slot1.func_82869_a(p_241440_4_) || !this.func_94530_a(itemstack5, slot1)) continue;
                        net.minecraft.item.ItemStack itemstack3 = slot1.func_75211_c();
                        if (j == 0 && itemstack3.func_190916_E() == itemstack3.func_77976_d()) continue;
                        int l = Math.min(itemstack5.func_77976_d() - itemstack5.func_190916_E(), itemstack3.func_190916_E());
                        net.minecraft.item.ItemStack itemstack4 = slot1.func_75209_a(l);
                        itemstack5.func_190917_f(l);
                        if (itemstack4.func_190926_b()) {
                            slot1.func_75215_d(net.minecraft.item.ItemStack.field_190927_a);
                        }
                        slot1.func_190901_a(p_241440_4_, itemstack4);
                    }
                }
            }
            this.func_75142_b();
        }
        return itemstack;
    }

    public static boolean func_195929_a(net.minecraft.item.ItemStack p_195929_0_, net.minecraft.item.ItemStack p_195929_1_) {
        return p_195929_0_.func_77973_b() == p_195929_1_.func_77973_b() && net.minecraft.item.ItemStack.func_77970_a(p_195929_0_, p_195929_1_);
    }

    public boolean func_94530_a(net.minecraft.item.ItemStack p_94530_1_, Slot p_94530_2_) {
        return true;
    }

    public void func_75134_a(PlayerEntity p_75134_1_) {
        PlayerInventory playerinventory = p_75134_1_.field_71071_by;
        if (!playerinventory.func_70445_o().func_190926_b()) {
            net.minecraft.item.ItemStack carried = playerinventory.func_70445_o();
            playerinventory.func_70437_b(net.minecraft.item.ItemStack.field_190927_a);
            p_75134_1_.func_71019_a(carried, false);
        }
    }

    protected void func_193327_a(PlayerEntity p_193327_1_, World p_193327_2_, IInventory p_193327_3_) {
        if (!p_193327_1_.func_70089_S() || p_193327_1_ instanceof ServerPlayerEntity && ((ServerPlayerEntity)p_193327_1_).func_193105_t()) {
            for (int j = 0; j < p_193327_3_.func_70302_i_(); ++j) {
                p_193327_1_.func_71019_a(p_193327_3_.func_70304_b(j), false);
            }
        } else {
            for (int i = 0; i < p_193327_3_.func_70302_i_(); ++i) {
                p_193327_1_.field_71071_by.func_191975_a(p_193327_2_, p_193327_3_.func_70304_b(i));
            }
        }
    }

    public void func_75130_a(IInventory p_75130_1_) {
        this.func_75142_b();
    }

    public void func_75141_a(int p_75141_1_, net.minecraft.item.ItemStack p_75141_2_) {
        this.func_75139_a(p_75141_1_).func_75215_d(p_75141_2_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190896_a(List<net.minecraft.item.ItemStack> p_190896_1_) {
        for (int i = 0; i < p_190896_1_.size(); ++i) {
            this.func_75139_a(i).func_75215_d(p_190896_1_.get(i));
        }
    }

    public void func_75137_b(int p_75137_1_, int p_75137_2_) {
        this.field_216964_d.get(p_75137_1_).func_221494_a(p_75137_2_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public short func_75136_a(PlayerInventory p_75136_1_) {
        this.field_75150_e = (short)(this.field_75150_e + 1);
        return this.field_75150_e;
    }

    public boolean func_75129_b(PlayerEntity p_75129_1_) {
        return !this.field_75148_f.contains(p_75129_1_);
    }

    public void func_75128_a(PlayerEntity p_75128_1_, boolean p_75128_2_) {
        if (p_75128_2_) {
            this.field_75148_f.remove(p_75128_1_);
        } else {
            this.field_75148_f.add(p_75128_1_);
        }
    }

    public abstract boolean func_75145_c(PlayerEntity var1);

    protected boolean func_75135_a(net.minecraft.item.ItemStack p_75135_1_, int p_75135_2_, int p_75135_3_, boolean p_75135_4_) {
        boolean flag = false;
        int i = p_75135_2_;
        if (p_75135_4_) {
            i = p_75135_3_ - 1;
        }
        if (p_75135_1_.func_77985_e()) {
            while (!p_75135_1_.func_190926_b() && !(!p_75135_4_ ? i >= p_75135_3_ : i < p_75135_2_)) {
                Slot slot = this.field_75151_b.get(i);
                net.minecraft.item.ItemStack itemstack = slot.func_75211_c();
                if (!itemstack.func_190926_b() && Container.func_195929_a(p_75135_1_, itemstack)) {
                    int maxSize;
                    int j = itemstack.func_190916_E() + p_75135_1_.func_190916_E();
                    if (j <= (maxSize = Math.min(slot.func_75219_a(), p_75135_1_.func_77976_d()))) {
                        p_75135_1_.func_190920_e(0);
                        itemstack.func_190920_e(j);
                        slot.func_75218_e();
                        flag = true;
                    } else if (itemstack.func_190916_E() < maxSize) {
                        p_75135_1_.func_190918_g(maxSize - itemstack.func_190916_E());
                        itemstack.func_190920_e(maxSize);
                        slot.func_75218_e();
                        flag = true;
                    }
                }
                if (p_75135_4_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!p_75135_1_.func_190926_b()) {
            i = p_75135_4_ ? p_75135_3_ - 1 : p_75135_2_;
            while (!(!p_75135_4_ ? i >= p_75135_3_ : i < p_75135_2_)) {
                Slot slot1 = this.field_75151_b.get(i);
                net.minecraft.item.ItemStack itemstack1 = slot1.func_75211_c();
                if (itemstack1.func_190926_b() && slot1.func_75214_a(p_75135_1_)) {
                    if (p_75135_1_.func_190916_E() > slot1.func_75219_a()) {
                        slot1.func_75215_d(p_75135_1_.func_77979_a(slot1.func_75219_a()));
                    } else {
                        slot1.func_75215_d(p_75135_1_.func_77979_a(p_75135_1_.func_190916_E()));
                    }
                    slot1.func_75218_e();
                    flag = true;
                    break;
                }
                if (p_75135_4_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public static int func_94529_b(int p_94529_0_) {
        return p_94529_0_ >> 2 & 3;
    }

    public static int func_94532_c(int p_94532_0_) {
        return p_94532_0_ & 3;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int func_94534_d(int p_94534_0_, int p_94534_1_) {
        return p_94534_0_ & 3 | (p_94534_1_ & 3) << 2;
    }

    public static boolean func_180610_a(int p_180610_0_, PlayerEntity p_180610_1_) {
        if (p_180610_0_ == 0) {
            return true;
        }
        if (p_180610_0_ == 1) {
            return true;
        }
        return p_180610_0_ == 2 && p_180610_1_.field_71075_bZ.field_75098_d;
    }

    protected void func_94533_d() {
        this.field_94536_g = 0;
        this.field_94537_h.clear();
    }

    public static boolean func_94527_a(@Nullable Slot p_94527_0_, net.minecraft.item.ItemStack p_94527_1_, boolean p_94527_2_) {
        boolean flag;
        boolean bl = flag = p_94527_0_ == null || !p_94527_0_.func_75216_d();
        if (!flag && p_94527_1_.func_77969_a(p_94527_0_.func_75211_c()) && net.minecraft.item.ItemStack.func_77970_a(p_94527_0_.func_75211_c(), p_94527_1_)) {
            return p_94527_0_.func_75211_c().func_190916_E() + (p_94527_2_ ? 0 : p_94527_1_.func_190916_E()) <= p_94527_1_.func_77976_d();
        }
        return flag;
    }

    public static void func_94525_a(Set<Slot> p_94525_0_, int p_94525_1_, net.minecraft.item.ItemStack p_94525_2_, int p_94525_3_) {
        switch (p_94525_1_) {
            case 0: {
                p_94525_2_.func_190920_e(MathHelper.func_76141_d((float)((float)p_94525_2_.func_190916_E() / (float)p_94525_0_.size())));
                break;
            }
            case 1: {
                p_94525_2_.func_190920_e(1);
                break;
            }
            case 2: {
                p_94525_2_.func_190920_e(p_94525_2_.func_77976_d());
            }
        }
        p_94525_2_.func_190917_f(p_94525_3_);
    }

    public boolean func_94531_b(Slot p_94531_1_) {
        return true;
    }

    public static int func_178144_a(@Nullable TileEntity p_178144_0_) {
        return p_178144_0_ instanceof IInventory ? Container.func_94526_b((IInventory)((Object)p_178144_0_)) : 0;
    }

    public static int func_94526_b(@Nullable IInventory p_94526_0_) {
        if (p_94526_0_ == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < p_94526_0_.func_70302_i_(); ++j) {
            net.minecraft.item.ItemStack itemstack = p_94526_0_.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)Math.min(p_94526_0_.func_70297_j_(), itemstack.func_77976_d());
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)p_94526_0_.func_70302_i_()) * 14.0f)) + (i > 0 ? 1 : 0);
    }
}

