/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DeadCoralWallFanBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;

public class BoneMealItem
extends Item {
    public BoneMealItem(Item.Properties p_i50055_1_) {
        super(p_i50055_1_);
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext p_195939_1_) {
        return BoneMealItem.applyBonemeal(p_195939_1_);
    }

    public static ActionResultType applyBonemeal(ItemUseContext p_195939_1_) {
        World world = p_195939_1_.func_195991_k();
        BlockPos blockpos = p_195939_1_.func_195995_a();
        BlockPos blockpos1 = blockpos.func_177972_a(p_195939_1_.func_196000_l());
        if (BoneMealItem.applyBonemeal(p_195939_1_.func_195996_i(), world, blockpos, p_195939_1_.func_195999_j())) {
            if (!world.field_72995_K) {
                world.func_217379_c(2005, blockpos, 0);
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        BlockState blockstate = world.func_180495_p(blockpos);
        boolean flag = blockstate.func_224755_d((IBlockReader)((Object)world), blockpos, p_195939_1_.func_196000_l());
        if (flag && BoneMealItem.func_203173_b(p_195939_1_.func_195996_i(), world, blockpos1, p_195939_1_.func_196000_l())) {
            if (!world.field_72995_K) {
                world.func_217379_c(2005, blockpos1, 0);
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    @Deprecated
    public static boolean func_195966_a(ItemStack p_195966_0_, World p_195966_1_, BlockPos p_195966_2_) {
        if (p_195966_1_ instanceof ServerWorld) {
            return BoneMealItem.applyBonemeal(p_195966_0_, p_195966_1_, p_195966_2_, (PlayerEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)p_195966_1_)));
        }
        return false;
    }

    public static boolean applyBonemeal(ItemStack p_195966_0_, World p_195966_1_, BlockPos p_195966_2_, PlayerEntity player) {
        IGrowable igrowable;
        BlockState blockstate = p_195966_1_.func_180495_p(p_195966_2_);
        int hook = ForgeEventFactory.onApplyBonemeal((PlayerEntity)player, (World)p_195966_1_, (BlockPos)p_195966_2_, (BlockState)blockstate, (ItemStack)p_195966_0_);
        if (hook != 0) {
            return hook > 0;
        }
        if (blockstate.func_177230_c() instanceof IGrowable && (igrowable = (IGrowable)blockstate.func_177230_c()).func_176473_a((IBlockReader)((Object)p_195966_1_), p_195966_2_, blockstate, p_195966_1_.field_72995_K)) {
            if (p_195966_1_ instanceof ServerWorld) {
                if (igrowable.func_180670_a(p_195966_1_, p_195966_1_.field_73012_v, p_195966_2_, blockstate)) {
                    igrowable.func_225535_a_((ServerWorld)p_195966_1_, p_195966_1_.field_73012_v, p_195966_2_, blockstate);
                }
                p_195966_0_.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    public static boolean func_203173_b(ItemStack p_203173_0_, World p_203173_1_, BlockPos p_203173_2_, @Nullable Direction p_203173_3_) {
        if (p_203173_1_.func_180495_p(p_203173_2_).func_203425_a(Blocks.field_150355_j) && p_203173_1_.func_204610_c(p_203173_2_).func_206882_g() == 8) {
            if (!(p_203173_1_ instanceof ServerWorld)) {
                return true;
            }
            block0: for (int i = 0; i < 128; ++i) {
                BlockPos blockpos = p_203173_2_;
                BlockState blockstate = Blocks.field_203198_aQ.func_176223_P();
                for (int j = 0; j < i / 16; ++j) {
                    if (p_203173_1_.func_180495_p(blockpos = blockpos.func_177982_a(field_77697_d.nextInt(3) - 1, (field_77697_d.nextInt(3) - 1) * field_77697_d.nextInt(3) / 2, field_77697_d.nextInt(3) - 1)).func_235785_r_((IBlockReader)((Object)p_203173_1_), blockpos)) continue block0;
                }
                Optional optional = p_203173_1_.func_242406_i(blockpos);
                if (Objects.equals(optional, Optional.of(Biomes.field_203614_T)) || Objects.equals(optional, Optional.of(Biomes.field_203617_W))) {
                    if (i == 0 && p_203173_3_ != null && p_203173_3_.func_176740_k().func_176722_c()) {
                        blockstate = (BlockState)((Block)((Object)BlockTags.field_211922_B.func_205596_a(p_203173_1_.field_73012_v))).func_176223_P().func_206870_a(DeadCoralWallFanBlock.field_211884_b, p_203173_3_);
                    } else if (field_77697_d.nextInt(4) == 0) {
                        blockstate = ((Block)((Object)BlockTags.field_212741_H.func_205596_a(field_77697_d))).func_176223_P();
                    }
                }
                if (blockstate.func_177230_c().func_203417_a(BlockTags.field_211922_B)) {
                    for (int k = 0; !blockstate.func_196955_c((IWorldReader)((Object)p_203173_1_), blockpos) && k < 4; ++k) {
                        blockstate = (BlockState)blockstate.func_206870_a(DeadCoralWallFanBlock.field_211884_b, Direction.Plane.HORIZONTAL.func_179518_a(field_77697_d));
                    }
                }
                if (!blockstate.func_196955_c((IWorldReader)((Object)p_203173_1_), blockpos)) continue;
                BlockState blockstate1 = p_203173_1_.func_180495_p(blockpos);
                if (blockstate1.func_203425_a(Blocks.field_150355_j) && p_203173_1_.func_204610_c(blockpos).func_206882_g() == 8) {
                    p_203173_1_.func_180501_a(blockpos, blockstate, 3);
                    continue;
                }
                if (!blockstate1.func_203425_a(Blocks.field_203198_aQ) || field_77697_d.nextInt(10) != 0) continue;
                ((IGrowable)Blocks.field_203198_aQ).func_225535_a_((ServerWorld)p_203173_1_, field_77697_d, blockpos, blockstate1);
            }
            p_203173_0_.func_190918_g(1);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void func_195965_a(IWorld p_195965_0_, BlockPos p_195965_1_, int p_195965_2_) {
        BlockState blockstate;
        if (p_195965_2_ == 0) {
            p_195965_2_ = 15;
        }
        if (!(blockstate = p_195965_0_.func_180495_p(p_195965_1_)).isAir((IBlockReader)((Object)p_195965_0_), p_195965_1_)) {
            double d1;
            double d0 = 0.5;
            if (blockstate.func_203425_a(Blocks.field_150355_j)) {
                p_195965_2_ *= 3;
                d1 = 1.0;
                d0 = 3.0;
            } else if (blockstate.func_200015_d((IBlockReader)((Object)p_195965_0_), p_195965_1_)) {
                p_195965_1_ = p_195965_1_.func_177984_a();
                p_195965_2_ *= 3;
                d0 = 3.0;
                d1 = 1.0;
            } else {
                d1 = blockstate.func_196954_c((IBlockReader)((Object)p_195965_0_), p_195965_1_).func_197758_c(Direction.Axis.Y);
            }
            p_195965_0_.func_195594_a((IParticleData)ParticleTypes.field_197632_y, (double)p_195965_1_.func_177958_n() + 0.5, (double)p_195965_1_.func_177956_o() + 0.5, (double)p_195965_1_.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            for (int i = 0; i < p_195965_2_; ++i) {
                double d8;
                double d7;
                double d2 = field_77697_d.nextGaussian() * 0.02;
                double d3 = field_77697_d.nextGaussian() * 0.02;
                double d4 = field_77697_d.nextGaussian() * 0.02;
                double d5 = 0.5 - d0;
                double d6 = (double)p_195965_1_.func_177958_n() + d5 + field_77697_d.nextDouble() * d0 * 2.0;
                if (p_195965_0_.func_180495_p(new BlockPos(d6, d7 = (double)p_195965_1_.func_177956_o() + field_77697_d.nextDouble() * d1, d8 = (double)p_195965_1_.func_177952_p() + d5 + field_77697_d.nextDouble() * d0 * 2.0).func_177977_b()).func_196958_f()) continue;
                p_195965_0_.func_195594_a((IParticleData)ParticleTypes.field_197632_y, d6, d7, d8, d2, d3, d4);
            }
        }
    }
}

