/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.EndPortalFrameBlock;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.EyeOfEnderEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;

public class EnderEyeItem
extends Item {
    public EnderEyeItem(Item.Properties p_i48502_1_) {
        super(p_i48502_1_);
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext p_195939_1_) {
        BlockPos blockpos;
        World world = p_195939_1_.func_195991_k();
        BlockState blockstate = world.func_180495_p(blockpos = p_195939_1_.func_195995_a());
        if (blockstate.func_203425_a(Blocks.field_150378_br) && !((Boolean)blockstate.func_177229_b(EndPortalFrameBlock.field_176507_b)).booleanValue()) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            BlockState blockstate1 = (BlockState)blockstate.func_206870_a(EndPortalFrameBlock.field_176507_b, true);
            Block.func_199601_a(blockstate, blockstate1, world, blockpos);
            world.func_180501_a(blockpos, blockstate1, 2);
            world.func_175666_e(blockpos, Blocks.field_150378_br);
            p_195939_1_.func_195996_i().func_190918_g(1);
            world.func_217379_c(1503, blockpos, 0);
            BlockPattern.PatternHelper blockpattern$patternhelper = EndPortalFrameBlock.func_185661_e().func_177681_a((IWorldReader)((Object)world), blockpos);
            if (blockpattern$patternhelper != null) {
                BlockPos blockpos1 = blockpattern$patternhelper.func_181117_a().func_177982_a(-3, 0, -3);
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        world.func_180501_a(blockpos1.func_177982_a(i, 0, j), Blocks.field_150384_bq.func_176223_P(), 2);
                    }
                }
                int viewDistance = world.getCBServer().getViewDistance() * 16;
                BlockPos soundPos = blockpos1.func_177982_a(1, 0, 1);
                world.func_73046_m();
                for (ServerPlayerEntity player : MinecraftServer.getServer().func_184103_al().field_72404_b) {
                    double deltaX = (double)soundPos.func_177958_n() - player.func_226277_ct_();
                    double deltaZ = (double)soundPos.func_177952_p() - player.func_226281_cx_();
                    double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    if (world.spigotConfig.endPortalSoundRadius > 0 && distanceSquared > (double)(world.spigotConfig.endPortalSoundRadius * world.spigotConfig.endPortalSoundRadius)) continue;
                    if (distanceSquared > (double)(viewDistance * viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.func_226277_ct_() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.func_226281_cx_() + deltaZ / deltaLength * (double)viewDistance;
                        player.field_71135_a.func_147359_a((IPacket<?>)new SPlaySoundEventPacket(1038, new BlockPos((int)relativeX, soundPos.func_177956_o(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.field_71135_a.func_147359_a((IPacket<?>)new SPlaySoundEventPacket(1038, soundPos, 0, true));
                }
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World p_77659_1_, PlayerEntity p_77659_2_, Hand p_77659_3_) {
        BlockPos blockpos;
        ItemStack itemstack = p_77659_2_.func_184586_b(p_77659_3_);
        BlockRayTraceResult raytraceresult = EnderEyeItem.func_219968_a(p_77659_1_, p_77659_2_, RayTraceContext.FluidMode.NONE);
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK && p_77659_1_.func_180495_p(raytraceresult.func_216350_a()).func_203425_a(Blocks.field_150378_br)) {
            return ActionResult.func_226250_c_((Object)((Object)itemstack));
        }
        p_77659_2_.func_184598_c(p_77659_3_);
        if (p_77659_1_ instanceof ServerWorld && (blockpos = ((ServerWorld)p_77659_1_).func_72863_F().func_201711_g().func_235956_a_((ServerWorld)p_77659_1_, Structure.field_236375_k_, p_77659_2_.func_233580_cy_(), 100, false)) != null) {
            EyeOfEnderEntity eyeofenderentity = new EyeOfEnderEntity(p_77659_1_, p_77659_2_.func_226277_ct_(), p_77659_2_.func_226283_e_(0.5), p_77659_2_.func_226281_cx_());
            eyeofenderentity.func_213863_b(itemstack);
            eyeofenderentity.func_180465_a(blockpos);
            if (!p_77659_1_.func_217376_c(eyeofenderentity)) {
                return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
            }
            if (p_77659_2_ instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_192132_l.func_192239_a((ServerPlayerEntity)p_77659_2_, blockpos);
            }
            p_77659_1_.func_184148_a(null, p_77659_2_.func_226277_ct_(), p_77659_2_.func_226278_cu_(), p_77659_2_.func_226281_cx_(), SoundEvents.field_187528_aR, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            p_77659_1_.func_217378_a(null, 1003, p_77659_2_.func_233580_cy_(), 0);
            if (!p_77659_2_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            p_77659_2_.func_71029_a(Stats.field_75929_E.func_199076_b(this));
            p_77659_2_.func_226292_a_(p_77659_3_, true);
            return ActionResult.func_226248_a_((Object)((Object)itemstack));
        }
        return ActionResult.func_226249_b_((Object)((Object)itemstack));
    }
}

