/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Food;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeItem;
import net.minecraftforge.common.util.ReverseTagWrapper;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.GameData;

public class Item
extends ForgeRegistryEntry<Item>
implements IItemProvider,
IForgeItem {
    public static final Map<Block, Item> field_179220_a = GameData.getBlockItemMap();
    protected static final UUID field_111210_e = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID field_185050_h = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    protected static final Random field_77697_d = new Random();
    protected final ItemGroup field_77701_a;
    private final Rarity field_208075_l;
    private final int field_77777_bU;
    private final int field_77699_b;
    private final boolean field_234684_d_;
    private final Item field_77700_c;
    @Nullable
    private String field_77774_bZ;
    @Nullable
    private final Food field_219974_q;
    @Nullable
    private final Supplier<ItemStackTileEntityRenderer> ister;
    private final Map<ToolType, Integer> toolClasses = Maps.newHashMap();
    private final ReverseTagWrapper<Item> reverseTags = new ReverseTagWrapper((Object)this, ItemTags::func_199903_a);
    protected final boolean canRepair;

    public static int func_150891_b(Item p_150891_0_) {
        return p_150891_0_ == null ? 0 : Registry.field_212630_s.func_148757_b((Object)p_150891_0_);
    }

    public static Item func_150899_d(int p_150899_0_) {
        return (Item)((Object)Registry.field_212630_s.func_148745_a(p_150899_0_));
    }

    @Deprecated
    public static Item func_150898_a(Block p_150898_0_) {
        return field_179220_a.getOrDefault((Object)p_150898_0_, Items.field_190931_a);
    }

    public Item(Properties p_i48487_1_) {
        this.field_77701_a = p_i48487_1_.field_200923_d;
        this.field_208075_l = p_i48487_1_.field_208104_e;
        this.field_77700_c = p_i48487_1_.field_200922_c;
        this.field_77699_b = p_i48487_1_.field_200921_b;
        this.field_77777_bU = p_i48487_1_.field_200920_a;
        this.field_219974_q = p_i48487_1_.field_221541_f;
        this.field_234684_d_ = p_i48487_1_.field_234688_g_;
        this.canRepair = p_i48487_1_.canRepair;
        this.toolClasses.putAll(p_i48487_1_.toolClasses);
        Object tmp = p_i48487_1_.ister == null ? null : DistExecutor.callWhenOn((Dist)Dist.CLIENT, (Supplier)p_i48487_1_.ister);
        this.ister = tmp == null ? null : () -> (ItemStackTileEntityRenderer)tmp;
    }

    public void func_219972_a(World p_219972_1_, LivingEntity p_219972_2_, ItemStack p_219972_3_, int p_219972_4_) {
    }

    public boolean func_179215_a(CompoundNBT p_179215_1_) {
        return false;
    }

    public boolean func_195938_a(BlockState p_195938_1_, World p_195938_2_, BlockPos p_195938_3_, PlayerEntity p_195938_4_) {
        return true;
    }

    public Item func_199767_j() {
        return this;
    }

    public ActionResultType func_195939_a(ItemUseContext p_195939_1_) {
        return ActionResultType.PASS;
    }

    public float func_150893_a(ItemStack p_150893_1_, BlockState p_150893_2_) {
        return 1.0f;
    }

    public ActionResult<ItemStack> func_77659_a(World p_77659_1_, PlayerEntity p_77659_2_, Hand p_77659_3_) {
        if (this.func_219971_r()) {
            ItemStack itemstack = p_77659_2_.func_184586_b(p_77659_3_);
            if (p_77659_2_.func_71043_e(this.func_219967_s().func_221468_d())) {
                p_77659_2_.func_184598_c(p_77659_3_);
                return ActionResult.func_226249_b_((Object)((Object)itemstack));
            }
            return ActionResult.func_226251_d_((Object)((Object)itemstack));
        }
        return ActionResult.func_226250_c_((Object)((Object)p_77659_2_.func_184586_b(p_77659_3_)));
    }

    public ItemStack func_77654_b(ItemStack p_77654_1_, World p_77654_2_, LivingEntity p_77654_3_) {
        return this.func_219971_r() ? p_77654_3_.func_213357_a(p_77654_2_, p_77654_1_) : p_77654_1_;
    }

    @Deprecated
    public final int func_77639_j() {
        return this.field_77777_bU;
    }

    @Deprecated
    public final int func_77612_l() {
        return this.field_77699_b;
    }

    public boolean func_77645_m() {
        return this.field_77699_b > 0;
    }

    public boolean func_77644_a(ItemStack p_77644_1_, LivingEntity p_77644_2_, LivingEntity p_77644_3_) {
        return false;
    }

    public boolean func_179218_a(ItemStack p_179218_1_, World p_179218_2_, BlockState p_179218_3_, BlockPos p_179218_4_, LivingEntity p_179218_5_) {
        return false;
    }

    public boolean func_150897_b(BlockState p_150897_1_) {
        return false;
    }

    public ActionResultType func_111207_a(ItemStack p_111207_1_, PlayerEntity p_111207_2_, LivingEntity p_111207_3_, Hand p_111207_4_) {
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_200296_o() {
        return new TranslationTextComponent(this.func_77658_a());
    }

    public String toString() {
        return Registry.field_212630_s.func_177774_c((Object)this).func_110623_a();
    }

    protected String func_195935_o() {
        if (this.field_77774_bZ == null) {
            this.field_77774_bZ = Util.func_200697_a("item", Registry.field_212630_s.func_177774_c((Object)this));
        }
        return this.field_77774_bZ;
    }

    public String func_77658_a() {
        return this.func_195935_o();
    }

    public String func_77667_c(ItemStack p_77667_1_) {
        return this.func_77658_a();
    }

    public boolean func_77651_p() {
        return true;
    }

    @Nullable
    @Deprecated
    public final Item func_77668_q() {
        return this.field_77700_c;
    }

    @Deprecated
    public boolean func_77634_r() {
        return this.field_77700_c != null;
    }

    public void func_77663_a(ItemStack p_77663_1_, World p_77663_2_, Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
    }

    public void func_77622_d(ItemStack p_77622_1_, World p_77622_2_, PlayerEntity p_77622_3_) {
    }

    public boolean func_77643_m_() {
        return false;
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return p_77661_1_.func_77973_b().func_219971_r() ? UseAction.EAT : UseAction.NONE;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        if (p_77626_1_.func_77973_b().func_219971_r()) {
            return this.func_219967_s().func_221465_e() ? 16 : 32;
        }
        return 0;
    }

    public void func_77615_a(ItemStack p_77615_1_, World p_77615_2_, LivingEntity p_77615_3_, int p_77615_4_) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack p_77624_1_, @Nullable World p_77624_2_, List<ITextComponent> p_77624_3_, ITooltipFlag p_77624_4_) {
    }

    public ITextComponent func_200295_i(ItemStack p_200295_1_) {
        return new TranslationTextComponent(this.func_77667_c(p_200295_1_));
    }

    public boolean func_77636_d(ItemStack p_77636_1_) {
        return p_77636_1_.func_77948_v();
    }

    public Rarity func_77613_e(ItemStack p_77613_1_) {
        if (!p_77613_1_.func_77948_v()) {
            return this.field_208075_l;
        }
        switch (this.field_208075_l) {
            case COMMON: 
            case UNCOMMON: {
                return Rarity.RARE;
            }
            case RARE: {
                return Rarity.EPIC;
            }
        }
        return this.field_208075_l;
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return this.getItemStackLimit(p_77616_1_) == 1 && this.isDamageable(p_77616_1_);
    }

    protected static BlockRayTraceResult func_219968_a(World p_219968_0_, PlayerEntity p_219968_1_, RayTraceContext.FluidMode p_219968_2_) {
        float f = p_219968_1_.field_70125_A;
        float f1 = p_219968_1_.field_70177_z;
        Vector3d vector3d = p_219968_1_.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = p_219968_1_.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        Vector3d vector3d1 = vector3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return p_219968_0_.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.OUTLINE, p_219968_2_, p_219968_1_));
    }

    public int func_77619_b() {
        return 0;
    }

    public void func_150895_a(ItemGroup p_150895_1_, NonNullList<ItemStack> p_150895_2_) {
        if (this.func_194125_a(p_150895_1_)) {
            p_150895_2_.add(new ItemStack(this));
        }
    }

    protected boolean func_194125_a(ItemGroup p_194125_1_) {
        if (this.getCreativeTabs().stream().anyMatch(tab -> tab == p_194125_1_)) {
            return true;
        }
        ItemGroup itemgroup = this.func_77640_w();
        return itemgroup != null && (p_194125_1_ == ItemGroup.field_78027_g || p_194125_1_ == itemgroup);
    }

    @Nullable
    public final ItemGroup func_77640_w() {
        return this.field_77701_a;
    }

    public boolean func_82789_a(ItemStack p_82789_1_, ItemStack p_82789_2_) {
        return false;
    }

    @Deprecated
    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType p_111205_1_) {
        return ImmutableMultimap.of();
    }

    public boolean isRepairable(ItemStack stack) {
        return this.canRepair && this.isDamageable(stack);
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        return this.toolClasses.keySet();
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        return this.toolClasses.getOrDefault(tool, -1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public final ItemStackTileEntityRenderer getItemStackTileEntityRenderer() {
        ItemStackTileEntityRenderer renderer = this.ister != null ? this.ister.get() : null;
        return renderer != null ? renderer : ItemStackTileEntityRenderer.field_147719_a;
    }

    public Set<ResourceLocation> getTags() {
        return this.reverseTags.getTagNames();
    }

    public boolean func_219970_i(ItemStack p_219970_1_) {
        return p_219970_1_.func_77973_b() == Items.field_222114_py;
    }

    public ItemStack func_190903_i() {
        return new ItemStack(this);
    }

    public boolean func_206844_a(ITag<Item> p_206844_1_) {
        return p_206844_1_.func_230235_a_(this);
    }

    public boolean func_219971_r() {
        return this.field_219974_q != null;
    }

    @Nullable
    public Food func_219967_s() {
        return this.field_219974_q;
    }

    public SoundEvent func_225520_U__() {
        return SoundEvents.field_187664_bz;
    }

    public SoundEvent func_225519_S__() {
        return SoundEvents.field_187537_bA;
    }

    public boolean func_234687_u_() {
        return this.field_234684_d_;
    }

    public boolean func_234685_a_(DamageSource p_234685_1_) {
        return !this.field_234684_d_ || !p_234685_1_.func_76347_k();
    }

    public static class Properties {
        private int field_200920_a = 64;
        private int field_200921_b;
        private Item field_200922_c;
        private ItemGroup field_200923_d;
        private Rarity field_208104_e = Rarity.COMMON;
        private Food field_221541_f;
        private boolean field_234688_g_;
        private boolean canRepair = true;
        private Map<ToolType, Integer> toolClasses = Maps.newHashMap();
        private Supplier<Callable<ItemStackTileEntityRenderer>> ister;

        public Properties func_221540_a(Food p_221540_1_) {
            this.field_221541_f = p_221540_1_;
            return this;
        }

        public Properties func_200917_a(int p_200917_1_) {
            if (this.field_200921_b > 0) {
                throw new RuntimeException("Unable to have damage AND stack.");
            }
            this.field_200920_a = p_200917_1_;
            return this;
        }

        public Properties func_200915_b(int p_200915_1_) {
            return this.field_200921_b == 0 ? this.func_200918_c(p_200915_1_) : this;
        }

        public Properties func_200918_c(int p_200918_1_) {
            this.field_200921_b = p_200918_1_;
            this.field_200920_a = 1;
            return this;
        }

        public Properties func_200919_a(Item p_200919_1_) {
            this.field_200922_c = p_200919_1_;
            return this;
        }

        public Properties func_200916_a(ItemGroup p_200916_1_) {
            this.field_200923_d = p_200916_1_;
            return this;
        }

        public Properties func_208103_a(Rarity p_208103_1_) {
            this.field_208104_e = p_208103_1_;
            return this;
        }

        public Properties func_234689_a_() {
            this.field_234688_g_ = true;
            return this;
        }

        public Properties setNoRepair() {
            this.canRepair = false;
            return this;
        }

        public Properties addToolType(ToolType type, int level) {
            this.toolClasses.put(type, level);
            return this;
        }

        public Properties setISTER(Supplier<Callable<ItemStackTileEntityRenderer>> ister) {
            this.ister = ister;
            return this;
        }
    }
}

