/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class ShovelItem
extends ToolItem {
    private static final Set<Block> field_150916_c = Sets.newHashSet((Object[])new Block[]{Blocks.field_150435_aG, Blocks.field_150346_d, Blocks.field_196660_k, Blocks.field_196661_l, Blocks.field_150458_ak, Blocks.field_196658_i, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_196611_F, Blocks.field_196604_cC, Blocks.field_150433_aE, Blocks.field_150425_aM, Blocks.field_185774_da, Blocks.field_196860_iS, Blocks.field_196862_iT, Blocks.field_196864_iU, Blocks.field_196866_iV, Blocks.field_196868_iW, Blocks.field_196870_iX, Blocks.field_196872_iY, Blocks.field_196874_iZ, Blocks.field_196877_ja, Blocks.field_196878_jb, Blocks.field_196879_jc, Blocks.field_196880_jd, Blocks.field_196881_je, Blocks.field_196882_jf, Blocks.field_196883_jg, Blocks.field_196884_jh, Blocks.field_235336_cN_});
    protected static final Map<Block, BlockState> field_195955_e = Maps.newHashMap((Map)ImmutableMap.of((Object)((Object)Blocks.field_196658_i), (Object)Blocks.field_185774_da.func_176223_P()));

    public ShovelItem(IItemTier p_i48469_1_, float p_i48469_2_, float p_i48469_3_, Item.Properties p_i48469_4_) {
        super(p_i48469_2_, p_i48469_3_, p_i48469_1_, field_150916_c, p_i48469_4_.addToolType(ToolType.SHOVEL, p_i48469_1_.func_200925_d()));
    }

    public boolean func_150897_b(BlockState p_150897_1_) {
        return p_150897_1_.func_203425_a(Blocks.field_150433_aE) || p_150897_1_.func_203425_a(Blocks.field_196604_cC);
    }

    public ActionResultType func_195939_a(ItemUseContext p_195939_1_) {
        World world = p_195939_1_.func_195991_k();
        BlockPos blockpos = p_195939_1_.func_195995_a();
        BlockState blockstate = world.func_180495_p(blockpos);
        if (p_195939_1_.func_196000_l() == Direction.DOWN) {
            return ActionResultType.PASS;
        }
        PlayerEntity playerentity = p_195939_1_.func_195999_j();
        BlockState blockstate1 = blockstate.getToolModifiedState(world, blockpos, playerentity, p_195939_1_.func_195996_i(), ToolType.SHOVEL);
        BlockState blockstate2 = null;
        if (blockstate1 != null && world.func_175623_d(blockpos.func_177984_a())) {
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            blockstate2 = blockstate1;
        } else if (blockstate.func_177230_c() instanceof CampfireBlock && ((Boolean)blockstate.func_177229_b(CampfireBlock.field_220101_b)).booleanValue()) {
            if (!world.func_201670_d()) {
                world.func_217378_a(null, 1009, blockpos, 0);
            }
            CampfireBlock.func_235475_c_(world, blockpos, blockstate);
            blockstate2 = (BlockState)blockstate.func_206870_a(CampfireBlock.field_220101_b, false);
        }
        if (blockstate2 != null) {
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, blockstate2, 11);
                if (playerentity != null) {
                    p_195939_1_.func_195996_i().func_222118_a(1, playerentity, p_220041_1_ -> p_220041_1_.func_213334_d(p_195939_1_.func_221531_n()));
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    @Nullable
    public static BlockState getShovelPathingState(BlockState originalState) {
        return field_195955_e.get((Object)originalState.func_177230_c());
    }
}

