/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mohistmc.util.i18n.i18n;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spigotmc.AsyncCatcher;

public class RecipeManager
extends JsonReloadListener {
    private static final Gson field_223401_a = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger field_199521_c = LogManager.getLogger();
    public Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> field_199522_d = ImmutableMap.of();
    public Map<IRecipeType<?>, Object2ObjectLinkedOpenHashMap<ResourceLocation, IRecipe<?>>> recipesCB = ImmutableMap.of();
    private boolean field_199523_e;

    public RecipeManager() {
        super(field_223401_a, "recipes");
    }

    protected void func_212853_a_(Map<ResourceLocation, JsonElement> p_212853_1_, IResourceManager p_212853_2_, IProfiler p_212853_3_) {
        Map.Entry<ResourceLocation, JsonElement> entry2;
        this.field_199523_e = false;
        HashMap map = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry2 : p_212853_1_.entrySet()) {
            ResourceLocation resourcelocation = entry2.getKey();
            if (resourcelocation.func_110623_a().startsWith("_")) continue;
            try {
                if (entry2.getValue().isJsonObject() && !CraftingHelper.processConditions((JsonObject)((JsonElement)entry2.getValue()).getAsJsonObject(), (String)"conditions")) {
                    field_199521_c.debug(i18n.get((String)"recipemanager.1", (Object[])new Object[]{resourcelocation}));
                    continue;
                }
                IRecipe<?> irecipe = RecipeManager.func_215377_a(resourcelocation, JSONUtils.func_151210_l((JsonElement)((JsonElement)entry2.getValue()), (String)"top element"));
                if (irecipe == null) continue;
                map.computeIfAbsent(irecipe.func_222127_g(), p_223391_0_ -> ImmutableMap.builder()).put((Object)resourcelocation, irecipe);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                field_199521_c.debug(i18n.get((String)"recipemanager.3", (Object[])new Object[]{resourcelocation}), jsonparseexception);
            }
        }
        this.field_199522_d = (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, p_223400_0_ -> ((ImmutableMap.Builder)p_223400_0_.getValue()).build()));
        HashMap map1 = Maps.newHashMap();
        entry2 = Registry.field_218367_H.iterator();
        while (entry2.hasNext()) {
            IRecipeType recipeType = (IRecipeType)entry2.next();
            map1.put(recipeType, new Object2ObjectLinkedOpenHashMap());
        }
        for (Map.Entry<ResourceLocation, JsonElement> entry3 : p_212853_1_.entrySet()) {
            ResourceLocation minecraftkey = entry3.getKey();
            try {
                if (entry3.getValue().isJsonObject() && !CraftingHelper.processConditions((JsonObject)entry3.getValue().getAsJsonObject(), (String)"conditions")) {
                    field_199521_c.debug(i18n.get((String)"recipemanager.1", (Object[])new Object[]{minecraftkey}));
                    continue;
                }
                IRecipe<?> irecipe = RecipeManager.func_215377_a(minecraftkey, JSONUtils.func_151210_l((JsonElement)entry3.getValue(), (String)"top element"));
                if (irecipe == null) continue;
                map1.computeIfAbsent(irecipe.func_222127_g(), recipes -> new Object2ObjectLinkedOpenHashMap()).putAndMoveToFirst((Object)minecraftkey, irecipe);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                String msg = jsonparseexception.getMessage();
                if (msg != null && msg.startsWith("Unknown item")) continue;
                field_199521_c.debug(i18n.get((String)"recipemanager.3", (Object[])new Object[]{minecraftkey}), jsonparseexception);
            }
        }
        this.recipesCB = (Map)map1.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry1 -> (Object2ObjectLinkedOpenHashMap)entry1.getValue()));
    }

    public void addRecipe(IRecipe<?> irecipe) {
        AsyncCatcher.catchOp((String)"Recipe Add");
        Map<ResourceLocation, IRecipe<?>> map = this.field_199522_d.get(irecipe.func_222127_g());
        Object2ObjectLinkedOpenHashMap<ResourceLocation, IRecipe<?>> map1 = this.recipesCB.get(irecipe.func_222127_g());
        if (map.containsKey(irecipe.func_199560_c()) || map1 != null && map1.containsKey((Object)irecipe.func_199560_c())) {
            return;
        }
        ImmutableMap newmap = new HashMap();
        newmap.putAll(map);
        newmap.put(irecipe.func_199560_c(), irecipe);
        newmap = ImmutableMap.copyOf(newmap);
        HashMap newrecipes = new HashMap();
        newrecipes.putAll(this.field_199522_d);
        newrecipes.put(irecipe.func_222127_g(), (Map<ResourceLocation, IRecipe<Object>>)newmap);
        this.field_199522_d = ImmutableMap.copyOf(newrecipes);
        map1.putAndMoveToFirst((Object)irecipe.func_199560_c(), irecipe);
    }

    public <C extends IInventory, T extends IRecipe<C>> Optional<T> func_215371_a(IRecipeType<T> p_215371_1_, C p_215371_2_, World p_215371_3_) {
        Optional recipe = this.func_215366_a(p_215371_1_).values().stream().flatMap(p_215372_3_ -> Util.func_215081_a(p_215371_1_.func_222148_a(p_215372_3_, p_215371_3_, p_215371_2_))).findFirst();
        p_215371_2_.setCurrentRecipe(recipe.orElse(null));
        return recipe;
    }

    public <C extends IInventory, T extends IRecipe<C>> List<T> func_241447_a_(IRecipeType<T> p_241447_1_) {
        return this.func_215366_a(p_241447_1_).values().stream().map(p_241453_0_ -> p_241453_0_).collect(Collectors.toList());
    }

    public <C extends IInventory, T extends IRecipe<C>> List<T> func_215370_b(IRecipeType<T> p_215370_1_, C p_215370_2_, World p_215370_3_) {
        return this.func_215366_a(p_215370_1_).values().stream().flatMap(p_215380_3_ -> Util.func_215081_a(p_215370_1_.func_222148_a(p_215380_3_, p_215370_3_, p_215370_2_))).sorted(Comparator.comparing(p_215379_0_ -> p_215379_0_.func_77571_b().func_77977_a())).collect(Collectors.toList());
    }

    private <C extends IInventory, T extends IRecipe<C>> Map<ResourceLocation, IRecipe<C>> func_215366_a(IRecipeType<T> p_215366_1_) {
        return this.field_199522_d.getOrDefault(p_215366_1_, Collections.emptyMap());
    }

    public <C extends IInventory, T extends IRecipe<C>> NonNullList<ItemStack> func_215369_c(IRecipeType<T> p_215369_1_, C p_215369_2_, World p_215369_3_) {
        Optional<T> optional = this.func_215371_a(p_215369_1_, p_215369_2_, p_215369_3_);
        if (optional.isPresent()) {
            return ((IRecipe)optional.get()).func_179532_b(p_215369_2_);
        }
        NonNullList<ItemStack> nonnulllist = NonNullList.func_191197_a(p_215369_2_.func_70302_i_(), ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, p_215369_2_.func_70301_a(i));
        }
        return nonnulllist;
    }

    public Optional<? extends IRecipe<?>> func_215367_a(ResourceLocation p_215367_1_) {
        return this.field_199522_d.values().stream().map(p_215368_1_ -> (IRecipe)p_215368_1_.get(p_215367_1_)).filter(Objects::nonNull).findFirst();
    }

    public Collection<IRecipe<?>> func_199510_b() {
        return this.field_199522_d.values().stream().flatMap(p_215376_0_ -> p_215376_0_.values().stream()).collect(Collectors.toSet());
    }

    public Stream<ResourceLocation> func_215378_c() {
        return this.field_199522_d.values().stream().flatMap(p_215375_0_ -> p_215375_0_.keySet().stream());
    }

    public static IRecipe<?> func_215377_a(ResourceLocation p_215377_0_, JsonObject p_215377_1_) {
        String s = JSONUtils.func_151200_h((JsonObject)p_215377_1_, (String)"type");
        return Registry.field_218368_I.func_241873_b(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Invalid or unsupported recipe type '" + s + "'")).func_199425_a_(p_215377_0_, p_215377_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_223389_a(Iterable<IRecipe<?>> p_223389_1_) {
        this.field_199523_e = false;
        HashMap map = Maps.newHashMap();
        p_223389_1_.forEach(p_223392_1_ -> {
            Map map1 = map.computeIfAbsent(p_223392_1_.func_222127_g(), p_223390_0_ -> Maps.newHashMap());
            IRecipe irecipe = map1.put(p_223392_1_.func_199560_c(), p_223392_1_);
            if (irecipe != null) {
                throw new IllegalStateException("Duplicate recipe ignored with ID " + p_223392_1_.func_199560_c());
            }
        });
        this.field_199522_d = ImmutableMap.copyOf((Map)map);
    }

    public void clearRecipes() {
        this.field_199522_d = Maps.newHashMap();
        this.recipesCB = Maps.newHashMap();
        Iterator iterator = Registry.field_218367_H.iterator();
        while (iterator.hasNext()) {
            IRecipeType recipeType = (IRecipeType)iterator.next();
            this.field_199522_d.put(recipeType, Collections.emptyMap());
            this.recipesCB.put(recipeType, new Object2ObjectLinkedOpenHashMap());
        }
    }
}

