/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftShapedRecipe;
import org.bukkit.inventory.RecipeChoice;

public class ShapedRecipe
implements ICraftingRecipe,
IShapedRecipe<CraftingInventory> {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    private final int field_77576_b;
    private final int field_77577_c;
    private final NonNullList<Ingredient> field_77574_d;
    private final ItemStack field_77575_e;
    private final ResourceLocation field_199561_e;
    private final String field_194137_e;

    public static void setCraftingSize(int width, int height) {
        if (MAX_WIDTH < width) {
            MAX_WIDTH = width;
        }
        if (MAX_HEIGHT < height) {
            MAX_HEIGHT = height;
        }
    }

    public ShapedRecipe(ResourceLocation p_i48162_1_, String p_i48162_2_, int p_i48162_3_, int p_i48162_4_, NonNullList<Ingredient> p_i48162_5_, ItemStack p_i48162_6_) {
        this.field_199561_e = p_i48162_1_;
        this.field_194137_e = p_i48162_2_;
        this.field_77576_b = p_i48162_3_;
        this.field_77577_c = p_i48162_4_;
        this.field_77574_d = p_i48162_5_;
        this.field_77575_e = p_i48162_6_;
    }

    public org.bukkit.inventory.ShapedRecipe toBukkitRecipe() {
        CraftItemStack result = CraftItemStack.asCraftCopy((org.bukkit.inventory.ItemStack)CraftItemStack.asBukkitCopy((ItemStack)this.func_77571_b()));
        CraftShapedRecipe craftRecipe = new CraftShapedRecipe((org.bukkit.inventory.ItemStack)result, this);
        craftRecipe.setGroup(this.field_194137_e);
        block0 : switch (this.field_77577_c) {
            case 1: {
                switch (this.field_77576_b) {
                    case 1: {
                        craftRecipe.shape(new String[]{"a"});
                        break;
                    }
                    case 2: {
                        craftRecipe.shape(new String[]{"ab"});
                        break;
                    }
                    case 3: {
                        craftRecipe.shape(new String[]{"abc"});
                    }
                }
                break;
            }
            case 2: {
                switch (this.field_77576_b) {
                    case 1: {
                        craftRecipe.shape(new String[]{"a", "b"});
                        break;
                    }
                    case 2: {
                        craftRecipe.shape(new String[]{"ab", "cd"});
                        break;
                    }
                    case 3: {
                        craftRecipe.shape(new String[]{"abc", "def"});
                    }
                }
                break;
            }
            case 3: {
                switch (this.field_77576_b) {
                    case 1: {
                        craftRecipe.shape(new String[]{"a", "b", "c"});
                        break block0;
                    }
                    case 2: {
                        craftRecipe.shape(new String[]{"ab", "cd", "ef"});
                        break block0;
                    }
                    case 3: {
                        craftRecipe.shape(new String[]{"abc", "def", "ghi"});
                    }
                }
            }
        }
        char c = 'a';
        for (Ingredient list : this.field_77574_d) {
            RecipeChoice choice = CraftRecipe.toBukkit((Ingredient)list);
            if (choice != null) {
                craftRecipe.setIngredient(c, choice);
            }
            c = (char)(c + 1);
        }
        return craftRecipe;
    }

    public ResourceLocation func_199560_c() {
        return this.field_199561_e;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return IRecipeSerializer.field_222157_a;
    }

    public String func_193358_e() {
        return this.field_194137_e;
    }

    public ItemStack func_77571_b() {
        return this.field_77575_e;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.field_77574_d;
    }

    public boolean func_194133_a(int p_194133_1_, int p_194133_2_) {
        return p_194133_1_ >= this.field_77576_b && p_194133_2_ >= this.field_77577_c;
    }

    public boolean func_77569_a(CraftingInventory p_77569_1_, World p_77569_2_) {
        for (int i = 0; i <= p_77569_1_.func_174922_i() - this.field_77576_b; ++i) {
            for (int j = 0; j <= p_77569_1_.func_174923_h() - this.field_77577_c; ++j) {
                if (this.func_77573_a(p_77569_1_, i, j, true)) {
                    return true;
                }
                if (!this.func_77573_a(p_77569_1_, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean func_77573_a(CraftingInventory p_77573_1_, int p_77573_2_, int p_77573_3_, boolean p_77573_4_) {
        for (int i = 0; i < p_77573_1_.func_174922_i(); ++i) {
            for (int j = 0; j < p_77573_1_.func_174923_h(); ++j) {
                int k = i - p_77573_2_;
                int l = j - p_77573_3_;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (k >= 0 && l >= 0 && k < this.field_77576_b && l < this.field_77577_c) {
                    ingredient = p_77573_4_ ? this.field_77574_d.get(this.field_77576_b - k - 1 + l * this.field_77576_b) : this.field_77574_d.get(k + l * this.field_77576_b);
                }
                if (ingredient.test(p_77573_1_.func_70301_a(i + j * p_77573_1_.func_174922_i()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77572_b(CraftingInventory p_77572_1_) {
        return this.func_77571_b().func_77946_l();
    }

    public int func_192403_f() {
        return this.field_77576_b;
    }

    public int getRecipeWidth() {
        return this.func_192403_f();
    }

    public int func_192404_g() {
        return this.field_77577_c;
    }

    public int getRecipeHeight() {
        return this.func_192404_g();
    }

    private static NonNullList<Ingredient> func_192402_a(String[] p_192402_0_, Map<String, Ingredient> p_192402_1_, int p_192402_2_, int p_192402_3_) {
        NonNullList<Ingredient> nonnulllist = NonNullList.func_191197_a(p_192402_2_ * p_192402_3_, Ingredient.field_193370_a);
        HashSet set = Sets.newHashSet(p_192402_1_.keySet());
        set.remove(" ");
        for (int i = 0; i < p_192402_0_.length; ++i) {
            for (int j = 0; j < p_192402_0_[i].length(); ++j) {
                String s = p_192402_0_[i].substring(j, j + 1);
                Ingredient ingredient = p_192402_1_.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + p_192402_2_ * i, ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] func_194134_a(String ... p_194134_0_) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < p_194134_0_.length; ++i1) {
            String s = p_194134_0_[i1];
            i = Math.min(i, ShapedRecipe.func_194135_a(s));
            int j1 = ShapedRecipe.func_194136_b(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (p_194134_0_.length == l) {
            return new String[0];
        }
        String[] astring = new String[p_194134_0_.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = p_194134_0_[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int func_194135_a(String p_194135_0_) {
        int i;
        for (i = 0; i < p_194135_0_.length() && p_194135_0_.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int func_194136_b(String p_194136_0_) {
        int i;
        for (i = p_194136_0_.length() - 1; i >= 0 && p_194136_0_.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static String[] func_192407_a(JsonArray p_192407_0_) {
        String[] astring = new String[p_192407_0_.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = JSONUtils.func_151206_a((JsonElement)p_192407_0_.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    private static Map<String, Ingredient> func_192408_a(JsonObject p_192408_0_) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : p_192408_0_.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.func_199802_a((JsonElement)entry.getValue()));
        }
        map.put(" ", Ingredient.field_193370_a);
        return map;
    }

    public static ItemStack func_199798_a(JsonObject p_199798_0_) {
        String s = JSONUtils.func_151200_h((JsonObject)p_199798_0_, (String)"item");
        Item item = (Item)((Object)Registry.field_212630_s.func_241873_b(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'")));
        if (p_199798_0_.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = JSONUtils.func_151208_a((JsonObject)p_199798_0_, (String)"count", (int)1);
        return CraftingHelper.getItemStack((JsonObject)p_199798_0_, (boolean)true);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapedRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("minecraft", "crafting_shaped");

        @Override
        public ShapedRecipe func_199425_a_(ResourceLocation p_199425_1_, JsonObject p_199425_2_) {
            String s = JSONUtils.func_151219_a((JsonObject)p_199425_2_, (String)"group", (String)"");
            Map map = ShapedRecipe.func_192408_a(JSONUtils.func_152754_s((JsonObject)p_199425_2_, (String)"key"));
            String[] astring = ShapedRecipe.func_194134_a(ShapedRecipe.func_192407_a(JSONUtils.func_151214_t((JsonObject)p_199425_2_, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList nonnulllist = ShapedRecipe.func_192402_a(astring, map, i, j);
            ItemStack itemstack = ShapedRecipe.func_199798_a(JSONUtils.func_152754_s((JsonObject)p_199425_2_, (String)"result"));
            return new ShapedRecipe(p_199425_1_, s, i, j, nonnulllist, itemstack);
        }

        @Override
        public ShapedRecipe func_199426_a_(ResourceLocation p_199426_1_, PacketBuffer p_199426_2_) {
            int i = p_199426_2_.func_150792_a();
            int j = p_199426_2_.func_150792_a();
            String s = p_199426_2_.func_150789_c(Short.MAX_VALUE);
            NonNullList<Ingredient> nonnulllist = NonNullList.func_191197_a(i * j, Ingredient.field_193370_a);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, Ingredient.func_199566_b(p_199426_2_));
            }
            ItemStack itemstack = p_199426_2_.func_150791_c();
            return new ShapedRecipe(p_199426_1_, s, i, j, nonnulllist, itemstack);
        }

        @Override
        public void func_199427_a_(PacketBuffer p_199427_1_, ShapedRecipe p_199427_2_) {
            p_199427_1_.func_150787_b(p_199427_2_.field_77576_b);
            p_199427_1_.func_150787_b(p_199427_2_.field_77577_c);
            p_199427_1_.func_180714_a(p_199427_2_.field_194137_e);
            for (Ingredient ingredient : p_199427_2_.field_77574_d) {
                ingredient.func_199564_a(p_199427_1_);
            }
            p_199427_1_.func_150788_a(p_199427_2_.field_77575_e);
        }
    }
}

