/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import co.aikar.util.Counter;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftShapelessRecipe;

public class ShapelessRecipe
implements ICraftingRecipe {
    private final ResourceLocation field_199562_a;
    private final String field_194138_c;
    private final ItemStack field_77580_a;
    private final NonNullList<Ingredient> field_77579_b;
    private final boolean isSimple;

    public ShapelessRecipe(ResourceLocation p_i48161_1_, String p_i48161_2_, ItemStack p_i48161_3_, NonNullList<Ingredient> p_i48161_4_) {
        this.field_199562_a = p_i48161_1_;
        this.field_194138_c = p_i48161_2_;
        this.field_77580_a = p_i48161_3_;
        this.field_77579_b = p_i48161_4_;
        this.isSimple = p_i48161_4_.stream().allMatch(Ingredient::isSimple);
    }

    public org.bukkit.inventory.ShapelessRecipe toBukkitRecipe() {
        CraftItemStack result = CraftItemStack.asCraftCopy((org.bukkit.inventory.ItemStack)CraftItemStack.asBukkitCopy((ItemStack)this.func_77571_b()));
        CraftShapelessRecipe recipe = new CraftShapelessRecipe((org.bukkit.inventory.ItemStack)result, this);
        recipe.setGroup(this.field_194138_c);
        for (Ingredient list : this.field_77579_b) {
            recipe.addIngredient(CraftRecipe.toBukkit((Ingredient)list));
        }
        return recipe;
    }

    public ResourceLocation func_199560_c() {
        return this.field_199562_a;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return IRecipeSerializer.field_222158_b;
    }

    public String func_193358_e() {
        return this.field_194138_c;
    }

    public ItemStack func_77571_b() {
        return this.field_77580_a;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.field_77579_b;
    }

    public boolean func_77569_a(CraftingInventory p_77569_1_, World p_77569_2_) {
        RecipeItemHelper recipeitemhelper = new RecipeItemHelper();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        boolean i = false;
        ArrayList<ItemStack> providedItems = new ArrayList<ItemStack>();
        Counter matchedProvided = new Counter();
        Counter matchedIngredients = new Counter();
        for (int j = 0; j < p_77569_1_.func_70302_i_(); ++j) {
            ItemStack itemstack = p_77569_1_.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            if (this.isSimple) {
                itemstack = itemstack.func_77946_l();
                providedItems.add(itemstack);
                for (Ingredient ingredient : this.field_77579_b) {
                    if (!ingredient.test(itemstack)) continue;
                    matchedProvided.increment((Object)itemstack);
                    matchedIngredients.increment((Object)ingredient);
                }
                continue;
            }
            inputs.add(itemstack);
        }
        if (this.isSimple && (matchedProvided.isEmpty() || matchedIngredients.isEmpty())) {
            return false;
        }
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(this.field_77579_b);
        providedItems.sort(Comparator.comparingInt(c -> (int)matchedProvided.getCount((Object)c)).reversed());
        ingredients.sort(Comparator.comparingInt(c -> (int)matchedIngredients.getCount(c)));
        block2: for (ItemStack provided : providedItems) {
            Iterator itIngredient = ingredients.iterator();
            while (itIngredient.hasNext()) {
                Ingredient ingredient = (Ingredient)itIngredient.next();
                if (!ingredient.test(provided)) continue;
                itIngredient.remove();
                continue block2;
            }
            return false;
        }
        return this.isSimple ? ingredients.isEmpty() : RecipeMatcher.findMatches(inputs, this.field_77579_b) != null;
    }

    public ItemStack func_77572_b(CraftingInventory p_77572_1_) {
        return this.field_77580_a.func_77946_l();
    }

    public boolean func_194133_a(int p_194133_1_, int p_194133_2_) {
        return p_194133_1_ * p_194133_2_ >= this.field_77579_b.size();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapelessRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("minecraft", "crafting_shapeless");

        @Override
        public ShapelessRecipe func_199425_a_(ResourceLocation p_199425_1_, JsonObject p_199425_2_) {
            String s = JSONUtils.func_151219_a((JsonObject)p_199425_2_, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = Serializer.func_199568_a(JSONUtils.func_151214_t((JsonObject)p_199425_2_, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > ShapedRecipe.MAX_WIDTH * ShapedRecipe.MAX_HEIGHT) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is " + ShapedRecipe.MAX_WIDTH * ShapedRecipe.MAX_HEIGHT);
            }
            ItemStack itemstack = ShapedRecipe.func_199798_a(JSONUtils.func_152754_s((JsonObject)p_199425_2_, (String)"result"));
            return new ShapelessRecipe(p_199425_1_, s, itemstack, nonnulllist);
        }

        private static NonNullList<Ingredient> func_199568_a(JsonArray p_199568_0_) {
            NonNullList<Ingredient> nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < p_199568_0_.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a(p_199568_0_.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add(ingredient);
            }
            return nonnulllist;
        }

        @Override
        public ShapelessRecipe func_199426_a_(ResourceLocation p_199426_1_, PacketBuffer p_199426_2_) {
            String s = p_199426_2_.func_150789_c(Short.MAX_VALUE);
            int i = p_199426_2_.func_150792_a();
            NonNullList<Ingredient> nonnulllist = NonNullList.func_191197_a(i, Ingredient.field_193370_a);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, Ingredient.func_199566_b(p_199426_2_));
            }
            ItemStack itemstack = p_199426_2_.func_150791_c();
            return new ShapelessRecipe(p_199426_1_, s, itemstack, nonnulllist);
        }

        @Override
        public void func_199427_a_(PacketBuffer p_199427_1_, ShapelessRecipe p_199427_2_) {
            p_199427_1_.func_180714_a(p_199427_2_.field_194138_c);
            p_199427_1_.func_150787_b(p_199427_2_.field_77579_b.size());
            for (Ingredient ingredient : p_199427_2_.field_77579_b) {
                ingredient.func_199564_a(p_199427_1_);
            }
            p_199427_1_.func_150788_a(p_199427_2_.field_77580_a);
        }
    }
}

