/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.util.JSONUtils;

public class LootingEnchantBonus
extends LootFunction {
    private final RandomValueRange field_186563_a;
    private final int field_189971_b;

    private LootingEnchantBonus(ILootCondition[] p_i47145_1_, RandomValueRange p_i47145_2_, int p_i47145_3_) {
        super(p_i47145_1_);
        this.field_186563_a = p_i47145_2_;
        this.field_189971_b = p_i47145_3_;
    }

    public LootFunctionType func_230425_b_() {
        return LootFunctionManager.field_237434_g_;
    }

    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of(LootParameters.field_216284_d);
    }

    private boolean func_215917_b() {
        return this.field_189971_b > 0;
    }

    public ItemStack func_215859_a(ItemStack p_215859_1_, LootContext p_215859_2_) {
        Entity entity = p_215859_2_.func_216031_c(LootParameters.field_216284_d);
        if (entity instanceof LivingEntity) {
            int i = p_215859_2_.getLootingModifier();
            if (p_215859_2_.func_216033_a(LootParameters.LOOTING_MOD)) {
                i = p_215859_2_.func_216031_c(LootParameters.LOOTING_MOD);
            }
            if (i <= 0) {
                return p_215859_1_;
            }
            float f = (float)i * this.field_186563_a.func_186507_b(p_215859_2_.func_216032_b());
            p_215859_1_.func_190917_f(Math.round(f));
            if (this.func_215917_b() && p_215859_1_.func_190916_E() > this.field_189971_b) {
                p_215859_1_.func_190920_e(this.field_189971_b);
            }
        }
        return p_215859_1_;
    }

    public static Builder func_215915_a(RandomValueRange p_215915_0_) {
        return new Builder(p_215915_0_);
    }

    public static class Serializer
    extends LootFunction.Serializer<LootingEnchantBonus> {
        public void func_230424_a_(JsonObject p_230424_1_, LootingEnchantBonus p_230424_2_, JsonSerializationContext p_230424_3_) {
            super.func_230424_a_(p_230424_1_, (LootFunction)p_230424_2_, p_230424_3_);
            p_230424_1_.add("count", p_230424_3_.serialize((Object)p_230424_2_.field_186563_a));
            if (p_230424_2_.func_215917_b()) {
                p_230424_1_.add("limit", p_230424_3_.serialize((Object)p_230424_2_.field_189971_b));
            }
        }

        public LootingEnchantBonus func_186530_b(JsonObject p_186530_1_, JsonDeserializationContext p_186530_2_, ILootCondition[] p_186530_3_) {
            int i = JSONUtils.func_151208_a((JsonObject)p_186530_1_, (String)"limit", (int)0);
            return new LootingEnchantBonus(p_186530_3_, (RandomValueRange)JSONUtils.func_188174_a((JsonObject)p_186530_1_, (String)"count", (JsonDeserializationContext)p_186530_2_, RandomValueRange.class), i);
        }
    }

    public static class Builder
    extends LootFunction.Builder<Builder> {
        private final RandomValueRange field_216073_a;
        private int field_216074_b = 0;

        public Builder(RandomValueRange p_i50932_1_) {
            this.field_216073_a = p_i50932_1_;
        }

        protected Builder func_212826_d_() {
            return this;
        }

        public Builder func_216072_a(int p_216072_1_) {
            this.field_216074_b = p_216072_1_;
            return this;
        }

        public ILootFunction func_216052_b() {
            return new LootingEnchantBonus(this.func_216053_g(), this.field_216073_a, this.field_216074_b);
        }
    }
}

