/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SChunkDataPacket
implements IPacket<IClientPlayNetHandler> {
    private int field_149284_a;
    private int field_149282_b;
    private int field_186948_c;
    private CompoundNBT field_218711_d;
    @Nullable
    private int[] field_229738_e_;
    private byte[] field_186949_d;
    private List<CompoundNBT> field_189557_e;
    private boolean field_149279_g;

    public SChunkDataPacket() {
    }

    public SChunkDataPacket(Chunk p_i242081_1_, int p_i242081_2_) {
        ChunkPos chunkpos = p_i242081_1_.func_76632_l();
        this.field_149284_a = chunkpos.field_77276_a;
        this.field_149282_b = chunkpos.field_77275_b;
        this.field_149279_g = p_i242081_2_ == 65535;
        this.field_218711_d = new CompoundNBT();
        for (Map.Entry<Heightmap.Type, Heightmap> entry : p_i242081_1_.func_217311_f()) {
            if (!entry.getKey().func_222681_b()) continue;
            this.field_218711_d.func_218657_a(entry.getKey().func_203500_b(), (INBT)new LongArrayNBT(entry.getValue().func_202269_a()));
        }
        if (this.field_149279_g) {
            this.field_229738_e_ = p_i242081_1_.func_225549_i_().func_227055_a_();
        }
        this.field_186949_d = new byte[this.func_218709_a(p_i242081_1_, p_i242081_2_)];
        this.field_186948_c = this.func_218708_a(new PacketBuffer(this.func_186945_f()), p_i242081_1_, p_i242081_2_);
        this.field_189557_e = Lists.newArrayList();
        for (Map.Entry<Object, Object> entry : p_i242081_1_.func_177434_r().entrySet()) {
            BlockPos blockpos = (BlockPos)entry.getKey();
            TileEntity tileentity = (TileEntity)((Object)entry.getValue());
            int i = blockpos.func_177956_o() >> 4;
            if (!this.func_149274_i() && (p_i242081_2_ & 1 << i) == 0) continue;
            CompoundNBT compoundnbt = tileentity.func_189517_E_();
            this.field_189557_e.add(compoundnbt);
        }
    }

    public void func_148837_a(PacketBuffer p_148837_1_) throws IOException {
        int i;
        this.field_149284_a = p_148837_1_.readInt();
        this.field_149282_b = p_148837_1_.readInt();
        this.field_149279_g = p_148837_1_.readBoolean();
        this.field_186948_c = p_148837_1_.func_150792_a();
        this.field_218711_d = p_148837_1_.func_150793_b();
        if (this.field_149279_g) {
            this.field_229738_e_ = p_148837_1_.func_189424_c(BiomeContainer.field_227049_a_);
        }
        if ((i = p_148837_1_.func_150792_a()) > 0x200000) {
            throw new RuntimeException("Chunk Packet trying to allocate too much memory on read.");
        }
        this.field_186949_d = new byte[i];
        p_148837_1_.readBytes(this.field_186949_d);
        int j = p_148837_1_.func_150792_a();
        this.field_189557_e = Lists.newArrayList();
        for (int k = 0; k < j; ++k) {
            this.field_189557_e.add(p_148837_1_.func_150793_b());
        }
    }

    public void func_148840_b(PacketBuffer p_148840_1_) throws IOException {
        p_148840_1_.writeInt(this.field_149284_a);
        p_148840_1_.writeInt(this.field_149282_b);
        p_148840_1_.writeBoolean(this.field_149279_g);
        p_148840_1_.func_150787_b(this.field_186948_c);
        p_148840_1_.func_150786_a(this.field_218711_d);
        if (this.field_229738_e_ != null) {
            p_148840_1_.func_186875_a(this.field_229738_e_);
        }
        p_148840_1_.func_150787_b(this.field_186949_d.length);
        p_148840_1_.writeBytes(this.field_186949_d);
        p_148840_1_.func_150787_b(this.field_189557_e.size());
        for (CompoundNBT compoundnbt : this.field_189557_e) {
            p_148840_1_.func_150786_a(compoundnbt);
        }
    }

    public void func_148833_a(IClientPlayNetHandler p_148833_1_) {
        p_148833_1_.func_147263_a(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public PacketBuffer func_186946_a() {
        return new PacketBuffer(Unpooled.wrappedBuffer((byte[])this.field_186949_d));
    }

    private ByteBuf func_186945_f() {
        ByteBuf bytebuf = Unpooled.wrappedBuffer((byte[])this.field_186949_d);
        bytebuf.writerIndex(0);
        return bytebuf;
    }

    public int writeChunk(PacketBuffer packetDataSerializer, Chunk chunk, int chunkSectionSelector) {
        return this.func_218708_a(packetDataSerializer, chunk, chunkSectionSelector);
    }

    public int func_218708_a(PacketBuffer p_218708_1_, Chunk p_218708_2_, int p_218708_3_) {
        int i = 0;
        ChunkSection[] achunksection = p_218708_2_.func_76587_i();
        int k = achunksection.length;
        for (int j = 0; j < k; ++j) {
            ChunkSection chunksection = achunksection[j];
            if (chunksection == Chunk.field_186036_a || this.func_149274_i() && chunksection.func_76663_a() || (p_218708_3_ & 1 << j) == 0) continue;
            i |= 1 << j;
            chunksection.func_222630_b(p_218708_1_);
        }
        return i;
    }

    protected int func_218709_a(Chunk p_218709_1_, int p_218709_2_) {
        int i = 0;
        ChunkSection[] achunksection = p_218709_1_.func_76587_i();
        int k = achunksection.length;
        for (int j = 0; j < k; ++j) {
            ChunkSection chunksection = achunksection[j];
            if (chunksection == Chunk.field_186036_a || this.func_149274_i() && chunksection.func_76663_a() || (p_218709_2_ & 1 << j) == 0) continue;
            i += chunksection.func_222633_j();
        }
        return i;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_149273_e() {
        return this.field_149284_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_149271_f() {
        return this.field_149282_b;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_149276_g() {
        return this.field_186948_c;
    }

    public boolean func_149274_i() {
        return this.field_149279_g;
    }

    @OnlyIn(value=Dist.CLIENT)
    public CompoundNBT func_218710_g() {
        return this.field_218711_d;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<CompoundNBT> func_189554_f() {
        return this.field_189557_e;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public int[] func_244296_i() {
        return this.field_229738_e_;
    }
}

