/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PotionUtils {
    private static final IFormattableTextComponent field_242400_a = new TranslationTextComponent("effect.none").func_240699_a_(TextFormatting.GRAY);

    public static List<EffectInstance> func_185189_a(ItemStack p_185189_0_) {
        return PotionUtils.func_185185_a(p_185189_0_.func_77978_p());
    }

    public static List<EffectInstance> func_185186_a(Potion p_185186_0_, Collection<EffectInstance> p_185186_1_) {
        ArrayList list = Lists.newArrayList();
        list.addAll(p_185186_0_.func_185170_a());
        list.addAll(p_185186_1_);
        return list;
    }

    public static List<EffectInstance> func_185185_a(@Nullable CompoundNBT p_185185_0_) {
        ArrayList list = Lists.newArrayList();
        list.addAll(PotionUtils.func_185187_c(p_185185_0_).func_185170_a());
        PotionUtils.func_185193_a(p_185185_0_, list);
        return list;
    }

    public static List<EffectInstance> func_185190_b(ItemStack p_185190_0_) {
        return PotionUtils.func_185192_b(p_185190_0_.func_77978_p());
    }

    public static List<EffectInstance> func_185192_b(@Nullable CompoundNBT p_185192_0_) {
        ArrayList list = Lists.newArrayList();
        PotionUtils.func_185193_a(p_185192_0_, list);
        return list;
    }

    public static void func_185193_a(@Nullable CompoundNBT p_185193_0_, List<EffectInstance> p_185193_1_) {
        if (p_185193_0_ != null && p_185193_0_.func_150297_b("CustomPotionEffects", 9)) {
            ListNBT listnbt = p_185193_0_.func_150295_c("CustomPotionEffects", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt = listnbt.func_150305_b(i);
                EffectInstance effectinstance = EffectInstance.func_82722_b(compoundnbt);
                if (effectinstance == null) continue;
                p_185193_1_.add(effectinstance);
            }
        }
    }

    public static int func_190932_c(ItemStack p_190932_0_) {
        CompoundNBT compoundnbt = p_190932_0_.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("CustomPotionColor", 99)) {
            return compoundnbt.func_74762_e("CustomPotionColor");
        }
        return PotionUtils.func_185191_c(p_190932_0_) == Potions.field_185229_a ? 0xF800F8 : PotionUtils.func_185181_a(PotionUtils.func_185189_a(p_190932_0_));
    }

    public static int func_185183_a(Potion p_185183_0_) {
        return p_185183_0_ == Potions.field_185229_a ? 0xF800F8 : PotionUtils.func_185181_a(p_185183_0_.func_185170_a());
    }

    public static int func_185181_a(Collection<EffectInstance> p_185181_0_) {
        int i = 3694022;
        if (p_185181_0_.isEmpty()) {
            return 3694022;
        }
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int j = 0;
        for (EffectInstance effectinstance : p_185181_0_) {
            if (!effectinstance.func_188418_e()) continue;
            int k = effectinstance.func_188419_a().func_76401_j();
            int l = effectinstance.func_76458_c() + 1;
            f += (float)(l * (k >> 16 & 0xFF)) / 255.0f;
            f1 += (float)(l * (k >> 8 & 0xFF)) / 255.0f;
            f2 += (float)(l * (k >> 0 & 0xFF)) / 255.0f;
            j += l;
        }
        if (j == 0) {
            return 0;
        }
        f = f / (float)j * 255.0f;
        f1 = f1 / (float)j * 255.0f;
        f2 = f2 / (float)j * 255.0f;
        return (int)f << 16 | (int)f1 << 8 | (int)f2;
    }

    public static Potion func_185191_c(ItemStack p_185191_0_) {
        return PotionUtils.func_185187_c(p_185191_0_.func_77978_p());
    }

    public static Potion func_185187_c(@Nullable CompoundNBT p_185187_0_) {
        return p_185187_0_ == null ? Potions.field_185229_a : Potion.func_185168_a(p_185187_0_.func_74779_i("Potion"));
    }

    public static ItemStack addPotionToItemStack(ItemStack itemstack, Potion potionregistry) {
        return PotionUtils.func_185188_a(itemstack, potionregistry);
    }

    public static ItemStack func_185188_a(ItemStack p_185188_0_, Potion p_185188_1_) {
        ResourceLocation resourcelocation = Registry.field_212621_j.func_177774_c((Object)p_185188_1_);
        if (p_185188_1_ == Potions.field_185229_a) {
            p_185188_0_.func_196083_e("Potion");
        } else {
            p_185188_0_.func_196082_o().func_74778_a("Potion", resourcelocation.toString());
        }
        return p_185188_0_;
    }

    public static ItemStack func_185184_a(ItemStack p_185184_0_, Collection<EffectInstance> p_185184_1_) {
        if (p_185184_1_.isEmpty()) {
            return p_185184_0_;
        }
        CompoundNBT compoundnbt = p_185184_0_.func_196082_o();
        ListNBT listnbt = compoundnbt.func_150295_c("CustomPotionEffects", 9);
        for (EffectInstance effectinstance : p_185184_1_) {
            listnbt.add((Object)effectinstance.func_82719_a(new CompoundNBT()));
        }
        compoundnbt.func_218657_a("CustomPotionEffects", (INBT)listnbt);
        return p_185184_0_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void func_185182_a(ItemStack p_185182_0_, List<ITextComponent> p_185182_1_, float p_185182_2_) {
        List<EffectInstance> list = PotionUtils.func_185189_a(p_185182_0_);
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            p_185182_1_.add((ITextComponent)field_242400_a);
        } else {
            for (EffectInstance effectinstance : list) {
                TranslationTextComponent iformattabletextcomponent = new TranslationTextComponent(effectinstance.func_76453_d());
                Effect effect = effectinstance.func_188419_a();
                Map<Attribute, AttributeModifier> map = effect.func_111186_k();
                if (!map.isEmpty()) {
                    for (Map.Entry<Attribute, AttributeModifier> entry : map.entrySet()) {
                        AttributeModifier attributemodifier = entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), effect.func_111183_a(effectinstance.func_76458_c(), attributemodifier), attributemodifier.func_220375_c());
                        list1.add(new Pair((Object)entry.getKey(), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.func_76458_c() > 0) {
                    iformattabletextcomponent = new TranslationTextComponent("potion.withAmplifier", new Object[]{iformattabletextcomponent, new TranslationTextComponent("potion.potency." + effectinstance.func_76458_c())});
                }
                if (effectinstance.func_76459_b() > 20) {
                    iformattabletextcomponent = new TranslationTextComponent("potion.withDuration", new Object[]{iformattabletextcomponent, EffectUtils.func_188410_a((EffectInstance)effectinstance, (float)p_185182_2_)});
                }
                p_185182_1_.add((ITextComponent)iformattabletextcomponent.func_240699_a_(effect.func_220303_e().func_220306_a()));
            }
        }
        if (!list1.isEmpty()) {
            p_185182_1_.add(StringTextComponent.field_240750_d_);
            p_185182_1_.add((ITextComponent)new TranslationTextComponent("potion.whenDrank").func_240699_a_(TextFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.func_111164_d();
                double d1 = attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                if (d0 > 0.0) {
                    p_185182_1_.add((ITextComponent)new TranslationTextComponent("attribute.modifier.plus." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent(((Attribute)((Object)pair.getFirst())).func_233754_c_())}).func_240699_a_(TextFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                p_185182_1_.add((ITextComponent)new TranslationTextComponent("attribute.modifier.take." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TranslationTextComponent(((Attribute)((Object)pair.getFirst())).func_233754_c_())}).func_240699_a_(TextFormatting.RED));
            }
        }
    }
}

