/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.profiler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mohistmc.util.i18n.i18n;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;
import net.minecraft.profiler.FilledProfileResult;
import net.minecraft.profiler.IProfileResult;
import net.minecraft.profiler.IProfilerSection;
import net.minecraft.profiler.IResultableProfiler;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class Profiler
implements IResultableProfiler {
    private static final long field_219907_a = Duration.ofMillis(100L).toNanos();
    private static final Logger field_151234_b = LogManager.getLogger();
    private final List<String> field_76325_b = Lists.newArrayList();
    private final LongList field_76326_c = new LongArrayList();
    private final Map<String, Section> field_230078_e_ = Maps.newHashMap();
    private final IntSupplier field_219912_f;
    private final LongSupplier field_233501_g_;
    private final long field_219913_g;
    private final int field_219914_h;
    private String field_219915_i = "";
    private boolean field_219916_j;
    @Nullable
    private Section field_230079_k_;
    private final boolean field_226230_l_;

    public Profiler(LongSupplier p_i231482_1_, IntSupplier p_i231482_2_, boolean p_i231482_3_) {
        this.field_219913_g = p_i231482_1_.getAsLong();
        this.field_233501_g_ = p_i231482_1_;
        this.field_219914_h = p_i231482_2_.getAsInt();
        this.field_219912_f = p_i231482_2_;
        this.field_226230_l_ = p_i231482_3_;
    }

    public void func_219894_a() {
        if (this.field_219916_j) {
            field_151234_b.error(i18n.get((String)"profiler.1"));
        } else {
            this.field_219916_j = true;
            this.field_219915_i = "";
            this.field_76325_b.clear();
            this.func_76320_a("root");
        }
    }

    public void func_219897_b() {
        if (!this.field_219916_j) {
            field_151234_b.error(i18n.get((String)"profiler.2"));
        } else {
            this.func_76319_b();
            this.field_219916_j = false;
            if (!this.field_219915_i.isEmpty()) {
                field_151234_b.error("Profiler tick ended before path was fully popped (remainder: '{}'). Mismatched push/pop?", new Supplier[]{() -> IProfileResult.func_225434_b((String)this.field_219915_i)});
            }
        }
    }

    public void func_76320_a(String p_76320_1_) {
        if (!this.field_219916_j) {
            field_151234_b.error(i18n.get((String)"profiler.3", (Object[])new Object[]{p_76320_1_}));
        } else {
            if (!this.field_219915_i.isEmpty()) {
                this.field_219915_i = this.field_219915_i + '\u001e';
            }
            this.field_219915_i = this.field_219915_i + p_76320_1_;
            this.field_76325_b.add(this.field_219915_i);
            this.field_76326_c.add(Util.func_211178_c());
            this.field_230079_k_ = null;
        }
    }

    public void func_194340_a(java.util.function.Supplier<String> p_194340_1_) {
        this.func_76320_a(p_194340_1_.get());
    }

    public void func_76319_b() {
        if (!this.field_219916_j) {
            field_151234_b.error(i18n.get((String)"profiler.4"));
        } else if (this.field_76326_c.isEmpty()) {
            field_151234_b.error(i18n.get((String)"profiler.5"));
        } else {
            long i = Util.func_211178_c();
            long j = this.field_76326_c.removeLong(this.field_76326_c.size() - 1);
            this.field_76325_b.remove(this.field_76325_b.size() - 1);
            long k = i - j;
            Section profiler$section = this.func_230081_e_();
            profiler$section.field_230082_a_ = profiler$section.field_230082_a_ + k;
            profiler$section.field_230083_b_ = profiler$section.field_230083_b_ + 1L;
            if (this.field_226230_l_ && k > field_219907_a) {
                field_151234_b.warn("Something's taking too long! '{}' took aprox {} ms", new Supplier[]{() -> IProfileResult.func_225434_b((String)this.field_219915_i), () -> (double)k / 1000000.0});
            }
            this.field_219915_i = this.field_76325_b.isEmpty() ? "" : this.field_76325_b.get(this.field_76325_b.size() - 1);
            this.field_230079_k_ = null;
        }
    }

    public void func_219895_b(String p_219895_1_) {
        this.func_76319_b();
        this.func_76320_a(p_219895_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_194339_b(java.util.function.Supplier<String> p_194339_1_) {
        this.func_76319_b();
        this.func_194340_a(p_194339_1_);
    }

    private Section func_230081_e_() {
        if (this.field_230079_k_ == null) {
            this.field_230079_k_ = this.field_230078_e_.computeIfAbsent(this.field_219915_i, p_230080_0_ -> new Section());
        }
        return this.field_230079_k_;
    }

    public void func_230035_c_(String p_230035_1_) {
        this.func_230081_e_().field_230084_c_.addTo((Object)p_230035_1_, 1L);
    }

    public void func_230036_c_(java.util.function.Supplier<String> p_230036_1_) {
        this.func_230081_e_().field_230084_c_.addTo((Object)p_230036_1_.get(), 1L);
    }

    public IProfileResult func_219905_d() {
        return new FilledProfileResult(this.field_230078_e_, this.field_219913_g, this.field_219914_h, this.field_233501_g_.getAsLong(), this.field_219912_f.getAsInt());
    }

    static class Section
    implements IProfilerSection {
        private long field_230082_a_;
        private long field_230083_b_;
        private Object2LongOpenHashMap<String> field_230084_c_ = new Object2LongOpenHashMap();

        private Section() {
        }

        public long func_230037_a_() {
            return this.field_230082_a_;
        }

        public long func_230038_b_() {
            return this.field_230083_b_;
        }

        public Object2LongMap<String> func_230039_c_() {
            return Object2LongMaps.unmodifiable(this.field_230084_c_);
        }
    }
}

