/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mohistmc.util.i18n.i18n;
import com.mojang.brigadier.arguments.StringArgumentType;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.PackCompatibility;
import net.minecraft.resources.data.PackMetadataSection;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourcePackInfo
implements AutoCloseable {
    private static final Logger field_195799_a = LogManager.getLogger();
    private static final PackMetadataSection field_212500_b = new PackMetadataSection((ITextComponent)new TranslationTextComponent("resourcePack.broken_assets").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.ITALIC}), SharedConstants.func_215069_a().getPackVersion());
    private final String field_195800_b;
    private final Supplier<IResourcePack> field_195801_c;
    private final ITextComponent field_195802_d;
    private final ITextComponent field_195803_e;
    private final PackCompatibility field_195804_f;
    private final Priority field_195805_g;
    private final boolean field_195806_h;
    private final boolean field_195807_i;
    private final boolean hidden;
    private final IPackNameDecorator field_232611_k_;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ResourcePackInfo func_195793_a(String p_195793_0_, boolean p_195793_1_, Supplier<IResourcePack> p_195793_2_, IFactory p_195793_3_, Priority p_195793_4_, IPackNameDecorator p_195793_5_) {
        try (IResourcePack iresourcepack = p_195793_2_.get();){
            PackMetadataSection packmetadatasection = (PackMetadataSection)iresourcepack.func_195760_a(PackMetadataSection.field_198964_a);
            if (p_195793_1_ && packmetadatasection == null) {
                field_195799_a.error(i18n.get((String)"resourcepackinfo.1"));
                packmetadatasection = field_212500_b;
            }
            if (packmetadatasection != null) {
                ResourcePackInfo resourcePackInfo = p_195793_3_.create(p_195793_0_, p_195793_1_, p_195793_2_, iresourcepack, packmetadatasection, p_195793_4_, p_195793_5_);
                return resourcePackInfo;
            }
            field_195799_a.warn(i18n.get((String)"resourcepackinfo.2", (Object[])new Object[]{p_195793_0_}));
            return null;
        }
        catch (IOException ioexception) {
            field_195799_a.warn(i18n.get((String)"resourcepackinfo.3", (Object[])new Object[]{ioexception.toString()}));
        }
        return null;
    }

    @Deprecated
    public ResourcePackInfo(String p_i231422_1_, boolean p_i231422_2_, Supplier<IResourcePack> p_i231422_3_, ITextComponent p_i231422_4_, ITextComponent p_i231422_5_, PackCompatibility p_i231422_6_, Priority p_i231422_7_, boolean p_i231422_8_, IPackNameDecorator p_i231422_9_) {
        this(p_i231422_1_, p_i231422_2_, p_i231422_3_, p_i231422_4_, p_i231422_5_, p_i231422_6_, p_i231422_7_, p_i231422_8_, p_i231422_9_, false);
    }

    public ResourcePackInfo(String p_i231422_1_, boolean p_i231422_2_, Supplier<IResourcePack> p_i231422_3_, ITextComponent p_i231422_4_, ITextComponent p_i231422_5_, PackCompatibility p_i231422_6_, Priority p_i231422_7_, boolean p_i231422_8_, IPackNameDecorator p_i231422_9_, boolean hidden) {
        this.field_195800_b = p_i231422_1_;
        this.field_195801_c = p_i231422_3_;
        this.field_195802_d = p_i231422_4_;
        this.field_195803_e = p_i231422_5_;
        this.field_195804_f = p_i231422_6_;
        this.field_195806_h = p_i231422_2_;
        this.field_195805_g = p_i231422_7_;
        this.field_195807_i = p_i231422_8_;
        this.field_232611_k_ = p_i231422_9_;
        this.hidden = hidden;
    }

    @Deprecated
    public ResourcePackInfo(String p_i231421_1_, boolean p_i231421_2_, Supplier<IResourcePack> p_i231421_3_, IResourcePack p_i231421_4_, PackMetadataSection p_i231421_5_, Priority p_i231421_6_, IPackNameDecorator p_i231421_7_) {
        this(p_i231421_1_, p_i231421_2_, p_i231421_3_, p_i231421_4_, p_i231421_5_, p_i231421_6_, p_i231421_7_, false);
    }

    public ResourcePackInfo(String p_i231421_1_, boolean p_i231421_2_, Supplier<IResourcePack> p_i231421_3_, IResourcePack p_i231421_4_, PackMetadataSection p_i231421_5_, Priority p_i231421_6_, IPackNameDecorator p_i231421_7_, boolean hidden) {
        this(p_i231421_1_, p_i231421_2_, p_i231421_3_, (ITextComponent)new StringTextComponent(p_i231421_4_.func_195762_a()), p_i231421_5_.func_198963_a(), PackCompatibility.func_198969_a((int)p_i231421_5_.func_198962_b()), p_i231421_6_, false, p_i231421_7_, hidden);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_195789_b() {
        return this.field_195802_d;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_195795_c() {
        return this.field_195803_e;
    }

    public ITextComponent func_195794_a(boolean p_195794_1_) {
        return TextComponentUtils.func_240647_a_((ITextComponent)this.field_232611_k_.decorate((ITextComponent)new StringTextComponent(this.field_195800_b))).func_240700_a_(p_211689_2_ -> p_211689_2_.func_240712_a_(p_195794_1_ ? TextFormatting.GREEN : TextFormatting.RED).func_240714_a_(StringArgumentType.escapeIfRequired((String)this.field_195800_b)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, new StringTextComponent("").func_230529_a_(this.field_195802_d).func_240702_b_("\n").func_230529_a_(this.field_195803_e))));
    }

    public PackCompatibility func_195791_d() {
        return this.field_195804_f;
    }

    public IResourcePack func_195796_e() {
        return this.field_195801_c.get();
    }

    public String func_195790_f() {
        return this.field_195800_b;
    }

    public boolean func_195797_g() {
        return this.field_195806_h;
    }

    public boolean func_195798_h() {
        return this.field_195807_i;
    }

    public Priority func_195792_i() {
        return this.field_195805_g;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IPackNameDecorator func_232614_i_() {
        return this.field_232611_k_;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof ResourcePackInfo)) {
            return false;
        }
        ResourcePackInfo resourcepackinfo = (ResourcePackInfo)p_equals_1_;
        return this.field_195800_b.equals(resourcepackinfo.field_195800_b);
    }

    public int hashCode() {
        return this.field_195800_b.hashCode();
    }

    @Override
    public void close() {
    }

    public static enum Priority {
        TOP,
        BOTTOM;


        public <T> int func_198993_a(List<T> p_198993_1_, T p_198993_2_, Function<T, ResourcePackInfo> p_198993_3_, boolean p_198993_4_) {
            ResourcePackInfo resourcepackinfo;
            int i;
            Priority resourcepackinfo$priority;
            Priority priority = resourcepackinfo$priority = p_198993_4_ ? this.func_198992_a() : this;
            if (resourcepackinfo$priority == BOTTOM) {
                ResourcePackInfo resourcepackinfo1;
                int j;
                for (j = 0; j < p_198993_1_.size() && (resourcepackinfo1 = p_198993_3_.apply(p_198993_1_.get(j))).func_195798_h() && resourcepackinfo1.func_195792_i() == this; ++j) {
                }
                p_198993_1_.add(j, p_198993_2_);
                return j;
            }
            for (i = p_198993_1_.size() - 1; i >= 0 && (resourcepackinfo = p_198993_3_.apply(p_198993_1_.get(i))).func_195798_h() && resourcepackinfo.func_195792_i() == this; --i) {
            }
            p_198993_1_.add(i + 1, p_198993_2_);
            return i + 1;
        }

        public Priority func_198992_a() {
            return this == TOP ? BOTTOM : TOP;
        }
    }

    @FunctionalInterface
    public static interface IFactory {
        @Nullable
        public ResourcePackInfo create(String var1, boolean var2, Supplier<IResourcePack> var3, IResourcePack var4, PackMetadataSection var5, Priority var6, IPackNameDecorator var7);
    }
}

